/***************************************************************************
 *   Copyright (C) 2002-2006 by                                            *
 *   Jens Henrik Gbbert (jenshenrik.goebbert@gmx.de)                      *
 *   and Raul Fernandes (rgfbr@yahoo.com.br)                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/***************************************************************************
                          findRec.h  -  description
                             -------------------
    begin                : Mit Aug 7 2002
    copyright            : (C) 2002 by Jens Henrik Gbbert
    email                : jenshenrik.goebbert@gmx.de
 ***************************************************************************/


#ifndef FINDREC_H
#define FINDREC_H

#include <qimage.h>
//#include "showimg.h"
template <class T> class QValueList;
  struct letter
  {
    int x_left  ;   //I assume it is leftupper=(x_left-space_left,y_up),
    int y_up    ;    //   rightlower=(x_right+space_right,y_down)
    int x_right ;
    int y_down  ;
    int space_left;  //space to the next left letter
    int space_right; //space to the next right letter
  };

  class FindRec
  {
    public:
      FindRec(/*ImageViewer *p,*/ QImage *img);
      ~FindRec();

      int findword(int xOfPoint, int yOfPoint);

      int word_x_right;
      int word_x_left;
      int word_y_down;
      int word_y_up;
      int word_letter; // tells how many letters the word has yet ('lette' == 5)

    private:
      int findletter(int lnow, const int xOfPoint, const int yOfPoint_up, const int yOfPoint_down,int direction);
      int checkColorChange(const QRgb * c,const int pixelcount);

      const int maxlwidth; // not really maximal width of a letter - but letter will not be wider than 2*maxlwidth
      int minlwidth;
      int maxlheight;// not really maximal height of a letter - but letter will not be higher than 2*maxlheight
      int minlheight;
      int maxmiss;   // how good can the user hit a letter .. he may miss it by 'maxmiss'
      int rdiff;
      int gdiff;
      int bdiff;

      int word_x;
      int word_y;
      int word_width;
      int word_height;

      int best_up;
      int best_down;

      QImage  *image;
      int image_height;
      int image_width;

//      ImageViewer *parent;

      letter the_letter[100]; // max. letters in a word = size of array (is checked not to get an overrun at the end of findword()
      int letterdist;
      int smallest_letterhight;

  };

#endif // FINDREC_H
