/***************************************************************************
 *   Copyright (C) 2004-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KTRCLIPBOARD_H
#define KTRCLIPBOARD_H

#include <qobject.h>

class QString;
class QClipboard;
class QTimer;

/**
@short ktrClipboard
@author Raul Fernandes
*/
class ktrClipboard : public QObject{

   Q_OBJECT

public:
    ktrClipboard();

    ~ktrClipboard();
    /*!
       \fn ktrClipboard::text()
    */
    QString text();
    /*!
       \fn ktrClipboard::stop()
    */
    void stop();
    /*!
       \fn ktrClipboard::start()
    */
    void start();

public slots:
    /*!
       \fn ktrClipboard::verify()
    */
    void verify();

signals:
    void selectionChanged();

private:
    QClipboard *clip;
    QTimer *timer;
    QString selection;
};

#endif
