/***************************************************************************
 *   Copyright (C) 2005-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef STARDICT_H
#define STARDICT_H

#include <qstring.h>
#include <qvaluelist.h>

#ifndef NOPTIMIZE
#include <qmap.h>
#endif

class QFile;

/**
@author Raul Fernandes
*/
class StarDict{
public:
    StarDict( const QString & );

    ~StarDict();

    bool extraField() { return m_extraField; };
    bool hasName() { return m_hasName; };
    unsigned long mtime()  { return m_mtime; };
    QString filename() { return m_filename; };
    QString search( const QString & );
    QCString Inflate( const QByteArray & );
    int size();
    bool isOk(){ return m_isOk; };
    QString bookname() { return m_bookname; };
    QString author() { return m_author; };
    QString version() { return m_version; };
    QString description() { return m_description; };

protected:
    void readExtraField();
    void readFileName();
    void readComment();

    bool m_isOk;

    bool isCompressed;
    char FLAGS;
    QFile *file;
    QFile *idxFile;
    QFile *ifoFile;
    bool m_extraField;
    bool m_hasName;
    bool FTEXT; // bit 0 -  texto
    bool FHCRC; // bit 1 - tem CRC16
    bool FCOMMENT; // bit 3 - tem comentrio
    unsigned long m_mtime;
    unsigned long XLEN;
    char SI1, SI2;
    unsigned long LEN, VER, CHLEN, CHCNT;
    QValueList<unsigned long> offsets;
    QString m_comment;
    QString m_filename;
    char *crc16[2];
    unsigned long offset;

    // ifo file
    QString m_version;
    QString m_bookname;
    uint m_wordcount;
    ulong m_idxfilesize;
    QString m_sametypesequence;
    QString m_author;
    QString m_email;
    QString m_website;
    QString m_description;
    QString m_date;

    struct entry{
    unsigned long position;
    unsigned long size;
    };

#ifndef NOPTIMIZE
    typedef QMap<QString, entry>Dictionary;
    Dictionary dic;
#endif
};

#endif // STARDICT_H
