/***************************************************************************
 *   Copyright (C) 2004-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KTRANSLATOR_PLUGIN_H
#define KTRANSLATOR_PLUGIN_H

#include <qobject.h>
#include <kdemacros.h>

class QWidget;

/**
 *  Namespace for KTranslator Plugins
 */

namespace KTranslator {

    /**
     * @short Dictionary Plugin Abstract Class
     * @author Raul Fernandes <rgfbr@yahoo.com.br>
     * @version 0.1
     * This is the base class to make dictionary plugins for KTranslator. The dictionary plugins are the
     * code that do the real search of word in dictionaries.
     * When KTranslator wants to translate a word, it calls the search function of each plugin passing the
     * word as argument. The plugin should return the result in this way:
     *
     * \verbatim
     * <dicName>Dictionary Name</dicName>
     * <headword>Headword</headword>
     * <inflection>Inflections</inflection>
     * <pos>Part of Speech</pos>
     * <definition>Definition of word<link>Link to other words</link></definition>
     * <pos>Part of Speech</pos>
     * <definition>Definition of word<link>Link to other words</link></definition>
     * ...
     * <pos>Part of Speech</pos>
     * <definition>Definition of word<link>Link to other words</link></definition>
     * \endverbatim
     *
     * There are no obrigatory tag, but you should at least return <dicName>, <headword> and one <definition>.
     */
    class KDE_EXPORT DictionaryPlugin : public QObject
    {

    public:

        /**
         * Default constructor.
         */
        DictionaryPlugin(QObject *parent, const char* name=0);

        /**
         * Destructs the plugin.
         */
        virtual ~DictionaryPlugin();

        /**
         * Function that do the searchs.
         * @returns the result of search.
         */
        virtual QString search( const QString & )=0;

        /**
         * @returns if plugin is enabled or not.
         */
        bool enabled() { return m_enabled; };

        /**
         * Sets if plugin is enabled or not.
         */
        void setEnabled( bool enable ) { m_enabled = enable; };

        /**
         * @returns if plugin loaded correctly and are ready to use.
         */
        bool isOk() { return m_isOk; };

        /**
         * Sets if plugin loaded correctly and are ready to use.
         */
        void setOk( bool isOk ) { m_isOk = isOk; };
        virtual QWidget *confPage()=0;
        virtual void applyConf( QWidget * )=0;
        virtual int size()=0;

        /**
         * @returns text with informations about plugin to be shown to user.
         */
        QString tooltip() { return m_tooltip; };
    protected:
        QString m_tooltip;
    private:
        bool m_enabled;
        bool m_isOk;
    };
};


#endif /* KTRANSLATOR_PLUGIN_H */
