/***************************************************************************
                          latexedit.cpp  -  description
                             -------------------
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by Brachet Pascal
    email                : pascal.brachet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "latexedit.h"
#include <klocale.h>

latexedit::latexedit(KWriteDoc *doc,QWidget *parent, const char *name) :
  KWrite(doc, parent, name)
{

}


latexedit::~latexedit() {
}

QString latexedit::getName()
{
QString fn;
if (doc()->url().isEmpty()) {fn=QString(i18n("Untitled"));}
//else {fn=doc()->url().url();};
else {fn=doc()->url().prettyURL();};
if ( fn.left(5) == "file:" ) {fn.remove(0,5);};
return fn;
}

void latexedit::readConfig(KConfig *config)
{
  config->setGroup("Editor Options");
  KWrite::readConfig( config );
  doc() ->readConfig( config );
  HlManager *hlManager = doc()->hlManager;
  ItemFont      defaultFont;
  ItemStyleList defaultStyleList;
  hlManager->getDefaults(defaultStyleList,defaultFont);
  hlManager->setDefaults(defaultStyleList,defaultFont);
}

void latexedit::writeConfig(KConfig *config)
{
  config->setGroup("Editor Options");
  KWrite::writeConfig( config );
  doc() ->writeConfig( config );
}

