/***************************************************************************
                          ktexmaker2.h  -  description
                             -------------------
    begin                : Tue May 29 22:14:48 CEST 2001
    copyright            : (C) 2001 by Brachet Pascal
    email                : pascal.brachet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KTEXMAKER2_H
#define KTEXMAKER2_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>
#include <latexedit.h>
#include <kapp.h>
#include <kparts/mainwindow.h>
#include <kprocess.h>
#include <kapp.h>
#include <khelpmenu.h>

#include <qsplitter.h>
#include <qwidget.h>
#include <qstrlist.h>
#include <qlistview.h>
#include <qtabwidget.h>
#include <qwidgetstack.h>
#include <qmultilineedit.h>

#include "logwidget.h"
#include "docpart.h"
#include "tabdialog.h"
#include "structdialog.h"
#include "l2hdialog.h"
#include "usermenudialog.h"
#include "structviewdialog.h"
#include "selectfiledialog.h"
#include "toolsoptionsdialog.h"
#include "quickdocumentdialog.h"
#include "letterdialog.h"
#include "gfe/qplotmaker.h"
#include "gfe/qplotdialog.h"
#include "konsole/texkonsolewidget.h"

#define ID_HINTTEXT 300
#define ID_LINE_COLUMN 301
#define ID_TOOLS 302
#define ID_MODE 303
#define ID_VIEW_OUTPUTVIEW 304
#define ID_VIEW_STRUCTVIEW 305
#define ID_COMBO1 306
#define ID_COMBO2 307
#define ID_COMBO3 308
#define ID_BACK 309
#define ID_FORWARD 310
#define ID_HOME 311
#define ID_EDITORVIEW 312
#define ID_LATEXMODE 312

typedef QList<latexedit> writelist;


class Ktexmaker2 : public KMainWindow
{
  Q_OBJECT

   public:
   /** construtor */
   Ktexmaker2();
   /** destructor */
   ~Ktexmaker2();
   void Loader(const char *filename);
   bool FileAlreadyOpen(QString file_name);
   QString ConvertForBash(QString  dirname);

   private:
   KConfig* config;
   latexedit* Editor;
   QString MasterName;
   QWidgetStack *topWidgetStack;
   QSplitter *splitter1, *splitter2 ;
   KParts::ReadOnlyPart *ps_part;
   docpart *html_part;
   QMultiLineEdit* output;
   LogWidget* stdoutput;
   QListView* outstruct;
   QListViewItem *parent_level[5],*lastChild, *Child;
   QTabWidget *Editors, *Outputview, *Structview;
   TexKonsoleWidget* texkonsole;

   l2hdialog *l2hDlg;
   tabdialog *quickDlg;
   structdialog *stDlg;
   selectfiledialog *sfDlg;
   usermenudialog *umDlg;
   structviewdialog *swDlg;
   toolsoptionsdialog *toDlg;
   Qplotmaker *gfedialog;
   quickdocumentdialog *startDlg;
   letterdialog *ltDlg;

   writelist *EditorsList;
   KStatusBar *StatusBar;
   KMenuBar *MenuBar;
   KToolBar *MainToolBar, *QuickToolBar;
   KAccel *keys;
   QPopupMenu *file;
   QPopupMenu *edit;
   QPopupMenu *tools;
   QPopupMenu *recent;
   QPopupMenu *latex1;
   QPopupMenu *latex11;
   QPopupMenu *latex12;
   QPopupMenu *latex13;
   QPopupMenu *latex14;
   QPopupMenu *latex15;
   QPopupMenu *latex16;
   QPopupMenu *math1;
   QPopupMenu *math11;
   QPopupMenu *math12;
   QPopupMenu *math13;
   QPopupMenu *math14;
   QPopupMenu *math15;
   QPopupMenu *math16;
   QPopupMenu *math17;
   QPopupMenu *math18;
   QPopupMenu *usermenu;
   QPopupMenu *wizard;
   QPopupMenu *options;
   QPopupMenu *greek1;
   QPopupMenu *greek11;
   QPopupMenu *greek12;
   QPopupMenu *greek13;
   QPopupMenu *bibmenu;
   QPopupMenu *grafmenu;
   QPopupMenu *help;
   KHelpMenu* help_menu;
   QString struct_level1, struct_level2, struct_level3, struct_level4, struct_level5;
   QString latex_command, viewdvi_command, dvips_command;
   QString viewps_command, ps2pdf_command, makeindex_command, bibtex_command, pdflatex_command, viewpdf_command;
   QString lastDocument;
   bool kdetools, logpresent, singlemode, previewpresent, htmlpresent;
   bool showstructview,showoutputview, latexmode;
   uint maxRecentCount;
   QStrList *recentFilesList, *UserMenuNames, *UserMenuTags;
   QStrList *structlist, *structitem, *errorlist, *combolist1, *combolist2, *combolist3;
   KShellProcess* P;

   private slots:
   void NewFile();
   void OpenFile();
   void OpenRecentFile(int id);
   void SaveFile();
   void SaveFileAs();
   void SaveAllFiles();
   void Close();
   void CloseAll();
   void Print();
   void Exit();


   void Undo();
   void Redo();
   void Cut();
   void Copy();
   void Paste();
   void SelectAll();
   void Search();
   void SearchAgain();
   void Replace();
   void GotoLine();
   void Indent();
   void Unindent();
   void Comment();
   void Uncomment();
   void ToggleVerticalSelection();

   void ToggleTools();
   void ToggleMode();
   void ToggleLatexMode();
   void ToggleStructView();
   void ToggleOutputView();
   void ShowStructView(bool change);
   void ShowOutputView(bool change);
   void slotOptionsEditor();
   void slotOptionsEditorFonts();
   void OptionsTools();
   void ConfigureKeys();

   void EditUserMenu();
   void InsertUserTag(int id);
   void ChangeStructViewItems();

   void spellcheck();

   void Preview();
   void PreviewDVI();
   void PreviewPS();
   void PreviewPDF();
   void ShowEditorWidget();
   void Terminal();
   void Compile();
   void Latex();
   void ViewDvi();
   void DviToPS();
   void ViewPS();
   void ViewLog();
   void LatexToHtml();
   void HtmlPreview();
   void PStoPDF();
   void MakeIndex();
   void MakeBib();
   void PDFLatex();
   void ViewPDF();
   void RunXfig();
   void RunGfe();
   void CleanAll();
   void slotProcessOutput(KProcess* proc,char* buffer,int buflen);
   void slotProcessExited(KProcess* proc);

   void InsertTag(QString Entity, int dx, int dy);
   void QuickTabular();
   void QuickArray();
   void QuickLetter();
   void QuickDocument();
   void Insert1();
   void Insert1bis();
   void Insert1ter();
   void Insert2();
   void Insert3();
   void Insert4();
   void Insert5();
   void Insert6();
   void Insert6bis();
   void Insert7();
   void Insert8();
   void Insert9();
   void Insert10();
   void Insert11();
   void Insert12();
   void Insert13();
   void Insert14();
   void Insert15();
   void Insert16();
   void Insert17();
   void Insert18();
   void Insert19();
   void Insert20();
   void Insert21();
   void Insert22();
   void Insert23();
   void Insert24();
   void Insert25();
   void Insert26();
   void Insert27();
   void Insert28();
   void Insert29();
   void Insert30();
   void Insert31();
   void Insert32();
   void Insert33();
   void Insert34();
   void Insert35();
   void Insert36();
   void Insert37();
   void Insert37bis();
   void Insert37ter();
   void Insert38();
   void Insert39();
   void Insert40();
   void Insert41();
   void Insert42();
   void Insert43();
   void Insert44();
   void Insert45();
   void Insert46();
   void SizeCommand(const QString& text);
   void NewLine();

   void InsertMath1();
   void InsertMath2();
   void InsertMath3();
   void InsertMath4();
   void InsertMath5();
   void InsertMath6();
   void InsertMath7();
   void InsertMath8();
   void InsertMath9();
   void InsertMath10();
   void InsertMath11();
   void InsertMath12();
   void InsertMath13();
   void InsertMath14();
   void InsertMath15();
   void InsertMath16();
   void InsertMath17();
   void InsertMath18();
   void InsertMath19();
   void InsertMath20();
   void InsertMath21();
   void InsertMath22();
   void InsertMath23();
   void InsertMath24();
   void InsertMath25();
   void InsertMath26();
   void InsertMath27();
   void InsertMath28();
   void InsertMath29();
   void InsertMath30();
   void InsertMath31();
   void InsertMath32();
   void InsertMath33();
   void InsertMath34();
   void InsertMath35();
   void InsertMath36();
   void InsertMath37();
   void InsertMath38();
   void InsertMath39();
   void InsertMath40();
   void InsertMath41();
   void InsertMath42();
   void InsertMath43();
   void InsertMath44();
   void InsertMath45();
   void InsertMath46();
   void InsertMath47();
   void InsertMath48();
   void InsertMath49();
   void InsertMath50();
   void InsertMath51();
   void InsertMath52();
   void InsertMath53();
   void InsertMath54();
   void InsertMath55();
   void InsertMath56();
   void InsertMath57();
   void InsertMath58();
   void InsertMath59();
   void InsertMath60();
   void InsertMath61();
   void InsertMath62();
   void InsertMath63();
   void InsertMath64();
   void InsertMath65();
   void InsertMath66();
   void InsertMath67();
   void InsertMath68();
   void InsertMath69();
   void InsertMath70();
   void InsertMath71();
   void InsertMath72();
   void InsertMath73();
   void InsertMath74();
   void InsertMath75();
   void InsertMath76();
   void InsertMath77();
   void InsertMath78();
   void InsertMath79();
   void InsertMath80();
   void InsertMath81();
   void InsertMath82();
   void InsertMath83();
   void InsertMath84();
   void InsertMath85();
   void InsertMath86();
   void InsertMath87();
   void InsertMath88();
   void InsertMath89();
   void InsertMath90();
   void LeftDelimiter(const QString& text);
   void RightDelimiter(const QString& text);

   void InsertGreek1();
   void InsertGreek2();
   void InsertGreek3();
   void InsertGreek4();
   void InsertGreek5();
   void InsertGreek6();
   void InsertGreek7();
   void InsertGreek8();
   void InsertGreek9();
   void InsertGreek10();
   void InsertGreek11();
   void InsertGreek12();
   void InsertGreek13();
   void InsertGreek14();
   void InsertGreek15();
   void InsertGreek16();
   void InsertGreek17();
   void InsertGreek18();
   void InsertGreek19();
   void InsertGreek20();
   void InsertGreek21();
   void InsertGreek22();
   void InsertGreek23();
   void InsertGreek24();
   void InsertGreek25();
   void InsertGreek26();
   void InsertGreek27();
   void InsertGreek28();
   void InsertGreek29();
   void InsertGreek30();
   void InsertGreek31();
   void InsertGreek32();
   void InsertGreek33();
   void InsertGreek34();
   void InsertGreek35();
   void InsertGreek36();
   void InsertGreek37();
   void InsertGreek38();
   void InsertGreek39();
   void InsertGreek40();

   void Symbols();
   void LatexHelp();

   void InsertBib1();
   void InsertBib2();
   void InsertBib3();
   void InsertBib4();
   void InsertBib5();
   void InsertBib6();
   void InsertBib7();
   void InsertBib8();
   void InsertBib9();
   void InsertBib10();
   void InsertBib11();
   void InsertBib12();
   void InsertBib13();

   void ResetPart();
   void BrowserBack();
   void BrowserForward();
   void BrowserHome();
   void UserManual();

   protected:
   void InitMainWidget();
   void InitMenuBar();
   void InitToolBar();
   void InitStatusBar();
   void InitAccelerators();
   virtual void closeEvent(QCloseEvent *e);
   void ReadSettings();
   void SaveSettings();

   protected slots:
   void SetCurrentEditor(QWidget *editor);
   void UpdateLineColStatus();
   void UpdateCaption();
   void AddRecentFile(const char* fileName);
   void NewDocumentStatus();
   void UpdateStructure();
   void LatexError();
   void NextError();
   void PreviousError();
   void ClickedOnStructure(QListViewItem *);
   void DoubleClickedOnStructure(QListViewItem *);
   void ClickedOnOutput();
};

#endif
