/***************************************************************************
                          ktexmaker2.cpp  -  description
                             -------------------
    begin                : Tue May 29 22:14:48 CEST 2001
    copyright            : (C) 2001 by Brachet Pascal
    email                : pascal.brachet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ktexmaker2.h"

#include <krun.h>
#include <klocale.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <klineedit.h>
#include <kglobalsettings.h>
#include <kconfig.h>
#include <klibloader.h>
#include <kwin.h>
#include <kwdialog.h>
#include <kaboutdata.h>
#include <kkeydialog.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <kstddirs.h>

#include <qvbox.h>
#include <qtabwidget.h>
#include <qlistview.h>
#include <qfileinfo.h>
#include <qfont.h>
#include <qvaluelist.h>
#include <qtextstream.h>
#include <qregexp.h>
#include <qtooltip.h>
#include <qheader.h>
#include <iostream.h>
#include <stdlib.h>

#include "kwdoc.h"
#include "highlight.h"

Ktexmaker2::Ktexmaker2()
{
config = KGlobal::config();
ReadSettings();
InitAccelerators();
InitMenuBar();
InitStatusBar();
InitToolBar();
InitMainWidget();
}

Ktexmaker2::~Ktexmaker2()
{
}

//////////////////////// KEY ACCEL //////////////////////////////////////
void Ktexmaker2::InitAccelerators()
{
  keys=new KAccel(this);

  keys->insertStdItem(KStdAccel::New);
  keys->insertStdItem(KStdAccel::Open);
  keys->insertStdItem(KStdAccel::Save);
  keys->insertItem(i18n("Save As"), "Save As", SHIFT + CTRL + Key_S);
  keys->insertItem(i18n("Save All"), "Save All", "");
  keys->insertStdItem(KStdAccel::Close);
  keys->insertItem(i18n("Close All"), "Close All", "");
  keys->insertStdItem(KStdAccel::Print);
  keys->insertStdItem(KStdAccel::Quit, "Exit");

  keys->connectItem(KStdAccel::New, this, SLOT(NewFile()));
  keys->connectItem(KStdAccel::Open, this, SLOT(OpenFile()));
  keys->connectItem(KStdAccel::Save, this, SLOT(SaveFile()));
  keys->connectItem("Save As", this, SLOT(SaveFileAs()));
  keys->connectItem("Save All", this, SLOT(SaveAllFiles()));
  keys->connectItem(KStdAccel::Close, this, SLOT(Close()));
  keys->connectItem("Close All", this, SLOT(CloseAll()));
  keys->connectItem(KStdAccel::Print, this, SLOT(Print()));
  keys->connectItem(KStdAccel::Quit, this, SLOT(Exit()));

  /*------------Edit Menu--------------*/
  keys->insertStdItem(KStdAccel::Undo);
  keys->insertStdItem(KStdAccel::Redo);
  keys->insertStdItem(KStdAccel::Cut);
  keys->insertStdItem(KStdAccel::Copy);
  keys->insertStdItem(KStdAccel::Paste);
  keys->insertItem(i18n("Select All"), "Select All",CTRL + Key_A);
  keys->insertItem(i18n("Toggle Vertical/Normal Selection"), "Toggle Vertical/Normal Selection",Key_F4);
  keys->insertStdItem(KStdAccel::Find);
  keys->insertStdItem(KStdAccel::FindNext);
  keys->insertStdItem(KStdAccel::Replace);
  keys->insertItem(i18n("Goto Line"), "Goto Line", CTRL + Key_G);
  keys->insertItem(i18n("Indent"), "Indent", CTRL + Key_I);
  keys->insertItem(i18n("Unindent"), "Unindent", CTRL + Key_U);
  keys->insertItem(i18n("Comment"), "Comment", CTRL + Key_M);
  keys->insertItem(i18n("Uncomment"), "Uncomment", CTRL +ALT+ Key_M);

  keys->connectItem(KStdAccel::Undo, this, SLOT(Undo()));
  keys->connectItem(KStdAccel::Redo, this, SLOT(Redo()));
  keys->connectItem(KStdAccel::Cut, this, SLOT(Cut()));
  keys->connectItem(KStdAccel::Copy, this, SLOT(Copy()));
  keys->connectItem(KStdAccel::Paste, this, SLOT(Paste()));
  keys->connectItem("Select All", this, SLOT(SelectAll()));
  keys->connectItem("Toggle Vertical/Normal Selection", this, SLOT(ToggleVerticalSelection()));
  keys->connectItem(KStdAccel::Find, this, SLOT(Search()));
  keys->connectItem(KStdAccel::FindNext, this, SLOT(SearchAgain()));
  keys->connectItem(KStdAccel::Replace, this, SLOT(Replace()));
  keys->connectItem("Goto Line", this, SLOT(GotoLine()));
  keys->connectItem("Indent", this, SLOT(Indent()));
  keys->connectItem("Unindent", this, SLOT(Unindent()));
  keys->connectItem("Comment", this, SLOT(Comment()));
  keys->connectItem("Uncomment", this, SLOT(Uncomment()));


  /*------------Tools Menu-------------*/
  keys->insertItem(i18n("LaTeX 'tex file'"), "LaTeX 'tex file'", Key_F5);
  keys->insertItem(i18n("DVI Viewer"), "DVI Viewer", Key_F6);
  keys->insertItem(i18n("DVI -> PS"), "DVI -> PS", Key_F7);
  keys->insertItem(i18n("PS Viewer"), "PS Viewer", Key_F8);
  keys->insertItem(i18n("PDFLaTeX 'tex file'"), "PDFLaTeX 'tex file'", Key_F9);
  keys->insertItem(i18n("PDF Viewer"), "PDF Viewer", Key_F10);
  keys->insertItem(i18n("Preview"), "Preview", Key_F11);
  keys->insertItem(i18n("TeX Terminal"), "TeX Terminal", Key_F12);

  keys->connectItem("LaTeX 'tex file'", this, SLOT(Compile()));
  keys->connectItem("DVI Viewer", this, SLOT(ViewDvi()));
  keys->connectItem("DVI -> PS", this, SLOT(DviToPS()));
  keys->connectItem("PS Viewer", this, SLOT(ViewPS()));
  keys->connectItem("PDFLaTeX 'tex file'", this, SLOT(PDFLatex()));
  keys->connectItem("PDF Viewer", this, SLOT(ViewPDF()));
  keys->connectItem("Preview", this, SLOT(Preview()));
  keys->connectItem("TeX Terminal", this, SLOT(Terminal()));

  /*------------Math Menu-------------*/
  keys->insertItem("$...$", "$...$", ALT+Key_M);
  keys->insertItem("$$...$$", "$$...$$", SHIFT+ALT+Key_M);
  keys->insertItem("_{} - subscript", "_{} - subscript", ALT+Key_D);
  keys->insertItem("^{} - superscript", "^{} - superscript", ALT+Key_U);
  keys->insertItem("\\sqrt{}", "\\sqrt{}", ALT+Key_S);
  keys->insertItem("\\left", "\\left", ALT+Key_L);
  keys->insertItem("\\right", "\\right", ALT+Key_R);
  keys->insertItem("\\dfrac{}{}", "\\dfrac{}{}", ALT+Key_F);
  keys->insertItem("\\frac{}{}", "\\frac{}{}", SHIFT+ALT+Key_F);

  keys->connectItem("$...$", this, SLOT(InsertMath1()));
  keys->connectItem("$$...$$", this, SLOT(InsertMath2()));
  keys->connectItem("_{} - subscript", this, SLOT(InsertMath3()));
  keys->connectItem("^{} - superscript", this, SLOT(InsertMath4()));
  keys->connectItem("\\sqrt{}", this, SLOT(InsertMath7()));
  keys->connectItem("\\left", this, SLOT(InsertMath8()));
  keys->connectItem("\\right", this, SLOT(InsertMath9()));
  keys->connectItem("\\dfrac{}{}", this, SLOT(InsertMath6()));
  keys->connectItem("\\frac{}{}", this, SLOT(InsertMath5()));

  /*------------Latex Menu-------------*/
  keys->insertItem("\\textit - Italics", "\\textit - Italics", SHIFT+ALT+Key_I);
  keys->insertItem("\\textsl - Slanted", "\\textsl - Slanted", SHIFT+ALT+Key_S);
  keys->insertItem("\\textbf - Boldface", "\\textbf - Boldface", SHIFT+ALT+Key_B);
  keys->insertItem("\\texttt - Typewriter", "\\texttt - Typewriter", SHIFT+ALT+Key_T);
  keys->insertItem("\\textsc - Small caps", "\\textsc - Small caps", SHIFT+ALT+Key_C);

  keys->connectItem("\\textit - Italics", this, SLOT(Insert21()));
  keys->connectItem("\\textsl - Slanted", this, SLOT(Insert22()));
  keys->connectItem("\\textbf - Boldface", this, SLOT(Insert23()));
  keys->connectItem("\\texttt - Typewriter", this, SLOT(Insert24()));
  keys->connectItem("\\textsc - Small caps", this, SLOT(Insert25()));


  keys->readSettings();
  }

///////////////////////////////////////// MENU BAR //////////////////////////////////////
void Ktexmaker2::InitMenuBar()
{

int id;

MenuBar = new KMenuBar(this);

file = new QPopupMenu();
id = file->insertItem(SmallIcon("filenew"),i18n("New"), this, SLOT(NewFile()));
keys->changeMenuAccel(file, id, KStdAccel::New);
id = file->insertItem(SmallIcon("fileopen"),i18n("Open"), this, SLOT(OpenFile()));
keys->changeMenuAccel(file, id, KStdAccel::Open);

recent = new QPopupMenu();
for (uint i=0; i<recentFilesList->count(); i++)
recent->insertItem(recentFilesList->at(i));
file->insertItem (i18n("Open Recent"), recent);
connect(recent, SIGNAL(activated(int)), SLOT(OpenRecentFile(int)));
file->insertSeparator();

id= file->insertItem(SmallIcon("filesave"),i18n("Save"), this, SLOT(SaveFile()));
keys->changeMenuAccel(file,id, KStdAccel::Save);
id= file->insertItem(i18n("Save as"), this, SLOT(SaveFileAs()));
keys->changeMenuAccel(file,id, "Save As");
id=file->insertItem(i18n("Save All"), this, SLOT(SaveAllFiles()));
keys->changeMenuAccel(file,id, "Save All");
file->insertSeparator();
id = file->insertItem(i18n("Close"), this, SLOT(Close()));
keys->changeMenuAccel(file, id, KStdAccel::Close);
id = file->insertItem(i18n("Close All"), this, SLOT(CloseAll()));
keys->changeMenuAccel(file, id, "Close All");
file->insertSeparator();
id= file->insertItem(SmallIcon("fileprint"),i18n("Print Source"), this, SLOT(Print()));
keys->changeMenuAccel(file,id, KStdAccel::Print);
file->insertSeparator();
id = file->insertItem(SmallIcon("exit"),i18n("Exit"), this, SLOT(Exit()));
keys->changeMenuAccel(file, id, KStdAccel::Quit);

MenuBar->insertItem(i18n("File"), file);
MenuBar->insertSeparator();

edit = new QPopupMenu();
id= edit->insertItem(SmallIcon("undo"),i18n("Undo"), this, SLOT(Undo()));
keys->changeMenuAccel(edit,id, KStdAccel::Undo);
id= edit->insertItem(SmallIcon("redo"),i18n("Redo"), this, SLOT(Redo()));
keys->changeMenuAccel(edit,id, KStdAccel::Redo);
edit->insertSeparator();
id= edit->insertItem(SmallIcon("editcut"),i18n("Cut"), this, SLOT(Cut()));
keys->changeMenuAccel(edit,id, KStdAccel::Cut);
id = edit->insertItem(SmallIcon("editcopy"),i18n("Copy"), this, SLOT(Copy()));
keys->changeMenuAccel(edit,id, KStdAccel::Copy);
id = edit->insertItem(SmallIcon("editpaste"),i18n("Paste"), this, SLOT(Paste()));
keys->changeMenuAccel(edit,id, KStdAccel::Paste);
id = edit->insertItem(i18n("Select All"), this, SLOT(SelectAll()));
keys->changeMenuAccel(edit, id, "Select All");
edit->insertSeparator();
id = edit->insertItem(i18n("Toggle Vertical/Normal Selection"),this,SLOT(ToggleVerticalSelection()));
keys->changeMenuAccel(edit, id, "Toggle Vertical/Normal Selection");
edit->insertSeparator();
id = edit->insertItem(i18n("Indent"), this, SLOT(Indent()));
keys->changeMenuAccel(edit, id, "Indent");
id = edit->insertItem(i18n("Unindent"), this, SLOT(Unindent()));
keys->changeMenuAccel(edit, id, "Unindent");
edit->insertSeparator();
id = edit->insertItem(i18n("Comment"), this, SLOT(Comment()));
keys->changeMenuAccel(edit, id, "Comment");
id = edit->insertItem(i18n("Uncomment"), this, SLOT(Uncomment()));
keys->changeMenuAccel(edit, id, "Uncomment");
edit->insertSeparator();
id = edit->insertItem(SmallIcon("goto"),i18n("Goto Line"), this, SLOT(GotoLine()));
keys->changeMenuAccel(edit, id, "Goto Line");
id = edit->insertItem(SmallIcon("find"),i18n("Search"), this, SLOT(Search()));
keys->changeMenuAccel(edit, id, KStdAccel::Find);
id = edit->insertItem(SmallIcon("next"),i18n("Search Again"), this, SLOT(SearchAgain()));
keys->changeMenuAccel(edit, id, KStdAccel::FindNext);
id = edit->insertItem(SmallIcon("reload"),i18n("Replace"), this, SLOT(Replace()));
keys->changeMenuAccel(edit, id, KStdAccel::Replace);
edit->insertSeparator();
id = edit->insertItem(SmallIcon("spellcheck"),i18n("Spelling"), this, SLOT(spellcheck()));
edit->insertSeparator();
id = edit->insertItem(i18n("Refresh Structure"), this, SLOT(UpdateStructure()));
id = edit->insertItem(SmallIcon("back"),i18n("Previous LaTeX Error"), this, SLOT(PreviousError()));
id = edit->insertItem(SmallIcon("forward"),i18n("Next LaTeX Error"), this, SLOT(NextError()));

MenuBar->insertItem(i18n("Edit"), edit);
MenuBar->insertSeparator();

tools=new QPopupMenu();
id = tools->insertItem(SmallIcon("exec"),i18n("LaTeX 'tex file'"), this, SLOT(Latex()));
keys->changeMenuAccel(tools, id, "LaTeX 'tex file'");
id = tools->insertItem(SmallIcon("log"),i18n("View 'log file'"), this, SLOT(ViewLog()));
id = tools->insertItem(SmallIcon("dvi"),i18n("DVI Viewer"), this, SLOT(ViewDvi()));
keys->changeMenuAccel(tools, id, "DVI Viewer");
id = tools->insertItem(i18n("DVI -> PS"), this, SLOT(DviToPS()));
keys->changeMenuAccel(tools, id, "DVI -> PS");
id = tools->insertItem(SmallIcon("postscript"),i18n("PS Viewer"), this, SLOT(ViewPS()));
keys->changeMenuAccel(tools, id, "PS Viewer");
tools->insertSeparator();
id = tools->insertItem(SmallIcon("exec"),i18n("PDFLaTeX 'tex file'"), this, SLOT(PDFLatex()));
keys->changeMenuAccel(tools, id, "PDFLaTeX 'tex file'");
id = tools->insertItem(i18n("PS -> PDF"), this, SLOT(PStoPDF()));
id = tools->insertItem(SmallIcon("pdf"),i18n("PDF Viewer"), this, SLOT(ViewPDF()));
keys->changeMenuAccel(tools, id, "PDF Viewer");
tools->insertSeparator();
id = tools->insertItem(i18n("Latex2html"), this, SLOT(LatexToHtml()));
id = tools->insertItem(SmallIcon("html"),i18n("Html Preview"), this, SLOT(HtmlPreview()));
tools->insertSeparator();
id = tools->insertItem(i18n("Make index 'idx file'"), this, SLOT(MakeIndex()));
id = tools->insertItem(i18n("BibTeX 'aux file'"), this, SLOT(MakeBib()));
tools->insertSeparator();
id = tools->insertItem(SmallIcon("kdvi"),i18n("Preview"), this, SLOT(Preview()));
keys->changeMenuAccel(tools, id, "Preview");
id = tools->insertItem(SmallIcon("openterm"),i18n("TeX Terminal"), this, SLOT(Terminal()));
keys->changeMenuAccel(tools, id, "TeX Terminal");
tools->insertSeparator();
id = tools->insertItem(i18n("Clean"), this, SLOT(CleanAll()));
MenuBar->insertItem(i18n("Tools"), tools);
MenuBar->insertSeparator();

latex1=new QPopupMenu();

id = latex1->insertItem("\\documentclass", this, SLOT(Insert1()));
id = latex1->insertItem("\\usepackage{}", this, SLOT(Insert1bis()));
id = latex1->insertItem("AMS packages", this, SLOT(Insert1ter()));
id = latex1->insertItem("\\begin{document}", this, SLOT(Insert2()));
id = latex1->insertItem("\\author{}", this, SLOT(Insert45()));
id = latex1->insertItem("\\title{}", this, SLOT(Insert46()));

latex11=new QPopupMenu();
id = latex11->insertItem("\\part", this, SLOT(Insert3()));
id = latex11->insertItem("\\chapter", this, SLOT(Insert4()));
id = latex11->insertItem("\\section", this, SLOT(Insert5()));
id = latex11->insertItem("\\subsection", this, SLOT(Insert6()));
id = latex11->insertItem("\\subsubsection", this, SLOT(Insert6bis()));
id = latex11->insertItem("\\paragraph", this, SLOT(Insert7()));
id = latex11->insertItem("\\subparagraph", this, SLOT(Insert8()));
latex1->insertItem(i18n("Sectionning"), latex11);

latex12=new QPopupMenu();
id = latex12->insertItem("\\begin{center}", this, SLOT(Insert9()));
id = latex12->insertItem("\\begin{flushleft}", this, SLOT(Insert10()));
id = latex12->insertItem("\\begin{flushright}", this, SLOT(Insert11()));
id = latex12->insertItem("\\begin{quote}", this, SLOT(Insert12()));
id = latex12->insertItem("\\begin{quotation}", this, SLOT(Insert13()));
id = latex12->insertItem("\\begin{verse}", this, SLOT(Insert14()));
id = latex12->insertItem("\\begin{verbatim}", this, SLOT(Insert15()));
id = latex12->insertItem("\\begin{table}", this, SLOT(Insert42()));
id = latex12->insertItem("\\begin{figure}", this, SLOT(Insert43()));
id = latex12->insertItem("\\begin{titlepage}", this, SLOT(Insert44()));
latex1->insertItem(i18n("Environment"), latex12);

latex13=new QPopupMenu();
id = latex13->insertItem("\\begin{itemize}", this, SLOT(Insert16()));
id = latex13->insertItem("\\begin{enumerate}", this, SLOT(Insert17()));
id = latex13->insertItem("\\begin{description}", this, SLOT(Insert18()));
id = latex13->insertItem("\\begin{list}", this, SLOT(Insert19()));
id = latex13->insertItem("\\item", this, SLOT(Insert20()));
latex1->insertItem(i18n("List Environment"), latex13);

latex14=new QPopupMenu();
id = latex14->insertItem("\\textit - Italics", this, SLOT(Insert21()));
keys->changeMenuAccel(latex14, id, "\\textit - Italics");
id = latex14->insertItem("\\textsl - Slanted", this, SLOT(Insert22()));
keys->changeMenuAccel(latex14, id, "\\textsl - Slanted");
id = latex14->insertItem("\\textbf - Boldface", this, SLOT(Insert23()));
keys->changeMenuAccel(latex14, id, "\\textbf - Boldface");
id = latex14->insertItem("\\texttt - Typewriter", this, SLOT(Insert24()));
keys->changeMenuAccel(latex14, id, "\\texttt - Typewriter");
id = latex14->insertItem("\\textsc - Small caps", this, SLOT(Insert25()));
keys->changeMenuAccel(latex14, id, "\\textsc - Small caps");
latex1->insertItem(i18n("Font Styles"), latex14);

latex15=new QPopupMenu();
id = latex15->insertItem("\\begin{tabbing}", this, SLOT(Insert26()));
id = latex15->insertItem("\\begin{tabular}", this, SLOT(Insert27()));
id = latex15->insertItem("\\multicolumn", this, SLOT(Insert28()));
id = latex15->insertItem("\\hline", this, SLOT(Insert29()));
id = latex15->insertItem("\\vline", this, SLOT(Insert30()));
id = latex15->insertItem("\\cline", this, SLOT(Insert31()));
latex1->insertItem(i18n("Tabular Environment"), latex15);

latex16=new QPopupMenu();
id = latex16->insertItem("\\newpage", this, SLOT(Insert32()));
id = latex16->insertItem("\\linebreak", this, SLOT(Insert33()));
id = latex16->insertItem("\\pagebreak", this, SLOT(Insert34()));
id = latex16->insertItem("\\bigskip", this, SLOT(Insert35()));
id = latex16->insertItem("\\medskip", this, SLOT(Insert36()));
latex1->insertItem(i18n("Spacing"), latex16);
latex1->insertSeparator();
id = latex1->insertItem("\\includegraphics{file.eps}", this, SLOT(Insert37()));
id = latex1->insertItem("\\include{file}", this, SLOT(Insert37bis()));
id = latex1->insertItem("\\input{file}", this, SLOT(Insert37ter()));
latex1->insertSeparator();
id = latex1->insertItem("\\label{}", this, SLOT(Insert41()));
id = latex1->insertItem("\\cite{}", this, SLOT(Insert38()));
id = latex1->insertItem("\\bibliographystyle{}", this, SLOT(Insert39()));
id = latex1->insertItem("\\bibliography{}", this, SLOT(Insert40()));
MenuBar->insertItem("LaTeX", latex1);

math1=new QPopupMenu();

id = math1->insertItem("$...$", this, SLOT(InsertMath1()));
keys->changeMenuAccel(math1, id, "$...$");
id = math1->insertItem("$$...$$", this, SLOT(InsertMath2()));
keys->changeMenuAccel(math1, id, "$$...$$");
id = math1->insertItem("\\begin{equation}", this, SLOT(InsertMath74()));
id = math1->insertItem("\\begin{eqnarray}", this, SLOT(InsertMath75()));
math1->insertSeparator();
id = math1->insertItem("_{} - subscript", this, SLOT(InsertMath3()));
keys->changeMenuAccel(math1, id, "_{} - subscript");
id = math1->insertItem("^{} - superscript", this, SLOT(InsertMath4()));
keys->changeMenuAccel(math1, id, "^{} - superscript");
id = math1->insertItem("\\frac{}{}", this, SLOT(InsertMath5()));
keys->changeMenuAccel(math1, id, "\\frac{}{}");
id = math1->insertItem("\\dfrac{}{}", this, SLOT(InsertMath6()));
keys->changeMenuAccel(math1, id, "\\dfrac{}{}");
id = math1->insertItem("\\sqrt{}", this, SLOT(InsertMath7()));
keys->changeMenuAccel(math1, id, "\\sqrt{}");
id = math1->insertItem("\\left", this, SLOT(InsertMath8()));
keys->changeMenuAccel(math1, id, "\\left");
id = math1->insertItem("\\right", this, SLOT(InsertMath9()));
keys->changeMenuAccel(math1, id, "\\right");
id = math1->insertItem("\\begin{array}", this, SLOT(InsertMath10()));

math11=new QPopupMenu();
id = math11->insertItem(UserIcon("lbrace"),"\\lbrace", this, SLOT(InsertMath11()));
id = math11->insertItem(UserIcon("rbrace"),"\\rbrace", this, SLOT(InsertMath12()));
id = math11->insertItem(UserIcon("overbrace"),"\\overbrace{}", this, SLOT(InsertMath13()));
id = math11->insertItem(UserIcon("underbrace"),"\\underbrace{}", this, SLOT(InsertMath14()));
id = math11->insertItem(UserIcon("overline"),"\\overline{}", this, SLOT(InsertMath15()));
id = math11->insertItem(UserIcon("underlinebis"),"\\underline{}", this, SLOT(InsertMath16()));
id = math11->insertItem(UserIcon("widehat"),"\\widehat{}", this, SLOT(InsertMath54()));
id = math11->insertItem(UserIcon("vert"),"\\vert", this, SLOT(InsertMath17()));
id = math11->insertItem(UserIcon("Vert"),"\\Vert", this, SLOT(InsertMath18()));
math1->insertItem(i18n("Delimiters"), math11);

math12=new QPopupMenu();
id = math12->insertItem(UserIcon("le"),"\\leq", this, SLOT(InsertMath19()));
id = math12->insertItem(UserIcon("ge"),"\\geq", this, SLOT(InsertMath20()));
id = math12->insertItem(UserIcon("leslant"),"\\leqslant", this, SLOT(InsertMath48()));
id = math12->insertItem(UserIcon("geslant"),"\\geqslant", this, SLOT(InsertMath49()));
id = math12->insertItem(UserIcon("sumbis"),"\\sum", this, SLOT(InsertMath21()));
id = math12->insertItem(UserIcon("prod"),"\\prod", this, SLOT(InsertMath22()));
id = math12->insertItem("\\lim", this, SLOT(InsertMath23()));
id = math12->insertItem(UserIcon("int"),"\\int", this, SLOT(InsertMath24()));
id = math12->insertItem(UserIcon("cdot"),"\\cdot", this, SLOT(InsertMath25()));
id = math12->insertItem(UserIcon("times"),"\\times", this, SLOT(InsertMath26()));
id = math12->insertItem(UserIcon("div"),"\\div", this, SLOT(InsertMath44()));
math1->insertItem(i18n("Operators1"), math12);
math16=new QPopupMenu();
id = math16->insertItem(UserIcon("cup"),"\\cup", this, SLOT(InsertMath27()));
id = math16->insertItem(UserIcon("cap"),"\\cap", this, SLOT(InsertMath28()));
id = math16->insertItem(UserIcon("subset"),"\\subset", this, SLOT(InsertMath50()));
id = math16->insertItem(UserIcon("wedge"),"\\wedge", this, SLOT(InsertMath47()));
id = math16->insertItem(UserIcon("pm"),"\\pm", this, SLOT(InsertMath43()));
id = math16->insertItem(UserIcon("star"),"\\star", this, SLOT(InsertMath45()));
id = math16->insertItem(UserIcon("bullet"),"\\bullet", this, SLOT(InsertMath46()));
id = math16->insertItem(UserIcon("in"),"\\in", this, SLOT(InsertMath29()));
id = math16->insertItem(UserIcon("notin"),"\\notin", this, SLOT(InsertMath55()));
id = math16->insertItem(UserIcon("neq"),"\\neq", this, SLOT(InsertMath30()));
id = math16->insertItem(UserIcon("approx"),"\\approx", this, SLOT(InsertMath51()));
id = math16->insertItem(UserIcon("perp"),"\\perp", this, SLOT(InsertMath52()));
id = math16->insertItem(UserIcon("parallel"),"\\parallel", this, SLOT(InsertMath53()));
math1->insertItem(i18n("Operators2"), math16);

math13=new QPopupMenu();
id = math13->insertItem(UserIcon("leftarrow"),"\\leftarrow", this, SLOT(InsertMath31()));
id = math13->insertItem(UserIcon("rightarrow"),"\\rightarrow", this, SLOT(InsertMath32()));
id = math13->insertItem(UserIcon("leftrightarrow"),"\\leftrightarrow", this, SLOT(InsertMath33()));
id = math13->insertItem(UserIcon("Leftarrow"),"\\Leftarrow", this, SLOT(InsertMath34()));
id = math13->insertItem(UserIcon("Rightarrow"),"\\Rightarrow", this, SLOT(InsertMath35()));
id = math13->insertItem(UserIcon("Leftrightarrow"),"\\Leftrightarrow", this, SLOT(InsertMath36()));
id = math13->insertItem(UserIcon("overrightarrow"),"\\overrightarrow", this, SLOT(InsertMath37()));
id = math13->insertItem(UserIcon("uparrow"),"\\uparrow", this, SLOT(InsertMath56()));
id = math13->insertItem(UserIcon("Uparrow"),"\\Uparrow", this, SLOT(InsertMath57()));
id = math13->insertItem(UserIcon("downarrow"),"\\downarrow", this, SLOT(InsertMath58()));
id = math13->insertItem(UserIcon("Downarrow"),"\\Downarrow", this, SLOT(InsertMath59()));
id = math13->insertItem(UserIcon("updownarrow"),"\\updownarrow", this, SLOT(InsertMath60()));
id = math13->insertItem(UserIcon("Updownarrow"),"\\Updownarrow", this, SLOT(InsertMath61()));
id = math13->insertItem(UserIcon("nearrow"),"\\nearrow", this, SLOT(InsertMath62()));
id = math13->insertItem(UserIcon("searrow"),"\\searrow", this, SLOT(InsertMath63()));
id = math13->insertItem(UserIcon("swarrow"),"\\swarrow", this, SLOT(InsertMath64()));
id = math13->insertItem(UserIcon("nwarrow"),"\\nwarrow", this, SLOT(InsertMath65()));
math1->insertItem(i18n("Arrows"), math13);

math14=new QPopupMenu();
id = math14->insertItem(UserIcon("forall"),"\\forall", this, SLOT(InsertMath38()));
id = math14->insertItem(UserIcon("exists"),"\\exists", this, SLOT(InsertMath39()));
id = math14->insertItem(UserIcon("infty"),"\\infty", this, SLOT(InsertMath40()));
id = math14->insertItem(UserIcon("partial"),"\\partial", this, SLOT(InsertMath41()));
id = math14->insertItem(UserIcon("prime"),"\\prime", this, SLOT(InsertMath42()));
math1->insertItem(i18n("Symbols"), math14);

math15=new QPopupMenu();
id = math15->insertItem("\\mathrm{}", this, SLOT(InsertMath66()));
id = math15->insertItem("\\mathit{}", this, SLOT(InsertMath67()));
id = math15->insertItem("\\mathbf{}", this, SLOT(InsertMath68()));
id = math15->insertItem("\\mathsf{}", this, SLOT(InsertMath69()));
id = math15->insertItem("\\mathtt{}", this, SLOT(InsertMath70()));
id = math15->insertItem("\\mathcal{}", this, SLOT(InsertMath71()));
id = math15->insertItem("\\mathbb{}", this, SLOT(InsertMath72()));
id = math15->insertItem("\\mathfrak{}", this, SLOT(InsertMath73()));
math1->insertItem(i18n("Math Font Styles"), math15);

math17=new QPopupMenu();
id = math17->insertItem(UserIcon("acute"),"\\acute{}", this, SLOT(InsertMath76()));
id = math17->insertItem(UserIcon("grave"),"\\grave{}", this, SLOT(InsertMath77()));
id = math17->insertItem(UserIcon("tilde"),"\\tilde{}", this, SLOT(InsertMath78()));
id = math17->insertItem(UserIcon("bar"),"\\bar{}", this, SLOT(InsertMath79()));
id = math17->insertItem(UserIcon("vec"),"\\vec{}", this, SLOT(InsertMath80()));
id = math17->insertItem(UserIcon("hat"),"\\hat{}", this, SLOT(InsertMath81()));
id = math17->insertItem(UserIcon("check"),"\\check{}", this, SLOT(InsertMath82()));
id = math17->insertItem(UserIcon("breve"),"\\breve{}", this, SLOT(InsertMath83()));
id = math17->insertItem(UserIcon("dot"),"\\dot{}", this, SLOT(InsertMath84()));
id = math17->insertItem(UserIcon("ddot"),"\\ddot{}", this, SLOT(InsertMath85()));
math1->insertItem(i18n("Math Accents"), math17);

math18=new QPopupMenu();
id = math18->insertItem("small", this, SLOT(InsertMath86()));
id = math18->insertItem("medium", this, SLOT(InsertMath87()));
id = math18->insertItem("large", this, SLOT(InsertMath88()));
id = math18->insertItem("\\quad", this, SLOT(InsertMath89()));
id = math18->insertItem("\\qquad", this, SLOT(InsertMath90()));
math1->insertItem(i18n("Math Spaces"), math18);

MenuBar->insertItem(i18n("Math"), math1);
MenuBar->insertSeparator();

greek1=new QPopupMenu();
greek11=new QPopupMenu();
id = greek11->insertItem(UserIcon("alpha"),"\\alpha", this, SLOT(InsertGreek1()));
id = greek11->insertItem(UserIcon("beta"),"\\beta", this, SLOT(InsertGreek2()));
id = greek11->insertItem(UserIcon("gamma"),"\\gamma", this, SLOT(InsertGreek3()));
id = greek11->insertItem(UserIcon("delta"),"\\delta", this, SLOT(InsertGreek4()));
id = greek11->insertItem(UserIcon("epsilon"),"\\epsilon", this, SLOT(InsertGreek5()));
id = greek11->insertItem(UserIcon("varepsilon"),"\\varepsilon", this, SLOT(InsertGreek6()));
id = greek11->insertItem(UserIcon("zeta"),"\\zeta", this, SLOT(InsertGreek7()));
id = greek11->insertItem(UserIcon("eta"),"\\eta", this, SLOT(InsertGreek8()));
id = greek11->insertItem(UserIcon("theta"),"\\theta", this, SLOT(InsertGreek9()));
id = greek11->insertItem(UserIcon("vartheta"),"\\vartheta", this, SLOT(InsertGreek10()));
id = greek11->insertItem(UserIcon("iota"),"\\iota", this, SLOT(InsertGreek11()));
id = greek11->insertItem(UserIcon("kappa"),"\\kappa", this, SLOT(InsertGreek12()));
id = greek11->insertItem(UserIcon("lambda"),"\\lambda", this, SLOT(InsertGreek13()));
id = greek11->insertItem(UserIcon("mu"),"\\mu", this, SLOT(InsertGreek14()));
id = greek11->insertItem(UserIcon("nu"),"\\nu", this, SLOT(InsertGreek15()));
greek1->insertItem(i18n("Lowercase1"), greek11);

greek12=new QPopupMenu();
id = greek12->insertItem(UserIcon("xi"),"\\xi", this, SLOT(InsertGreek16()));
id = greek12->insertItem(UserIcon("pi"),"\\pi", this, SLOT(InsertGreek17()));
id = greek12->insertItem(UserIcon("varpi"),"\\varpi", this, SLOT(InsertGreek18()));
id = greek12->insertItem(UserIcon("rho"),"\\rho", this, SLOT(InsertGreek19()));
id = greek12->insertItem(UserIcon("varrho"),"\\varrho", this, SLOT(InsertGreek20()));
id = greek12->insertItem(UserIcon("sigma"),"\\sigma", this, SLOT(InsertGreek21()));
id = greek12->insertItem(UserIcon("varsigma"),"\\varsigma", this, SLOT(InsertGreek22()));
id = greek12->insertItem(UserIcon("tau"),"\\tau", this, SLOT(InsertGreek23()));
id = greek12->insertItem(UserIcon("upsilon"),"\\upsilon", this, SLOT(InsertGreek24()));
id = greek12->insertItem(UserIcon("phi"),"\\phi", this, SLOT(InsertGreek25()));
id = greek12->insertItem(UserIcon("varphi"),"\\varphi", this, SLOT(InsertGreek26()));
id = greek12->insertItem(UserIcon("chi"),"\\chi", this, SLOT(InsertGreek27()));
id = greek12->insertItem(UserIcon("psi"),"\\psi", this, SLOT(InsertGreek28()));
id = greek12->insertItem(UserIcon("omega"),"\\omega", this, SLOT(InsertGreek29()));
greek1->insertItem(i18n("Lowercase2"), greek12);

greek13=new QPopupMenu();
id = greek13->insertItem(UserIcon("Gamma"),"\\Gamma", this, SLOT(InsertGreek30()));
id = greek13->insertItem(UserIcon("Delta"),"\\Delta", this, SLOT(InsertGreek31()));
id = greek13->insertItem(UserIcon("Theta"),"\\Theta", this, SLOT(InsertGreek32()));
id = greek13->insertItem(UserIcon("Lambda"),"\\Lambda", this, SLOT(InsertGreek33()));
id = greek13->insertItem(UserIcon("Xi"),"\\Xi", this, SLOT(InsertGreek34()));
id = greek13->insertItem(UserIcon("Pi"),"\\Pi", this, SLOT(InsertGreek35()));
id = greek13->insertItem(UserIcon("Sigma"),"\\Sigma", this, SLOT(InsertGreek36()));
id = greek13->insertItem(UserIcon("Upsilon"),"\\Upsilon", this, SLOT(InsertGreek37()));
id = greek13->insertItem(UserIcon("Phi"),"\\Phi", this, SLOT(InsertGreek38()));
id = greek13->insertItem(UserIcon("Psi"),"\\Psi", this, SLOT(InsertGreek39()));
id = greek13->insertItem(UserIcon("Omega"),"\\Omega", this, SLOT(InsertGreek40()));
greek1->insertItem(i18n("Uppercase"), greek13);
MenuBar->insertItem(i18n("Greek"), greek1);
MenuBar->insertSeparator();

wizard=new QPopupMenu();
id = wizard->insertItem(SmallIcon("wizard"),i18n("Quick Start"), this, SLOT(QuickDocument()));
id = wizard->insertItem(SmallIcon("wizard"),i18n("Quick Letter"), this, SLOT(QuickLetter()));
wizard->insertSeparator();
id = wizard->insertItem(SmallIcon("wizard"),i18n("Quick Tabular"), this, SLOT(QuickTabular()));
id = wizard->insertItem(SmallIcon("wizard"),i18n("Quick Array"), this, SLOT(QuickArray()));

MenuBar->insertItem(i18n("Wizard"), wizard);
MenuBar->insertSeparator();

bibmenu=new QPopupMenu();

id = bibmenu->insertItem("Article in Journal", this, SLOT(InsertBib1()));
id = bibmenu->insertItem("Article in Conference Proceedings", this, SLOT(InsertBib2()));
id = bibmenu->insertItem("Article in a collection", this, SLOT(InsertBib3()));
id = bibmenu->insertItem("Chapter or Pages in a Book", this, SLOT(InsertBib4()));
id = bibmenu->insertItem("Conference Proceedings", this, SLOT(InsertBib5()));
id = bibmenu->insertItem("Book", this, SLOT(InsertBib6()));
id = bibmenu->insertItem("Booklet", this, SLOT(InsertBib7()));
id = bibmenu->insertItem("PhD. Thesis", this, SLOT(InsertBib8()));
id = bibmenu->insertItem("Master's Thesis", this, SLOT(InsertBib9()));
id = bibmenu->insertItem("Technical Report", this, SLOT(InsertBib10()));
id = bibmenu->insertItem("Technical Manual", this, SLOT(InsertBib11()));
id = bibmenu->insertItem("Unpublished", this, SLOT(InsertBib12()));
id = bibmenu->insertItem("Miscellaneous", this, SLOT(InsertBib13()));
MenuBar->insertItem(i18n("Bibliography"), bibmenu);
MenuBar->insertSeparator();

usermenu = new QPopupMenu();
for (int i=9; i>-1; i--)
  {
  QString nu=QString::number(10-i);
  nu=nu.leftJustify(2,' ');
  usermenu->insertItem(nu+": "+UserMenuNames->at(i));
  }
connect(usermenu, SIGNAL(activated(int)), SLOT(InsertUserTag(int)));
usermenu->insertSeparator();
usermenu->insertItem(i18n("Edit User Menu"),this, SLOT(EditUserMenu()));
MenuBar->insertItem (i18n("User"), usermenu);
MenuBar->insertSeparator();

grafmenu=new QPopupMenu();
grafmenu->insertItem(UserIcon("xfig"),i18n("Xfig"),this,SLOT(RunXfig()));
grafmenu->insertItem(i18n("Gnuplot Front End"),this,SLOT(RunGfe()));
MenuBar->insertItem(i18n("Graph"), grafmenu);
MenuBar->insertSeparator();

options=new QPopupMenu();
options->insertItem(SmallIcon("edit"),i18n("Editor Options"),this,SLOT(slotOptionsEditor()));
options->insertItem(SmallIcon("fonts"),i18n("Editor Fonts and Highlighting"),this,SLOT(slotOptionsEditorFonts()));
options->insertItem(i18n("Configure Keys"),this,SLOT(ConfigureKeys()));
options->insertSeparator();
id = options->insertItem(i18n("Toggle LaTeX/PdfLaTeX mode"), this, SLOT(ToggleLatexMode()));
id = options->insertItem(i18n("Toggle KDE/X mode"), this, SLOT(ToggleTools()));
id = options->insertItem(i18n("Toggle Single/Multi mode"), this, SLOT(ToggleMode()));
options->insertSeparator();
options->insertItem(SmallIcon("configure"),i18n("Define Structure View"),this,SLOT(ChangeStructViewItems()));
options->insertItem(SmallIcon("configure"),i18n("Configure Tools"),this,SLOT(OptionsTools()));
options->insertSeparator();
id = options->insertItem(i18n("Show Structure View"),this,SLOT(ToggleStructView()),0,ID_VIEW_STRUCTVIEW);
id = options->insertItem(i18n("Show Output View"),this,SLOT(ToggleOutputView()),0,ID_VIEW_OUTPUTVIEW);
if (showstructview) {options->setItemChecked(ID_VIEW_STRUCTVIEW,true);}
else {options->setItemChecked(ID_VIEW_STRUCTVIEW,false);}
if (showoutputview) {options->setItemChecked(ID_VIEW_OUTPUTVIEW,true);}
else {options->setItemChecked(ID_VIEW_OUTPUTVIEW,false);}
MenuBar->insertItem(i18n("Options"), options);
MenuBar->insertSeparator();


const KAboutData *aboutData = KGlobal::instance()->aboutData();
help_menu = new KHelpMenu( this, aboutData);
KPopupMenu *help = help_menu->menu();
help->clear();
help->insertItem(SmallIcon("help"),i18n("LaTeX Reference"),this,SLOT(LatexHelp()));
help->insertItem(SmallIcon("help"),i18n("Table of Math symbols"), this, SLOT(Symbols()));
help->insertItem(SmallIcon("help"),i18n("User Manual"),this,SLOT(UserManual()));
help->insertSeparator();	
QString appName = (aboutData)? aboutData->programName() : QString::fromLatin1(kapp->name());
help->insertItem( kapp->miniIcon(), i18n( "&About %1" ).arg(appName), help_menu, SLOT( aboutApplication() ));
help->insertItem( SmallIcon("go"), i18n( "About &KDE" ),help_menu, SLOT( aboutKDE() ) );

MenuBar->insertItem(i18n("&Help"), help_menu->menu());  	

}
////////////////////////////////// TOOL BAR ///////////////////////////////////
void Ktexmaker2::InitToolBar()
{


MainToolBar = new KToolBar(this);

MainToolBar->insertButton(UserIcon("new"), 0,SIGNAL(clicked()), this,SLOT(NewFile()), TRUE, i18n("New Document"));
MainToolBar->insertButton(UserIcon("open"), 0,SIGNAL(clicked()), this,SLOT(OpenFile()), TRUE, i18n("Open Document"));
MainToolBar->insertButton(UserIcon("save"), 0,SIGNAL(clicked()), this,SLOT(SaveFile()), TRUE, i18n("Save Document"));
MainToolBar->insertButton(UserIcon("close"), 0,SIGNAL(clicked()), this, SLOT(Close()), TRUE, i18n("Close document"));
MainToolBar->insertButton(UserIcon("undo"), 0,SIGNAL(clicked()), this, SLOT(Undo()), TRUE, i18n("Undo"));
MainToolBar->insertButton(UserIcon("redo"), 0,SIGNAL(clicked()), this, SLOT(Redo()), TRUE, i18n("Redo"));
MainToolBar->insertButton(UserIcon("cut"), 0,SIGNAL(clicked()), this, SLOT(Cut()), TRUE, i18n("Cut"));
MainToolBar->insertButton(UserIcon("copy"), 0,SIGNAL(clicked()), this, SLOT(Copy()), TRUE, i18n("Copy"));
MainToolBar->insertButton(UserIcon("paste"), 0,SIGNAL(clicked()), this, SLOT(Paste()), TRUE, i18n("Paste"));
MainToolBar->insertButton(UserIcon("find"), 0,SIGNAL(clicked()), this, SLOT(Search()), TRUE, i18n("Search"));

MainToolBar->insertLineSeparator();

MainToolBar->insertButton(UserIcon("structure"), 0,SIGNAL(clicked()), this, SLOT(UpdateStructure()), TRUE, i18n("Refresh Structure"));
MainToolBar->insertButton(UserIcon("log"), 0,SIGNAL(clicked()), this, SLOT(ViewLog()), TRUE, i18n("View 'Log file'"));
MainToolBar->insertButton(UserIcon("errorprev"), 0,SIGNAL(clicked()), this, SLOT(PreviousError()), TRUE, i18n("Previous LaTeX Error"));
MainToolBar->insertButton(UserIcon("errornext"), 0,SIGNAL(clicked()), this, SLOT(NextError()), TRUE, i18n("Next LaTeX Error"));

MainToolBar->insertLineSeparator();

MainToolBar->insertButton(UserIcon("latex"), 0,SIGNAL(clicked()), this,SLOT(Compile()), TRUE, i18n("Compile"));
MainToolBar->insertButton(UserIcon("preview"),0,SIGNAL(clicked()),this,SLOT(Preview()),true,i18n("Preview"));

MainToolBar->insertLineSeparator();

MainToolBar->insertButton(UserIcon("dvi"), 0,SIGNAL(clicked()), this,SLOT(ViewDvi()), TRUE, i18n("DVI Viewer"));
MainToolBar->insertButton(UserIcon("dvips"), 0,SIGNAL(clicked()), this,SLOT(DviToPS()), TRUE, i18n("DVI to PS"));
MainToolBar->insertButton(UserIcon("ps"), 0,SIGNAL(clicked()), this,SLOT(ViewPS()), TRUE, i18n("PS Viewer"));
MainToolBar->insertButton(UserIcon("pdf"), 0,SIGNAL(clicked()), this,SLOT(ViewPDF()), TRUE, i18n("PDF Viewer"));

MainToolBar->insertLineSeparator();

MainToolBar->insertButton(UserIcon("back"), ID_BACK,SIGNAL(clicked()), this, SLOT(BrowserBack()), false, i18n("Back"));
MainToolBar->insertButton(UserIcon("forward"), ID_FORWARD,SIGNAL(clicked()), this, SLOT(BrowserForward()), false, i18n("Forward"));
MainToolBar->insertButton(UserIcon("home"), ID_HOME,SIGNAL(clicked()), this, SLOT(BrowserHome()), false, i18n("Index"));
MainToolBar->insertLineSeparator();
MainToolBar->insertButton(UserIcon("editorview"),ID_EDITORVIEW,SIGNAL(clicked()),this,SLOT(ShowEditorWidget()),false,i18n("Return to Editor View"));



QuickToolBar = new KToolBar(this);
QuickToolBar->insertButton(UserIcon("bold"), 0,SIGNAL(clicked()), this,SLOT(Insert23()), TRUE, i18n("Bold"));
QuickToolBar->insertButton(UserIcon("italic"), 0,SIGNAL(clicked()), this,SLOT(Insert21()), TRUE, i18n("Italic"));
QuickToolBar->insertButton(UserIcon("underline"), 0,SIGNAL(clicked()), this,SLOT(InsertMath16()), TRUE, i18n("Underline"));
QuickToolBar->insertButton(UserIcon("left"), 0,SIGNAL(clicked()), this,SLOT(Insert10()), TRUE, i18n("Left"));
QuickToolBar->insertButton(UserIcon("center"), 0,SIGNAL(clicked()), this,SLOT(Insert9()), TRUE, i18n("Center"));
QuickToolBar->insertButton(UserIcon("right"), 0,SIGNAL(clicked()), this,SLOT(Insert11()), TRUE, i18n("Right"));
combolist3=new QStrList();
combolist3->append("tiny");
combolist3->append("scriptsize");
combolist3->append("footnotesize");
combolist3->append("small");
combolist3->append("normalsize");
combolist3->append("large");
combolist3->append("Large");
combolist3->append("LARGE");
combolist3->append("huge");
combolist3->append("Huge");
QuickToolBar->insertCombo(combolist3,ID_COMBO3,false,SIGNAL(activated(const QString&)),this,SLOT(SizeCommand(const QString&)),true,i18n("Size Commands") );
KComboBox* combo3 = QuickToolBar->getCombo(ID_COMBO3);
combo3->setFocusPolicy(QWidget::ClickFocus);
QuickToolBar->insertSeparator();
QuickToolBar->insertLineSeparator();
QuickToolBar->insertButton(UserIcon("mathmode"), 0,SIGNAL(clicked()), this,SLOT(InsertMath1()), TRUE, i18n("Inline Math ($...$)"));
QuickToolBar->insertButton(UserIcon("indice"), 0,SIGNAL(clicked()), this,SLOT(InsertMath3()), TRUE, i18n("Subscript"));
QuickToolBar->insertButton(UserIcon("puissance"), 0,SIGNAL(clicked()), this,SLOT(InsertMath4()), TRUE, i18n("Superscript"));
QuickToolBar->insertButton(UserIcon("frac"), 0,SIGNAL(clicked()), this,SLOT(InsertMath5()), TRUE, i18n("frac"));
QuickToolBar->insertButton(UserIcon("dfrac"), 0,SIGNAL(clicked()), this,SLOT(InsertMath6()), TRUE, i18n("dfrac"));
QuickToolBar->insertButton(UserIcon("racine"), 0,SIGNAL(clicked()), this,SLOT(InsertMath7()), TRUE, i18n("sqrt"));
QuickToolBar->insertButton(UserIcon("sum"), 0,SIGNAL(clicked()), this,SLOT(InsertMath21()), TRUE, i18n("sum"));
QuickToolBar->insertButton(UserIcon("integral"), 0,SIGNAL(clicked()), this,SLOT(InsertMath24()), TRUE, i18n("int"));
QuickToolBar->insertLineSeparator();
QuickToolBar->insertSeparator();
combolist1=new QStrList();
combolist1->append("left (");
combolist1->append("left [");
combolist1->append("left {");
combolist1->append("left <");
combolist1->append("left )");
combolist1->append("left ]");
combolist1->append("left }");
combolist1->append("left >");
combolist1->append("left.");
QuickToolBar->insertCombo(combolist1,ID_COMBO1,false,SIGNAL(activated(const QString&)),this,SLOT(LeftDelimiter(const QString&)),true,i18n("Left delimiter") );
KComboBox* combo1 = QuickToolBar->getCombo(ID_COMBO1);
combo1->setFocusPolicy(QWidget::ClickFocus);
QuickToolBar->insertSeparator();
combolist2=new QStrList();
combolist2->append("right )");
combolist2->append("right ]");
combolist2->append("right }");
combolist2->append("right >");
combolist2->append("right (");
combolist2->append("right [");
combolist2->append("right {");
combolist2->append("right <");
combolist2->append("right.");
QuickToolBar->insertCombo(combolist2,ID_COMBO2,false,SIGNAL(activated(const QString&)),this,SLOT(RightDelimiter(const QString&)),true,i18n("Right delimiter") );
KComboBox* combo2 = QuickToolBar->getCombo(ID_COMBO2);
combo2->setFocusPolicy(QWidget::ClickFocus);
QuickToolBar->insertSeparator();
QuickToolBar->insertLineSeparator();
QuickToolBar->insertButton(UserIcon("newline"), 0,SIGNAL(clicked()), this,SLOT(NewLine()), TRUE, i18n("New Line"));

}
////////////////////////// STATUS BAR //////////////////////////////////////
void Ktexmaker2::InitStatusBar()
{
StatusBar = new KStatusBar(this);
StatusBar->insertFixedItem( "Line:000000 Col: 000", ID_LINE_COLUMN );
StatusBar->insertItem("XXXXX", ID_TOOLS);
StatusBar->insertItem("XXXXXXXX", ID_MODE);
StatusBar->insertItem("XXXXXXXXXX", ID_LATEXMODE);
StatusBar->insertItem(i18n("Untitled"), ID_HINTTEXT,10);

StatusBar->setItemAlignment( ID_HINTTEXT, AlignLeft|AlignVCenter );
StatusBar->setItemAlignment( ID_LINE_COLUMN, AlignLeft|AlignVCenter );
StatusBar->changeItem( i18n("Line: 1 Col: 1"), ID_LINE_COLUMN );
if (kdetools) {StatusBar->changeItem(" KDE ", ID_TOOLS);}
else {StatusBar->changeItem("  X  ", ID_TOOLS);}
if (singlemode) {StatusBar->changeItem(" Single ", ID_MODE);}
else {StatusBar->changeItem(" Multi ", ID_MODE);}
if (latexmode) {StatusBar->changeItem(" LaTeX ", ID_LATEXMODE);}
else {StatusBar->changeItem(" PdfLaTeX ", ID_LATEXMODE);}
}

void Ktexmaker2::UpdateLineColStatus()
{
QString linenumber;
linenumber.sprintf(i18n("Line: %d Col: %d"), Editor->currentLine() + 1, Editor->currentColumn() + 1);
this->statusBar()->changeItem(linenumber.data(), ID_LINE_COLUMN);
}

//////////////////////////   MAIN WIDGET //////////////////////////////////
void Ktexmaker2::InitMainWidget()
{
MenuBar->show();
addToolBar(MainToolBar);
MainToolBar->setBarPos(KToolBar::Top);
MainToolBar->show();
addToolBar(QuickToolBar);
QuickToolBar->setBarPos(KToolBar::Top);
QuickToolBar->show();

topWidgetStack = new QWidgetStack( this );
topWidgetStack->setFocusPolicy(QWidget::NoFocus);
splitter1=new QSplitter(QSplitter::Vertical, topWidgetStack, "splitter1" );
splitter2=new QSplitter(QSplitter::Horizontal, splitter1, "splitter2" );

Structview=new QTabWidget(splitter2);
Structview->setFocusPolicy(QWidget::NoFocus);
outstruct = new QListView( Structview );
outstruct->setFocusPolicy(QWidget::ClickFocus);
outstruct->header()->hide();
outstruct->addColumn("Structure",-1);
outstruct->setSorting(-1,true);
outstruct->setFont(KGlobalSettings::generalFont());
connect( outstruct, SIGNAL(clicked(QListViewItem *)), SLOT(ClickedOnStructure(QListViewItem *)));
connect( outstruct, SIGNAL(doubleClicked(QListViewItem *)), SLOT(DoubleClickedOnStructure(QListViewItem *)));
QToolTip::add(outstruct, i18n( "Click to jump to the line\n(Double-click for 'input' and 'include')" ) );
structlist=new QStrList();
structitem=new QStrList();
Structview->addTab(outstruct, i18n(" Structure :"));

Editors=new QTabWidget(splitter2);
Editors->setFocusPolicy(QWidget::ClickFocus);
EditorsList=new writelist();
EditorsList->setAutoDelete(TRUE);
connect(Editors, SIGNAL(currentChanged(QWidget*)), this, SLOT(SetCurrentEditor(QWidget*)));

Outputview=new QTabWidget(splitter1);
Outputview->setFocusPolicy(QWidget::ClickFocus);
output = new QMultiLineEdit( Outputview );
output->setFocusPolicy(QWidget::NoFocus);
output->setReadOnly(true);
output->setFont(KGlobalSettings::generalFont());
Outputview->addTab(output,SmallIcon("help"), i18n(" About :"));
stdoutput = new LogWidget( Outputview );
stdoutput->setFocusPolicy(QWidget::ClickFocus);
stdoutput->setMinimumHeight(80);
stdoutput->setReadOnly(true);
stdoutput->setFont(KGlobalSettings::generalFont());
Outputview->addTab(stdoutput,SmallIcon("log"), i18n(" Messages / Log File :"));
logpresent=false;
errorlist=new QStrList();
connect(stdoutput, SIGNAL(clicked()),this,SLOT(ClickedOnOutput()));
QToolTip::add(stdoutput, i18n( "Click on a line number in the 'log' file\nto jump to the corresponding line in the editor" ) );
Outputview->showPage(output);

texkonsole=new TexKonsoleWidget(Outputview,"konsole");
texkonsole->setFocusPolicy(QWidget::ClickFocus);
Outputview->addTab(texkonsole,SmallIcon("openterm"),"Konsole");

QValueList<int> sizes;
sizes << 100 << 400;
splitter2->setSizes( sizes );
sizes.clear();
sizes << 400 << 100;
splitter1->setSizes( sizes );

topWidgetStack->addWidget(splitter1 , 0);
topWidgetStack->raiseWidget(0);
splitter1->show();
splitter2->show();
setCentralWidget(topWidgetStack);

ShowOutputView(false);
ShowStructView(false);
previewpresent=false;
htmlpresent=false;
NewFile();
MasterName=Editor->getName();
}
////////////////////////////  FILE /////////////////////////////////////////////
void Ktexmaker2::NewFile()
{
HlManager *hl = new HlManager();
Editor = new latexedit(new KWriteDoc( hl),Editors, "Editor");
Editor->readConfig(config);
Editor -> setHl( hl->nameFind( "Latex"));
connect(Editor, SIGNAL(newCurPos()), this, SLOT(UpdateLineColStatus()));
connect(Editor, SIGNAL(fileChanged()), this, SLOT(UpdateCaption()));
connect(Editor, SIGNAL(newStatus()), this, SLOT(NewDocumentStatus()));
EditorsList->append(Editor);
Editors->addTab(Editor, i18n("Untitled"));
Editors->showPage(Editor);
Editor->setFocusPolicy(StrongFocus);
Editor->setFocus();
UpdateCaption();
UpdateLineColStatus();
}

void Ktexmaker2::OpenFile()
{
QString currentDir=QDir::currentDirPath();
QString finame(lastDocument);
if (!finame.isEmpty())
  {
  QFileInfo fi(finame);
  if (fi.exists() && fi.isReadable()) currentDir=fi.dirPath();
  }
QString fileName=KFileDialog::getOpenFileName(currentDir, "*.tex *.bib",this, i18n("Open File"));
if (fileName.isEmpty() || FileAlreadyOpen(fileName)) return;
if ((fileName.right(4)!=".tex") && (fileName.right(4)!=".bib"))
    {
    KMessageBox::error(this,"This is not a .tex or a .bib file");
    return;
    }
if (Editor->isModified() || Editor->getName()!=i18n("Untitled")) NewFile();
QFileInfo fi(fileName);
if (fi.exists() && fi.isReadable())
  {
  Editor->loadURL(fileName);
  AddRecentFile(Editor->getName());
  Editor->setFocus();
  UpdateCaption();
  UpdateLineColStatus();
  }
 else
  {
  if (!Editor->isModified() && Editor->getName()==i18n("Untitled")) Close();
  }
}

void Ktexmaker2::OpenRecentFile(int id)
{

QString fileName(recent->text(id));
if (fileName.isEmpty()  || FileAlreadyOpen(fileName)) return;
if ((fileName.right(4)!=".tex") && (fileName.right(4)!=".bib"))
    {
    KMessageBox::error(this,"This is not a .tex or a .bib file");
    return;
    }
QFileInfo file(fileName);
if (!file.exists() || file.isDir() || !file.isReadable()) return;
if (Editor->isModified() || Editor->getName()!=i18n("Untitled")) NewFile();
Editor->loadURL(fileName);
AddRecentFile(Editor->getName());
Editor->setFocus();
UpdateCaption();
UpdateLineColStatus();
}

void Ktexmaker2::Loader(const char *filename)
{
QString fileName(filename);
if ((fileName.right(4)!=".tex") && (fileName.right(4)!=".bib"))
    {
    KMessageBox::error(this,"This is not a .tex or a .bib file");
    return;
    }
QFileInfo file(fileName);
	if (file.exists() && !file.isDir() && file.isReadable())
  {
  if (Editor->isModified() || Editor->getName()!=i18n("Untitled")) NewFile();
  QString currentDir= QDir::currentDirPath();
  Editor->loadURL(file.absFilePath());
  QDir::setCurrent(currentDir);
  AddRecentFile(Editor->getName());
  Editor->setFocus();
  UpdateCaption();
  UpdateLineColStatus();
  }
}

void Ktexmaker2::SaveFile()
{

if (Editor->isModified())
 {
	if (Editor->save()==latexedit::OK)
			{
			AddRecentFile(Editor->getName());
      Editor->setFocus();
      UpdateCaption();
      UpdateLineColStatus();
			}
 }
}

void Ktexmaker2::SaveFileAs()
{

if (Editor->saveAs()== latexedit::OK)
{
  AddRecentFile(Editor->getName());
  Editor->setFocus();
  UpdateCaption();
  UpdateLineColStatus();
}
}

void Ktexmaker2::SaveAllFiles()
{

latexedit *currentEditor=Editor;
Editor=EditorsList->first();
while (Editor)
{
	if (Editor->isModified())
			{
					if (Editor->getName()==i18n("Untitled")) Editors->showPage(Editor);
					if (Editor->save()==latexedit::OK)
							{
									AddRecentFile(Editor->getName());
							}
			}
	Editor=EditorsList->next();
}
Editor=currentEditor;
Editors->showPage(currentEditor);
Editor->setFocus();
UpdateCaption();
UpdateLineColStatus();
}

void Ktexmaker2::Close()
{

if (Editor->canDiscard())
{
EditorsList->removeRef(Editor);
Editor=EditorsList->current();
if (!Editor) {NewFile();}
else
   {
   Editor->setFocus();
   UpdateCaption();
   UpdateLineColStatus();
   }
}
}

void Ktexmaker2::CloseAll()
{

latexedit *editor=EditorsList->first();
while (editor)
{
	if (editor->canDiscard())
			{
      latexedit *temp=editor;
      editor=EditorsList->next();
      EditorsList->removeRef(temp);
			}
	else
			break;
}
Editor=EditorsList->current();
if (!Editor) {NewFile();}
else
   {
   Editor->setFocus();
   UpdateCaption();
   UpdateLineColStatus();
   }
}

void Ktexmaker2::Print()
{

  SaveFile();
  QString  filename=Editor->getName().data() ;
  QFileInfo fi(filename);
	if (fi.exists() && fi.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
  QString com;
  QString command = "enscript -2rG";
  com = QString ("%s '%s' &").arg(command).arg(filename);
  system(com.ascii());
  }
  else KMessageBox::error(this, i18n("TeX file not found or not valid ! "));
}


void Ktexmaker2::Exit()
{
close();
}

void Ktexmaker2::closeEvent(QCloseEvent* e)
{
bool accept=TRUE;
SaveSettings();
latexedit *editor=EditorsList->first();
while (editor)
{
	accept=editor->canDiscard();
	if (accept)
			{
       latexedit *temp=editor;
       editor=EditorsList->next();
       EditorsList->removeRef(temp);
			}
	else
			break;
}
if (accept)
{
	e->accept();
};
}


///////////////////////////////// EDIT /////////////////////////////////////
void Ktexmaker2::Undo()
{

Editor->undo();
}

void Ktexmaker2::Redo()
{

Editor->redo();
}


void Ktexmaker2::Cut()
{

Editor->cut();
}

void Ktexmaker2::Copy()
{
Editor->copy();
}

void Ktexmaker2::Paste()
{

Editor->paste();
}

void Ktexmaker2::SelectAll()
{

Editor->selectAll();
}

void Ktexmaker2::Search()
{

Editor->find();
}

void Ktexmaker2::SearchAgain()
{

Editor->findAgain();
}

void Ktexmaker2::Replace()
{

Editor->replace();
}

void Ktexmaker2::GotoLine()
{

Editor->gotoLine();
}

void Ktexmaker2::Indent()
{

Editor->indent();
}

void Ktexmaker2::Unindent()
{

Editor->unIndent();
}

void Ktexmaker2::Comment()
{

Editor->comment();
}

void Ktexmaker2::Uncomment()
{

Editor->uncomment();
}

void Ktexmaker2::ToggleVerticalSelection()
{
Editor->toggleVertical();
}

void Ktexmaker2::SetCurrentEditor(QWidget *editor)
{
Editor = EditorsList->at(0);
while(Editor)
  {
  		if (Editor == editor)  break;
  		Editor = EditorsList->next();
  }
Editor->setEnabled(TRUE);
Editor->setFocus();
UpdateCaption();
UpdateLineColStatus();
}

void Ktexmaker2::UpdateCaption()
{
if (Editor->getName()!=i18n("Untitled")) lastDocument=Editor->getName();
QString title;
title.sprintf(i18n("File: %s"),Editor->getName().data());
setCaption(title);
QString shortName = Editor->getName();
int pos;
while ( (pos = (int)shortName.find('/')) != -1 )
shortName.remove(0,pos+1);
if (Editor->isModified()) Editors->changeTab(Editor,UserIcon("modified"), shortName);
else Editors->changeTab(Editor,UserIcon("empty"), shortName);
this->statusBar()->changeItem(Editor->getName().data(),ID_HINTTEXT);
output->clear();
if (singlemode)
 {
 stdoutput->clear();
 logpresent=false;
 }
output->insertLine(i18n("Ready..."));
if (singlemode) Outputview->showPage(output);
UpdateStructure();
}

void Ktexmaker2::AddRecentFile(const char* fileName)
{
if (recentFilesList->find(fileName)!=-1) return;

if (recentFilesList->count() < maxRecentCount)
recentFilesList->append(fileName);
else
{
	recentFilesList->removeFirst();
	recentFilesList->append(fileName);
};

recent->clear();
for (uint i=0; i < recentFilesList->count(); i++)
recent->insertItem(recentFilesList->at(i));
}

bool Ktexmaker2::FileAlreadyOpen(QString file_name)
{
bool rep=false;
latexedit *ed=EditorsList->first();
while (ed)
 {
 if (ed->getName()==file_name)
    {
    rep=true;
    SetCurrentEditor(ed);
    Editors->showPage(Editor);
    }
 ed=EditorsList->next();
 };

return rep;
}

void Ktexmaker2::NewDocumentStatus()
{
QString title;
title.sprintf(i18n("File: %s"),Editor->getName().data());
setCaption(title);
QString shortName = Editor->getName();
int pos;
while ( (pos = (int)shortName.find('/')) != -1 )
shortName.remove(0,pos+1);
if (Editor->isModified()) Editors->changeTab(Editor,UserIcon("modified"), shortName);
else Editors->changeTab(Editor,UserIcon("empty"), shortName);
}
////////////////////////// CONFIG //////////////////////////////////////
void Ktexmaker2::ReadSettings()
{
singlemode=true;
config->setGroup("General");
QSize size(750, 550);
resize(config->readSizeEntry("Geometry", &size));
kdetools=config->readBoolEntry("Using KDE tools",true);
showstructview=config->readBoolEntry("View Structure",true);
showoutputview=config->readBoolEntry("View Output",true);
latexmode=config->readBoolEntry("Latex Mode",true);

struct_level1=config->readEntry("Structure Level 1","part");
struct_level2=config->readEntry("Structure Level 2","chapter");
struct_level3=config->readEntry("Structure Level 3","section");
struct_level4=config->readEntry("Structure Level 4","subsection");
struct_level5=config->readEntry("Structure Level 5","subsubsection");

latex_command=config->readEntry("Latex","latex -interaction=nonstopmode $texname");
viewdvi_command=config->readEntry("Dvi","xdvi $dviname");
dvips_command=config->readEntry("Dvips","dvips -o $psname $dviname");
viewps_command=config->readEntry("Ps","gv $psname");
ps2pdf_command=config->readEntry("Ps2pdf","ps2pdf $psname");
makeindex_command=config->readEntry("Makeindex","makeindex $idxname");
bibtex_command=config->readEntry("Bibtex","bibtex $bibname");
pdflatex_command=config->readEntry("Pdflatex","pdflatex -interaction=nonstopmode $texname");
viewpdf_command=config->readEntry("Pdf","acroread $pdfname");

lastDocument=config->readEntry("Last Document","");

maxRecentCount=config->readUnsignedNumEntry("Recent Files Count", 5);
recentFilesList=new QStrList();
config->readListEntry("Recent Files", *recentFilesList, ':');
while (recentFilesList->count()>maxRecentCount)
recentFilesList->removeFirst();

UserMenuNames=new QStrList();
UserMenuTags=new QStrList();
config->readListEntry("User Menu Names", *UserMenuNames, ':');
config->readListEntry("User Menu Tags", *UserMenuTags, ':');
for (uint i=UserMenuNames->count(); i<10; i++)
UserMenuNames->append("");
for (uint i=UserMenuTags->count(); i<10; i++)
UserMenuTags->append("");
}

void Ktexmaker2::SaveSettings()
{
config->setGroup("General");
config->writeEntry("Geometry", size());
config->writeEntry("Using KDE tools",kdetools);
config->writeEntry("View Structure",showstructview);
config->writeEntry("View Output",showoutputview);
config->writeEntry("Latex Mode",latexmode);

config->writeEntry("Structure Level 1",struct_level1);
config->writeEntry("Structure Level 2",struct_level2);
config->writeEntry("Structure Level 3",struct_level3);
config->writeEntry("Structure Level 4",struct_level4);
config->writeEntry("Structure Level 5",struct_level5);

config->writeEntry("Latex",latex_command);
config->writeEntry("Dvi",viewdvi_command);
config->writeEntry("Dvips",dvips_command);
config->writeEntry("Ps",viewps_command);
config->writeEntry("Ps2pdf",ps2pdf_command);
config->writeEntry("Makeindex",makeindex_command);
config->writeEntry("Bibtex",bibtex_command);
config->writeEntry("Pdflatex",pdflatex_command);
config->writeEntry("Pdf",viewpdf_command);

config->writeEntry("Last Document",lastDocument);

config->writeEntry("Recent Files Count",	maxRecentCount);
config->writeEntry("Recent Files", *recentFilesList, ':');
config->writeEntry("User Menu Names", *UserMenuNames, ':');
config->writeEntry("User Menu Tags", *UserMenuTags, ':');

Editor->writeConfig(config);

config->sync();
}
////////////////////// PREVIEW ////////////////////////////////////
void Ktexmaker2::Preview()
{
if (latexmode) {PreviewDVI();}
else {PreviewPDF();}
}
void Ktexmaker2::PreviewDVI()
{
  output->clear();
  output->insertLine("Preview...");
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
  QString name=fi.dirPath()+"/"+fi.baseName()+".dvi";
  QString dviname=fi.baseName()+".dvi";
  QString psname=fi.baseName()+".ps";
  QFileInfo fic(name);
	if (fic.exists() && fic.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
    KShellProcess* P = new KShellProcess("/bin/sh");
    P->clearArguments();
    (*P) << "export dviname='" << dviname << "'" << "&&";
    (*P) << "export psname='" << psname << "'" << "&&";
    (*P) << "cd " << ConvertForBash(fi.dirPath()) << "&&";
    (*P) << "dvips -o $psname $dviname" ;
    stdoutput->clear();
    stdoutput->insertLine("Dvips -o... :\n");
    Outputview->showPage(stdoutput);
    connect(P, SIGNAL( receivedStdout(KProcess*, char*, int) ), this, SLOT(slotProcessOutput(KProcess*, char*, int ) ) );
    connect(P, SIGNAL( receivedStderr(KProcess*, char*, int) ),this, SLOT(slotProcessOutput(KProcess*, char*, int ) ) );
    connect(P, SIGNAL(processExited(KProcess*)),this, SLOT(PreviewPS()));
    P->start(KProcess::NotifyOnExit, KProcess::AllOutput);
  }
 else
 {
  KMessageBox::error(this, i18n("Preview could not be displayed.\nTeX file must be saved and compiled before."));
 }
}

void Ktexmaker2::ShowEditorWidget()
{
if (previewpresent || htmlpresent)
 {
   MainToolBar->setItemEnabled(ID_EDITORVIEW,false);
   MainToolBar->setItemEnabled(ID_BACK,false);
   MainToolBar->setItemEnabled(ID_FORWARD,false);
   MainToolBar->setItemEnabled(ID_HOME,false);
   ResetPart();
   topWidgetStack->raiseWidget(0);
   splitter1->show();
   splitter2->show();
   if (!showstructview)  Structview->hide();
   if (showoutputview)   Outputview->show();
 }
}

void Ktexmaker2::PreviewPS()
{
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
QString name=fi.dirPath()+"/"+fi.baseName()+".ps";
QFileInfo fic(name);
if (fic.exists() && fic.isReadable() && Editor->getName()!=i18n("Untitled"))
   {
   MainToolBar->setItemEnabled(ID_EDITORVIEW,true);
   MainToolBar->setItemEnabled(ID_BACK,false);
   MainToolBar->setItemEnabled(ID_FORWARD,false);
   MainToolBar->setItemEnabled(ID_HOME,false);
   ResetPart();
   KLibFactory *factory = KLibLoader::self()->factory("libkghostview");
   ps_part = (KParts::ReadOnlyPart *)factory->create(topWidgetStack, "kgvpart", "KParts::ReadOnlyPart" );
   ps_part->openURL(name);
   topWidgetStack->addWidget(ps_part->widget() , 1 );
   topWidgetStack->raiseWidget(1);
   ps_part->widget()->show();
   previewpresent=true;
   }
else
   {
   KMessageBox::error(this, i18n("Preview could not be displayed.\nTeX file must be saved and compiled before."));
   }
}

void Ktexmaker2::PreviewPDF()
{
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
QString name=fi.dirPath()+"/"+fi.baseName()+".pdf";
QFileInfo fic(name);
if (fic.exists() && fic.isReadable() && Editor->getName()!=i18n("Untitled"))
   {
   MainToolBar->setItemEnabled(ID_EDITORVIEW,true);
   MainToolBar->setItemEnabled(ID_BACK,false);
   MainToolBar->setItemEnabled(ID_FORWARD,false);
   MainToolBar->setItemEnabled(ID_HOME,false);
   ResetPart();
   KLibFactory *factory = KLibLoader::self()->factory("libkghostview");
   ps_part = (KParts::ReadOnlyPart *)factory->create(topWidgetStack, "kgvpart", "KParts::ReadOnlyPart" );
   ps_part->openURL(name);
   topWidgetStack->addWidget(ps_part->widget() , 1 );
   topWidgetStack->raiseWidget(1);
   ps_part->widget()->show();
   previewpresent=true;
   }
else
   {
   KMessageBox::error(this, i18n("Preview could not be displayed.\nTeX file must be saved and compiled before."));
   }
}
///////////////////////////////// TOOLS FUNCTION ///////////////////////////////
QString Ktexmaker2::ConvertForBash(QString  dirname)
{
QString exp=dirname;
exp.replace( QRegExp(" "), "%20" );
exp.replace( QRegExp("%20"), "\\ " );
return exp;
}

void Ktexmaker2::Compile()
{
if (latexmode) {Latex();}
else {PDFLatex();}
}

void Ktexmaker2::Terminal()
{
  SaveFile();
  output->clear();
  Outputview->showPage(output);
  output->insertLine( "About TeX Terminal :");
  output->insertLine( "-----------------------------------" );
  output->insertLine( "To compile TEX file : latex $texname (or pdflatex $texname...)");
  output->insertLine( "To view LogFile : less $logname (or kedit $logname...)");
  output->insertLine( "To view DVI : xdvi $dviname (or kdvi $dviname...)");
  output->insertLine( "To create PS file : dvips $dviname");
  output->insertLine( "To view PS : gv $psname (or kghostview $psname...)");
  output->insertLine( "To view PDF : xpdf $pdfname (or acroread $pdfname...)");
  output->insertLine( "LaTeX -> Html : latex2html $texname...");
  output->insertLine( "PS -> PDF : ps2pdf $psname...");
  output->insertLine( "To compile IDX file : makeindex $idxname...");
  output->insertLine( "To run BibTeX : bibtex $bibname...");
  output->insertLine( "-----------------------------------" );
  output->insertLine( "The Terminal is opened in the current directory.");
  output->insertLine( "Bash variables $texname, $logname, $dviname ,$psname, $pdfname, $idxname and $bibname");
  output->insertLine( "are generated automatically by Ktexmaker");
  output->insertLine( "Use these variables instead of the real file names!");
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
  QString name=fi.baseName();
  QString texname=name+".tex";
  QString logname=name+".log";
  QString dviname=name+".dvi";
  QString psname=name+".ps";
  QString pdfname=name+".pdf";
  QString idxname=name+".idx";
  QString bibname=name+".bib";
	if (fi.exists() && fi.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
  Outputview->showPage(texkonsole);
  QString comd="export texname='"+texname+"'\n";
  comd+="export logname='"+logname+"'\n";
  comd+="export dviname='"+dviname+"'\n";
  comd+="export psname='"+psname+"'\n";
  comd+="export pdfname='"+pdfname+"'\n";
  comd+="export idxname='"+idxname+"'\n";
  comd+="export bibname='"+bibname+"'\n";
  comd+="cd "+ConvertForBash(fi.dirPath())+"\n";
  texkonsole->LaunchCommand(comd);
  texkonsole->setFocus();
  }
 else
 {
  KMessageBox::error(this, i18n("TeX file not found or not valid ! "));
 }
}

void Ktexmaker2::Latex()
{
  SaveFile();
  output->clear();
  output->insertLine("LaTeX...:");
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
  QString name=fi.baseName();
  QString texname=name+".tex";
	if (fi.exists() && fi.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
  Outputview->showPage(texkonsole);
  QString comd="export texname='"+texname+"'\n";
  comd+="cd "+ConvertForBash(fi.dirPath())+"\n";
  comd+=latex_command+"\n";
  texkonsole->LaunchCommand(comd);
  }
 else
 {
  KMessageBox::error(this, i18n("TeX file not found or not valid ! "));
 }
}

void Ktexmaker2::ViewDvi()
{
  SaveFile();
  output->clear();
  output->insertLine("DVI viewer...");
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
  QString name=fi.dirPath()+"/"+fi.baseName()+".dvi";
  QString dviname=fi.baseName()+".dvi";
  QFileInfo fic(name);
	if (fic.exists() && fic.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
  stdoutput->clear();
  stdoutput->insertLine("DVI viewer...:\n");
  Outputview->showPage(stdoutput);
  if (kdetools) {new KRun(name);}
  else
      {
      KShellProcess* P = new KShellProcess("/bin/sh");
      P->clearArguments();
      (*P) << "export dviname='" << dviname << "'" << "&&";
      (*P) << "cd " << ConvertForBash(fi.dirPath()) << "&&";
      (*P) << viewdvi_command ;
      connect(P, SIGNAL( receivedStdout(KProcess*, char*, int) ), this, SLOT(slotProcessOutput(KProcess*, char*, int ) ) );
      connect(P, SIGNAL( receivedStderr(KProcess*, char*, int) ),this, SLOT(slotProcessOutput(KProcess*, char*, int ) ) );
      connect(P, SIGNAL(processExited(KProcess*)),this, SLOT(slotProcessExited(KProcess*)));
      P->start(KProcess::NotifyOnExit, KProcess::AllOutput);
      }
 }
 else
 {
  KMessageBox::error(this, i18n("DVI file not found or not valid ! "));
 }
}

void Ktexmaker2::DviToPS()
{
  SaveFile();
  output->clear();
  output->insertLine("Dvips -o... :");
  output->insertLine("Converts the DVI file produced by LaTeX to a PostScript file.");
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
  QString name=fi.dirPath()+"/"+fi.baseName()+".dvi";
  QString dviname=fi.baseName()+".dvi";
  QString psname=fi.baseName()+".ps";
  QFileInfo fic(name);
	if (fic.exists() && fic.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
  Outputview->showPage(texkonsole);
  QString comd="export dviname='"+dviname+"'\n";
  comd+="export psname='"+psname+"'\n";
  comd+="cd "+ConvertForBash(fi.dirPath())+"\n";
  comd+=dvips_command+"\n";
  texkonsole->LaunchCommand(comd);
  }
 else
 {
  KMessageBox::error(this, i18n("DVI file not found or not valid ! "));
 }
}

void Ktexmaker2::ViewPS()
{
  SaveFile();
  output->clear();
  output->insertLine("Postscript viewer...:");
  output->insertLine("You can use it to print your document.");
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
  QString name=fi.dirPath()+"/"+fi.baseName()+".ps";
  QString psname=fi.baseName()+".ps";
  QFileInfo fic(name);
	if (fic.exists() && fic.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
  stdoutput->clear();
  stdoutput->insertLine("Postscript viewer...:\n");
  Outputview->showPage(stdoutput);
  if (kdetools) {new KRun(name);}
  else
      {
      KShellProcess* P = new KShellProcess("/bin/sh");
      P->clearArguments();
      (*P) << "export psname='" << psname << "'" << "&&";
      (*P) << "cd " << ConvertForBash(fi.dirPath()) << "&&";
      (*P) << viewps_command ;
      connect(P, SIGNAL( receivedStdout(KProcess*, char*, int) ), this, SLOT(slotProcessOutput(KProcess*, char*, int ) ) );
      connect(P, SIGNAL( receivedStderr(KProcess*, char*, int) ),this, SLOT(slotProcessOutput(KProcess*, char*, int ) ) );
      connect(P, SIGNAL(processExited(KProcess*)),this, SLOT(slotProcessExited(KProcess*)));
      P->start(KProcess::NotifyOnExit, KProcess::AllOutput);
      }
  }
 else
 {
  KMessageBox::error(this, i18n("PS file not found or not valid ! "));
 }
}

void Ktexmaker2::ViewLog()
{

Outputview->showPage(stdoutput);
stdoutput->clear();
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
QString name=fi.dirPath()+"/"+fi.baseName()+".log";
QString logname=fi.baseName()+".log";
QFileInfo fic(name);
if (fic.exists() && fic.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
  stdoutput->insertLine("************** LOG FILE *************** :");
  QFile f(name);
		if ( f.open(IO_ReadOnly) )
      {
			QTextStream t( &f );
			QString s;
			while ( !t.eof() )
       {
				s = t.readLine();
        int row = (stdoutput->numLines() == 0)? 0 : stdoutput->numLines()-1;
        int col = qstrlen(stdoutput->textLine(row));
        if (s.left(1) == "\n" && col == 0)  s = QString(" ")+s;
        stdoutput->insertLine(s);
        }
		  }
  	f.close();
    logpresent=true;
    LatexError();
  }
else {stdoutput->insertLine("**** NO LOG FILE **** :");}
}

void Ktexmaker2::LatexToHtml()
{
  SaveFile();
  output->clear();
  output->insertLine("Latex2html...");
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
  QString name=fi.baseName();
  QString texname=name+".tex";

	if (fi.exists() && fi.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
    l2hDlg = new l2hdialog(this," LaTex2Html options :");
    if ( l2hDlg->exec() )
    {
  Outputview->showPage(texkonsole);
  QString comd="export texname='"+texname+"'\n";
  comd+="cd "+ConvertForBash(fi.dirPath())+"\n";
  comd+="latex2html $texname "+l2hDlg->options_edit->text()+"\n";
  texkonsole->LaunchCommand(comd);
    }
    delete l2hDlg;
  }
 else
 {
  KMessageBox::error(this, i18n("TeX file not found or not valid ! "));
 }
}
void Ktexmaker2::HtmlPreview()
{
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
QString name=fi.baseName();
QString htmlname=fi.dirPath()+"/"+name+"/index.html";
QFileInfo fih(htmlname);
if (fih.exists() && fih.isReadable() )
 {
    MainToolBar->setItemEnabled(ID_EDITORVIEW,true);
    MainToolBar->setItemEnabled(ID_BACK,true);
    MainToolBar->setItemEnabled(ID_FORWARD,true);
    MainToolBar->setItemEnabled(ID_HOME,true);
    ResetPart();
    html_part = new docpart(topWidgetStack,"help");
    html_part->openURL(htmlname);
    html_part->addToHistory(htmlname);
    topWidgetStack->addWidget(html_part->widget() , 1 );
    topWidgetStack->raiseWidget(1);
    html_part->show();
    htmlpresent=true;
 }
else
 {
  KMessageBox::error(this, i18n("Html file not found or not valid ! "));
 }
}
void Ktexmaker2::PStoPDF()
{
  SaveFile();
  output->clear();
  output->insertLine("ps2pdf...:");
  output->insertLine("To produce a PDF document with standard Type1 fonts");
  output->insertLine("you can try these commands (and ignore the LaTeX errors!):");
  output->insertLine("\\usepackage{times,mathptmx}");
  output->insertLine("\\DeclareMathAlphabet{\\bm}{OT1}{ptm}{b}{it}");
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
  QString name=fi.dirPath()+"/"+fi.baseName()+".ps";
  QString psname=fi.baseName()+".ps";
  QFileInfo fic(name);
	if (fic.exists() && fic.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
  Outputview->showPage(texkonsole);
  QString comd="export psname='"+psname+"'\n";
  comd+="cd "+ConvertForBash(fi.dirPath())+"\n";
  comd+=ps2pdf_command+"\n";
  texkonsole->LaunchCommand(comd);
  }
 else
 {
  KMessageBox::error(this, i18n("PS file not found or not valid ! "));
 }
}

void Ktexmaker2::MakeIndex()
{
  SaveFile();
  output->clear();
  output->insertLine("Makeindex...");
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
  QString name=fi.dirPath()+"/"+fi.baseName()+".idx";
  QString idxname=fi.baseName()+".idx";
  QFileInfo fic(name);
	if (fic.exists() && fic.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
  Outputview->showPage(texkonsole);
  QString comd="export idxname='"+idxname+"'\n";
  comd+="cd "+ConvertForBash(fi.dirPath())+"\n";
  comd+=makeindex_command+"\n";
  texkonsole->LaunchCommand(comd);
  }
 else
 {
  KMessageBox::error(this, i18n("idx file not found or not valid ! "));
 }
}
void Ktexmaker2::MakeBib()
{
  SaveFile();
  output->clear();
  output->insertLine("BibTeX...");
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
  QString name=fi.dirPath()+"/"+fi.baseName()+".aux";
  QString bibname=fi.baseName();
  QFileInfo fic(name);
	if (fic.exists() && fic.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
  Outputview->showPage(texkonsole);
  QString comd="export bibname='"+bibname+"'\n";
  comd+="cd "+ConvertForBash(fi.dirPath())+"\n";
  comd+=bibtex_command+"\n";
  texkonsole->LaunchCommand(comd);
  }
 else
 {
  KMessageBox::error(this, i18n("aux file not found or not valid ! "));
 }
}

void Ktexmaker2::PDFLatex()
{
  SaveFile();
  output->clear();
  output->insertLine("PDFLaTeX...:");
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
  QString name=fi.baseName();
  QString texname=name+".tex";
	if (fi.exists() && fi.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
  Outputview->showPage(texkonsole);
  QString comd="export texname='"+texname+"'\n";
  comd+="cd "+ConvertForBash(fi.dirPath())+"\n";
  comd+=pdflatex_command+"\n";
  texkonsole->LaunchCommand(comd);
  }
 else
 {
  KMessageBox::error(this, i18n("TeX file not found or not valid ! "));
 }
}


void Ktexmaker2::ViewPDF()
{
  SaveFile();
  output->clear();
  output->insertLine("PDF viewer...:");
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
  QString name=fi.dirPath()+"/"+fi.baseName()+".pdf";
  QString pdfname=fi.baseName()+".pdf";
  QFileInfo fic(name);
	if (fic.exists() && fic.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
  stdoutput->clear();
  stdoutput->insertLine("PDF viewer...:\n");
  Outputview->showPage(stdoutput);
  KShellProcess* P = new KShellProcess("/bin/sh");
  P->clearArguments();
  (*P) << "export pdfname='" << pdfname << "'" << "&&";
  (*P) << "cd " << ConvertForBash(fi.dirPath()) << "&&";
  (*P) << viewpdf_command ;
  connect(P, SIGNAL( receivedStdout(KProcess*, char*, int) ), this, SLOT(slotProcessOutput(KProcess*, char*, int ) ) );
  connect(P, SIGNAL( receivedStderr(KProcess*, char*, int) ),this, SLOT(slotProcessOutput(KProcess*, char*, int ) ) );
  connect(P, SIGNAL(processExited(KProcess*)),this, SLOT(slotProcessExited(KProcess*)));
  P->start(KProcess::NotifyOnExit, KProcess::AllOutput);
  }
 else
 {
  KMessageBox::error(this, i18n("PDF file not found or not valid ! "));
 }
}

void Ktexmaker2::Symbols()
{
  output->clear();
  output->insertLine("Table of available mathematical symbols...");
  QFileInfo fic(locate("appdata","doc/symbols.ps"));
	if (fic.exists() && fic.isReadable())
  {
   MainToolBar->setItemEnabled(ID_EDITORVIEW,true);
   MainToolBar->setItemEnabled(ID_BACK,false);
   MainToolBar->setItemEnabled(ID_FORWARD,false);
   MainToolBar->setItemEnabled(ID_HOME,false);
   ResetPart();
   KLibFactory *factory = KLibLoader::self()->factory("libkghostview");
   ps_part = (KParts::ReadOnlyPart *)factory->create(topWidgetStack, "kgvpart", "KParts::ReadOnlyPart" );
   ps_part->openURL(locate("appdata","doc/symbols.ps"));
   topWidgetStack->addWidget(ps_part->widget() , 1 );
   topWidgetStack->raiseWidget(1);
   ps_part->widget()->show();
   previewpresent=true;
  }
 else
 {
  KMessageBox::error(this, i18n("File not found !"));
 }
}

void Ktexmaker2::LatexHelp()
{
  output->clear();
  output->insertLine("LaTeX2e help...");
  QFileInfo fic(locate("appdata","doc/latexhelp.html"));
	if (fic.exists() && fic.isReadable())
  {
   MainToolBar->setItemEnabled(ID_EDITORVIEW,true);
   MainToolBar->setItemEnabled(ID_BACK,true);
   MainToolBar->setItemEnabled(ID_FORWARD,true);
   MainToolBar->setItemEnabled(ID_HOME,true);
   ResetPart();
   html_part = new docpart(topWidgetStack,"help");
   html_part->openURL(locate("appdata","doc/latexhelp.html"));
   html_part->addToHistory(locate("appdata","doc/latexhelp.html"));
   topWidgetStack->addWidget(html_part->widget() , 1 );
   topWidgetStack->raiseWidget(1);
   html_part->show();
   htmlpresent=true;
  }
 else
 {
  KMessageBox::error(this, i18n("File not found !"));
 }
}

void Ktexmaker2::RunXfig()
{
  SaveFile();
  output->clear();
  output->insertLine("Xfig...:");
  stdoutput->clear();
  stdoutput->insertLine("Xfig...:\n");
  Outputview->showPage(stdoutput);
  KShellProcess* P = new KShellProcess("/bin/sh");
  P->clearArguments();
  (*P) << "xfig" ;
  connect(P, SIGNAL( receivedStdout(KProcess*, char*, int) ), this, SLOT(slotProcessOutput(KProcess*, char*, int ) ) );
  connect(P, SIGNAL( receivedStderr(KProcess*, char*, int) ),this, SLOT(slotProcessOutput(KProcess*, char*, int ) ) );
  connect(P, SIGNAL(processExited(KProcess*)),this, SLOT(slotProcessExited(KProcess*)));
  P->start(KProcess::NotifyOnExit, KProcess::AllOutput);
}

void Ktexmaker2::RunGfe()
{
  SaveFile();
  output->clear();
  output->insertLine("Gnuplot Front End...:");
  stdoutput->clear();
  stdoutput->insertLine("Gnuplot Front End...:");
  Outputview->showPage(stdoutput);
  gfedialog = new Qplotmaker(this,"Gnuplot Front End");
  if ( gfedialog->exec() ) stdoutput->insertLine("*** dialog exited normally ***");

  delete gfedialog;
}

void Ktexmaker2::CleanAll()
{
int query;

  SaveFile();
  output->clear();
  output->insertLine("Clean...:");
  QString finame;
  if (singlemode) {finame=Editor->getName();}
  else {finame=MasterName;}
  QFileInfo fi(finame);
  QString name=fi.dirPath()+"/"+fi.baseName()+".tex";
  QString n1=fi.baseName()+".log";
  QString n2=fi.baseName()+".aux";
  QString n3=fi.baseName()+".dvi";
  QString n4=fi.baseName()+".lof";
  QString n5=fi.baseName()+".lot";
  QString n6=fi.baseName()+".bit";
  QString n7=fi.baseName()+".idx";
  QString n8=fi.baseName()+".glo";
  QString n9=fi.baseName()+".bbl";
  QString n10=fi.baseName()+".ilg";
  QString n11=fi.baseName()+".toc";
  QString n12=fi.baseName()+".ind";
  QFileInfo fic(name);
	if (fic.exists() && fic.isReadable() && Editor->getName()!=i18n("Untitled"))
  {
   QStringList prettyList;

   prettyList.append(n1);
   prettyList.append(n2);
   prettyList.append(n3);
   prettyList.append(n4);
   prettyList.append(n5);
   prettyList.append(n6);
   prettyList.append(n7);
   prettyList.append(n8);
   prettyList.append(n9);
   prettyList.append(n10);
   prettyList.append(n11);
   prettyList.append(n12);
   query = KMessageBox::warningContinueCancelList( this,
            i18n( "Do you really want to delete these files?" ),
            prettyList,
            i18n( "Delete Files" ),
            i18n( "Delete" ));

   if (query==KMessageBox::Continue)
   {
    stdoutput->clear();
    stdoutput->insertLine("Delete the output files generated by LaTeX...:\n");
    Outputview->showPage(stdoutput);
    KShellProcess* P = new KShellProcess("/bin/sh");
    P->clearArguments();
    (*P) << "export n1='" << n1 << "'" << "&&";
    (*P) << "export n2='" << n2 << "'" << "&&";
    (*P) << "export n3='" << n3 << "'" << "&&";
    (*P) << "export n4='" << n4 << "'" << "&&";
    (*P) << "export n5='" << n5 << "'" << "&&";
    (*P) << "export n6='" << n6 << "'" << "&&";
    (*P) << "export n7='" << n7 << "'" << "&&";
    (*P) << "export n8='" << n8 << "'" << "&&";
    (*P) << "export n9='" << n9 << "'" << "&&";
    (*P) << "export n10='" << n10 << "'" << "&&";
    (*P) << "export n11='" << n11 << "'" << "&&";
    (*P) << "export n12='" << n12 << "'" << "&&";
    (*P) << "cd " << ConvertForBash(fi.dirPath()) << "&&";
  	(*P) << "rm -f $n1" << "&&";
  	(*P) << "rm -f $n2" << "&&";
  	(*P) << "rm -f $n3" << "&&";
  	(*P) << "rm -f $n4" << "&&";
  	(*P) << "rm -f $n5" << "&&";
  	(*P) << "rm -f $n6" << "&&";
  	(*P) << "rm -f $n7" << "&&";
  	(*P) << "rm -f $n8" << "&&";
  	(*P) << "rm -f $n9" << "&&";
  	(*P) << "rm -f $n10" << "&&";
  	(*P) << "rm -f $n11" << "&&";
  	(*P) << "rm -f $n12" ;
    connect(P, SIGNAL( receivedStdout(KProcess*, char*, int) ), this, SLOT(slotProcessOutput(KProcess*, char*, int ) ) );
    connect(P, SIGNAL( receivedStderr(KProcess*, char*, int) ),this, SLOT(slotProcessOutput(KProcess*, char*, int ) ) );
    connect(P, SIGNAL(processExited(KProcess*)),this, SLOT(slotProcessExited(KProcess*)));
    P->start(KProcess::NotifyOnExit, KProcess::AllOutput);
    }
  }
 else
  {
  KMessageBox::error(this, i18n("tex file not found or not valid ! "));
  }

}

void Ktexmaker2::slotProcessOutput(KProcess* proc,char* buffer,int buflen)
{
int row = (stdoutput->numLines() == 0)? 0 : stdoutput->numLines()-1;
int col = qstrlen(stdoutput->textLine(row));
QString s=QCString(buffer,buflen+1);
if (s.left(1) == "\n" && col == 0)  s = QString(" ")+s;
stdoutput->setCursorPosition(row,col,false);
stdoutput->insertAt(s, row, col);
}

void Ktexmaker2::slotProcessExited(KProcess* proc)
{
logpresent=false;
QString result="";
if (proc->normalExit())
  {
  result= ((proc->exitStatus()) ? "\n*** process failed ***" : "\n*** process exited normally ***");
  }
else
  {
   result= "\n*** process exited with error(s) ***";
  }
int row = (stdoutput->numLines() == 0)? 0 : stdoutput->numLines()-1;
int col = qstrlen(stdoutput->textLine(row));
stdoutput->insertAt(result, row, col);
}


/////////////////////////////// LATEX TAGS ///////////////////////////////////////
void Ktexmaker2::InsertTag(QString Entity, int dx, int dy)
{

	int line, column;
  Editor->setFocus();
  line=Editor->currentLine();
  column=Editor->currentColumn();
  Editor->insertText(Entity);
  line=Editor->currentLine();
  column=Editor->currentColumn();
  Editor->setCursorPosition(line+dy,column+dx);
  UpdateLineColStatus();
  output->clear();
  output->insertLine(i18n("Ready..."));
  Outputview->showPage(output);
}

void Ktexmaker2::QuickDocument()
{

  Editor->setFocus();
  QString tag=QString("\\documentclass[");
	startDlg = new quickdocumentdialog(this,i18n("Quick Start"));
  if ( startDlg->exec() )
  {
  tag+=startDlg->combo2->currentText()+QString(",");
  tag+=startDlg->combo3->currentText()+QString("]{");
  tag+=startDlg->combo1->currentText()+QString("} \\usepackage[");
  tag+=startDlg->combo4->currentText()+QString("] {inputenc} \n");
  if (startDlg->checkbox1->isChecked()) tag+=QString("\\usepackage{amsmath} \\usepackage{amsfonts} \\usepackage{amssymb} \n");
  tag+=QString("\\begin{document}\n\n\\end{document}");
  Editor->insertText(tag);
  UpdateLineColStatus();
  InsertTag(" ",-15,-1);
  }
  delete( startDlg);
  output->clear();
  output->insertLine(i18n("Ready..."));
}


void Ktexmaker2::QuickTabular()
{

  Editor->setFocus();
  output->clear();
  output->insertLine(i18n("Ready..."));
  QString al;

	quickDlg = new tabdialog(this,i18n("Tabular"));

  if ( quickDlg->exec() ) {
  int	y = quickDlg->spinBoxRows->value();
  int	x = quickDlg->spinBoxCollums->value();
  	QString tag = QString("\\begin{tabular}{|");
    if  ((quickDlg->combo->currentItem ())==0) al=QString("c|");
    if  ((quickDlg->combo->currentItem ())==1) al=QString("l|");
    if  ((quickDlg->combo->currentItem ())==2) al=QString("r|");
 		for ( int j=0;j<x;j++) {tag +=al;}
    tag +=QString("}\n");
 	  for ( int i=0;i<y;i++) {
 		  tag += QString("\\hline ");
 		  for ( int j=0;j<x-1;j++)
 			  tag +=quickDlg->Table1->text(i,j)+ QString(" & ");
 		  tag +=quickDlg->Table1->text(i,x-1)+ QString(" \\\\ \n");
 	  }
 	  tag += QString("\\hline \n\\end{tabular} ");
  Editor->insertText(tag);
  UpdateLineColStatus();
  }

  delete( quickDlg);

}

void Ktexmaker2::QuickArray()
{

  Editor->setFocus();
  output->clear();
  output->insertLine(i18n("Ready..."));
  QString al;

	quickDlg = new tabdialog(this,i18n("Array"));

  if ( quickDlg->exec() ) {
  	int y = quickDlg->spinBoxRows->value();
  	int x = quickDlg->spinBoxCollums->value();
  	QString tag = QString("\\begin{array}{");
    if  ((quickDlg->combo->currentItem ())==0) al=QString("c");
    if  ((quickDlg->combo->currentItem ())==1) al=QString("l");
    if  ((quickDlg->combo->currentItem ())==2) al=QString("r");
 		for ( int j=0;j<x;j++) {tag +=al;}
    tag +=QString("}\n");
 	  for ( int i=0;i<y-1;i++) {
  		  for ( int j=0;j<x-1;j++)
 			  tag +=quickDlg->Table1->text(i,j)+ QString(" & ");
 		  tag +=quickDlg->Table1->text(i,x-1)+ QString(" \\\\ \n");
 	  }
  		  for ( int j=0;j<x-1;j++)
 			  tag +=quickDlg->Table1->text(y-1,j)+ QString(" & ");
 	  tag +=quickDlg->Table1->text(y-1,x-1)+ QString("\n\\end{array} ");
  Editor->insertText(tag);
  UpdateLineColStatus();
  }
  delete( quickDlg);

}

void Ktexmaker2::QuickLetter()
{
  Editor->setFocus();
  QString tag=QString("\\documentclass[");
	ltDlg = new letterdialog(this,i18n("Quick Letter"));
  if ( ltDlg->exec() )
  {
  tag+=ltDlg->combo2->currentText()+QString(",");
  tag+=ltDlg->combo3->currentText()+QString("]{letter} \\usepackage[");
  tag+=ltDlg->combo4->currentText()+QString("] {inputenc} \n");
  if (ltDlg->checkbox1->isChecked()) tag+=QString("\\usepackage{amsmath} \\usepackage{amsfonts} \\usepackage{amssymb} \n");
  Editor->insertText(tag);
  UpdateLineColStatus();
  InsertTag("\\address{your name and address} \n",0,0);
  InsertTag("\\signature{your signature} \n",0,0);
  InsertTag("\\begin{document} \n",0,0);
  InsertTag("\\begin{letter}{name and address of the recipient} \n",0,0);
  InsertTag("\\opening{saying hello} \n \n",0,0);
  InsertTag("write your letter here \n \n" ,0,0);
  InsertTag("\\closing{saying goodbye} \n",0,0);
  InsertTag("%\\cc{Cclist} \n",0,0);
  InsertTag("%\\ps{adding a postscript} \n",0,0);
  InsertTag("%\\encl{list of enclosed material} \n",0,0);
  InsertTag("\\end{letter} \n",0,0);
  InsertTag("\\end{document}",16,-13);
  }
  delete( ltDlg);
  output->clear();
  output->insertLine(i18n("Personal letter..."));
}

void Ktexmaker2::Insert1()
{
InsertTag("\\documentclass[10pt]{} ",-2,0);
output->clear();
output->insertLine( "\\documentclass[options]{class}" );
output->insertLine( "class : article,report,book,letter" );
output->insertLine( "size options : 10pt, 11pt, 12pt" );
output->insertLine( "paper size options: a4paper, a5paper, b5paper, letterpaper, legalpaper, executivepaper" );
output->insertLine("other options: ");
output->insertLine("landscape -- selects landscape format. Default is portrait. ");
output->insertLine("titlepage, notitlepage -- selects if there should be a separate title page.");
output->insertLine("leqno -- equation number on left side of equations. Default is right side.");
output->insertLine("fleqn -- displayed formulas flush left. Default is centred.");
output->insertLine("onecolumn, twocolumn -- one or two columns. Defaults to one column");
output->insertLine("oneside, twoside -- selects one- or twosided layout.");
}
void Ktexmaker2::Insert1bis()
{
InsertTag("\\usepackage{} ",-2,0);
output->clear();
output->insertLine("\\usepackage[options]{pkg}");
output->insertLine("Any options given in the \\documentclass command that are unknown by the selected document class");
output->insertLine("are passed on to the packages loaded with \\usepackage.");
}
void Ktexmaker2::Insert1ter()
{
InsertTag("\\usepackage{amsmath} \\usepackage{amsfonts} \\usepackage{amssymb} ",0,0);
output->clear();
output->insertLine("The principal American Mathematical Society packages");
}
void Ktexmaker2::Insert2()
{
InsertTag("\\begin{document}\n\n\\end{document} ",-15,-1);
output->clear();
output->insertLine("Text is allowed only between \\begin{document} and \\end{document}.");
output->insertLine("The 'preamble' (before \\begin{document}} ) may contain declarations only.");
}

void Ktexmaker2::Insert3()
{

Editor->setFocus();
QString tag;
output->clear();
output->insertLine( "\\part{title}");
output->insertLine( "\\part*{title} : do not include a number and do not make an entry in the table of contents");
stDlg = new structdialog(this," \\part");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\part{");}
  else
  {tag=QString("\\part*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("} ");
  Editor->insertText(tag);
  UpdateLineColStatus();
  UpdateStructure();
  }
delete( stDlg);
}

void Ktexmaker2::Insert4()
{

Editor->setFocus();
QString tag;
output->clear();
output->insertLine( "\\chapter{title}");
output->insertLine( "\\chapter*{title} : do not include a number and do not make an entry in the table of contents");
output->insertLine( "Only for 'report' and 'book' class document.");
stDlg = new structdialog(this," \\chapter");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\chapter{");}
  else
  {tag=QString("\\chapter*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("} ");
  Editor->insertText(tag);
  UpdateLineColStatus();
  UpdateStructure();
  }
delete( stDlg);
}

void Ktexmaker2::Insert5()
{

Editor->setFocus();
QString tag;
output->clear();
output->insertLine( "\\section{title}");
output->insertLine( "\\section*{title} : do not include a number and do not make an entry in the table of contents");
stDlg = new structdialog(this," \\section");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\section{");}
  else
  {tag=QString("\\section*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("} ");
  Editor->insertText(tag);
  UpdateLineColStatus();
  UpdateStructure();
  }
delete( stDlg);
}

void Ktexmaker2::Insert6()
{

Editor->setFocus();
QString tag;
output->clear();
output->insertLine( "\\subsection{title}");
output->insertLine( "\\subsection*{title} : do not include a number and do not make an entry in the table of contents");
stDlg = new structdialog(this," \\subsection");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\subsection{");}
  else
  {tag=QString("\\subsection*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("} ");
  Editor->insertText(tag);
  UpdateLineColStatus();
  UpdateStructure();
  }
delete( stDlg);
}

void Ktexmaker2::Insert6bis()
{

Editor->setFocus();
QString tag;
output->clear();
output->insertLine( "\\subsubsection{title}");
output->insertLine( "\\subsubsection*{title} : do not include a number and do not make an entry in the table of contents");
stDlg = new structdialog(this," \\subsubsection");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\subsubsection{");}
  else
  {tag=QString("\\subsubsection*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("} ");
  Editor->insertText(tag);
  UpdateLineColStatus();
  UpdateStructure();
  }
delete( stDlg);
}

void Ktexmaker2::Insert7()
{

Editor->setFocus();
QString tag;
output->clear();
output->insertLine( "\\paragraph{title}");
output->insertLine( "\\paragraph*{title} : do not include a number and do not make an entry in the table of contents");
stDlg = new structdialog(this," \\paragraph");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\paragraph{");}
  else
  {tag=QString("\\paragraph*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("} ");
  Editor->insertText(tag);
  UpdateLineColStatus();
  UpdateStructure();
  }
delete( stDlg);
}

void Ktexmaker2::Insert8()
{

Editor->setFocus();
QString tag;
output->clear();
output->insertLine( "\\subparagraph{title}");
output->insertLine( "\\subparagraph*{title} : do not include a number and do not make an entry in the table of contents");
stDlg = new structdialog(this," \\subparagraph");
if ( stDlg->exec() )
  {
  if (stDlg->checkbox->isChecked())
  {tag=QString("\\subparagraph{");}
  else
  {tag=QString("\\subparagraph*{");}
  tag +=stDlg->title_edit->text();
  tag +=QString("} ");
  Editor->insertText(tag);
  UpdateLineColStatus();
  UpdateStructure();
  }
delete( stDlg);
}

void Ktexmaker2::Insert9()
{
if (!Editor->hasMarkedText())
   {
   InsertTag("\\begin{center}\n\n\\end{center} ",-13,-1);
   }
else
   {
   Editor->cut();
   InsertTag("\\begin{center}\n",0,0);
   Editor->paste();
   InsertTag("\n\\end{center}",0,0);
   }
output->clear();
output->insertLine( "Each line must be terminated with the string \\\\.");
}

void Ktexmaker2::Insert10()
{
if (!Editor->hasMarkedText())
   {
   InsertTag("\\begin{flushleft}\n\n\\end{flushleft} ",-16,-1);
   }
else
   {
   Editor->cut();
   InsertTag("\\begin{flushleft}\n",0,0);
   Editor->paste();
   InsertTag("\n\\end{flushleft}",0,0);
   }
output->clear();
output->insertLine( "Each line must be terminated with the string \\\\.");
}

void Ktexmaker2::Insert11()
{
if (!Editor->hasMarkedText())
   {
   InsertTag("\\begin{flushright}\n\n\\end{flushright} ",-17,-1);
   }
else
   {
   Editor->cut();
   InsertTag("\\begin{flushright}\n",0,0);
   Editor->paste();
   InsertTag("\n\\end{flushright}",0,0);
   }
output->clear();
output->insertLine( "Each line must be terminated with the string \\\\.");
}

void Ktexmaker2::Insert12()
{
InsertTag("\\begin{quote}\n\n\\end{quote} ",-12,-1);
output->clear();
output->insertLine("The text is justified at both margins.");
output->insertLine(" Leaving a blank line between text produces a new paragraph.");
}

void Ktexmaker2::Insert13()
{
InsertTag("\\begin{quotation}\n\n\\end{quotation} ",-16,-1);
output->clear();
output->insertLine("The text is justified at both margins and there is paragraph indentation.");
output->insertLine(" Leaving a blank line between text produces a new paragraph.");
}

void Ktexmaker2::Insert14()
{
InsertTag("\\begin{verse}\n\n\\end{verse} ",-12,-1);
output->clear();
output->insertLine("The verse environment is designed for poetry.");
output->insertLine("Separate the lines of each stanza with \\\\, and use one or more blank lines to separate the stanzas.");
}

void Ktexmaker2::Insert15()
{
InsertTag("\\begin{verbatim}\n\n\\end{verbatim} ",-15,-1);
output->clear();
output->insertLine("Environment that gets LaTeX to print exactly what you type in.");
}

void Ktexmaker2::Insert16()
{
InsertTag("\\begin{itemize}\n\\item \n\\end{itemize} ",-8,-1);
output->clear();
output->insertLine("The itemize environment produces a 'bulleted' list.");
output->insertLine("Each item of an itemized list begins with an \\item command.");
}

void Ktexmaker2::Insert17()
{
InsertTag("\\begin{enumerate}\n\\item \n\\end{enumerate} ",-10,-1);
output->clear();
output->insertLine("The enumerate environment produces a numbered list.");
output->insertLine("Each item of an enumerated list begins with an \\item command.");
}

void Ktexmaker2::Insert18()
{
InsertTag("\\begin{description}\n\\item[]\n\\end{description} ",-12,-1);
output->clear();
output->insertLine("The description environment is used to make labelled lists.");
output->insertLine("Each item of the list begins with an \\item[label] command.");
output->insertLine("The 'label' is bold face and flushed right.");
}

void Ktexmaker2::Insert19()
{
InsertTag("\\begin{list}{}{}\n\\item \n\\end{list} ",2,-2);
output->clear();
output->insertLine("\\begin{list}{label}{spacing}");
output->insertLine("The {label} argument is a piece of text that is inserted in a box to form the label. ");
output->insertLine("The {spacing} argument contains commands to change the spacing parameters for the list.");
output->insertLine("Each item of the list begins with an \\item command.");
}

void Ktexmaker2::Insert20()
{
InsertTag("\\item ",0,0);
output->clear();
output->insertLine("\\item[label] Hello!");
}

void Ktexmaker2::Insert21()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\textit{} ",-2,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\textit{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
output->clear();
output->insertLine("\\textit{italic text}");
}

void Ktexmaker2::Insert22()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\textsl{} ",-2,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\textsl{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
output->clear();
output->insertLine("\\textsl{slanted text}");
}

void Ktexmaker2::Insert23()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\textbf{} ",-2,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\textbf{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
output->clear();
output->insertLine("\\textbf{boldface text}");
}

void Ktexmaker2::Insert24()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\texttt{} ",-2,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\texttt{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
output->clear();
output->insertLine("\\texttt{typewriter text}");
}

void Ktexmaker2::Insert25()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\textsc{} ",-2,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\textsc{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
output->clear();
output->insertLine("\\textsc{small caps text}");
}

void Ktexmaker2::Insert26()
{
InsertTag("\\begin{tabbing}\n\n\\end{tabbing} ",-14,-1);
output->clear();
output->insertLine("The tabbing environment provides a way to align text in columns.");
output->insertLine("\\begin{tabbing}");
output->insertLine("text \\= more text \\= still more text \\= last text \\\\");
output->insertLine("second row \\>  \\> more \\\\");
output->insertLine("\\end{tabbing}");
output->insertLine("Commands :");
output->insertLine("\\=  Sets a tab stop at the current position.");
output->insertLine("\\>  Advances to the next tab stop.");
output->insertLine("\\<  Allows you to put something to the left of the local margin without changing the margin. Can only be used at the start of the line.");
output->insertLine("\\+  Moves the left margin of the next and all the following commands one tab stop to the right");
output->insertLine("\\-  Moves the left margin of the next and all the following commands one tab stop to the left");
output->insertLine("\\'  Moves everything that you have typed so far in the current column to the right of the previous column, flush against the current column's tab stop. ");
output->insertLine("\\`  Allows you to put text flush right against any tab stop, including tab stop 0");
output->insertLine("\\kill  Sets tab stops without producing text.");
output->insertLine("\\a  In a tabbing environment, the commands \\=, \\' and \\` do not produce accents as normal. Instead, the commands \\a=, \\a' and \\a` are used.");
}

void Ktexmaker2::Insert27()
{
InsertTag("\\begin{tabular}{}\n\n\\end{tabular} ",2,-2);
output->clear();
output->insertLine("\\begin{tabular}[pos]{cols}");
output->insertLine("column 1 entry & column 2 entry ... & column n entry \\\\");
output->insertLine("...");
output->insertLine("\\end{tabular}");
output->insertLine("pos : Specifies the vertical position; default is alignment on the centre of the environment.");
output->insertLine("     t - align on top row");
output->insertLine("     b - align on bottom row");
output->insertLine("cols : Specifies the column formatting.");
output->insertLine("     l - A column of left-aligned items.");
output->insertLine("     r - A column of right-aligned items.");
output->insertLine("     c - A column of centred items.");
output->insertLine("     | - A vertical line the full height and depth of the environment.");
output->insertLine("     @{text} - This inserts text in every row.");
output->insertLine("The \\hline command draws a horizontal line the width of the table.");
output->insertLine("The \\cline{i-j} command draws horizontal lines across the columns specified, beginning in column i and ending in column j,");
output->insertLine("The \\vline command draws a vertical line extending the full height and depth of its row.");

}

void Ktexmaker2::Insert28()
{
InsertTag("\\multicolumn{}{}{} ",-6,0);
output->clear();
output->insertLine("\\multicolumn{cols}{pos}{text}");
output->insertLine("col, specifies the number of columns to span.");
output->insertLine("pos specifies the formatting of the entry: c for centred, l for flushleft, r for flushright.");
output->insertLine("text specifies what text is to make up the entry.");
}

void Ktexmaker2::Insert29()
{
InsertTag("\\hline ",0,0);
output->clear();
output->insertLine("The \\hline command draws a horizontal line the width of the table.");
}

void Ktexmaker2::Insert30()
{
InsertTag("\\vline ",0,0);
output->clear();
output->insertLine("The \\vline command draws a vertical line extending the full height and depth of its row.");
}

void Ktexmaker2::Insert31()
{
InsertTag("\\cline{-} ",-3,0);
output->clear();
output->insertLine("The \\cline{i-j} command draws horizontal lines across the columns specified, beginning in column i and ending in column j,");
}

void Ktexmaker2::Insert32()
{
InsertTag("\\newpage ",0,0);
output->clear();
output->insertLine("The \\newpage command ends the current page");
}

void Ktexmaker2::Insert33()
{
InsertTag("\\linebreak ",0,0);
output->clear();
output->insertLine("The \\linebreak command tells LaTeX to break the current line at the point of the command.");
}

void Ktexmaker2::Insert34()
{
InsertTag("\\pagebreak ",0,0);
output->clear();
output->insertLine("The \\pagebreak command tells LaTeX to break the current page at the point of the command.");
}

void Ktexmaker2::Insert35()
{
InsertTag("\\bigskip ",0,0);
output->clear();
output->insertLine("The \\bigskip command adds a 'big' vertical space.");
}

void Ktexmaker2::Insert36()
{
InsertTag("\\medskip ",0,0);
output->clear();
output->insertLine("The \\medskip command adds a 'medium' vertical space.");
}

void Ktexmaker2::Insert37()
{
output->clear();
output->insertLine("This command is used to import .eps files (\\usepackage{graphicx} is needed)");
output->insertLine("Examples :");
output->insertLine("\\includegraphics{file.eps}");
output->insertLine("\\includegraphics[width=10cm]{file.eps}");
output->insertLine("\\includegraphics*[height=3in]{file.eps}");
sfDlg = new selectfiledialog(this,"includegraphics{file.eps}");
sfDlg->source_edit->fileDialog()->setFilter("*.eps|Eps Files");
if (sfDlg->exec() )
  {
InsertTag("\\includegraphics{"+sfDlg->source_edit->lineEdit()->text()+".eps} ",0,0);
  }
delete sfDlg;
}

void Ktexmaker2::Insert37bis()
{
output->clear();
output->insertLine("\\include{file}");
output->insertLine("The \\include command is used in conjunction with the \\includeonly command for selective inclusion of files.");
sfDlg = new selectfiledialog(this,"include{file}");
sfDlg->source_edit->fileDialog()->setFilter("*.tex");
if (sfDlg->exec() )
  {
InsertTag("\\include{"+sfDlg->source_edit->lineEdit()->text()+"} ",0,0);
  }
UpdateStructure();
delete sfDlg;
}

void Ktexmaker2::Insert37ter()
{
output->clear();
output->insertLine("\\input{file}");
output->insertLine("The \\input command causes the indicated file to be read and processed, exactly as if its contents had been inserted in the current file at that point.");
sfDlg = new selectfiledialog(this,"input{file}");
sfDlg->source_edit->fileDialog()->setFilter("*.tex");
if (sfDlg->exec() )
  {
InsertTag("\\input{"+sfDlg->source_edit->lineEdit()->text()+"} ",0,0);
  }
UpdateStructure();
delete sfDlg;
}

void Ktexmaker2::Insert38()
{
InsertTag("\\cite{} ",-2,0);
output->clear();
output->insertLine("\\cite{ref} :");
output->insertLine("This command generates an in-text citation to the reference associated with the ref entry in the bib file");
output->insertLine("You can open the bib file with Ktexmaker2 to see all the available references");
}

void Ktexmaker2::Insert39()
{
InsertTag("\\bibliographystyle{} ",-2,0);
output->clear();
output->insertLine("The argument to \\bibliographystyle refers to a file style.bst, which defines how your citations will look");
output->insertLine("The standard styles distributed with BibTeX are:");
output->insertLine("alpha : sorted alphabetically. Labels are formed from name of author and year of publication.");
output->insertLine("plain  : sorted alphabetically. Labels are numeric.");
output->insertLine("unsrt : like plain, but entries are in order of citation.");
output->insertLine("abbrv  : like plain, but more compact labels.");
}
void Ktexmaker2::Insert40()
{

Editor->setFocus();
QString tag;
QFileInfo fi(Editor->getName());
tag=QString("\\bibliography{");
tag +=fi.baseName();
tag +=QString("} ");
Editor->insertText(tag);
UpdateLineColStatus();
output->clear();
output->insertLine("The argument to \\bibliography refers to the bib file (without extension)");
output->insertLine("which should contain your database in BibTeX format.");
output->insertLine("Ktexmaker2 inserts automatically the base name of the TeX file");
}
void Ktexmaker2::Insert41()
{
InsertTag("\\label{} ",-2,0);
output->clear();
output->insertLine("\\label{key}");
}
void Ktexmaker2::Insert42()
{
if (!Editor->hasMarkedText())
   {
   InsertTag("\\begin{table}\n\n\\caption{}\n\\end{table} ",-12,-2);
   }
else
   {
   Editor->cut();
   InsertTag("\\begin{table}\n",0,0);
   Editor->paste();
   InsertTag("\n\\caption{}\n\\end{table}",-3,-1);
   }
output->clear();
output->insertLine( "\\begin{table}[placement]");
output->insertLine( "body of the table");
output->insertLine( "\\caption{table title}");
output->insertLine( "\\end{table}");
output->insertLine( "Tables are objects that are not part of the normal text, and are usually floated to a convenient place");
output->insertLine( "The optional argument [placement] determines where LaTeX will try to place your table");
output->insertLine( "h : Here - at the position in the text where the table environment appear");
output->insertLine( "t : Top - at the top of a text page");
output->insertLine( "b : Bottom - at the bottom of a text page");
output->insertLine( "p : Page of floats - on a separate float page, which is a page containing no text, only floats");
output->insertLine( "The body of the table is made up of whatever text, LaTeX commands, etc., you wish.");
output->insertLine( "The \\caption command allows you to title your table.");

}
void Ktexmaker2::Insert43()
{
if (!Editor->hasMarkedText())
   {
   InsertTag("\\begin{figure}\n\n\\caption{}\n\\end{figure} ",-13,-2);
   }
else
   {
   Editor->cut();
   InsertTag("\\begin{figure}\n",0,0);
   Editor->paste();
   InsertTag("\n\\caption{}\n\\end{figure}",-4,-1);
   }
output->clear();
output->insertLine( "\\begin{figure}[placement]");
output->insertLine( "body of the figure");
output->insertLine( "\\caption{figure title}");
output->insertLine( "\\end{figure}");
output->insertLine( "Figures are objects that are not part of the normal text, and are usually floated to a convenient place");
output->insertLine( "The optional argument [placement] determines where LaTeX will try to place your figure");
output->insertLine( "h : Here - at the position in the text where the figure environment appear");
output->insertLine( "t : Top - at the top of a text page");
output->insertLine( "b : Bottom - at the bottom of a text page");
output->insertLine( "p : Page of floats - on a separate float page, which is a page containing no text, only floats");
output->insertLine( "The body of the figure is made up of whatever text, LaTeX commands, etc., you wish.");
output->insertLine( "The \\caption command allows you to title your figure.");
}
void Ktexmaker2::Insert44()
{
InsertTag("\\begin{titlepage}\n\n\\end{titlepage} ",-16,-1);
output->clear();
output->insertLine( "\\begin{titlepage}");
output->insertLine( "text");
output->insertLine( "\\end{titlepage}");
output->insertLine( "The titlepage environment creates a title page, i.e. a page with no printed page number or heading.");
}
void Ktexmaker2::Insert45()
{
InsertTag("\\author{}",-1,0);
output->clear();
output->insertLine( "\\author{names}");
output->insertLine( "The \\author command declares the author(s), where names is a list of authors separated by \\and commands.");
}
void Ktexmaker2::Insert46()
{
InsertTag("\\title{}",-1,0);
output->clear();
output->insertLine( "\\title{text}");
output->insertLine( "The \title command declares text to be the title.");
output->insertLine( "Use \\\\ to tell LaTeX where to start a new line in a long title.");
}
void Ktexmaker2::SizeCommand(const QString& text)
{
if (text=="tiny")
    {
    if (!Editor->hasMarkedText())
       {
       InsertTag("\\begin{tiny}  \\end{tiny}",-11,0);
       }
    else
       {
       Editor->cut();
       InsertTag("\\begin{tiny}",0,0);
       Editor->paste();
       InsertTag("\\end{tiny}",0,0);
       }
    }

if (text=="scriptsize")
    {
    if (!Editor->hasMarkedText())
       {
       InsertTag("\\begin{scriptsize}  \\end{scriptsize}",-17,0);
       }
    else
       {
       Editor->cut();
       InsertTag("\\begin{scriptsize}",0,0);
       Editor->paste();
       InsertTag("\\end{scriptsize}",0,0);
       }
    }

if (text=="footnotesize")
    {
    if (!Editor->hasMarkedText())
       {
       InsertTag("\\begin{footnotesize}  \\end{footnotesize}",-19,0);
       }
    else
       {
       Editor->cut();
       InsertTag("\\begin{footnotesize}",0,0);
       Editor->paste();
       InsertTag("\\end{footnotesize}",0,0);
       }
    }

if (text=="small")
    {
    if (!Editor->hasMarkedText())
       {
       InsertTag("\\begin{small}  \\end{small}",-12,0);
       }
    else
       {
       Editor->cut();
       InsertTag("\\begin{small}",0,0);
       Editor->paste();
       InsertTag("\\end{small}",0,0);
       }
    }

if (text=="normalsize")
    {
    if (!Editor->hasMarkedText())
       {
       InsertTag("\\begin{normalsize}  \\end{normalsize}",-17,0);
       }
    else
       {
       Editor->cut();
       InsertTag("\\begin{normalsize}",0,0);
       Editor->paste();
       InsertTag("\\end{normalsize}",0,0);
       }
    }

if (text=="large")
    {
    if (!Editor->hasMarkedText())
       {
       InsertTag("\\begin{large}  \\end{large}",-12,0);
       }
    else
       {
       Editor->cut();
       InsertTag("\\begin{large}",0,0);
       Editor->paste();
       InsertTag("\\end{large}",0,0);
       }
    }

if (text=="Large")
    {
    if (!Editor->hasMarkedText())
       {
       InsertTag("\\begin{Large}  \\end{Large}",-12,0);
       }
    else
       {
       Editor->cut();
       InsertTag("\\begin{Large}",0,0);
       Editor->paste();
       InsertTag("\\end{Large}",0,0);
       }
    }

if (text=="LARGE")
    {
    if (!Editor->hasMarkedText())
       {
       InsertTag("\\begin{LARGE}  \\end{LARGE}",-12,0);
       }
    else
       {
       Editor->cut();
       InsertTag("\\begin{LARGE}",0,0);
       Editor->paste();
       InsertTag("\\end{LARGE}",0,0);
       }
    }

if (text=="huge")
    {
    if (!Editor->hasMarkedText())
       {
       InsertTag("\\begin{huge}  \\end{huge}",-11,0);
       }
    else
       {
       Editor->cut();
       InsertTag("\\begin{huge}",0,0);
       Editor->paste();
       InsertTag("\\end{huge}",0,0);
       }
    }

if (text=="Huge")
    {
    if (!Editor->hasMarkedText())
       {
       InsertTag("\\begin{Huge}  \\end{Huge}",-11,0);
       }
    else
       {
       Editor->cut();
       InsertTag("\\begin{Huge}",0,0);
       Editor->paste();
       InsertTag("\\end{Huge}",0,0);
       }
    }
}

void Ktexmaker2::NewLine()
{
InsertTag("\\",0,0);
InsertTag("\\\n",0,0);
}
//////////////////////////// MATHS TAGS/////////////////////////////////////
void Ktexmaker2::InsertMath1()
{
InsertTag("$  $",-2,0);
}

void Ktexmaker2::InsertMath2()
{
InsertTag("$$  $$",-3,0);
}

void Ktexmaker2::InsertMath3()
{
InsertTag("_{}",-1,0);
}

void Ktexmaker2::InsertMath4()
{
InsertTag("^{}",-1,0);
}

void Ktexmaker2::InsertMath5()
{
InsertTag("\\frac{}{}",-3,0);
}

void Ktexmaker2::InsertMath6()
{
InsertTag("\\dfrac{}{}",-3,0);
}

void Ktexmaker2::InsertMath7()
{
InsertTag("\\sqrt{}",-1,0);
}
void Ktexmaker2::InsertMath8()
{
InsertTag("\\left ",0,0);
}

void Ktexmaker2::InsertMath9()
{
InsertTag("\\right ",0,0);
}

void Ktexmaker2::InsertMath10()
{
InsertTag("\\begin{array}{}\n\n\\end{array}",3,-2);
output->clear();
output->insertLine("\\begin{array}{col1col2...coln}");
output->insertLine("column 1 entry & column 2 entry ... & column n entry \\\\");
output->insertLine("...");
output->insertLine("\\end{array}");
output->insertLine("Each column, coln, is specified by a single letter that tells how items in that row should be formatted.");
output->insertLine("     c -- for centered ");
output->insertLine("     l -- for flush left ");
output->insertLine("     r -- for flush right");
}
void Ktexmaker2::InsertMath11()
{
InsertTag("\\lbrace",0,0);
}

void Ktexmaker2::InsertMath12()
{
InsertTag("\\rbrace",0,0);
}

void Ktexmaker2::InsertMath13()
{
InsertTag("\\overbrace{}",-1,0);
}

void Ktexmaker2::InsertMath14()
{
InsertTag("\\underbrace{}",-1,0);
}

void Ktexmaker2::InsertMath15()
{
InsertTag("\\overline{}",-1,0);
}

void Ktexmaker2::InsertMath16()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\underline{} ",-1,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\underline{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
}

void Ktexmaker2::InsertMath17()
{
InsertTag("\\vert",0,0);
}

void Ktexmaker2::InsertMath18()
{
InsertTag("\\Vert",0,0);
}

void Ktexmaker2::InsertMath19()
{
InsertTag("\\leq ",0,0);
}

void Ktexmaker2::InsertMath20()
{
InsertTag("\\geq ",0,0);
}

void Ktexmaker2::InsertMath21()
{
InsertTag("\\sum",0,0);
}
void Ktexmaker2::InsertMath22()
{
InsertTag("\\prod",0,0);
}
void Ktexmaker2::InsertMath23()
{
InsertTag("\\lim",0,0);
}

void Ktexmaker2::InsertMath24()
{
InsertTag("\\int",0,0);
}

void Ktexmaker2::InsertMath25()
{
InsertTag("\\cdot",0,0);
}

void Ktexmaker2::InsertMath26()
{
InsertTag("\\times",0,0);
}

void Ktexmaker2::InsertMath27()
{
InsertTag("\\cup",0,0);
}

void Ktexmaker2::InsertMath28()
{
InsertTag("\\cap",0,0);
}

void Ktexmaker2::InsertMath29()
{
InsertTag("\\in",0,0);
}

void Ktexmaker2::InsertMath30()
{
InsertTag("\\neq",0,0);
}
void Ktexmaker2::InsertMath31()
{
InsertTag("\\leftarrow ",0,0);
}
void Ktexmaker2::InsertMath32()
{
InsertTag("\\rightarrow ",0,0);
}
void Ktexmaker2::InsertMath33()
{
InsertTag("\\leftrightarrow ",0,0);
}
void Ktexmaker2::InsertMath34()
{
InsertTag("\\Leftarrow ",0,0);
}
void Ktexmaker2::InsertMath35()
{
InsertTag("\\Rightarrow ",0,0);
}

void Ktexmaker2::InsertMath36()
{
InsertTag("\\Leftrightarrow ",0,0);
}

void Ktexmaker2::InsertMath37()
{
InsertTag("\\overrightarrow{}",-1,0);
}
void Ktexmaker2::InsertMath38()
{
InsertTag("\\forall",0,0);
}

void Ktexmaker2::InsertMath39()
{
InsertTag("\\exists",0,0);
}

void Ktexmaker2::InsertMath40()
{
InsertTag("\\infty",0,0);
}

void Ktexmaker2::InsertMath41()
{
InsertTag("\\partial",0,0);
}
void Ktexmaker2::InsertMath42()
{
InsertTag("\\prime",0,0);
}
void Ktexmaker2::InsertMath43()
{
InsertTag("\\pm",0,0);
}
void Ktexmaker2::InsertMath44()
{
InsertTag("\\div",0,0);
}
void Ktexmaker2::InsertMath45()
{
InsertTag("\\star",0,0);
}
void Ktexmaker2::InsertMath46()
{
InsertTag("\\bullet",0,0);
}
void Ktexmaker2::InsertMath47()
{
InsertTag("\\wedge",0,0);
}
void Ktexmaker2::InsertMath48()
{
InsertTag("\\leqslant ",0,0);
}
void Ktexmaker2::InsertMath49()
{
InsertTag("\\geqslant",0,0);
}
void Ktexmaker2::InsertMath50()
{
InsertTag("\\subset",0,0);
}
void Ktexmaker2::InsertMath51()
{
InsertTag("\\approx",0,0);
}
void Ktexmaker2::InsertMath52()
{
InsertTag("\\perp",0,0);
}
void Ktexmaker2::InsertMath53()
{
InsertTag("\\parallel",0,0);
}
void Ktexmaker2::InsertMath54()
{
InsertTag("\\widehat{}",-1,0);
}
void Ktexmaker2::InsertMath55()
{
InsertTag("\\notin",0,0);
}
void Ktexmaker2::InsertMath56()
{
InsertTag("\\uparrow",0,0);
}
void Ktexmaker2::InsertMath57()
{
InsertTag("\\Uparrow",0,0);
}
void Ktexmaker2::InsertMath58()
{    Ktexmaker2::
InsertTag("\\downarrow",0,0);
}
void Ktexmaker2::InsertMath59()
{
InsertTag("\\Downarrow",0,0);
}
void Ktexmaker2::InsertMath60()
{
InsertTag("\\updownarrow",0,0);
}
void Ktexmaker2::InsertMath61()
{
InsertTag("\\Updownarrow",0,0);
}
void Ktexmaker2::InsertMath62()
{
InsertTag("\\nearrow",0,0);
}
void Ktexmaker2::InsertMath63()
{
InsertTag("\\searrow",0,0);
}
void Ktexmaker2::InsertMath64()
{
InsertTag("\\swarrow",0,0);
}
void Ktexmaker2::InsertMath65()
{
InsertTag("\\nwarrow",0,0);
}
void Ktexmaker2::InsertMath66()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\mathrm{} ",-2,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\mathrm{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
}
void Ktexmaker2::InsertMath67()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\mathit{} ",-2,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\mathit{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
}
void Ktexmaker2::InsertMath68()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\mathbf{} ",-2,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\mathbf{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
}
void Ktexmaker2::InsertMath69()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\mathsf{} ",-2,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\mathsf{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
}
void Ktexmaker2::InsertMath70()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\mathtt{} ",-2,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\mathtt{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
}
void Ktexmaker2::InsertMath71()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\mathcal{} ",-2,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\mathcal{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
}
void Ktexmaker2::InsertMath72()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\mathbb{} ",-2,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\mathbb{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
}
void Ktexmaker2::InsertMath73()
{
if (!Editor->hasMarkedText())
   {
    InsertTag("\\mathfrak{} ",-2,0);
   }
else
   {
   Editor->cut();
   InsertTag("\\mathfrak{",0,0);
   Editor->paste();
   InsertTag("}",0,0);
   }
}
void Ktexmaker2::InsertMath74()
{
InsertTag("\\begin{equation}\n\n\\end{equation} ",-15,-1);
}
void Ktexmaker2::InsertMath75()
{
InsertTag("\\begin{eqnarray}\n\n\\end{eqnarray} ",-15,-1);
}
void Ktexmaker2::InsertMath76()
{
InsertTag("\\acute{}",-1,0);
}
void Ktexmaker2::InsertMath77()
{
InsertTag("\\grave{}",-1,0);
}
void Ktexmaker2::InsertMath78()
{
InsertTag("\\tilde{}",-1,0);
}
void Ktexmaker2::InsertMath79()
{
InsertTag("\\bar{}",-1,0);
}
void Ktexmaker2::InsertMath80()
{
InsertTag("\\vec{}",-1,0);
}
void Ktexmaker2::InsertMath81()
{
InsertTag("\\hat{}",-1,0);
}
void Ktexmaker2::InsertMath82()
{
InsertTag("\\check{}",-1,0);
}
void Ktexmaker2::InsertMath83()
{
InsertTag("\\breve{}",-1,0);
}
void Ktexmaker2::InsertMath84()
{
InsertTag("\\dot{}",-1,0);
}
void Ktexmaker2::InsertMath85()
{
InsertTag("\\ddot{}",-1,0);
}
void Ktexmaker2::InsertMath86()
{
InsertTag("\\, ",0,0);
}
void Ktexmaker2::InsertMath87()
{
InsertTag("\\: ",0,0);
}
void Ktexmaker2::InsertMath88()
{
InsertTag("\\; ",0,0);
}
void Ktexmaker2::InsertMath89()
{
InsertTag("\\quad ",0,0);
}
void Ktexmaker2::InsertMath90()
{
InsertTag("\\qquad",0,0);
}

void Ktexmaker2::LeftDelimiter(const QString& text)
{
if (text=="left (") InsertTag("\\left( ",0,0);
if (text=="left [") InsertTag("\\left[ ",0,0);
if (text=="left {") InsertTag("\\left\\lbrace ",0,0);
if (text=="left <") InsertTag("\\left\\langle ",0,0);
if (text=="left )") InsertTag("\\left) ",0,0);
if (text=="left ]") InsertTag("\\left] ",0,0);
if (text=="left }") InsertTag("\\left\\rbrace ",0,0);
if (text=="left >") InsertTag("\\left\\rangle ",0,0);
if (text=="left.") InsertTag("\\left. ",0,0);
}
void Ktexmaker2::RightDelimiter(const QString& text)
{
if (text=="right (") InsertTag("\\right( ",0,0);
if (text=="right [") InsertTag("\\right[ ",0,0);
if (text=="right {") InsertTag("\\right\\lbrace ",0,0);
if (text=="right <") InsertTag("\\right\\langle ",0,0);
if (text=="right )") InsertTag("\\right) ",0,0);
if (text=="right ]") InsertTag("\\right] ",0,0);
if (text=="right }") InsertTag("\\right\\rbrace ",0,0);
if (text=="right >") InsertTag("\\right\\rangle ",0,0);
if (text=="right.") InsertTag("\\right. ",0,0);
}
////////////////////////// GREEK TAGS //////////////////////////////////
void Ktexmaker2::InsertGreek1()
{
InsertTag("\\alpha",0,0);
}
void Ktexmaker2::InsertGreek2()
{
InsertTag("\\beta",0,0);
}
void Ktexmaker2::InsertGreek3()
{
InsertTag("\\gamma",0,0);
}
void Ktexmaker2::InsertGreek4()
{
InsertTag("\\delta",0,0);
}
void Ktexmaker2::InsertGreek5()
{
InsertTag("\\epsilon",0,0);
}
void Ktexmaker2::InsertGreek6()
{
InsertTag("\\varepsilon",0,0);
}
void Ktexmaker2::InsertGreek7()
{
InsertTag("\\zeta",0,0);
}
void Ktexmaker2::InsertGreek8()
{
InsertTag("\\eta",0,0);
}
void Ktexmaker2::InsertGreek9()
{
InsertTag("\\theta",0,0);
}
void Ktexmaker2::InsertGreek10()
{
InsertTag("\\vartheta",0,0);
}
void Ktexmaker2::InsertGreek11()
{
InsertTag("\\iota",0,0);
}
void Ktexmaker2::InsertGreek12()
{
InsertTag("\\kappa",0,0);
}
void Ktexmaker2::InsertGreek13()
{
InsertTag("\\lambda",0,0);
}
void Ktexmaker2::InsertGreek14()
{
InsertTag("\\mu",0,0);
}
void Ktexmaker2::InsertGreek15()
{
InsertTag("\\nu",0,0);
}
void Ktexmaker2::InsertGreek16()
{
InsertTag("\\xi",0,0);
}
void Ktexmaker2::InsertGreek17()
{
InsertTag("\\pi",0,0);
}
void Ktexmaker2::InsertGreek18()
{
InsertTag("\\varpi",0,0);
}
void Ktexmaker2::InsertGreek19()
{
InsertTag("\\rho",0,0);
}
void Ktexmaker2::InsertGreek20()
{
InsertTag("\\varrho",0,0);
}
void Ktexmaker2::InsertGreek21()
{
InsertTag("\\sigma",0,0);
}
void Ktexmaker2::InsertGreek22()
{
InsertTag("\\varsigma",0,0);
}
void Ktexmaker2::InsertGreek23()
{
InsertTag("\\tau",0,0);
}
void Ktexmaker2::InsertGreek24()
{
InsertTag("\\upsilon",0,0);
}
void Ktexmaker2::InsertGreek25()
{
InsertTag("\\phi",0,0);
}
void Ktexmaker2::InsertGreek26()
{
InsertTag("\\varphi",0,0);
}
void Ktexmaker2::InsertGreek27()
{
InsertTag("\\chi",0,0);
}
void Ktexmaker2::InsertGreek28()
{
InsertTag("\\psi",0,0);
}
void Ktexmaker2::InsertGreek29()
{
InsertTag("\\omega",0,0);
}
void Ktexmaker2::InsertGreek30()
{
InsertTag("\\Gamma",0,0);
}
void Ktexmaker2::InsertGreek31()
{
InsertTag("\\Delta",0,0);
}
void Ktexmaker2::InsertGreek32()
{
InsertTag("\\Theta",0,0);
}
void Ktexmaker2::InsertGreek33()
{
InsertTag("\\Lambda",0,0);
}
void Ktexmaker2::InsertGreek34()
{
InsertTag("\\Xi",0,0);
}
void Ktexmaker2::InsertGreek35()
{
InsertTag("\\Pi",0,0);
}
void Ktexmaker2::InsertGreek36()
{
InsertTag("\\Sigma",0,0);
}
void Ktexmaker2::InsertGreek37()
{
InsertTag("\\Upsilon",0,0);
}
void Ktexmaker2::InsertGreek38()
{
InsertTag("\\Phi",0,0);
}
void Ktexmaker2::InsertGreek39()
{
InsertTag("\\Psi",0,0);
}
void Ktexmaker2::InsertGreek40()
{
InsertTag("\\Omega",0,0);
}
////////////////////////// BIBLIOGRAPHY //////////////////////////
void Ktexmaker2::InsertBib1()
{
InsertTag("@Article{,\n",0,0);
InsertTag("author = {},\n",0,0);
InsertTag("title = {},\n",0,0);
InsertTag("journal = {},\n",0,0);
InsertTag("year = {},\n",0,0);
InsertTag("OPTkey = {},\n",0,0);
InsertTag("OPTvolume = {},\n",0,0);
InsertTag("OPTnumber = {},\n",0,0);
InsertTag("OPTpages = {},\n",0,0);
InsertTag("OPTmonth = {},\n",0,0);
InsertTag("OPTnote = {},\n",0,0);
InsertTag("OPTannote = {}\n",0,0);
InsertTag("}",8,-12);
output->clear();
output->insertLine("Bib fields - Article in Journal");
output->insertLine( "OPT.... : optionnal fields");
}
void Ktexmaker2::InsertBib2()
{
InsertTag("@InProceedings{,\n",0,0);
InsertTag("author = {},\n",0,0);
InsertTag("title = {},\n",0,0);
InsertTag("booktitle = {},\n",0,0);
InsertTag("OPTcrossref = {},\n",0,0);
InsertTag("OPTkey = {},\n",0,0);
InsertTag("OPTpages = {},\n",0,0);
InsertTag("OPTyear = {},\n",0,0);
InsertTag("OPTeditor = {},\n",0,0);
InsertTag("OPTvolume = {},\n",0,0);
InsertTag("OPTnumber = {},\n",0,0);
InsertTag("OPTseries = {},\n",0,0);
InsertTag("OPTaddress = {},\n",0,0);
InsertTag("OPTmonth = {},\n",0,0);
InsertTag("OPTorganization = {},\n",0,0);
InsertTag("OPTpublisher = {},\n",0,0);
InsertTag("OPTnote = {},\n",0,0);
InsertTag("OPTannote = {}\n",0,0);
InsertTag("}",14,-18);
output->clear();
output->insertLine("Bib fields - Article in Conference Proceedings");
output->insertLine( "OPT.... : optionnal fields");
}
void Ktexmaker2::InsertBib3()
{
InsertTag("@InCollection{,\n",0,0);
InsertTag("author = {},\n",0,0);
InsertTag("title = {},\n",0,0);
InsertTag("booktitle = {},\n",0,0);
InsertTag("OPTcrossref = {},\n",0,0);
InsertTag("OPTkey = {},\n",0,0);
InsertTag("OPTpages = {},\n",0,0);
InsertTag("OPTpublisher = {},\n",0,0);
InsertTag("OPTyear = {},\n",0,0);
InsertTag("OPTeditor = {},\n",0,0);
InsertTag("OPTvolume = {},\n",0,0);
InsertTag("OPTnumber = {},\n",0,0);
InsertTag("OPTseries = {},\n",0,0);
InsertTag("OPTtype = {},\n",0,0);
InsertTag("OPTchapter = {},\n",0,0);
InsertTag("OPTaddress = {},\n",0,0);
InsertTag("OPTedition = {},\n",0,0);
InsertTag("OPTmonth = {},\n",0,0);
InsertTag("OPTnote = {},\n",0,0);
InsertTag("OPTannote = {}\n",0,0);
InsertTag("}",13,-20);
output->clear();
output->insertLine("Bib fields - Article in a Collection");
output->insertLine( "OPT.... : optionnal fields");
}
void Ktexmaker2::InsertBib4()
{
InsertTag("@InBook{,\n",0,0);
InsertTag("ALTauthor = {},\n",0,0);
InsertTag("ALTeditor = {},\n",0,0);
InsertTag("title = {},\n",0,0);
InsertTag("chapter = {},\n",0,0);
InsertTag("publisher = {},\n",0,0);
InsertTag("year = {},\n",0,0);
InsertTag("OPTkey = {},\n",0,0);
InsertTag("OPTvolume = {},\n",0,0);
InsertTag("OPTnumber = {},\n",0,0);
InsertTag("OPTseries = {},\n",0,0);
InsertTag("OPTtype = {},\n",0,0);
InsertTag("OPTaddress = {},\n",0,0);
InsertTag("OPTedition = {},\n",0,0);
InsertTag("OPTmonth = {},\n",0,0);
InsertTag("OPTpages = {},\n",0,0);
InsertTag("OPTnote = {},\n",0,0);
InsertTag("OPTannote = {}\n",0,0);
InsertTag("}",7,-18);
output->clear();
output->insertLine("Bib fields - Chapter or Pages in a Book");
output->insertLine( "ALT.... : you have the choice between these two fields");
output->insertLine( "OPT.... : optionnal fields");
}
void Ktexmaker2::InsertBib5()
{
InsertTag("@Proceedings{,\n",0,0);
InsertTag("title = {},\n",0,0);
InsertTag("year = {},\n",0,0);
InsertTag("OPTkey = {},\n",0,0);
InsertTag("OPTeditor = {},\n",0,0);
InsertTag("OPTvolume = {},\n",0,0);
InsertTag("OPTnumber = {},\n",0,0);
InsertTag("OPTseries = {},\n",0,0);
InsertTag("OPTaddress = {},\n",0,0);
InsertTag("OPTmonth = {},\n",0,0);
InsertTag("OPTorganization = {},\n",0,0);
InsertTag("OPTpublisher = {},\n",0,0);
InsertTag("OPTnote = {},\n",0,0);
InsertTag("OPTannote = {}\n",0,0);
InsertTag("}",12,-14);
output->clear();
output->insertLine("Bib fields - Conference Proceedings");
output->insertLine( "OPT.... : optionnal fields");
}
void Ktexmaker2::InsertBib6()
{
InsertTag("@Book{,\n",0,0);
InsertTag("ALTauthor = {},\n",0,0);
InsertTag("ALTeditor = {},\n",0,0);
InsertTag("title = {},\n",0,0);
InsertTag("publisher = {},\n",0,0);
InsertTag("year = {},\n",0,0);
InsertTag("OPTkey = {},\n",0,0);
InsertTag("OPTvolume = {},\n",0,0);
InsertTag("OPTnumber = {},\n",0,0);
InsertTag("OPTseries = {},\n",0,0);
InsertTag("OPTaddress = {},\n",0,0);
InsertTag("OPTedition = {},\n",0,0);
InsertTag("OPTmonth = {},\n",0,0);
InsertTag("OPTnote = {},\n",0,0);
InsertTag("OPTannote = {}\n",0,0);
InsertTag("}",5,-15);
output->clear();
output->insertLine("Bib fields - Book");
output->insertLine( "ALT.... : you have the choice between these two fields");
output->insertLine( "OPT.... : optionnal fields");
}
void Ktexmaker2::InsertBib7()
{
InsertTag("@Booklet{,\n",0,0);
InsertTag("title = {},\n",0,0);
InsertTag("OPTkey = {},\n",0,0);
InsertTag("OPTauthor = {},\n",0,0);
InsertTag("OPThowpublished = {},\n",0,0);
InsertTag("OPTaddress = {},\n",0,0);
InsertTag("OPTmonth = {},\n",0,0);
InsertTag("OPTyear = {},\n",0,0);
InsertTag("OPTnote = {},\n",0,0);
InsertTag("OPTannote = {}\n",0,0);
InsertTag("}",8,-10);
output->clear();
output->insertLine("Bib fields - Booklet");
output->insertLine( "OPT.... : optionnal fields");
}
void Ktexmaker2::InsertBib8()
{
InsertTag("@PhdThesis{,\n",0,0);
InsertTag("author = {},\n",0,0);
InsertTag("title = {},\n",0,0);
InsertTag("school = {},\n",0,0);
InsertTag("year = {},\n",0,0);
InsertTag("OPTkey = {},\n",0,0);
InsertTag("OPTtype = {},\n",0,0);
InsertTag("OPTaddress = {},\n",0,0);
InsertTag("OPTmonth = {},\n",0,0);
InsertTag("OPTnote = {},\n",0,0);
InsertTag("OPTannote = {}\n",0,0);
InsertTag("}",10,-11);
output->clear();
output->insertLine("Bib fields - PhD. Thesis");
output->insertLine( "OPT.... : optionnal fields");
}
void Ktexmaker2::InsertBib9()
{
InsertTag("@MastersThesis{,\n",0,0);
InsertTag("author = {},\n",0,0);
InsertTag("title = {},\n",0,0);
InsertTag("school = {},\n",0,0);
InsertTag("year = {},\n",0,0);
InsertTag("OPTkey = {},\n",0,0);
InsertTag("OPTtype = {},\n",0,0);
InsertTag("OPTaddress = {},\n",0,0);
InsertTag("OPTmonth = {},\n",0,0);
InsertTag("OPTnote = {},\n",0,0);
InsertTag("OPTannote = {}\n",0,0);
InsertTag("}",14,-11);
output->clear();
output->insertLine("Bib fields - Master's Thesis");
output->insertLine( "OPT.... : optionnal fields");
}
void Ktexmaker2::InsertBib10()
{
InsertTag("@TechReport{,\n",0,0);
InsertTag("author = {},\n",0,0);
InsertTag("title = {},\n",0,0);
InsertTag("institution = {},\n",0,0);
InsertTag("year = {},\n",0,0);
InsertTag("OPTkey = {},\n",0,0);
InsertTag("OPTtype = {},\n",0,0);
InsertTag("OPTnumber = {},\n",0,0);
InsertTag("OPTaddress = {},\n",0,0);
InsertTag("OPTmonth = {},\n",0,0);
InsertTag("OPTnote = {},\n",0,0);
InsertTag("OPTannote = {}\n",0,0);
InsertTag("}",11,-12);
output->clear();
output->insertLine("Bib fields - Technical Report");
output->insertLine( "OPT.... : optionnal fields");
}
void Ktexmaker2::InsertBib11()
{
InsertTag("@Manual{,\n",0,0);
InsertTag("title = {},\n",0,0);
InsertTag("OPTkey = {},\n",0,0);
InsertTag("OPTauthor = {},\n",0,0);
InsertTag("OPTorganization = {},\n",0,0);
InsertTag("OPTaddress = {},\n",0,0);
InsertTag("OPTedition = {},\n",0,0);
InsertTag("OPTmonth = {},\n",0,0);
InsertTag("OPTyear = {},\n",0,0);
InsertTag("OPTnote = {},\n",0,0);
InsertTag("OPTannote = {}\n",0,0);
InsertTag("}",7,-11);
output->clear();
output->insertLine("Bib fields - Technical Manual");
output->insertLine( "OPT.... : optionnal fields");
}
void Ktexmaker2::InsertBib12()
{
InsertTag("@Unpublished{,\n",0,0);
InsertTag("author = {},\n",0,0);
InsertTag("title = {},\n",0,0);
InsertTag("note = {},\n",0,0);
InsertTag("OPTkey = {},\n",0,0);
InsertTag("OPTmonth = {},\n",0,0);
InsertTag("OPTyear = {},\n",0,0);
InsertTag("OPTannote = {}\n",0,0);
InsertTag("}",12,-8);
output->clear();
output->insertLine("Bib fields - Unpublished");
output->insertLine( "OPT.... : optionnal fields");
}
void Ktexmaker2::InsertBib13()
{
InsertTag("@Misc{,\n",0,0);
InsertTag("OPTkey = {},\n",0,0);
InsertTag("OPTauthor = {},\n",0,0);
InsertTag("OPTtitle = {},\n",0,0);
InsertTag("OPThowpublished = {},\n",0,0);
InsertTag("OPTmonth = {},\n",0,0);
InsertTag("OPTyear = {},\n",0,0);
InsertTag("OPTnote = {},\n",0,0);
InsertTag("OPTannote = {}\n",0,0);
InsertTag("}",5,-9);
output->clear();
output->insertLine("Bib fields - Miscellaneous");
output->insertLine( "OPT.... : optionnal fields");
}
////////////////////////// STRUCTURE /////////////////////////////
void Ktexmaker2::UpdateStructure()
{

outstruct->clear();
QString shortName = Editor->getName();
int pos;
while ( (pos = (int)shortName.find('/')) != -1 )
shortName.remove(0,pos+1);
QListViewItem *top=  new QListViewItem( outstruct, shortName,"0",0 );
top->setOpen(TRUE);
top->setPixmap(0,SmallIcon("contents"));
Child=lastChild=parent_level[0]=parent_level[1]=parent_level[2]=parent_level[3]=parent_level[4]=top;
structlist->clear();
structitem->clear();
structlist->append(QString::number(0));
structitem->append(shortName);
QListViewItem *toplabel=  new QListViewItem(top,"LABELS","0",0 );
structlist->append(QString::number(0));
structitem->append("LABELS");
QString s;
for(int i = 0; i < Editor->numLines(); i++)
 {
 s = Editor->textLine(i);
 int tagStart, tagEnd;
 //// label ////
 tagStart=tagEnd=0;
 tagStart=s.find("\\label{", tagEnd);
 if (tagStart!=-1)
  {
    s=s.mid(tagStart,qstrlen(s));
    tagStart=s.find("}", tagEnd);
    if (tagStart!=-1)
    {
    s=s.mid(0,tagStart+1);
    structlist->append(QString::number(i));
    s=s+" (line "+QString::number(i+1)+")";
    structitem->append(s);
    Child = toplabel->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    Child=new QListViewItem( toplabel,lastChild,s );
    }
  };

 //// include ////
 tagStart=tagEnd=0;
 tagStart=s.find("\\include{", tagEnd);
 if (tagStart!=-1)
  {
    s=s.mid(tagStart,qstrlen(s));
    tagStart=s.find("}", tagEnd);
    if (tagStart!=-1)
    {
    s=s.mid(0,tagStart+1);
    structlist->append("include");
    structitem->append(s);
    Child = top->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    Child=new QListViewItem( top,lastChild,s );
    }
  };
 //// input ////
 tagStart=tagEnd=0;
 tagStart=s.find("\\input{", tagEnd);
 if (tagStart!=-1)
  {
    s=s.mid(tagStart,qstrlen(s));
    tagStart=s.find("}", tagEnd);
    if (tagStart!=-1)
    {
    s=s.mid(0,tagStart+1);
    structlist->append("input");
    structitem->append(s);
    Child = top->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    Child=new QListViewItem( top,lastChild,s );
    }
  };
 //// part ////
 tagStart=tagEnd=0;
 tagStart=s.find(QRegExp("\\\\"+struct_level1+"\\*?[\\{\\[]"), tagEnd);
 if (tagStart!=-1)
  {
    structlist->append(QString::number(i));
    s=s+" (line "+QString::number(i+1)+")";
    structitem->append(s);
    Child = top->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    parent_level[0]=new QListViewItem( top,lastChild,s );
    parent_level[1]=parent_level[2]=parent_level[3]=parent_level[4]=parent_level[0];
  };
 //// chapter ////
 tagStart=tagEnd=0;
 tagStart=s.find(QRegExp("\\\\"+struct_level2+"\\*?[\\{\\[]"), tagEnd);
 if (tagStart!=-1)
  {
    structlist->append(QString::number(i));
    s=s+" (line "+QString::number(i+1)+")";
    structitem->append(s);
    Child = parent_level[0]->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    parent_level[1]=new QListViewItem(parent_level[0],lastChild , s );
    parent_level[2]=parent_level[3]=parent_level[4]=parent_level[1];
  };
 //// section ////
 tagStart=tagEnd=0;
 tagStart=s.find(QRegExp("\\\\"+struct_level3+"\\*?[\\{\\[]"), tagEnd);
 if (tagStart!=-1)
  {
    structlist->append(QString::number(i));
    s=s+" (line "+QString::number(i+1)+")";
    structitem->append(s);
    Child = parent_level[1]->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    parent_level[2]=new QListViewItem( parent_level[1],lastChild, s);
    parent_level[3]=parent_level[4]=parent_level[2];
  };
 //// subsection ////
 tagStart=tagEnd=0;
 tagStart=s.find(QRegExp("\\\\"+struct_level4+"\\*?[\\{\\[]"), tagEnd);
 if (tagStart!=-1)
  {
    structlist->append(QString::number(i));
    s=s+" (line "+QString::number(i+1)+")";
    structitem->append(s);
    Child = parent_level[2]->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    parent_level[3]=new QListViewItem( parent_level[2],lastChild, s);
    parent_level[4]=parent_level[3];
  };
 //// subsubsection ////
 tagStart=tagEnd=0;
 tagStart=s.find(QRegExp("\\\\"+struct_level5+"\\*?[\\{\\[]"), tagEnd);
 if (tagStart!=-1)
  {
    structlist->append(QString::number(i));
    s=s+" (line "+QString::number(i+1)+")";
    structitem->append(s);
    Child = parent_level[3]->firstChild();
    while( Child ) {
    lastChild=Child;
    Child = Child->nextSibling();
    };
    parent_level[4]=new QListViewItem( parent_level[3],lastChild, s);
  };
 }
outstruct->show();
}

void Ktexmaker2::ClickedOnStructure(QListViewItem *)
{
QListViewItem *item = outstruct->currentItem();
QString it;
int i=0;
if ((item) && (!structlist->isEmpty()))
 {
  for ( it=structitem->first(); it != 0; it=structitem->next() )
  {
  if (it!=item->text(0)) i++;
  else break;
  }
 bool ok;
 QString s=structlist->at(i);
if (s!="include" && s!="input")
 {
 int l=s.toInt(&ok,10);
 if (ok && l<=Editor->numLines())
  {
  Editor->setFocus();
  Editor->setCursorPosition(l, 0);
  UpdateLineColStatus();
  }
 }
 }
}

void Ktexmaker2::DoubleClickedOnStructure(QListViewItem *)
{
QListViewItem *item = outstruct->currentItem();
QString it;
int i=0;
if ((item) && (!structlist->isEmpty()))
 {
  for ( it=structitem->first(); it != 0; it=structitem->next() )
  {
  if (it!=item->text(0)) i++;
  else break;
  }
QString s=structlist->at(i);
if (s=="input")
 {
QString fname=structitem->at(i);
if (fname.right(5)==".tex}") fname=QFileInfo(Editor->getName()).dirPath()+"/"+fname.mid(7,qstrlen(fname)-8);
else fname=QFileInfo(Editor->getName()).dirPath()+"/"+fname.mid(7,qstrlen(fname)-8)+".tex";
if (FileAlreadyOpen(fname)) return;
if (Editor->isModified() || Editor->getName()!=i18n("Untitled")) NewFile();
QFileInfo fi(fname);
if (fi.exists() && fi.isReadable())
  {
  Editor->loadURL(fname);
  AddRecentFile(Editor->getName());
  Editor->setFocus();
  UpdateCaption();
  UpdateLineColStatus();
  }
 else
  {
  if (!Editor->isModified() && Editor->getName()==i18n("Untitled")) Close();
  }
 };
if (s=="include")
 {
QString fname=structitem->at(i);
if (fname.right(5)==".tex}") fname=QFileInfo(Editor->getName()).dirPath()+"/"+fname.mid(9,qstrlen(fname)-10);
else fname=QFileInfo(Editor->getName()).dirPath()+"/"+fname.mid(9,qstrlen(fname)-10)+".tex";
if (FileAlreadyOpen(fname)) return;
if (Editor->isModified() || Editor->getName()!=i18n("Untitled")) NewFile();
QFileInfo fi(fname);
if (fi.exists() && fi.isReadable())
  {
  Editor->loadURL(fname);
  AddRecentFile(Editor->getName());
  Editor->setFocus();
  UpdateCaption();
  UpdateLineColStatus();
  }
 else
  {
  if (!Editor->isModified() && Editor->getName()==i18n("Untitled")) Close();
  }
 };
}
}

void Ktexmaker2::ClickedOnOutput()
{
 int x,y,Start, End;
 bool ok;
 QString s;
 QString line="";
 stdoutput->getCursorPosition(&x,&y);
 s = stdoutput->textLine(x);
 //// l. ///
 s = stdoutput->textLine(x);
 Start=End=0;
 Start=s.find(QRegExp("l.[0-9]"), End);
 if (Start!=-1)
  {
  Start=Start+2;
  s=s.mid(Start,qstrlen(s));
  End=s.find(QRegExp("[ a-zA-Z.\\-]"),0);
  if (End!=-1)
    line=s.mid(0,End);
  else
    line=s.mid(0,qstrlen(s));
  };
 //// line ///
 s = stdoutput->textLine(x);
 Start=End=0;
 Start=s.find(QRegExp("line [0-9]"), End);
 if (Start!=-1)
  {
  Start=Start+5;
  s=s.mid(Start,qstrlen(s));
  End=s.find(QRegExp("[ a-zA-Z.\\-]"),0);
  if (End!=-1)
    line=s.mid(0,End);
  else
    line=s.mid(0,qstrlen(s));
  };
 //// lines ///
 s = stdoutput->textLine(x);
 Start=End=0;
 Start=s.find(QRegExp("lines [0-9]"), End);
 if (Start!=-1)
  {
  Start=Start+6;
  s=s.mid(Start,qstrlen(s));
  End=s.find(QRegExp("[ a-zA-Z.\\-]"),0);
  if (End!=-1)
    line=s.mid(0,End);
  else
    line=s.mid(0,qstrlen(s));
  };
int l=line.toInt(&ok,10)-1;
if (ok && l<=Editor->numLines())
 {
 Editor->setFocus();
 Editor->setCursorPosition(l, 0);
 UpdateLineColStatus();
 }
}
////////////////////////// ERRORS /////////////////////////////
void Ktexmaker2::LatexError()
{
errorlist->clear();
QString s;
for(int i = 0; i < stdoutput->numLines(); i++)
 {
 s = stdoutput->textLine(i);
 int tagStart, tagEnd;
 //// ! ////
 tagStart=tagEnd=0;
 tagStart=s.find("!", tagEnd);
 if (tagStart==0)
  {
    errorlist->append(QString::number(i));
  };
 //// latex warning ////
 tagStart=tagEnd=0;
 tagStart=s.find("LaTeX Warning", tagEnd);
 if (tagStart!=-1)
  {
    errorlist->append(QString::number(i));
  };
 }
}

void Ktexmaker2::NextError()
{
QString line="";
bool ok;
if (!logpresent) {ViewLog();}
if (logpresent && !errorlist->isEmpty())
  {
  Outputview->showPage(stdoutput);
  int id=errorlist->findRef(errorlist->next());
  if (id>=0)
  {
  line=errorlist->at(id);
  }
  else
  {
  line=errorlist->at(0);
  }
  int l=line.toInt(&ok,10);
  if (ok && l<=stdoutput->numLines())
    {
    stdoutput->setCursorPosition(0 , 0, FALSE );
    stdoutput->setCursorPosition(l+3 , 0, FALSE );
    }
  }
if (logpresent && errorlist->isEmpty())
  {
Outputview->showPage(output);
output->clear();
output->insertLine("No LaTeX errors detected !");
  }
}

void Ktexmaker2::PreviousError()
{
QString line="";
bool ok;
if (!logpresent) {ViewLog();}
if (logpresent && !errorlist->isEmpty())
  {
  Outputview->showPage(stdoutput);
  int id=errorlist->findRef(errorlist->prev());
  if (id>=0)
  {
  line=errorlist->at(id);
  }
  else
  {
  line=errorlist->at(errorlist->count()-1);
  }
  int l=line.toInt(&ok,10);
  if (ok && l<=stdoutput->numLines())
    {
    stdoutput->setCursorPosition(0 , 0, FALSE );
    stdoutput->setCursorPosition(l+3 , 0, FALSE );
    }
  }

if (logpresent && errorlist->isEmpty())
  {
Outputview->showPage(output);
output->clear();
output->insertLine("No LaTeX errors detected !");
  }
}
//////////////////// SPELLCHECK //////////////////////////////
void Ktexmaker2::spellcheck()
{

Editor->spellcheck();
}
/////////////////// USER MENU ///////////////////////////////
void Ktexmaker2::EditUserMenu()
{
umDlg = new usermenudialog(this,"Edit Menu User :");
umDlg->LineEdit19->setText(UserMenuNames->at(0));
umDlg->LineEdit29->setText(UserMenuTags->at(0));
umDlg->LineEdit18->setText(UserMenuNames->at(1));
umDlg->LineEdit28->setText(UserMenuTags->at(1));
umDlg->LineEdit17->setText(UserMenuNames->at(2));
umDlg->LineEdit27->setText(UserMenuTags->at(2));
umDlg->LineEdit16->setText(UserMenuNames->at(3));
umDlg->LineEdit26->setText(UserMenuTags->at(3));
umDlg->LineEdit15->setText(UserMenuNames->at(4));
umDlg->LineEdit25->setText(UserMenuTags->at(4));
umDlg->LineEdit14->setText(UserMenuNames->at(5));
umDlg->LineEdit24->setText(UserMenuTags->at(5));
umDlg->LineEdit13->setText(UserMenuNames->at(6));
umDlg->LineEdit23->setText(UserMenuTags->at(6));
umDlg->LineEdit12->setText(UserMenuNames->at(7));
umDlg->LineEdit22->setText(UserMenuTags->at(7));
umDlg->LineEdit11->setText(UserMenuNames->at(8));
umDlg->LineEdit21->setText(UserMenuTags->at(8));
umDlg->LineEdit10->setText(UserMenuNames->at(9));
umDlg->LineEdit20->setText(UserMenuTags->at(9));
if ( umDlg->exec() )
 {
  UserMenuNames->clear();
  UserMenuTags->clear();
  UserMenuNames->append(umDlg->LineEdit19->text());
  UserMenuTags->append(umDlg->LineEdit29->text());
  UserMenuNames->append(umDlg->LineEdit18->text());
  UserMenuTags->append(umDlg->LineEdit28->text());
  UserMenuNames->append(umDlg->LineEdit17->text());
  UserMenuTags->append(umDlg->LineEdit27->text());
  UserMenuNames->append(umDlg->LineEdit16->text());
  UserMenuTags->append(umDlg->LineEdit26->text());
  UserMenuNames->append(umDlg->LineEdit15->text());
  UserMenuTags->append(umDlg->LineEdit25->text());
  UserMenuNames->append(umDlg->LineEdit14->text());
  UserMenuTags->append(umDlg->LineEdit24->text());
  UserMenuNames->append(umDlg->LineEdit13->text());
  UserMenuTags->append(umDlg->LineEdit23->text());
  UserMenuNames->append(umDlg->LineEdit12->text());
  UserMenuTags->append(umDlg->LineEdit22->text());
  UserMenuNames->append(umDlg->LineEdit11->text());
  UserMenuTags->append(umDlg->LineEdit21->text());
  UserMenuNames->append(umDlg->LineEdit10->text());
  UserMenuTags->append(umDlg->LineEdit20->text());

  usermenu->clear();
  for (int i=9; i>-1; i--)
    {
    QString nu=QString::number(10-i);
    nu=nu.leftJustify(2,' ');
    usermenu->insertItem(nu+": "+UserMenuNames->at(i));
    }
  usermenu->insertSeparator();
  usermenu->insertItem(i18n("Edit User Menu"),this, SLOT(EditUserMenu()));
 }
delete umDlg;
}

void Ktexmaker2::InsertUserTag(int id)
{
bool ok;
QString num=usermenu->text(id);
num=num.left(2);
int n=num.toInt(&ok,10);
if (ok) InsertTag(UserMenuTags->at(10-n),0,0);
}

/////////////////  OPTIONS ////////////////////
void Ktexmaker2::ToggleLatexMode()
{
latexmode=!latexmode;
if (latexmode) {StatusBar->changeItem(" LaTeX ", ID_LATEXMODE);}
else {StatusBar->changeItem(" PdfLaTeX ", ID_LATEXMODE);}
}
void Ktexmaker2::ToggleTools()
{
kdetools=!kdetools;
if (kdetools) {StatusBar->changeItem(" KDE ", ID_TOOLS);}
else {StatusBar->changeItem("  X  ", ID_TOOLS);}
}
void Ktexmaker2::ToggleMode()
{
singlemode=!singlemode;
if (singlemode) {StatusBar->changeItem(" Single ", ID_MODE);}
else {
      MasterName=Editor->getName();
      QString shortName = MasterName;
      int pos;
      while ( (pos = (int)shortName.find('/')) != -1 )
      shortName.remove(0,pos+1);
      StatusBar->changeItem(" Multi :"+shortName, ID_MODE);
      }
}

void Ktexmaker2::slotOptionsEditor(){
  KWin kwin;
  // I read that no widgets should be created on the stack
  KDialogBase *kd = new KDialogBase(KDialogBase::IconList,
                                    i18n("Configure Editor"),
                                    KDialogBase::Ok | KDialogBase::Cancel |
                                    KDialogBase::Help ,
                                    KDialogBase::Ok, this, "tabdialog");
  kd->resize(400,350);
    // color options
  QVBox *page=kd->addVBoxPage(i18n("Colors"), QString::null,
                              BarIcon("colorize", KIcon::SizeMedium) );
  ColorConfig *colorConfig = new ColorConfig(page);
  QColor* colors = Editor->getColors();
  colorConfig->setColors(colors);

  // indent options
  page=kd->addVBoxPage(i18n("Indent"), QString::null,
                       BarIcon("rightjust", KIcon::SizeMedium) );
  IndentConfigTab *indentConfig = new IndentConfigTab(page, Editor);

  // select options
  page=kd->addVBoxPage(i18n("Select"), QString::null,
                       BarIcon("misc") );
  SelectConfigTab *selectConfig = new SelectConfigTab(page, Editor);

  // edit options
  page=kd->addVBoxPage(i18n("Edit"), QString::null,
                       BarIcon("edit", KIcon::SizeMedium ) );
  EditConfigTab *editConfig = new EditConfigTab(page, Editor);

  // spell checker
  page = kd->addVBoxPage( i18n("Spelling"), i18n("Spell checker behavior"),
                          BarIcon("spellcheck", KIcon::SizeMedium) );
  KSpellConfig *ksc = new KSpellConfig(page, 0L, Editor->ksConfig(), false );

  kwin.setIcons(kd->winId(), kapp->icon(), kapp->miniIcon());

 if (kd->exec()) {
    // color options
    colorConfig->getColors(colors);
    Editor->applyColors();
    // indent options
    indentConfig->getData(Editor);
    // select options
    selectConfig->getData(Editor);
    // edit options
    editConfig->getData(Editor);
    // spell checker
    ksc->writeGlobalSettings();
    Editor->setKSConfig(*ksc);
  }

  delete kd;
  Editor->writeConfig(config);
}

void Ktexmaker2::slotOptionsEditorFonts(){
  Editor->hlDlg();
  Editor->writeConfig(config);
}


void Ktexmaker2::ToggleOutputView()
{
ShowOutputView(true);
}

void Ktexmaker2::ToggleStructView()
{
ShowStructView(true);
}

void Ktexmaker2::ShowOutputView(bool change)
{
if (change) showoutputview=!showoutputview;
if (showoutputview)
    {
    options->setItemChecked(ID_VIEW_OUTPUTVIEW,true);
    Outputview->show();
    }
else
   {
   options->setItemChecked(ID_VIEW_OUTPUTVIEW,false);
   Outputview->hide();
   }
}

void Ktexmaker2::ShowStructView(bool change)
{
if (change) showstructview=!showstructview;
if (showstructview)
   {
   options->setItemChecked(ID_VIEW_STRUCTVIEW,true);
   Structview->show();
   }
else
   {
   options->setItemChecked(ID_VIEW_STRUCTVIEW,false);
   Structview->hide();
   }
}

void Ktexmaker2::ChangeStructViewItems()
{
int tagStart,tagEnd;
swDlg = new structviewdialog(this,"Edit Structure View Items :");
swDlg->LineEdit1->setText(struct_level1);
swDlg->LineEdit2->setText(struct_level2);
swDlg->LineEdit3->setText(struct_level3);
swDlg->LineEdit4->setText(struct_level4);
swDlg->LineEdit5->setText(struct_level5);
if ( swDlg->exec() )
 {
 struct_level1=swDlg->LineEdit1->text();
 struct_level2=swDlg->LineEdit2->text();
 struct_level3=swDlg->LineEdit3->text();
 struct_level4=swDlg->LineEdit4->text();
 struct_level5=swDlg->LineEdit5->text();
 tagStart=tagEnd=0;
 tagStart=struct_level1.find("\\", tagEnd);
 if ((tagStart!=-1) || struct_level1.isEmpty() || struct_level1=="input" || struct_level1=="include") struct_level1="part";
 tagStart=tagEnd=0;
 tagStart=struct_level2.find("\\", tagEnd);
 if ((tagStart!=-1) || struct_level2.isEmpty() || struct_level2=="input" || struct_level2=="include") struct_level2="chapter";
 tagStart=tagEnd=0;
 tagStart=struct_level3.find("\\", tagEnd);
 if ((tagStart!=-1) || struct_level3.isEmpty() || struct_level3=="input" || struct_level3=="include") struct_level3="section";
 tagStart=tagEnd=0;
 tagStart=struct_level4.find("\\", tagEnd);
 if ((tagStart!=-1) || struct_level4.isEmpty() || struct_level4=="input" || struct_level4=="include") struct_level4="subsection";
 tagStart=tagEnd=0;
 tagStart=struct_level5.find("\\", tagEnd);
 if ((tagStart!=-1) || struct_level5.isEmpty() || struct_level5=="input" || struct_level5=="include") struct_level5="subsubsection";
 }
delete swDlg;
UpdateStructure();
}

void Ktexmaker2::OptionsTools()
{
toDlg = new toolsoptionsdialog(this,"Configure Tools");
toDlg->LineEdit3->setText(latex_command);
toDlg->LineEdit4->setText(viewdvi_command);
toDlg->LineEdit5->setText(dvips_command);
toDlg->LineEdit6->setText(viewps_command);
toDlg->LineEdit7->setText(ps2pdf_command);
toDlg->LineEdit8->setText(makeindex_command);
toDlg->LineEdit9->setText(bibtex_command);
toDlg->LineEdit10->setText(pdflatex_command);
toDlg->LineEdit11->setText(viewpdf_command);
if (toDlg->exec())
  {
   latex_command=toDlg->LineEdit3->text();
   viewdvi_command=toDlg->LineEdit4->text();
   dvips_command=toDlg->LineEdit5->text();
   viewps_command=toDlg->LineEdit6->text();
   ps2pdf_command=toDlg->LineEdit7->text();
   makeindex_command=toDlg->LineEdit8->text();
   bibtex_command=toDlg->LineEdit9->text();
   pdflatex_command=toDlg->LineEdit10->text();
   viewpdf_command=toDlg->LineEdit11->text();
  }
delete toDlg;
}
void Ktexmaker2::ConfigureKeys()
{
	KKeyDialog::configureKeys(keys);
  keys->writeSettings();
}
////////////////////// PART ////////////////////////////////
void Ktexmaker2::ResetPart()
{
if (ps_part && previewpresent) delete ps_part;
if (html_part && htmlpresent) delete html_part;
previewpresent=false;
htmlpresent=false;
}

void Ktexmaker2::BrowserBack()
{
if (html_part && htmlpresent) html_part->back();
}

void Ktexmaker2::BrowserForward()
{
if (html_part && htmlpresent) html_part->forward();
}

void Ktexmaker2::BrowserHome()
{
if (html_part && htmlpresent) html_part->home();
}

void Ktexmaker2::UserManual()
{
  output->clear();
  output->insertLine("User Manual...");
  QFileInfo fic(locate("appdata","doc/usermanual.html"));
	if (fic.exists() && fic.isReadable())
  {
   MainToolBar->setItemEnabled(ID_EDITORVIEW,true);
   MainToolBar->setItemEnabled(ID_BACK,true);
   MainToolBar->setItemEnabled(ID_FORWARD,true);
   MainToolBar->setItemEnabled(ID_HOME,true);
   ResetPart();
   html_part = new docpart(topWidgetStack,"help");
   html_part->openURL(locate("appdata","doc/usermanual.html"));
   html_part->addToHistory(locate("appdata","doc/usermanual.html"));
   topWidgetStack->addWidget(html_part->widget() , 1 );
   topWidgetStack->raiseWidget(1);
   html_part->show();
   htmlpresent=true;
  }
 else
 {
  KMessageBox::error(this, i18n("File not found !"));
 }
}
