/**********************************************************************

	--- Qt Architect generated file ---

	File: fileFilter.cpp
	Last generated: Sat May 2 22:35:39 1998

 *********************************************************************/
using namespace std;

#include "fileFilter.h"
#include <qstring.h>
#include <qfiledlg.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <string>

#define Inherited fileFilterData

fileFilter::fileFilter
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Data File Filtering Command" );
}


fileFilter::~fileFilter()
{
}

void fileFilter::setGnuInterface(gnuInterface* gnu)
{
  gnuInt = gnu;

  string temp = gnuInt->getFileFilter();
  filterEdit->setText(temp.c_str());

  string quoteChar = gnuInt->getFileFilterQuoteChar();
  
  if (quoteChar == "single")
  {
    singleQuoteRB->setChecked(TRUE);
    doubleQuoteRB->setChecked(FALSE);
  }

  if (quoteChar == "double")
  {
    doubleQuoteRB->setChecked(TRUE);
    singleQuoteRB->setChecked(FALSE);
  }
  
}

void fileFilter::insertCurrentFilename()
{
  QString currentText = filterEdit->text();

  string temp = gnuInt->getPlotFilename();
  QString filename = temp.c_str();

  QString newString;

  newString += currentText ;
  newString += filename;
  
  filterEdit->setText(newString);
}

void fileFilter::insertNewFilename()
{
  QString currentText = filterEdit->text();
  
  QString filename = KFileDialog::getOpenFileName(QDir::currentDirPath(), "",this, i18n("Open File"));

  if (!filename.isNull())
  {
    QString newString;
    newString += currentText;
    newString += filename;
    
    filterEdit->setText(newString);
  }
}

void fileFilter::setFilter()
{
  string filterCmd;
  
  if (singleQuoteRB->isChecked() == TRUE)
    gnuInt->setFileFilterQuoteChar("single");
  else if (doubleQuoteRB->isChecked() == TRUE)
    gnuInt->setFileFilterQuoteChar("double");
  
  filterCmd += filterEdit->text();
  
  gnuInt->setFileFilter(filterCmd);

  QDialog::accept();
}
