# $Id: getperlflags.pl,v 1.1 2005/07/19 19:22:12 ekalin Exp $
# The ExtUtils::Embed module returns, under Windows, compiler options
# using the syntax used by Microsoft Compilers.
# Since I compile KildClient for Windows with mingw32, a port of gcc and
# related GNU applications, the flags must be using the gcc syntax.
# This file does the conversion

use ExtUtils::Embed;
use warnings;
use strict;

sub kcccopts {
  my $cflags = ccopts();

  if ($^O eq 'MSWin32') {
    $cflags =~ s/-[^DI][a-zA-Z0-9_=]*//g;
    $cflags =~ s/-I"([^"]+)"/-I$1/g;
    $cflags =~ s#\\#/#g;
  }

  print $cflags;
}


sub kcldopts {
  my $ldflags = ldopts();

  if ($^O eq 'MSWin32') {
    $ldflags =~ /-libpath:"([^"]+)"/;
    my $libincdir = $1;

    $ldflags =~ / ([A-Za-z0-9_\\:.]+)\b/;
    my $libfile = $1;

    my $winldflags = "-L$libincdir $libfile";
    $winldflags =~ s#\\#/#g;

    print $winldflags;
  } else {
    print $ldflags;
  }
}


if ($ARGV[0] eq 'ccopts') {
  kcccopts();
} elsif ($ARGV[0] eq 'ldopts') {
  kcldopts();
}
