/* dialog stuff copied from gnotepad+/src/dialog.c
 */

#include "dialog.h"

typedef struct dlg_data {
        GtkWidget *     dlg;    /* top level dialog widget */
        GtkWidget **    wgts;   /* widgets for dialog buttons */
        short           num;    /* number of buttons */
        short           id;     /* id of button pushed, starts at 1. -1 error */
        GtkSignalFunc **cbs;    /* array of callbacks for button widgets */
        void **         cbd;    /* array of callback data */
} dlg_data_t;


/*** local function definitions ***/
/*
 * PRIVATE: def_cb
 *
 * callback for all button widgets used in do_dialog().  upon invocation,
 * the callback data contains an array of the widget pointers created in
 * do_dialog().  this array is scanned and if a match is found, the id num
 * in the callback data is set, the top-level dialog widget is destroyed,
 * and the dialog widget is set to NULL.  setting the dialog widget to NULL
 * will cause the while loop in do_dialog() to exit.
 */
static void
def_cb(GtkWidget *wgt, gpointer cbdata)
{
	short i;
	dlg_data_t *data = (dlg_data_t *)cbdata;

	g_assert(data != NULL);
	g_assert(data->num > 0);
	g_assert(data->wgts != NULL);
	g_assert(data->id == -1);

	for (i = 0; i < data->num; i++) {
		if (data->wgts[i] == wgt) {
			data->id = i;
			break;
		}
	}

	gtk_widget_destroy(data->dlg);
	data->dlg = NULL;	/* this exits the while loop in do_dialog() */
} /* def_cb */

/*
 * PUBLIC: do_dialog()
 *
 * generic routine to create a dialog box.
 *
 * PARAMETERS:
 *     title   - title of dialog box.  if NULL, default is "Dialog Title"
 *     msg     - message to user.  if NULL, default is "Hello world!"
 *     num     - number of buttons.
 *     buttons - array of button text.  e.g., { "Yes", "No", "Cancel" }
 *               use GE_BUTTON_OK (et al) for both Gnome and non-Gnome.
 *               see dialog.h for definitions.
 *     dflt    - default button number, starting at 1.  -1 for no default.
 *     cbs     - array of callback functions.  if cbs is NULL, then the
 *               default callback function will be used.
 *     cbd     - array of callback data.  if cbd is NULL, then the default
 *               callback data (dlgdata) is used.
 *     block   - blocking or not.  if blocking, do_dialog() does not return
 *               control back to the caller until the user has pushed one of
 *               the buttons (thus causing the dialog box to be destroyed).
 *               for now, this is always blocking.
 *
 * RETURN VALUES:
 *     blocking: number of button which was pushed by user, starting at 1.
 *     non-blocking: always returns success unless error.
 *     -1 if error.
 */
int
do_dialog(char *title, char *msg, short num, char **buttons, short dflt,
	GtkSignalFunc **cbs, void **cbd, bool_t block)
{
  /* standard dialog centre-justifies by default */
  return do_dialog_justify( title, msg, GTK_JUSTIFY_CENTER, num, buttons, 
			    dflt, cbs, cbd, block );
}



/* Same as do_dialog, but includes a GtkJustification argument (otherwise
   the dialog text is centred by default) */
int
do_dialog_justify(char *title, char *msg, GtkJustification jtype, short num, 
	  char **buttons, short dflt, GtkSignalFunc **cbs, void **cbd, bool_t block)
{
	GtkWidget *tmp;
	GtkWidget **wgts;	/* array to hold all the button widgets */
	GtkWidget *dlg;		/* top level dialog widget */
	dlg_data_t *dlgdata;	/* dialog callback data */
	GtkSignalFunc *cbfunc;	/* callback func */
	char *cbdata;
	short i, ret;

	/* for now, it's always blocking */
	g_assert(block == TRUE);

	if (num < 1 || buttons == NULL)
		return -1;

	dlg = gtk_dialog_new();

	gtk_window_set_position(GTK_WINDOW(dlg), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(dlg), (title) ? title : "Dialog Title");
	gtk_widget_set_name(dlg, "gnp+");
	gtk_window_set_wmclass(GTK_WINDOW(dlg), "gnp+", "gnp+");
	gtk_window_set_policy(GTK_WINDOW(dlg), TRUE, TRUE, FALSE);

	tmp = gtk_label_new((msg) ? msg : ((title) ? title : "Hello world!"));
	gtk_label_set_justify( GTK_LABEL(tmp), jtype );
	gtk_box_pack_start(
		GTK_BOX(GTK_DIALOG(dlg)->vbox), tmp, TRUE, FALSE, 10);
	gtk_widget_show(tmp);

	wgts = g_new(GtkWidget *, num);
	dlgdata = g_new0(dlg_data_t, 1);
	dlgdata->dlg = dlg;
	dlgdata->wgts = g_new0(GtkWidget *, num);
	dlgdata->num = num;
	dlgdata->id = -1;
	dlgdata->cbs = cbs;
	dlgdata->cbd = cbd;

	for (i = 0; i < num; i++) {
		tmp = gtk_button_new_with_label(buttons[i]);
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dlg)->action_area),
			tmp, TRUE, TRUE, 2);

		dlgdata->wgts[i] = tmp;

		cbfunc = (cbs && cbs[i]) ? cbs[i] : (GtkSignalFunc *)def_cb;
		cbdata = (cbd && cbd[i]) ? (char *)(cbd[i]) : (char *)dlgdata;
		(void)gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
					 GTK_SIGNAL_FUNC(cbfunc), cbdata);
		if (cbfunc != (GtkSignalFunc *)def_cb) {
			(void)gtk_signal_connect(GTK_OBJECT(tmp), "clicked",
						 GTK_SIGNAL_FUNC(def_cb),
						 dlgdata);
		}

		gtk_widget_show(tmp);

		if (dflt == i + 1) {
			GTK_WIDGET_SET_FLAGS(tmp, GTK_CAN_DEFAULT);
			gtk_widget_grab_default(tmp);
		}
	}

	gtk_widget_show(dlg);
	gtk_grab_add(dlg);

	if (block) {
		/* loop around doing nothing until dialog widget is gone */
		while (dlgdata->dlg != NULL)
			gtk_main_iteration_do(TRUE);

		ret = dlgdata->id + 1;
		g_free(dlgdata->wgts);
		g_free(dlgdata);
		g_free(wgts);
		return ret;
	}

	return 0;	/* non-blocking always returns success */
} /* do_dialog */
