#
# Abstract base class for configuration widgets.
#
class ConfigWidget:

    def __init__(self, attrs, getter, setter):

        self.__getter = getter
        self.__setter = setter
        self.__bind = attrs.get("bind", "")


    def _get_config(self): return self.__getter(self.__bind)
    def _set_config(self, v): self.__setter(self.__bind, v)

    def get_widgets(self): raise NotImplementedError
