from ConfigWidget import ConfigWidget

import gtk
import gnome.ui

class ConfigFont(ConfigWidget):

    def __init__(self, attrs, getter, setter):

        ConfigWidget.__init__(self, attrs, getter, setter)
        label = attrs.get("label", "")

        lbl = gtk.Label(label)
        lbl.show()
        align = gtk.Alignment(0.0, 0.0, 0.0, 0.0)
        align.show()
        align.add(lbl)

        btn = gnome.ui.FontPicker()
        btn.fi_set_use_font_in_label(True, 12)
        btn.set_mode(gnome.ui.FONT_PICKER_MODE_FONT_INFO)
        btn.show()
        btn.connect("font-set", self.__on_change)

        font = self._get_config()
        btn.set_font_name(font)

        self.__widgets = (align, btn)


    def get_widgets(self): return self.__widgets


    def __on_change(self, src, arg):

        value = src.get_font_name()
        self._set_config("\"" + value + "\"")
