from ConfigWidget import ConfigWidget

import gtk

class ConfigBoolean(ConfigWidget):

    def __init__(self, attrs, getter, setter):

        ConfigWidget.__init__(self, attrs, getter, setter)
        label = attrs.get("label", "")

        check = gtk.CheckButton(label)
        check.show()

        #self.__tooltips.set_tip(check, help)

        value = self._get_config()
        check.set_active(value)
        check.connect("toggled", self.__on_change)

        self.__widgets = (check,)


    def get_widgets(self): return self.__widgets


    def __on_change(self, src):

        value = src.get_active()
        self._set_config(value)
