import time
import calendar



#
# Class for encapsulating date objects.
#
class Date:

    UNSET = -1


    def __init__(self, year, month, day, hours = -1, mins = -1, secs = -1,
                 is_utc = 0):

        self.__year = year
        self.__month = month
        self.__day = day
        self.__hours = hours
        self.__mins = mins
        self.__secs = secs

        if (is_utc): self.__utc_to_localtime()



    def __cmp__(self, other):

        return cmp(self.get_day(), other.get_day())



    def __repr__(self):

        return str(self.get_day()) + str(self.get_daytime())



    def __hash__(self):

        return hash(repr(self))



    #
    # Converts this UTC date to local time.
    #
    def __utc_to_localtime(self):

        secs = calendar.timegm(self._to_time())
        localtime = time.localtime(secs)
        localsecs = calendar.timegm(localtime)
        diff = int(localsecs - secs)

        self.add_time(0, 0, 0, 0, 0, diff)
        


    def copy(self):

        clone = Date(self.__year, self.__month, self.__day,
                     self.__hours, self.__mins, self.__secs)
        return clone



    def get_day(self): return (self.__year, self.__month, self.__day)

    def get_daytime(self): return (self.__hours, self.__mins, self.__secs)

    def has_daytime(self): return (self.__hours != self.UNSET)


    def _to_time(self):

        year = self.__year
        month = self.__month
        day = self.__day
        h = self.__hours
        m = self.__mins
        s = self.__secs

        if (h != self.UNSET):
            value = time.strptime("%(year)d %(month)d %(day)d "
                                  "%(h)d %(m)d %(s)d" % vars(),
                                  "%Y %m %d %H %M %S")
        else:
            value = time.strptime("%(year)d %(month)d %(day)d" % vars(),
                                  "%Y %m %d")
            
        return value



    #
    # Adds a given amount of time to the given date. Amounts may be negative.
    #
    def add_time(self, dyear, dmonth, dday, dhour = 0, dmin = 0, dsec = 0):

        current_time = self._to_time()
        year = current_time[0]
        month = current_time[1]
        day = current_time[2]
        julian_day = current_time[7]

        if (calendar.isleap(year)): ndays = 366
        else: ndays = 365


        julian_day += dday
        while (julian_day > ndays):
            julian_day -= ndays
            year += 1
        while (julian_day < 1):
            julian_day += ndays
            year -= 1

        month += dmonth
        while (month > 12):
            month -= 12
            year += 1
        while (month < 1):
            month += 12
            year -= 1

        year += dyear
    

        if (dday):
            t = time.strptime("%(year)d %(julian_day)d" % vars(),
                                "%Y %j")
        elif (dyear):
            t = time.strptime("%(year)d %(month)d %(day)d" % vars(),
                                "%Y %m %d")
        
        else:
            t = time.strptime("%(year)d %(month)d %(day)d" % vars(),
                                "%Y %m %d")
            #t = time.strptime("%(year)d %(month)d %(julian_day)d" % vars(),
            #                    "%Y %m %j")

        self.__year = t[0]
        self.__month = t[1]
        self.__day = t[2]

        if (dhour or dmin or dsec): self.__add_daytime(dhour, dmin, dsec)



    def __add_daytime(self, dhour, dmin, dsec):

        ch, cm, cs = self.get_daytime()
        ch += dhour
        cm += dmin
        cs += dsec

        while (cs >= 60):
            cs -= 60
            cm += 1
        while (cs < 0):
            cs += 60
            cm -= 1

        while (cm >= 60):
            cm -= 60
            ch += 1
        while (cm < 0):
            cm += 60
            ch -= 1

        while (ch >= 24):
            ch -= 24
            self.add_time(0, 0, 1)
        while (ch < 0):
            ch += 24
            self.add_time(0, 0, -1)

        self.__hours = ch
        self.__mins = cm
        self.__secs = cs



    #
    # Returns the time interval to another date in seconds.
    #
    def get_interval(self, other):

        t1 = self._to_time()
        t2 = other._to_time()

        diff = time.mktime(t2) - time.mktime(t1)

        return int(diff)
