'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) radiobox.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS radiobox iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
radiobox \- Create and manipulate a radiobox widget
.SH SYNOPSIS
\fBradiobox\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- labeledframe <- radiobox
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBborderWidth\fR	\fBcursor\fR	\fBdisabledForeground\fR
\fBforeground\fR	\fBrelief\fR	\fBselectColor\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBlabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR	\fBlabelMargin\fR
\fBlabelPos\fR	\fBlabelText\fR	\fBlabelVariable\fR
.fi
.LP
See the "labeledframe" class manual entry for details on the 
inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:   \fBcommand\fR
Class:  \fBCommand\fR
Command-Line Switch:    \fB-command\fR
.fi
.IP
Specifies a Tcl command procedure to be evaluated following a change in 
the current radio box selection.
.LP
.nf
Name:   \fBorient\fR
Class:  \fBOrient\fR
Command-Line Switch:    \fB-orient\fR
Default Value:	\fBvertical\fR
.fi
.IP
Specifies the orientation of the radiobuttons within the radiobox.  Valid
values are either "horizontal" or "vertical".
.LP
.BE

.SH DESCRIPTION
.PP
The \fBradiobox\fR command creates a radio button box widget 
capable of adding, inserting, deleting, selecting, and configuring 
radiobuttons as well as obtaining the currently selected button.

.SH "METHODS"
.PP
The \fBradiobox\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  
.PP
Many of the widget commands for the \fBradiobox\fR take as one argument an
indicator of which radiobutton of the radiobox to operate on.  These indicators
are called \fIindexes\fR and allow reference and manipulation of radiobuttons.
Radiobox indexes may be specified in any of the following forms:
.TP 12
\fInumber\fR
Specifies the radiobutton numerically, where 0 corresponds to the top 
radiobutton of the radiobox.
.TP 12
\fBend\fR
Indicates the last radiobutton of the radiobox.
.TP 12
\fIpattern\fR
If the index doesn't satisfy one of the above forms then this
form is used.  \fIPattern\fR is pattern-matched against the tag of
each radiobutton in the radiobox, in order from top to bottom,
until a matching entry is found.  The rules of \fBTcl_StringMatch\fR
are used.

.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBadd\fR \fItag\fR ?\fIoption value option value\fR?
Adds a new radiobutton to the radiobuttond window on the bottom.  The command
takes additional options which are passed on to the radiobutton as construction
arguments.  These include the standard Tk radiobutton options.  The tag is
returned.
.TP
\fIpathName \fBbuttonconfigure\fR \fIindex\fR ?\fIoptions\fR?
This command is similar to the \fBconfigure\fR command, except that
it applies to the options for an individual radiobutton, 
whereas \fBconfigure\fRapplies to the options for the radiobox as a whole.
\fIOptions\fR may have any of the values accepted by the \fBadd\fR
widget command.  If \fIoptions\fR are specified, options are modified
as indicated in the command and the command returns an empty string.
If no \fIoptions\fR are specified, returns a list describing
the current options for entry \fIindex\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBradiobox\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBradiobox\fR
command.
.TP
\fIpathName \fBdelete\fR \fIindex\fR
Deletes a specified radiobutton given an \fIindex\fR.
.TP
\fIpathName \fBdeselect\fR \fIindex\fR
Deselects a specified radiobutton given an \fIindex\fR.
.TP
\fIpathName \fBflash\fR \fIindex\fR
Flashes a specified radiobutton given an \fIindex\fR.
.TP
\fIpathName \fBget\fR
Returns the tag of the currently selected radiobutton.
.TP
\fIpathName \fBindex\fR \fIindex\fR
Returns the numerical index corresponding to index.
.TP
\fIpathName \fBinsert \fIindex\fR \fItag\fR ?\fIoption value option value ...\fR?
Same as the \fBadd\fR command except that it inserts the new
radiobutton just before the one given by \fIindex\fR, instead of appending
to the end of the radiobox.  The \fIoption\fR, and \fIvalue\fR
arguments have the same interpretation as for the \fBadd\fR widget
command.  
.TP
\fIpathName \fBselect\fR \fIindex\fR
Selects a specified radiobutton given an \fIindex\fR.

.SH EXAMPLE
.DS
 radiobox .rb -labeltext Fonts
 .rb add times -text Times
 .rb add helvetica -text Helvetica
 .rb add courier -text Courier
 .rb add symbol -text Symbol
 .rb select courier

 pack .rb -padx 10 -pady 10 -fill both -expand yes
.DE

.SH AUTHOR
Michael J. McLennan
.DE
Mark L. Ulferts
.SH KEYWORDS
radiobox, widget
