 class FitsFile {
     constructor {args} {}
     destructor {} 
     
     public method openf {} 
     public method closef {}
     public method save {}
     public method saveAs { {saveFileName ""} }
     public method saveHDUsAs {}
     public method revertFile {}
     public method writeHisKey {}
     public method getBackup {}
     public method getTabInfo {name}
     public method getColInfo {colName} 
     public method getExprInfo {expr}
     public method getImgInfo {} 
     public method getcolblock {col rowrange} 
     public method getKeywords {keywords} 
     public method getNumHdus {} 
     public method dumpHeader {} 
     public method isOpen {} 
     public method isReadOnly {}
     public method closeCmd { {force 0} } 
     public method fileHighLight {} 
     public method cleanChild {}
     public method updateHighLight {extNum field value}
     public method sort {column ascendFlag isMerge}
     public method getWcs {{RAColNum {}} {DecColNum {}}}
     public method getColMinMax {colname felem rowrange} 
     public method getColStat {colname felem rowrange} 
     public method getColNum {colname}
     public method getTLMinMax {colname}
     public method makeHistogram {args}
     public method plotHisto {}
     public method addChild { child extNum }
     public method freeChild { extNum }
     public method countChanged {}
     public method getMaster {}

     public method plotData       { extNum {xyNames {}} }
     public method openHeader     { extNum }
     public method openTable      { extNum {coor {}} {newTable {}} }
     public method openExtension  { extNum }
     public method closeExtension { extNum }

     private variable loaded
     private variable graph
     private variable fhl
     private variable mBar
     private variable subwin
     private variable myChildren
     private variable myExtNums 
     
     private common smoothID
     public variable xwin
     public variable ywin 
     public variable dosmooth 

#public member
    public variable opened
    public variable filename
    public variable openedFileName

    public variable chdu
    public variable isMaster 0
    public variable isFailedToCopy 0 
    public variable fitsfile
    public variable filePermission ""

    public method move {extension} 
    public method getNthKey {n}
    public method copyCHDU {saveName}
    public method insertKey {n rec fflag}
    public method putNthKey {n rec fflag}
    public method putHis {rec} 
    public method delNthKey {n}
    public method flush {isClear} 
    public method loadColumn {col null i}
    public method loadExpr {expr null {rows "-"}}
    public method loadImage {}
    public method loadImageBlock {fRow nRow fCol nCol slice}
    public method loadImageSlice {i r}
    public method freeColumn {add} 
    public method freeExpr {add}
    public method freeImage  {add}
    public method freeVTable {add}
    public method loadTBlock {var cList fRow nRows fCol nCols i} 
    public method delRows {n0 nn} 
    public method delRowsWithCondition {cond} 
    public method delCols {colList}
    public method addColumn {name form}
    public method addColumnFrExpr {name form expr}
    public method addRow {nRows}
    public method putImage {fElem fRow value}
    public method putTable {name felem range value}
    public method putKwd {rec fflag} 
    public method saveTabToASCII {$name n fRow nRows fCol colList width} 
    public method saveImgToASCII {$name n fRow nRows fCol nCols width}
    public method saveImgSliceToASCII {$name n fRow nRows fCol nCols width slice} 
    public method getKeyword {keyword} 
    public method insertCol {index ttype tform}
    public method insertRow {index nRows}
    public method getOrigName {}
    public method changeFile {}
    public method unchangeFile {}
    public method isFileChanged {}
    public method loadImageMeanCols {fCol lCol slice} 
    public method loadImageMeanRows {fRow lRow slice} 
    public method updateChecksum { {forceUpdate 0} }
    public method verifyChecksum {}
	 

     # private member
     private variable fileMode
     private variable isChanged 0
     private variable numExts
     private variable isFtp 0
     private variable isHttp 0
     private variable origFileObj ""
     private variable ftp_user
     private variable ftp_pass
     private variable ftp_file

     private method ftpFile {fname saveAs}
     private method fetchFile {}
     private method deleteHDUs {} 
     private method copyHDUs {}
     private method pasteHDUs {} 
     private method drawHighLight {} 
     private method drawContent {}
     private method redrawHighLight {} 
     private method writeHDUsToClipBoard {ifDelete}
     private method isHDUSelected {} 
     private method isImgSelected {} 
     private method isTblSelected {} 
     private method appendNewHDU {}
     private method postMenus {}
     private method smoothImgs {}
     private method smoothOK {} 
     private method plotHDUs {}
     
     private variable extData
     private variable extCheck
     private variable openExtraTable 0
     private method setNewTable { flag }
}


body FitsFile::constructor {args} {
    global listObjs
    global isWin

    set fitsfile ""
    set opened 0

    set filename [lindex $args 0]
    set fileMode [lindex $args 1]

    # Build full path to filename
    set rName [urlTail $filename]
    set dName [getFullDirPath $filename]
    set filename "${dName}${rName}"

    if { $isWin } {
	# Must change all \'s to /'s to avoid problems with escape chars
	regsub -all "\\\\" $filename "/" filename
    }

    if { [llength $args]==3 } {
       # This indicates we want to work with a backup of the original file
       set origFileObj [lindex $args 2]
       set openedFileName [$origFileObj getBackup]
       openf
    } else {
       fetchFile
       lappend listObjs $this
       set myChildren {}
       set myExtNums {}
       set isMaster 1
       fileHighLight
       update idletasks
	    
       if { $fvPref::ifAutoPlotPrimary } {
          openf
          move 1
          set dims [getImgInfo]
          closef
          if { [llength $dims]==2 } {
             plotData 1
          }
       }
    }

}

body FitsFile::destructor {} {
   global listObjs
   global backupDir
   
   if { $isMaster } {
      set pos [lsearch $listObjs $this]
      if { $pos !=-1 } {
	 set listObjs [lreplace $listObjs $pos $pos]
      }
      
      # Get location of this file in the native format, so that we can
      # do a valid string comparison
      
      set nativeBackupDir [file nativename $backupDir]
      set nativeOpenedDir [file nativename [file dir $openedFileName]]
      
      if { $nativeOpenedDir == $nativeBackupDir } {
	 # File viewed/editted or FTP/HTTP file copied
	 file delete $openedFileName
      }
      destroy $fhl
   } else {
      # This is an extension file handler... close and exit
      if { $isChanged } {
	 writeHisKey
	 updateChecksum
      }
      if { [catch {closef} err] } {
	 puts $err
      }
   }
}

body FitsFile::fetchFile {} {
   global backupDir
   global isWin isMac

   #####
   # Copy FTP and HTTP files to backup directory for accessing
   #####

   if { [string range $filename 0 5] == "ftp://" } {

      #    Handle FTP files

      set isFtp 1

      # Make copy and check that the name is unique
      set cnt 0
      set endName [urlTail $filename]
      set openedFileName [file join ${backupDir} $endName]
      while { [file exists $openedFileName] } {
	 incr cnt
	 set openedFileName [file join $backupDir f${cnt}_$endName]
      }
      
      # Copy ftp file using RemoteClass ftp method, rather than
      # leave it to CFITSIO, which doesn't have drivers for Windows
      
      ftpFile $filename $openedFileName
      
   } elseif { [string range $filename 0 6] == "http://" } {
      
      #    Handle HTTP files

      set isHttp 1

      # Make copy, but check that the name is unique
      set cnt 0
      set endName [urlTail $filename]
      set openedFileName [file join ${backupDir} $endName]
      while { [file exists $openedFileName] } {
	 incr cnt
	 set openedFileName [file join ${backupDir} h${cnt}_$endName]
      }
	 
      set tmpFileName ${filename}\($openedFileName\)
      set f [fits open $tmpFileName]
      $f close
	 
   } else {
      set openedFileName $filename
   }

   if { $isWin } {
      set filePermission [file attributes $openedFileName -system]
   } elseif { $isMac } {
       set filePermissions ""
   } else {
      set filePermission [file attributes $openedFileName -permissions]
   }
}

body FitsFile::ftpFile { fname saveAs } {
   global backupDir

   set ftpC ftp_[namespace tail $this]
   RemoteClass $ftpC

#  Decode this file syntax: "ftp://userName:passwd@host/path/file.fits"

   set fname [string range $fname 6 end]
   set idx [string first "/" $fname]
   if { $idx == -1 || [string range $fname end end]=="/" } {
      # Not pointing to a file... error out
      error "File name points to a host or directory, not a file"
   }
   set path [string range $fname $idx end]
   incr idx -1
   set loginInfo [string range $fname 0 $idx]
   set idx [string last "/" $path]
   set file [string range $path [expr $idx+1] end]
   set path [string range "$path" 1 [expr $idx-1]]

   set idx [string last "@" $loginInfo]
   if { $idx==-1 } {
      set host $loginInfo
      set user anonymous
      set pass "fv@fv.gsfc.nasa.gov"
   } else {
      set host [string range $loginInfo [expr $idx+1] end]
      set user [string range $loginInfo 0 [expr $idx-1]]
      set idx [string first ":" $user]
      if { $idx==-1 } {
	 set pass "fv@fv.gsfc.nasa.gov"
      } else {
	 set pass [string range $user [expr $idx+1] end]
	 set user [string range $user 0 [expr $idx-1]]
      }
   }

   $ftpC openConn $host $user $pass
   $ftpC cd $path
   if { ![$ftpC get ${file} $saveAs] } {
      delete object $ftpC
      error "Unable to copy $file to local disk"
   }
   delete object $ftpC

   # save FTP information for later

   set ftp_user $user
   set ftp_pass $pass
   if { $path == "" } {
      set ftp_file "${host}/${file}"
   } else {
      set ftp_file "${host}/${path}/${file}"
   }
   if { $user == "anonymous" } {
      set filename "ftp://${ftp_file}"
   } else {
      set filename "ftp://${user}@${ftp_file}"
   }
}

body FitsFile::openf {} {
   global backupDir

   if { $isMaster || $isFailedToCopy } {
      # Read ONLY
      set rw 0
   } else {
      set rw 1
   }
   if { [catch {set fitsfile [fits open $openedFileName $rw]}] } {
      error "Cannot open file"
   } 
   set opened 1
   return $fitsfile
}

body FitsFile::getBackup {} {
   global backupDir
   global isWin isMac

   # Get location of this file in the native format, so that we can
   # do a valid string comparison... do not create backup if opened
   # file is already in the backup directory... eg, histogram
      
   set nativeBackupDir [file nativename $backupDir]
   set nativeOpenedDir [file nativename [file dir $openedFileName]]

   if { $openedFileName == $filename && !$isFtp && !$isHttp \
	 && $nativeOpenedDir != $nativeBackupDir } {
      
      set root [file rootname [urlTail $filename]]
      set ext  [file extension $filename]
   
      # make the filename "." and ":" free for Win32
      regsub -all ":|\\." $root "_" tmpFileName
      
      # Make sure the name is unique
      set cnt 0
      set backupfilename [file join ${backupDir} ${tmpFileName}$ext]
      while { [file exists $backupfilename] } {
	 incr cnt
	 set backupfilename [file join ${backupDir} b${cnt}_${tmpFileName}$ext]
      }
      
      # Try to make a copy in the backupDir
      
      # If a compressed file, use CFITSIO to copy/uncompress
      if { [isFits $filename]==2 } {
         set fName "${filename}(${backupfilename})"
         set errFlag [catch {set f [fits open $fName 0]} err]
         if { !$errFlag } {$f close}
      } else {
         set errFlag [catch {file copy $filename $backupfilename} err]
      }

      if { $errFlag } {
         set fileMode 1
         set isFailedToCopy 1
         puts "Error: $err"
	 puts "Cannot make backup, please set FVTMP to some place"
	 puts "which has bigger disk space. Open as readonly this time."
      } else {
	 # chmod to 666 for read and write
	 if { $isWin || $isMac } {
	    file attributes $backupfilename -readonly 0
	 } else {
	    file attributes $backupfilename -permissions 00666
	 }
	 set openedFileName $backupfilename
      }
   }
   return $openedFileName
}

body FitsFile::closef {} {

    if { [catch {eval $fitsfile close} error] == 1 } {
	error  $error
    }
    set opened 0
    set loaded 0
}

body FitsFile::countChanged {} {
   # Count number of extensions changed

   set nChanged 0
   foreach child $myChildren {
      set childFObj ::FitsExtension::[$child cget -fFObj]
      if { [$childFObj isFileChanged] } {
         incr nChanged
      }
   }
   return $nChanged
}

body FitsFile::save {} {
   global isWin isMac

   if { ![isFileChanged] } return

   if { $origFileObj != "" } {

      set nChanged [$origFileObj countChanged]
      if { $nChanged > 1 } {
	 set feedback [promptMsg "WARNING: This will save changes made\
	       to multiple extensions.  Continue?" \
	       return Yes No]
	 if { $feedback == "CANCEL" } return
      }
      $origFileObj save
      return
   }

   # Update/flush each subordinate FITS file still opened

   foreach child $myChildren {
      set childFObj ::FitsExtension::[$child cget -fFObj]
      if { [$childFObj isFileChanged] } {
	 $childFObj writeHisKey
	 $childFObj updateChecksum
	 $childFObj flush noClear 
	 $child updateDisps ""
      }
   }

   # Try to make a backup

   if { [catch {file copy -force $filename $filename~} err] } {
      puts "Warning: cannot make a backup of the original file:\n $err"
   } 

   # Copy file

   if { [catch {file copy -force $openedFileName $filename} err ] } {
      error $err
      return
   }

   unchangeFile
   # copy permissions of original
   if { $isWin } {
      file attributes $filename -system $filePermission
   } elseif { $isMac } {
       # Make file fvEd/FITS type
       file attributes $filename -creator "fvEd" -type "FITS"
   } else {
      file attributes $filename -permissions $filePermission
   }
   redrawHighLight
}

body FitsFile::saveAs { {saveFileName ""} } {
   global isWin isMac

   # This function should be called only from the Master FitsFile
   # PDW 2000/11/16: SaveAs does exist in Mac File menu, so this
   #                 needs to work there, too, so pass it to origFileObj
   if { $origFileObj != "" } {
      $origFileObj saveAs $saveFileName
      return
   }

   if { $saveFileName == "" } {
      set t [urlTail $filename]
      set r [file root $t]
      set e [file ext $t]
      if { [lsearch -exact [list .gz .Z .z] $e]!=-1 } {
         set e [file ext $r]
         set r [file root $r]
      }
      set sugName "${r}_2${e}"
      set saveFileName [getSelectedFileName $sugName]
      if { $saveFileName == "" } return
      if { [file exist $saveFileName] } {
         set feedback [promptMsg "File $saveFileName exists\n overwrite?" \
               return Yes No]
         if { $feedback == "CANCEL" } return
      }
   }

   # Update/flush each subordinate FITS file still opened

   foreach child $myChildren {
      set childFObj ::FitsExtension::[$child cget -fFObj]
      if { [$childFObj isFileChanged] } {
         $childFObj writeHisKey
         $childFObj updateChecksum
         $childFObj flush noClear 
      }
   }

   file copy -force $openedFileName $saveFileName

   unchangeFile
   # copy permissions of original, but make read/write
   if { $isWin } {
      file attributes $saveFileName -system $filePermission
      file attributes $saveFileName -readonly 0
      set filePermission [file attributes $saveFileName -system]
   } elseif { $isMac } {
       # Make file fvEd/FITS type
       file attributes $saveFileName -creator "fvEd" -type "FITS"
   } else {
      set filePermission "006[string range $filePermission 3 end]"
      file attributes $saveFileName -permissions $filePermission
   }
   set filename $saveFileName
   .fvwinkeeper signoff  $fhl
   .fvwinkeeper register $fhl "Highlight" [urlTail $filename] 0 $this
   set fileMode 0
   foreach child $myChildren {
      $child setFileName $filename
   }
   redrawHighLight
}


body FitsFile::saveHDUsAs {} {
   global isWin isMac

   if { ![isHDUSelected] } {
      error "Please select HDU first"
      return
   }

   set t [urlTail $filename]
   set r [file root $t]
   set e [file ext $t]
   if { [lsearch -exact [list .gz .Z .z] $e]!=-1 } {
      set e [file ext $r]
      set r [file root $r]
   }
   set sugName "${r}_hdu${e}"
   set saveFileName [getSelectedFileName $sugName]
   if { $saveFileName=="" } return
   if { [file exist $saveFileName] } {
      set feedback [promptMsg "File $saveFileName exists\n overwrite?" \
                              return Yes No]
      if { $feedback == "CANCEL" } return
   }

   file delete $saveFileName
   set tmpfits [fits open $saveFileName 2 tmpfits]
   $tmpfits put ihd -p 
   $tmpfits close
   
   set tmpfitsfile [fits open $openedFileName 0]

   set nhdus [$tmpfitsfile info nhdu]
   for {set i $nhdus} {$i > 0} {incr i -1} {
      if { $extCheck($i) } {
	 $tmpfitsfile move $i
	 $tmpfitsfile append $saveFileName
      }
      set extCheck($i) 0
   }
   
   $tmpfitsfile close
   
   # copy permissions of original but make writeable
   if { $isWin } {
      file attributes $saveFileName -system $filePermission
      file attributes $saveFileName -readonly 0
      set filePermission [file attributes $saveFileName -system]
   } elseif { $isMac } {
       # Make file fvEd/FITS type
       file attributes $saveFileName -creator "fvEd" -type "FITS"
   } else {
      set filePermission "006[string range $filePermission 3 end]"
      file attributes $saveFileName -permissions $filePermission
   }
}


body FitsFile::flush {isClear} {
    if { $isClear == "clear"} {
	$fitsfile flush clear
    } else {
	$fitsfile flush
    }
}

body FitsFile::revertFile {} {

   if { ![isFileChanged] } return

   set feedback [promptMsg \
	 "All changes since last save will be lost.  Continue?" \
	 return Yes No]
   if {$feedback == "CANCEL"} return

   cleanChild

   if { $filename != $openedFileName } {
      file delete $openedFileName
   }
   if { $isFtp } {
      # Must reconstruct original filename
      set filename "ftp://${ftp_user}:${ftp_pass}@${ftp_file}"
   }
   fetchFile
   unchangeFile
   redrawHighLight
}

body FitsFile::writeHisKey {} {
   global env
   global isWin

# write the HISTORY keyword
   if { $fvPref::ifWriteHisKey == 1 && [isFileChanged] && $origFileObj != "" } {
      set date [clock format [clock seconds] \
	    -format %Y-%m-%dT%H:%M:%S] 
      
      # Search through the various environment variables for a user name
      if { [info exists env(USER)] } {
	 set uname $env(USER)
      } elseif { [info exists env(USERNAME)] } {
	 set uname $env(USERNAME)
      } elseif { [info exists env(LOGNAME)] } {
	 set uname $env(LOGNAME)
      } else {
	 set uname "???"
      }

      putHis "File modified by user \'$uname\' with fv  on $date" 
   }
}

body FitsFile::getNumHdus {} {
    isOpen
    return [$fitsfile info nhdu]
}

body FitsFile::getTabInfo {name} {
    return [$fitsfile info $name]
}


body FitsFile::getColInfo {colName} {
    return [$fitsfile info column -exact $colName]
}

body FitsFile::getExprInfo {expr} {
    return [$fitsfile info expr $expr]
}

body FitsFile::getImgInfo {} {
    return [$fitsfile info imgdim]
}


body FitsFile::move {extension} {
    # move to extension

    isOpen
    if { [catch {$fitsfile move $extension} ] == 1 } {
	error "Cannot move to extension $extension. Does the file still exist?"
	return
    } else {
	set chdu $extension
    }
    
}

body FitsFile::getcolblock {col rowrange} {
    isOpen
    if { [catch {
       set x [$fitsfile get table -c -noformat $col $rowrange]
    } err] }  {
       puts "Cannot read table block of column $col: $err"
       return {}
    }
    return $x
}

body FitsFile::getKeyword {keyword} {
    # get $keyword
    isOpen
    return [$fitsfile get keyword ^$keyword\$]
}

body FitsFile::getWcs {{RAColNum {}} {DecColNum {}} } {
    isOpen

    if { $RAColNum == "" || $DecColNum == "" } {
	if { [catch {set wcs [$fitsfile get wcs -m]}] } {
	    return ""
	} else {
	    return $wcs
	}
    } else {
	set wcs [$fitsfile get wcs -m $RAColNum $DecColNum]
	return $wcs
    }
    
}

body FitsFile::getKeywords {keywords} {
    # return a list of all the values for $keywords

    set values {}

    isOpen
    set chdu [$fitsfile info chdu]
    
    set curext 0

    for {set i 1} {$i <= [llength $keywords]} {incr i} {
	set retval([lindex $keywords [expr $i-1]]) {}
    }
    
    while {1} {
	
	incr curext
	if {[catch {move $curext}]} {
	    #we're done.
	    break
	}
	
	for {set i 1} {$i <= [llength $keywords]} {incr i} {
	    set keyword [lindex $keywords [expr $i-1]]
	    if {[catch {getKeyword $keyword} result]} {
		# didn't find it
		continue
	    }
	    
	    set result [lindex [lindex $result 0] 1]
	    set result [string trim $result ']
	    set result [string trim $result]
	    
	    set retval($keyword) [concat $retval($keyword) \
				      [list $result]]
	    set values [concat $values [list $result]]
	}
    }
    move $chdu

    set values {}
    for {set i 1} {$i <= [llength $keywords]} {incr i} {
	set values [concat $values \
			[list $retval([lindex $keywords [expr $i-1]])]]
    }
    

    return $values
}

body FitsFile::dumpHeader {} {
    isOpen
    set header [$fitsfile dump -e]
    return $header	
}

body FitsFile::isOpen {} {
    if {$opened == 0} {
	error "FitsFile $this : $filename not open"
    }
}

body FitsFile::isReadOnly {} {
   if { $origFileObj=="" } {
      return $fileMode
   } else {
      return [$origFileObj isReadOnly]
   }
}

body FitsFile::closeCmd { {force 0} } {

   # Check for modifications needing saving

   if { [isFileChanged] } {
      if { $isFtp || $isHttp || [isReadOnly] } {
	 set cmd [code $this saveAs]
      } else {
	 set cmd [code $this save]
      }
      if { $force } { set cTxt "None" } else { set cTxt "Cancel" }
      set feedback [promptMsg \
	    "File $filename has changed.\n\
	    Do you want to save the file before closing?" \
	    $cmd Yes $cTxt]
      if {!$force && $feedback == "BREAK"} {
	 return 1
      }
   }

   cleanChild
   .fvwinkeeper signoff $fhl
   delete object $this
   return 0
}

body FitsFile::cleanChild {} {
   foreach i $myChildren {
      $i closeCmd
   }
}

body FitsFile::fileHighLight {} {
    # file highlight window - fhl 
    set fhl .fhl_[namespace tail $this]

    powToplevel $fhl .dummy

    drawHighLight

# report to fvwinkeeper
    .fvwinkeeper register $fhl "Highlight" [urlTail $filename] 0 $this
}

body FitsFile::drawHighLight {} {
    global isMac isWin
    
    if { $isMac } {
	set cmdkey "Cmd"
    } else {
	set cmdkey "Alt"
    }
    
    # bind $fhl <Destroy> "[code $this closeFrWm %W]"
    wm protocol $fhl WM_DELETE_WINDOW [code $this closeCmd]

    bind $fhl <<SaveFile>>    [code $this save]
    bind $fhl <<SaveFileAs>>  [code $this saveAs]
    bind $fhl <<Export>>      [code $this saveHDUsAs]
    bind $fhl <<RevertFile>>  [code $this revertFile]
    bind $fhl <<CloseWindow>> [code $this closeCmd]

    bind $fhl <<Copy>>        [code $this copyHDUs]
    bind $fhl <<Cut>>         [code $this deleteHDUs]
    bind $fhl <<Paste>>       [code $this pasteHDUs]
    bind $fhl <<Smooth>>      [code $this smoothImgs]
    bind $fhl <<PlotHDUs>>    [code $this plotHDUs]
    bind $fhl <<AppendHDU>>   [code $this appendNewHDU]
    
    bind $fhl <<PostMenus>>   [code $this postMenus]

    # Create toplevel MenuBar
    #   (Macs get one common menubar for each window type... finite number
    #    of cascade menus allowed.)

    if { $isMac } {
        set mBar .mbar.summary
        set evtWndw ""
    } else {
        set mBar $fhl.mbar
        set evtWndw $fhl
    }
    $fhl config -menu $mBar
    
    if { ![winfo exists $mBar] } {
        menu $mBar
        if { $isMac } {

            $mBar add cascade -menu $mBar.apple
            $mBar add cascade -menu $mBar.file  -label File
            $mBar add cascade -menu $mBar.edit  -label Edit
            $mBar add cascade -menu $mBar.tools  -label Tools
            $mBar add cascade -menu .mbar.wind  -label Windows
            $mBar add cascade -menu $mBar.help  -label Help
            
            # APPLE menu
            
            buildApplMenu $mBar.apple
            
        } else {

            $mBar add cascade -menu $mBar.file  -label File
            $mBar add cascade -menu $mBar.edit  -label Edit
            $mBar add cascade -menu $mBar.tools  -label Tools
            $mBar add cascade -menu $mBar.help  -label Help
            
        }

        # FILE menu

        buildFileMenu $mBar.file
        $mBar.file entryconfig "Export"   -label "Export HDUs..."
        $mBar.file entryconfig "Save As..." -state normal
        $mBar.file entryconfig "Close" -state normal

        # EDIT menu

        buildEditMenu $mBar.edit
        $mBar.edit entryconfigure "Copy"  -label "Copy HDUs"
        $mBar.edit entryconfigure "Cut"   -label "Cut HDUs"
        $mBar.edit entryconfigure "Paste" -label "Paste HDUs"
        
        $mBar.edit insert "Prefer*" command -label "New Extension..." \
            -underline 4 -accelerator "$cmdkey+E" \
            -command "doMenuEvent <<AppendHDU>>"
        $mBar.edit insert "Prefer*" separator

        # Tools menu
        buildToolsMenu $mBar.tools
        $mBar.tools entryconfigure "Smooth" -label "Smooth Image"
        $mBar.tools entryconfigure "Plot" -label "Plot"

        # HELP menu

        buildHelpMenu $mBar.help fileSummary "File Summary"
        
        # Configure the Post Commands

        if { $isMac || $isWin } {
            
            # The Mac and Windows post all menus at once, so we only need
            # to do the post on the top level
            
            $mBar configure -postcommand "doMenuEvent <<PostMenus>> $evtWndw"

        } else {
            
            # Unix has to post each individual menu

            $mBar.file configure -postcommand \
                    "doMenuEvent <<PostMenus>> $evtWndw"
            $mBar.edit configure -postcommand \
                    "doMenuEvent <<PostMenus>> $evtWndw"
            $mBar.tools configure -postcommand \
                    "doMenuEvent <<PostMenus>> $evtWndw"

        }
        
    }

    frame  $fhl.fsep   -height 3 -relief raised -borderwidth 1
    frame  $fhl.labelframe 
    
    label  $fhl.labelframe.findex   -text Index        -width 9  -justify center
    label  $fhl.labelframe.fextName -text Extension    -width 16 -justify center
    label  $fhl.labelframe.ftype    -text Type         -width 8  -justify center
    label  $fhl.labelframe.fdims    -text Dimension    -width 20 -justify center
    label  $fhl.labelframe.fbut     -text View         -width 27 -justify center
    label  $fhl.labelframe.fspace   -text ""           -width 3  -justify center

    grid config $fhl.labelframe  -column 0 -row 1 -columnspan 7 -sticky "nw"
    grid config $fhl.fsep        -column 0 -row 2 -columnspan 7 -sticky "nw"

    grid config $fhl.labelframe.findex   -column 0 -row 0 -sticky "nw"
    grid config $fhl.labelframe.fextName -column 1 -row 0 -sticky "nw"
    grid config $fhl.labelframe.ftype    -column 2 -row 0 -sticky "nw"
    grid config $fhl.labelframe.fdims    -column 3 -row 0 -sticky "nw"
    grid config $fhl.labelframe.fbut     -column 4 -row 0 -sticky "nw" -columnspan 3
    grid config $fhl.labelframe.fspace   -column 7 -row 0 -sticky "nw"

    iwidgets::scrolledframe $fhl.contentframe -relief ridge -borderwidth 2 \
	 -vscrollmode dynamic -hscrollmode none
    grid config $fhl.contentframe -column 0 -row 3 -columnspan 7 -sticky "snew"
    grid rowconfigure $fhl 3 -weight 5
    grid columnconfigure $fhl 0 -weight 5
    set subwin [$fhl.contentframe childsite]

    openf

    drawContent

    closef 
}

body FitsFile::postMenus {} {
   global isMac

   if { [isFileChanged] } {
      if { [isReadOnly] } {
	 $mBar.file entryconfigure Save -state disabled
      } else {
	 $mBar.file entryconfigure Save -state normal
      }
      $mBar.file entryconfigure Revert -state normal
   } else {
      $mBar.file entryconfigure Save -state disabled
      $mBar.file entryconfigure Revert -state disabled
   }

   if { [isHDUSelected] } {
      $mBar.file entryconfigure "Export*" -state normal
      $mBar.edit entryconfigure "Copy*" -state normal
      $mBar.edit entryconfigure "Cut*" -state normal
   } else {
      $mBar.file entryconfigure "Export*" -state disabled
      $mBar.edit entryconfigure "Copy*" -state disabled
      $mBar.edit entryconfigure "Cut*" -state disabled
   }
   
   if { [isImgSelected] } {
      $mBar.tools entryconfigure "Smooth*" -state normal
      $mBar.tools entryconfigure "Plot*" -state normal
   } else {
      $mBar.tools entryconfigure "Smooth*" -state disabled 
      if { [isTblSelected] } {
         $mBar.tools entryconfigure "Plot*" -state normal
      } else {
         $mBar.tools entryconfigure "Plot*" -state disabled 
      }
   }

   if { [lindex [fvClipBoard report] 0] == "HDUs" } {
      $mBar.edit entryconfigure "Paste*" -state normal
   } else {
      $mBar.edit entryconfigure "Paste*" -state disabled
   }
   update idle
}

body FitsFile::drawContent { } {
   global isWin isMac

   set rName [urlTail $filename]
   set dName [getFullDirPath $filename]
   wm title $fhl "fv: Summary of $rName in $dName"

   set nhdus [$this getNumHdus]
   set numExts $nhdus

   if { $isMac } {
       set btnRelief flat
   } else {
       set btnRelief raised
   }
      
   for {set i 1} {$i <= $nhdus} {incr i} {
      catch {$this move $i}
      set extData($i,dims) "0"
      if { $i == 1 } {
	 set extData($i,extName) Primary
	 set extData($i,type)    Image
	 set extData($i,chdu)    1                  
	 set dimsl [$this getImgInfo]
	 set ndims [llength $dimsl]
	 if { $ndims != 0 } {
	    set extData($i,dims) [lindex $dimsl 0] 
	    for {set k 1} { $k < $ndims } {incr k} {
	       set tmpDim [lindex $dimsl $k]
	       append extData($i,dims) " X $tmpDim" 
	    }
	 }
	 
      } else {
	 if { [catch { set extData($i,extName) \
	       [lindex [join [$this getKeyword EXTNAME]] 1] } ] } {
	    set extData($i,extName) "NoName" 
	 } else {
            set extData($i,extName) [string trim $extData($i,extName) {' }]
         }
	 set extData($i,type)    [lindex [join [$this getTabInfo hdutype]] 0]
	 set extData($i,chdu)    [$this getTabInfo chdu]
	 if { ($extData($i,type)=="Binary") || ($extData($i,type)=="ASCII") } {
	    set  extData($i,nrows) [$this getTabInfo nrows]
	    set  extData($i,ncols) [$this getTabInfo ncols]
	    set  extData($i,dims) "$extData($i,ncols) cols"
            append extData($i,dims) " X $extData($i,nrows) rows"
	    set  extData($i,colList) [$this getTabInfo column]
	 } else {
	    set  dimsl [$this getImgInfo ]
	    set  ndims [llength $dimsl ]
	    if { $ndims != 0} {
	       set extData($i,dims) [lindex $dimsl 0] 
	       for {set k 1} { $k < $ndims } {incr k} {
		  set tmpDim [lindex $dimsl $k]
		  set extData($i,dims) "$extData($i,dims) X $tmpDim" 
	       }
	    }
	 } 
      }
      
      checkbutton $subwin.index$i  -text [expr $i-1]  -width 6 \
	    -variable  [scope extCheck($i)] \
	    -selectcolor $fvPref::checkBBgColor  \
	    -activeforeground black -activebackground $fvPref::globalBgColor \
	    -justify center
      label  $subwin.extName$i -text $extData($i,extName)  -width 16 \
	    -justify center
      label  $subwin.type$i    -text $extData($i,type)     -width 8 \
	    -justify center
      label  $subwin.dims$i    -text $extData($i,dims)     -width 20 \
	    -justify center
      
      button $subwin.kwds$i -text "Header" \
            -borderwidth 2 -relief $btnRelief -width 5  \
	    -command  [code $this openHeader $extData($i,chdu)]
      button $subwin.plot$i -text "Plot" \
            -borderwidth 2 -relief $btnRelief -width 5 \
            -command  [code $this plotData $extData($i,chdu)]
      button $subwin.tab$i  -text "Table" \
            -borderwidth 2 -relief $btnRelief -width 5 \
            -command  [code $this openTable $extData($i,chdu)]

      if { ($extData($i,type)!="Binary") && ($extData($i,type)!="ASCII") } { 
         $subwin.plot$i config -text "Image"
	 # if image is empty, disable the image/table buttons
	 if { $extData($i,dims) == 0 } {
	    $subwin.plot$i configure -state disabled
	    $subwin.tab$i  configure -state disabled
	 }
      }
      bind $subwin.tab$i <3> { tkButtonDown %W }
      bind $subwin.tab$i <ButtonRelease-3> \
            "[code $this setNewTable 1]; tkButtonUp %W"
      if { $isMac } {
         bind $subwin.tab$i <Command-ButtonPress-1> { tkButtonDown %W }
         bind $subwin.tab$i <Command-ButtonRelease-1> \
               "[code $this setNewTable 1]; tkButtonUp %W"
      }

      grid config $subwin.index$i     -column 0 -row [expr $i] -sticky "snew"
      grid config $subwin.extName$i   -column 1 -row [expr $i] -sticky "snew"
      grid config $subwin.type$i      -column 2 -row [expr $i] -sticky "snew"
      grid config $subwin.dims$i      -column 3 -row [expr $i] -sticky "snew"
      grid config $subwin.kwds$i      -column 4 -row [expr $i] -sticky "snew"
      grid config $subwin.plot$i      -column 5 -row [expr $i] -sticky "snew"
      grid config $subwin.tab$i       -column 6 -row [expr $i] -sticky "snew"
   }

   set lineHeight [expr [winfo reqheight $subwin.tab1] ]
   if { $numExts <= 10} {
      $fhl.contentframe configure -height [expr 10 + $numExts*$lineHeight]
   } else {
      $fhl.contentframe configure -height [expr 10 + 10*$lineHeight]
   }

}

body FitsFile::updateHighLight {extNum field value} {
    switch $field {
	"DIMENSION" {
	    $subwin.dims$extNum configure \
		-text "[lindex $value 0] cols X [lindex $value 1] rows" 
	}
	"EXTNAME" {
	    $subwin.extName$extNum configure -text $value
	}
	default {return}
    }
}

body FitsFile::getNthKey {n} {
    isOpen
    return [$fitsfile get keyword -num $n]
}

body FitsFile::copyCHDU {saveName} {
    $fitsfile copy $saveName
} 

body FitsFile::insertKey {n rec fflag} {
    return [$fitsfile insert keyword $n $rec $fflag]
}

body FitsFile::putNthKey {n rec fflag} {
    return [$fitsfile put keyword -num $n $rec $fflag]
}

body FitsFile::putHis {rec} {
    return [$fitsfile put history $rec]
}

body FitsFile::delNthKey {n} {
    $fitsfile delete keyword $n
}

body FitsFile::loadColumn {col null i} {
    return [$fitsfile load column $col $null $i]
}

body FitsFile::loadExpr {expr null {rows "-"} } {
    return [$fitsfile load expr -rows $rows $expr $null]
}

body FitsFile::loadImage {} {
    return [$fitsfile load image]
}

body FitsFile::loadImageBlock {fRow nRow fCol nCol slice} {
    return [$fitsfile load iblock -- $fRow $nRow $fCol $nCol $slice]
}

body FitsFile::loadImageSlice {i r} {
    return [$fitsfile load image $i $r]
}

body FitsFile::freeColumn {add} {
    $fitsfile free column $add
}

body FitsFile::freeExpr {add} {
    $fitsfile free expr $add
}

body FitsFile::freeVTable {add} {
    $fitsfile free vtable $add
}

body FitsFile::loadTBlock {var cList fRow nRows fCol nCols i} {
    $fitsfile load tblock $var $cList $fRow $nRows $fCol $nCols $i 
}

body FitsFile::delRows {n0 nn} {
    $fitsfile delete rows $n0 $nn
}

body FitsFile::delRowsWithCondition {cond} {
    $fitsfile delete rows -expr $cond
}

body FitsFile::addColumn {name form} {
    $fitsfile add column $name $form
}

body FitsFile::addColumnFrExpr {name form expr} {
    $fitsfile add column $name $form $expr
}

body FitsFile::addRow {nRows} {
    $fitsfile add row $nRows
}

body FitsFile::insertCol {index ttype tform} {
    $fitsfile insert column $index $ttype $tform
}

body FitsFile::insertRow {index nRows} {
    $fitsfile insert row $index $nRows
}

body FitsFile::delCols {colList} {
    $fitsfile delete cols $colList
}

body FitsFile::putImage {fElem fRow value} {
    $fitsfile put image $fElem $fRow $value
}

body FitsFile::putTable {name felem range value}  {
    $fitsfile put table $name $felem $range $value
}

body FitsFile::putKwd {rec fflag} {
    $fitsfile put keyword $rec $fflag
}

body FitsFile::saveTabToASCII {name n fRow nRows fCol colList width} {
    $fitsfile sascii table $name $n $fRow $nRows $fCol $colList $width
}

body FitsFile::saveImgToASCII {name n fRow nRows fCol nCols width } {
    $fitsfile sascii image $name $n $fRow $nRows $fCol $nCols $width 
}

body FitsFile::saveImgSliceToASCII {name n fRow nRows fCol nCols width slice} {
    $fitsfile sascii image $name $n $fRow $nRows $fCol $nCols $width $slice
}

body FitsFile::freeImage {add} {
    $fitsfile free image $add
}

body FitsFile::sort {column ascendFlag isMerge} {
# column is a list of all the column names used in sorting 
# ascendFlag is a list of 1/0 to indicate ascending/decending 
#    sorting for each column
#  isMerge == 1, then merge all identical rows
    if { $isMerge == 1 } {
	$fitsfile sort -merge $column $ascendFlag
    } else {
	$fitsfile sort $column $ascendFlag 
    }
}

body FitsFile::getMaster {} {
   if { $origFileObj=="" } {
      return $this
   } else {
      return $origFileObj
   }
}

body FitsFile::getOrigName {} {
   if { $origFileObj=="" } {
      return $filename
   } else {
      return [$origFileObj getOrigName]
   }
}

body FitsFile::changeFile {} {
   set isChanged 1
   if { $origFileObj!="" } {
      $origFileObj changeFile
   }
}

body FitsFile::unchangeFile {} {

   set isChanged 0
   if { $origFileObj=="" } {
      foreach child $myChildren {
         set childFObj ::FitsExtension::[$child cget -fFObj]
         $childFObj unchangeFile
      }
   }
}

body FitsFile::isFileChanged {} {
   return $isChanged
}

body FitsFile::deleteHDUs {} {

    if { [isHDUSelected] != 1 } {
	error "Please select HDU first"
	return
    }

    if { $extCheck(1) } {
	tk_messageBox -message "You cannot delete the primary array\n"
	return
    }

    if { [llength $myChildren] != 0 } {
	tk_messageBox -message \
	    "There are extensions opened for this file. Please close all\
	    other fv windows related to this file before deleting HDUs."
	return
    }

# cut the HDUs to the clipboard file
    writeHDUsToClipBoard 1

    redrawHighLight
}

body FitsFile::redrawHighLight {} {
    
    foreach i [winfo children $subwin] {
	catch {destroy $i}
    }

    # Update required to let the TK event handlers actually handle the
    # destruction of this objects before we recreate them
    update idletasks

    openf
    drawContent
    closef
}

body FitsFile::copyHDUs {} {
# just copy
    if { ! [isHDUSelected] } {
	error "Please select HDU first"
	return
    }
    writeHDUsToClipBoard 0
    
}

body FitsFile::pasteHDUs {} {
    global backupDir

    set tmp [fvClipBoard report]
# check if there are hdus in the clipboard
    if { [lindex $tmp 0] != "HDUs" } {
	error "Sorry, there are no HDUs in the clipboard"
	return
    }
    set cbfilename [file join ${backupDir} cb.fits]
    fits open $cbfilename 0 tmpcbfits
    set nhdu [tmpcbfits info nhdu]

# skip the first header
    for { set i $nhdu} { $i > 1} {incr i -1} {
	tmpcbfits move $i
	tmpcbfits append $openedFileName
    }
    tmpcbfits close
# update the total numExts
    set numExts [expr $numExts+$nhdu-1]
    redrawHighLight
    changeFile
}

body FitsFile::smoothImgs {} {
    global titleFont
    global backupDir
    global fitsFileMode





# open the smooth dialog 
    if ![info exist xwin] {
       set xwin 3
    }
    if ![info exist ywin] {
       set ywin 3
    }


    if ![info exist smoothID] {
       set smoothID 1
    }

    set dosmooth 0 
    if [winfo  exists .smthdlg ] {
        focus .smthdlg 
        raise .smthdlg 
        return
    }

    toplevel .smthdlg -class Dialog 
    wm title .smthdlg "fv: Smooth Image"

    label .smthdlg.title -text "Size of smoothing box:" -font titleFont \
       -anchor w
    pack  .smthdlg.title -pady 5 -ipadx 35 -anchor w

    frame .smthdlg.smthx -relief flat
    label .smthdlg.smthx.px -text "Width: " -anchor w -font titleFont
    entry .smthdlg.smthx.ex -width 4 \
            -textvariable [scope xwin] -relief sunken   -font titleFont
    pack  .smthdlg.smthx.px .smthdlg.smthx.ex  -side left 
    label .smthdlg.smthx.unit -text " pixel" -anchor w -font titleFont
    pack  .smthdlg.smthx.px .smthdlg.smthx.ex .smthdlg.smthx.unit -side left 
    pack  .smthdlg.smthx -pady 3 -padx 3 -anchor w

    frame .smthdlg.smthy -relief flat
    label .smthdlg.smthy.py -text "Height:" -anchor w -font titleFont
    entry .smthdlg.smthy.ey -width 4  \
            -textvariable [scope ywin] -relief sunken   -font titleFont
    label .smthdlg.smthy.unit -text " pixel" -anchor w -font titleFont
    pack  .smthdlg.smthy.py .smthdlg.smthy.ey .smthdlg.smthy.unit -side left 
    pack  .smthdlg.smthy -side top -pady 3 -padx 3 -anchor w

    label .smthdlg.note -text "(must be odd numbers)" -font titleFont
    pack  .smthdlg.note -pady 5 -anchor w

    frame .smthdlg.smthbt -relief flat
    button .smthdlg.smthbt.ok -text OK  \
           -command [code $this smoothOK]
    button .smthdlg.smthbt.cancel -text Cancel -command {destroy .smthdlg}
    pack .smthdlg.smthbt.ok  -side left 
    pack .smthdlg.smthbt.cancel -side right 
    pack .smthdlg.smthbt -side top -pady 5 -padx 5 -expand true -fill x

    tkwait win .smthdlg
    set window $xwin
    lappend window $ywin 

    if {$dosmooth == 0 } {
        return 0
    }

#   smooth all the selected extensions 

    set tmpfits [fits open $filename 0]
    set numexts $numExts
    set smfile [file join $backupDir smooth.tmp$smoothID]
    incr smoothID   
    if [file exists $smfile] {
          file delete $smfile
    }
    for {set i 1} {$i <= $numexts} {incr i} {
        if { $extCheck($i) || $numexts == 1} {
            set htype [$tmpfits move $i]
            if {$htype == 0} { 
              $tmpfits smooth $window $smfile 
            }
        }
    }
    $tmpfits close

    set oldMode $fitsFileMode
    # Set Read-Only flag
    set fitsFileMode 1
    set smtmp [openFitsFile $smfile] 
    $smtmp changeFile
    set fitsFileMode $oldMode
    return 0
}

body FitsFile::smoothOK {} {
    set dosmooth 1 
    destroy .smthdlg 
}

body FitsFile::plotHDUs {} {
    global titleFont

    set numexts $numExts

    if {$numexts == 1} {
        plotData 1
        return 0
    }

    set tmpfits [fits open $filename 0]
    for {set i 1} {$i <= $numexts} {incr i} {
        if { $extCheck($i) } {
            set htype [$tmpfits move $i]
            if {$htype == 0} {
               set  dimsl [$tmpfits info imgdim]
               set  ndims [llength $dimsl ]
	       if { $ndims > 0} {  
                   plotData $i
               }
            } else {
               plotData $i
            }    
        }
    }
    $tmpfits close
    return 0
}

body FitsFile::isHDUSelected {} {

   for {set i 1} {$i <= $numExts} {incr i} {
      if { $extCheck($i) } {
         return 1
      }
   }
   return 0
}

body FitsFile::isImgSelected {} {
    
   for {set i 1} {$i <= $numExts} {incr i} {
      if { $extCheck($i) || $numExts==1 } {
         if { $extData($i,type) == "Image" && $extData($i,dims)!="0" } {
            return 1
         }
      }
   }
   return 0
}

body FitsFile::isTblSelected {} {

   for {set i 1} {$i <= $numExts} {incr i} {
      if { $extCheck($i) && $extData($i,type) != "Image" } {
         return 1
      }
   }
   return 0
}

body FitsFile::writeHDUsToClipBoard {ifDelete} {
    global backupDir

   getBackup

# ifDelete = 1 : cut
# ifDelete = 0 : copy

    set cbfilename [file join ${backupDir} cb.fits]
    file delete $cbfilename
    set tmpcbfits [fits open $cbfilename 2 tmpcbfits]
    $tmpcbfits put ihd -p 
    $tmpcbfits close
    
    set tmpfits [fits open [getBackup] 1]

    set hduList {}
    for {set i $numExts} {$i > 0} {incr i -1} {
	if { $extCheck($i) } {
	    $tmpfits move $i
	    $tmpfits append $cbfilename
	    lappend hduList "[expr $i-1],"
	    if { $ifDelete } {
		$tmpfits delete chdu
	    }
	}
	set extCheck($i) 0
    }
    
    # register to the clipboard. The first arg is a dummy arg
    fvClipBoard register "HDUs" $filename $hduList $hduList
    
    set numExts [$tmpfits info nhdu]	
    $tmpfits close
    if { $ifDelete } changeFile
}


body FitsFile::getColNum { colname } {
    set collist [$fitsfile info column]
    set colnum [lsearch -exact $collist $colname]
    incr colnum
    return $colnum
}

body FitsFile::getTLMinMax {colname} {
    set colnum [getColNum $colname]
    if { $colnum == 0} {
	return ""
    }
    if { [catch {set tmpmin [getKeyword "TLMIN$colnum"]}] == 1} return ""
    set min [lindex [lindex $tmpmin 0] 1]
    if { [catch {set tmpmax [getKeyword "TLMAX$colnum"]}] == 1} return ""
    set max [lindex [lindex $tmpmax 0] 1]
    #  Make sure min/max is a valid number
    regsub {[dD]} $min E min
    regsub {[dD]} $max E max
    if { [catch {set min [expr $min]}] } { set min "" }
    if { [catch {set max [expr $max]}] } { set max "" }
    return "$min $max"
}

body FitsFile::getColMinMax {colname felem rowrange} {
    return [$fitsfile info column -minmax $colname $felem $rowrange]
}

body FitsFile::getColStat {colname felem rowrange} {
    return [$fitsfile info column -stat $colname $felem $rowrange]
}

body FitsFile::makeHistogram {args} {
   eval $fitsfile histogram $args
}

body FitsFile::loadImageMeanCols {fCol lCol slice} {
    return [$fitsfile load icols $fCol $lCol $slice]
}

body FitsFile::loadImageMeanRows {fRow lRow slice} {
    return [$fitsfile load irows $fRow $lRow $slice]
}

body FitsFile::plotHisto { } {
    global histoPlotId

    openf

# if not a 1D histogram abort.

   if { [catch {set xval [getKeyword "CRVAL1"]} ] } {closef; return}
   if { [catch {set xpix [getKeyword "CRPIX1"]} ] } {closef; return}
   if { [catch {set xbin [getKeyword "CDELT1"]} ] } {closef; return}

   set imgDim [getImgInfo]
   set numX [lindex $imgDim 0]
   if { [llength $imgDim]>2 \
	 || ([llength $imgDim]==2 && [lindex $imgDim 1]!=1) } {closef; return}
# 

   set xval [lindex [lindex $xval 0] 1]
   set xpix [lindex [lindex $xpix 0] 1]
   set xbin [lindex [lindex $xbin 0] 1]

   set xval [expr $xval + (1.0-$xpix)*$xbin]

    incr histoPlotId
    set graphID 1D_Histogram_${histoPlotId}
    set dataInfo [loadImageBlock 1 1 1 $numX 1]
    set dataAdd    [lindex $dataInfo 0]
    set dataType   [lindex $dataInfo 1]
    set dataLength [lindex $dataInfo 2]

    if { [winfo exist .pow.pow]!=1 } { 
       powInit .dummy
    }
    powCreateVectorEN x_$graphID x_$graphID $dataLength $xval $xbin NULL
    powCreateData y_d_$graphID $dataAdd $dataType $dataLength 1
    freeImage $dataAdd
    powCreateVector y_$graphID y_d_$graphID 0 $dataLength 1

    if { [catch {set xunt [getKeyword "CUNIT1"]} ] } {
       set xUnit Pixels
    } else {
       set xUnit [lindex [lindex $xunt 0] 1]
       set xUnit [string trim $xUnit { '}]
    }

    if { [catch {set xlbl [getKeyword "CTYPE1"]} ] } {
       set xLabel Pixels
    } else {
       set xLabel [lindex [lindex $xlbl 0] 1]
       set xLabel [string trim $xLabel { '}]
       set dsh [string first - $xLabel]
       if { $dsh > 0 } {
          incr dsh -1
          set xLabel [string range $xLabel 0 $dsh]
       }
    }

    set yUnit  NULL
    set yLabel Counts

    powCreateCurve $graphID x_$graphID NULL y_$graphID NULL NULL NULL

    # Draw as a histogram
    powSetCurveOptions $graphID $graphID lStep Yes lDisp Yes

    powCreateGraph $graphID $graphID NULL $xUnit $yUnit \
	$xLabel $yLabel \
	[lindex $fvPref::graphDispSize 0] [lindex $fvPref::graphDispSize 1]  

    closef
}


body FitsFile::appendNewHDU {} {
    if { [winfo exists .newhdu] } {
        delete object .newhdu
    }
    NewExtension .newhdu [getBackup] -title "fv: New HDU"

    tkwait window .newhdu

    redrawHighLight
    changeFile
}

body FitsFile::updateChecksum { {forceUpdate 0} } {

   
   if { [isFileChanged] && ! $forceUpdate} {
      isOpen
      switch $fvPref::ifAutoUpdateChecksum {
	 0 {return}
	 1 {
	    if { [$fitsfile checksum verify]<0 } { 
	       set forceUpdate 1
	    }
	 }
	 2 {set forceUpdate 1} 
      }
   }
   if { $forceUpdate } {
      $fitsfile checksum update
      changeFile
   }
}

body FitsFile::verifyChecksum {} {
    isOpen
# return 1 checksum ok
#        0 checksum keyword not there
#       -1 dooh!
    return [$fitsfile checksum verify]
}


#######################################
#
#          Open extensions
#
#######################################


body FitsFile::openHeader { extNum } {
   set fE [openExtension $extNum]
   return [$fE dispHeader]
}


body FitsFile::openTable { extNum {coor {}} {newTable {}} } {
   if { $newTable=="" } {
      set newTable $openExtraTable
   }
   set openExtraTable 0
   set fE [openExtension $extNum]
   return [$fE dispTable $coor $newTable]
}

body FitsFile::plotData { extNum {xyNames {}} } {
   set fE [openExtension $extNum]
   $fE plotData $xyNames
}	


body FitsFile::openExtension { extNum } {
   if { $origFileObj!="" } {
      return [$origFileObj openExtension $extNum]
   }
   set pos [lsearch $myExtNums $extNum]
   if { $pos==-1 } {
      set fE [FitsExtension #auto $fileMode $extNum $filename $this]
   } else {
      set fE [lindex $myChildren $pos]
   }
   return $fE
}


body FitsFile::closeExtension { extNum } {
   if { $origFileObj!="" } {
      $origFileObj closeExtension $extNum
   } else {
      if { $extNum < 0 } {
         # Close ALL extensions
         foreach fE $myChildren {
            $fE closeCmd
         }
      } else {
         set pos [lsearch $myExtNums $extNum]
         if { $pos!=-1 } {
            set fE [lindex $myChildren $pos]
            $fE closeCmd
         }
      }
   }
}


body FitsFile::setNewTable { flag } {
   set openExtraTable $flag
}

body FitsFile::addChild { child extNum } {
   set pos [lsearch $myExtNums $extNum]
   if { $pos==-1 } {
      lappend myChildren $child
      lappend myExtNums  $extNum
   } else {
      puts "$extNum already exists: [lindex $myChildren $pos]"
   }
}

body FitsFile::freeChild { extNum } {
   set pos [lsearch $myExtNums $extNum]
   if { $pos==-1 } {
      puts "$extNum does not exist"
   } else {
      set myChildren [lreplace $myChildren $pos $pos]
      set myExtNums  [lreplace $myExtNums $pos $pos]
   }
}
