#include "CCO_All.h"


void CCO_RetrieveConnTrack::parse()
{
	if (m_pMsgBuf)
		delete[] m_pMsgBuf;
	m_pMsgBuf = NULL;
	m_nMsgLen = bswapnhr(*reinterpret_cast<u_int16_t*>(m_pHeaderBuf));
	if (m_nMsgLen)
		m_pMsgBuf = new char[m_nMsgLen*sizeof(ConntrackMsg)];
}

const ConntrackMsg* CCO_RetrieveConnTrack::getMsg()
{
	if (!bConverted2Endian)
	{
		ConntrackMsg* it = reinterpret_cast<ConntrackMsg*>(m_pMsgBuf);
		ConntrackMsg* itEnd = it+m_nMsgLen;
		for (; it != itEnd; ++it)
		{
			bswapnh(it->birthday);
			bswapnh(it->lastPacket);
			// hostA
			bswapnh(it->port_hostA);
			bswapnh(it->packetCount_hostA);
			bswapnh(it->amount_hostA);
			bswapnh(it->lostAmount_hostA);
			bswapnh(it->rate_hostA);
			bswapnh(it->maxrate_hostA);
			bswapnh(it->maxtime_hostA);
			// hostB
			bswapnh(it->port_hostB);
			bswapnh(it->packetCount_hostB);
			bswapnh(it->amount_hostB);
			bswapnh(it->lostAmount_hostB);
			bswapnh(it->rate_hostB);
			bswapnh(it->maxrate_hostB);
			bswapnh(it->maxtime_hostB);
		}
		bConverted2Endian = true;
	}
	return reinterpret_cast<ConntrackMsg*>(m_pMsgBuf);
}
