#-*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from twisted.trial import unittest
from elisa.core.tests.elisa_test_case import ElisaTestCase, BoilerPlateApp
from elisa.core import common, player_engine_registry, plugin, media_uri
from elisa.base_components import player_engine

from elisa.core.player import STATES, Player

from test_player_engine import FooEngine, StupidPipe

from elisa.core.player_registry import PlayerRegistry

import gst

class StupidRegistry(object):

    engine = None

    def __init__(self):
        pass

    def create_engine_for_scheme(self, uri_scheme):
        if uri_scheme == 'non':
            self.engine = None
            raise player_engine_registry.NoEngineFound()

        self.engine = FooEngine()
        return self.engine

class simpleManager(object):
    def get_real_uri(self, res):
        return res

class FooPlugin(plugin.Plugin):
    name = 'foo'
    components = {'foo_eng': {'path':FooEngine},
                  }


class TestPlayerRegistry(ElisaTestCase):

    def setUp(self):
        ElisaTestCase.setUp(self)
        self._player_registry = PlayerRegistry()

        app = BoilerPlateApp('empty.conf')
        common.set_application(app)
            
        registry = app.plugin_registry
        registry.register_plugin(FooPlugin)

        app.config.set_option('player_engines', 
                ['foo:foo_eng'])

        from elisa.core.common import application
        application.media_manager = simpleManager()
 
        self._player_registry.initialize()

    def test_player_registry(self):

        player_registry = self._player_registry
        player = player_registry.create_player()
        player.uri = media_uri.MediaUri('foo:///bar')
        engine = player._engine
        engine.pipeline = StupidPipe()
        engine.state = STATES.STOPPED

        player_registry.play_all()
        self.assertEquals(engine.state, STATES.LOADING)

        engine.state = STATES.PLAYING
        player_registry.pause_all()
        self.assertEquals(engine.pipeline.state, gst.STATE_PAUSED)

        engine.state = STATES.PLAYING
        player_registry.stop_all()
        self.assertEquals(engine.pipeline.state, gst.STATE_READY)

        engine.volume = 3
        player_registry.mute_all()
        self.assertEquals(engine.volume, 0)
        player_registry.unmute_all()
        self.assertEquals(engine.volume, 3)
        player_registry.remove_player(player)

        player_registry.deinitialize()
