# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from twisted.trial import unittest
from elisa.core.backend import Backend
from elisa.core import config
from elisa.core import interface_controller

MAPPINGS="""\
[test:elisa_model]
supported_controllers = ['test:elisa_controller',]
controller = 'test:elisa_controller'
supported_views = ['test:elisa_view']
view = 'test:elisa_view'
"""


class TestBackend(unittest.TestCase):

    def setUp(self):
        cfg = config.Config('mappings.conf', MAPPINGS)
        self._backend = Backend(cfg)
        
    def test_get_view_path(self):
        
        path = self._backend.get_controller_path('test:elisa_model')
        self.assertEquals(path, 'test:elisa_controller')

        self.assertRaises(interface_controller.UndefinedMVCAssociation,
                          self._backend.get_controller_path, 'foo:bar')
