/*
 * type1 font (downlodable PostScript font)
 */
#include	"defs.h"
#include	"global.h"
#include	"bifont.h"
#ifdef KPATHSEA
#include	<kpathsea/pathsearch.h>
#include	<kpathsea/tex-file.h>
#endif

void
init_t1_fontinfo(fe)
struct font_entry *fe;
{
    int	mm_markchar();
    int	null_markchar();
    void read_t1_fontinfo();

/*
    biinifinfo(fe) = alloc_biinif(biaccinfo(fe)->bf);
    fe->fnt_markchar = mm_markchar;
*/
    fe->fnt_markchar = null_markchar;
    fe->fnt_readfontinfo = read_t1_fontinfo;
}

void
read_t1_fontinfo(fe)
struct font_entry *fe;
{
    char *fn, *filename;
    FILE *fp;
    void read_tfm_finfo();
#ifdef KPATHSEA
    char pathname[PATHLEN];	/* dummy */
    char *path, *base;
    const_string savepath;
    kpse_format_info_type *spec = &kpse_format_info[kpse_type1_format];
#endif

    read_tfm_finfo(fe);
    dev_tfm_initfe(fe);
    fn = dev_t1path(tfmfinfo(fe)->tfm_bf);
#ifdef KPATHSEA
    pavek(pathname, &path, &base, fn, NULL);
    if (path != NULL) {
	savepath = spec->path;
	spec->path = NULL;
	spec->override_path = path;
    }
    if (spec->path == NULL)
	kpse_init_format(kpse_type1_format);
    if (base == NULL)
	filename = kpse_find_file(fe->n, kpse_type1_format, false);
    else if (path == NULL)
	filename = kpse_find_file(base, kpse_type1_format, false);
    else
	filename = kpse_path_search(spec->path, base, false);
    if (path != NULL)
	spec->path = savepath;
    if (filename == NULL)
	filename = fn;
#ifdef DEBUG
    if (Debuguser && filename != NULL)
	(void)fprintf(stderr, "trying type1font file %s\n", filename);
#endif
#else
    filename = fn;
#endif
    dev_t1_initfontdict(fe, filename);
}
