//$Header:$

/*
WRLSAVE.CPP - WRL (VRML) Module for Geodesic Class

	Copyright (C) 1995 - 2002 Richard J. Bono

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	 Please direct inquiries, comments and modifications to:
	 Richard J. Bono
	 44 Augusta Rd.
	 Brownsville, TX 78521

	 email: rjbono@applied-synergetics.com

Revision history:

$Log:$

*/

#include "Geodesic.h"

//----------------------------------------WRL File memeber Functions
//-------------------save WRL file as indexed face set
void CGeodesic::save_WRL(char *filename)
{
	long sX, sY, sZ;
	double dX, dY, dZ;
	long end_face;

	//save chord data for symmetry triangle to WRL file
	//filename should include .WRL extension on MS-DOS systems

	ofstream WRL(filename);
	//Set field widths
	WRL << setiosflags(ios::fixed) << setw(8) << setprecision(6);

	//determine the number of faces required (first face = 0)
	if(sphere_flg)
		end_face = face_quantity(classtype, polytype);
	else
		end_face = 0;

	if(!show_status){
		cout << "Saving Data to File... ";
		status_count = 0;
	}

	//set up VRML file header
	WRL << "#VRML V1.0 ascii" << '\n' << '\n';
	WRL << "#WRL File Generated by WinDome 4.80 Beta 1: " << '\n' << '\n';
	WRL << "Separator {" << '\n';
	WRL << "  DEF BackgroundColor Info { string \"1.0 1.0 1.0\" }" << '\n';

	WRL << "  Material { diffuseColor 0 0 1}  #end Material set to blue" << '\n';
	WRL << "  Separator {" << '\n';
	WRL << "    Coordinate3 {" << '\n';
	WRL << "      point [" << '\n';

	//output VRML data...start with vertexia points...
	for(j=0; j<=end_face; j++){
		if(polytype == 1)
			icosa_sphere(j);
		else if(polytype == 2)
			octa_sphere(j);
		else if(polytype == 3)
			tetra_sphere(j);

		WRL << "       #Face #" << (j+1) << '\n';
		for(i=1; i<=vertex_calc; i++){

			if(!show_status){
				time_passage(status_count);
				status_count++;
				if(status_count > 3)
					status_count = 0;
			}
			if(ParabolaFlag){
				double TruncTheta;
				TruncTheta = ParabolaTheta(ParabolaRadius, ParabolaFocus);
				if(sphere_pnt[i].theta > TruncTheta)
					continue;			
			}
			//convert spherical to cartesian
			dX = sphere_pnt[i].radius *
				  clean_float(cos(sphere_pnt[i].phi * DEG_TO_RAD) *
								  sin(sphere_pnt[i].theta * DEG_TO_RAD));
			dY = sphere_pnt[i].radius *
				  clean_float(sin(sphere_pnt[i].phi * DEG_TO_RAD) *
								  sin(sphere_pnt[i].theta * DEG_TO_RAD));
			dZ = sphere_pnt[i].radius *
				  clean_float(cos(sphere_pnt[i].theta * DEG_TO_RAD));

			//Save data
			WRL << dX << " " << dY << " " << dZ << "," << '\n';
		}
	}
	WRL << "            ]" << '\n';
	WRL << "          }" << '\n';

	//Now define faces...
	WRL << "   Material {diffuseColor [ 1 0 0 ]}" << '\n';
	WRL << "     IndexedFaceSet {" << '\n';
	WRL << "       coordIndex [" << '\n';

	for(j=0; j<=end_face; j++){
		//output VRML face data...
		WRL << "       #Face #" << (j+1) << '\n';
		for(i=1; i<=face_calc; i++){
			if(!show_status){
				time_passage(status_count);
				status_count++;
				if(status_count > 3)
					status_count = 0;
			}
				if(ParabolaFlag){
					double TruncTheta;
					TruncTheta = ParabolaTheta(ParabolaRadius, ParabolaFocus);
					if(sphere_pnt[edgepts[i].start].theta > TruncTheta)
						continue;			
					else if(sphere_pnt[edgepts[i].end].theta > TruncTheta)
						continue;					
				}
			//Data saved is the point coordinate index for the given face
			sX = (polyface[i].cornerA + (vertex_calc * j)) - 1;
			sY = (polyface[i].cornerB + (vertex_calc * j)) - 1;
			sZ = (polyface[i].cornerC + (vertex_calc * j)) - 1;
		WRL << sX << ", " << sY << ", " << sZ << ", -1," << '\n';
		}
	}
	WRL << "               ] #end coordIndex" << '\n';
	WRL << "          } #end IndexedFaceSet" << '\n';
	WRL << "      } #end Separator of faces" << '\n';
	WRL << "} #end final Separator" << '\n';
	WRL.close();

}

//-------------------save WRL file as indexed line set
void CGeodesic::save_WRL_wire(char *filename)
{
	long start_pnt, end_pnt;
	double dX, dY, dZ;
	long end_face;

	//save chord data for symmetry triangle to WRL file
	//filename should include .WRL extension on MS-DOS systems

	ofstream WRL(filename);
	//Set field widths
	WRL << setiosflags(ios::fixed) << setw(8) << setprecision(6);

	//determine the number of faces required (first face = 0)
	if(sphere_flg)
		end_face = face_quantity(classtype, polytype);
	else
		end_face = 0;

	if(!show_status){
		cout << "Saving Data to File... ";
		status_count = 0;
	}

	//set up VRML file header
	WRL << "#VRML V1.0 ascii" << '\n' << '\n';
	WRL << "#WRL File Generated by WinDome 4.80 Beta 1: " << '\n' << '\n';
	WRL << "Separator {" << '\n';
	WRL << "  DEF BackgroundColor Info { string \"1.0 1.0 1.0\" }" << '\n';

	WRL << "  Material { diffuseColor 0 0 1}  #end Material set to blue" << '\n';
	WRL << "  Separator {" << '\n';
	WRL << "    Coordinate3 {" << '\n';
	WRL << "      point [" << '\n';

	//output VRML data...start with vertexia points...
	for(j=0; j<=end_face; j++){
		if(polytype == 1)
			icosa_sphere(j);
		else if(polytype == 2)
			octa_sphere(j);
		else if(polytype == 3)
			tetra_sphere(j);

		WRL << "       #Face #" << (j+1) << '\n';
		for(i=1; i<=vertex_calc; i++){

			if(!show_status){
				time_passage(status_count);
				status_count++;
				if(status_count > 3)
					status_count = 0;
			}

			//convert spherical to cartesian
			dX = sphere_pnt[i].radius *
				  clean_float(cos(sphere_pnt[i].phi * DEG_TO_RAD) *
								  sin(sphere_pnt[i].theta * DEG_TO_RAD));
			dY = sphere_pnt[i].radius *
				  clean_float(sin(sphere_pnt[i].phi * DEG_TO_RAD) *
								  sin(sphere_pnt[i].theta * DEG_TO_RAD));
			dZ = sphere_pnt[i].radius *
				  clean_float(cos(sphere_pnt[i].theta * DEG_TO_RAD));

			//Save data
			WRL << dX << " " << dY << " " << dZ << "," << '\n';
		}
	}
	WRL << "            ]" << '\n';
	WRL << "          }" << '\n';

	//Now define chords...
	WRL << "   Material {diffuseColor [ 1 0 0 ]}" << '\n';
	WRL << "     IndexedLineSet {" << '\n';
	WRL << "       coordIndex [" << '\n';

	for(j=0; j<=end_face; j++){
		//output VRML line data...
		WRL << "       #Face #" << (j+1) << '\n';
		for(i=1; i<=edges_calc; i++){
			if(!show_status){
				time_passage(status_count);
				status_count++;
				if(status_count > 3)
					status_count = 0;
			}
			//Data saved is the point coordinate index for the given chord
			start_pnt = (edgepts[i].start + (vertex_calc * j)) - 1;
			end_pnt = (edgepts[i].end + (vertex_calc * j)) - 1;
		WRL << start_pnt << ", " << end_pnt << ", -1," << '\n';
		}
	}
	WRL << "               ] #end coordIndex" << '\n';
	WRL << "          } #end IndexedLineSet" << '\n';
	WRL << "      } #end Separator of Lines" << '\n';
	WRL << "} #end final Separator" << '\n';
	WRL.close();
}
//-------------------save WRL file as indexed line set
void CGeodesic::save_buckywrl(char *filename)
{
	long start_pnt, end_pnt;
	double dX, dY, dZ;
	long end_face;

	//save chord data for symmetry triangle to WRL file
	//filename should include .WRL extension on MS-DOS systems

	ofstream WRL(filename);
	//Set field widths
	WRL << setiosflags(ios::fixed) << setw(8) << setprecision(6);

	//determine the number of faces required (first face = 0)
	if(sphere_flg)
		end_face = face_quantity(classtype, polytype);
	else
		end_face = 0;

	edges_calc = bucky_edges;

	if(!show_status){
		cout << "Saving Data to File... ";
		status_count = 0;
	}


	//set up VRML file header
	WRL << "#VRML V1.0 ascii" << '\n' << '\n';
	WRL << "#WRL File Generated by WinDome 4.80 Beta 1: " << '\n' << '\n';
	WRL << "Separator {" << '\n';
	WRL << "  DEF BackgroundColor Info { string \"1.0 1.0 1.0\" }" << '\n';

	WRL << "  Material { diffuseColor 0 0 1}  #end Material set to blue" << '\n';
	WRL << "  Separator {" << '\n';
	WRL << "    Coordinate3 {" << '\n';
	WRL << "      point [" << '\n';

	//output VRML data...start with vertexia points...
	for(j=0; j<=end_face; j++){
		if(polytype == 1)
			icosa_sphere(j);
		else if(polytype == 2)
			octa_sphere(j);
		else if(polytype == 3)
			tetra_sphere(j);

		WRL << "       #Face #" << (j+1) << '\n';
		for(i=1; i<=vertex_calc; i++){

			if(!show_status){
				status_count++;
				if(status_count > 3)
					status_count = 0;
			}

			//convert spherical to cartesian
			if(fmod((pnt_label[i].A + pnt_label[i].B), 3.0) != 0.0){
				dX = sphere_pnt[i].radius *
					  clean_float(cos(sphere_pnt[i].phi * DEG_TO_RAD) *
									  sin(sphere_pnt[i].theta * DEG_TO_RAD));
				dY = sphere_pnt[i].radius *
					  clean_float(sin(sphere_pnt[i].phi * DEG_TO_RAD) *
									  sin(sphere_pnt[i].theta * DEG_TO_RAD));
				dZ = sphere_pnt[i].radius *
					  clean_float(cos(sphere_pnt[i].theta * DEG_TO_RAD));
			 }
			 else{
				dX = 0.0;
				dY = 0.0;
				dZ = 0.0;
			 }
			 //Save data
			 WRL << dX << " " << dY << " " << dZ << "," << '\n';
		}
	}
	WRL << "            ]" << '\n';
	WRL << "          }" << '\n';

	//Now define chords...
	WRL << "   Material {diffuseColor [ 1 0 0 ]}" << '\n';
	WRL << "     IndexedLineSet {" << '\n';
	WRL << "       coordIndex [" << '\n';

	for(j=0; j<=end_face; j++){
		//output VRML line data...
		WRL << "       #Face #" << (j+1) << '\n';
		for(i=1; i<=edges_calc; i++){
			if(!show_status){
				time_passage(status_count);
				status_count++;
				if(status_count > 3)
					status_count = 0;
			}

			//Data saved is the point coordinate index for the given chord
			start_pnt = (edgepts[i].start + (vertex_calc * j)) - 1;
			end_pnt = (edgepts[i].end + (vertex_calc * j)) - 1;
		WRL << start_pnt << ", " << end_pnt << ", -1," << '\n';
		}
	}
	WRL << "               ] #end coordIndex" << '\n';
	WRL << "          } #end IndexedLineSet" << '\n';
	WRL << "      } #end Separator of Lines" << '\n';
	WRL << "} #end final Separator" << '\n';
	WRL.close();
}
//-------------------save WRL file as indexed face set
void CGeodesic::save_WRL_2(char *filename)
{
	long sX, sY, sZ;
	double dX, dY, dZ;
	long end_face;

	//save chord data for symmetry triangle to WRL file
	//filename should include .WRL extension on MS-DOS systems

	ofstream WRL(filename);
	//Set field widths
	WRL << setiosflags(ios::fixed) << setw(8) << setprecision(6);

	//determine the number of faces required (first face = 0)
	if(sphere_flg)
		end_face = face_quantity(classtype, polytype);
	else
		end_face = 0;

	if(!show_status){
		cout << "Saving Data to File... ";
		status_count = 0;
	}

	//set up VRML file header
	WRL << "#VRML V2.0 utf8" <<endl << endl;
	WRL << "#WRL File Generated by WinDome 4.80 Beta 1" << endl;
	WRL << "Shape {" << endl;
    WRL << "    appearance Appearance {" << endl;
	WRL << "        material Material {" << endl;
	WRL << "            diffuseColor 0.0 0.0 1.0" << endl;
	WRL << "         }" << endl;
	WRL << "    }" << endl;
	WRL << "    geometry IndexedFaceSet {" << endl;
	WRL << "        coord Coordinate {" << endl;
	WRL << "            point [" << endl;

	//output VRML data...start with vertexia points...
	for(j=0; j<=end_face; j++){
		if(polytype == 1)
			icosa_sphere(j);
		else if(polytype == 2)
			octa_sphere(j);
		else if(polytype == 3)
			tetra_sphere(j);

		WRL << "       #Face #" << (j+1) << '\n';
		for(i=1; i<=vertex_calc; i++){

			if(!show_status){
				time_passage(status_count);
				status_count++;
				if(status_count > 3)
					status_count = 0;
			}
			if(ParabolaFlag){
				double TruncTheta;
				TruncTheta = ParabolaTheta(ParabolaRadius, ParabolaFocus);
				if(sphere_pnt[i].theta > TruncTheta)
					continue;			
			}
			//convert spherical to cartesian
			dX = sphere_pnt[i].radius *
				  clean_float(cos(sphere_pnt[i].phi * DEG_TO_RAD) *
								  sin(sphere_pnt[i].theta * DEG_TO_RAD));
			dY = sphere_pnt[i].radius *
				  clean_float(sin(sphere_pnt[i].phi * DEG_TO_RAD) *
								  sin(sphere_pnt[i].theta * DEG_TO_RAD));
			dZ = sphere_pnt[i].radius *
				  clean_float(cos(sphere_pnt[i].theta * DEG_TO_RAD));

			//Save data
			WRL << dX << " " << dY << " " << dZ << "," << endl;
		}
	}
	WRL << "            ]" << endl;
	WRL << "          }" << endl;

	//Now define faces...
	WRL << "       coordIndex [" << endl;

	for(j=0; j<=end_face; j++){
		//output VRML face data...
		WRL << "       #Face #" << (j+1) << '\n';
		for(i=1; i<=face_calc; i++){
			if(!show_status){
				time_passage(status_count);
				status_count++;
				if(status_count > 3)
					status_count = 0;
			}
				if(ParabolaFlag){
					double TruncTheta;
					TruncTheta = ParabolaTheta(ParabolaRadius, ParabolaFocus);
					if(sphere_pnt[edgepts[i].start].theta > TruncTheta)
						continue;			
					else if(sphere_pnt[edgepts[i].end].theta > TruncTheta)
						continue;					
				}
			//Data saved is the point coordinate index for the given face
			sX = (polyface[i].cornerA + (vertex_calc * j)) - 1;
			sY = (polyface[i].cornerB + (vertex_calc * j)) - 1;
			sZ = (polyface[i].cornerC + (vertex_calc * j)) - 1;
		WRL << sX << ", " << sY << ", " << sZ << ", -1," << endl;
		}
	}
	WRL << "          ]" << endl;
	WRL << "          solid FALSE" << endl;
	WRL << "      }" << endl;
	WRL << "}" << endl;
	WRL.close();

}
//-------------------save WRL file as indexed line set
void CGeodesic::save_WRL_wire_2(char *filename)
{
	long start_pnt, end_pnt;
	double dX, dY, dZ;
	long end_face;

	//save chord data for symmetry triangle to WRL file
	//filename should include .WRL extension on MS-DOS systems

	ofstream WRL(filename);
	//Set field widths
	WRL << setiosflags(ios::fixed) << setw(8) << setprecision(6);

	//determine the number of faces required (first face = 0)
	if(sphere_flg)
		end_face = face_quantity(classtype, polytype);
	else
		end_face = 0;

	if(!show_status){
		cout << "Saving Data to File... ";
		status_count = 0;
	}

	//set up VRML file header
	WRL << "#VRML V2.0 utf8" << endl;
	WRL << "#WRL File Generated by WinDome 4.80 Beta 1" << endl;
	WRL << "Shape {" << endl;
	WRL << "    appearance Appearance {" << endl;
	WRL << "        material Material {" << endl;
	WRL << "            diffuseColor 0.0 0.0 1.0" << endl;
	WRL << "        }" << endl;
	WRL << "    }" << endl;
	WRL << "    geometry IndexedLineSet {" << endl;
	WRL << "        coord Coordinate {" << endl;
	WRL << "            point [" << endl;

	//output VRML data...start with vertexia points...
	for(j=0; j<=end_face; j++){
		if(polytype == 1)
			icosa_sphere(j);
		else if(polytype == 2)
			octa_sphere(j);
		else if(polytype == 3)
			tetra_sphere(j);

		WRL << "       #Face #" << (j+1) << '\n';
		for(i=1; i<=vertex_calc; i++){

			if(!show_status){
				time_passage(status_count);
				status_count++;
				if(status_count > 3)
					status_count = 0;
			}

			//convert spherical to cartesian
			dX = sphere_pnt[i].radius *
				  clean_float(cos(sphere_pnt[i].phi * DEG_TO_RAD) *
								  sin(sphere_pnt[i].theta * DEG_TO_RAD));
			dY = sphere_pnt[i].radius *
				  clean_float(sin(sphere_pnt[i].phi * DEG_TO_RAD) *
								  sin(sphere_pnt[i].theta * DEG_TO_RAD));
			dZ = sphere_pnt[i].radius *
				  clean_float(cos(sphere_pnt[i].theta * DEG_TO_RAD));

			//Save data
			WRL << dX << " " << dY << " " << dZ << "," << endl;
		}
	}
	WRL << "            ]" << endl;
	WRL << "          }" << endl;

	//Now define chords...
	WRL << "       coordIndex [" << endl;

	for(j=0; j<=end_face; j++){
		//output VRML line data...
		WRL << "       #Face #" << (j+1) << '\n';
		for(i=1; i<=edges_calc; i++){
			if(!show_status){
				status_count++;
				if(status_count > 3)
					status_count = 0;
			}
			//Data saved is the point coordinate index for the given chord
			start_pnt = (edgepts[i].start + (vertex_calc * j)) - 1;
			end_pnt = (edgepts[i].end + (vertex_calc * j)) - 1;
		WRL << start_pnt << ", " << end_pnt << ", -1," << endl;
		}
	}
	WRL << "          ]" << endl;
	WRL << "      }" << endl;
	WRL << "}" << endl;
	WRL.close();
}
//-------------------save WRL file as indexed line set
void CGeodesic::save_buckywrl_2(char *filename)
{
	long start_pnt, end_pnt;
	double dX, dY, dZ;
	long end_face;

	//save chord data for symmetry triangle to WRL file
	//filename should include .WRL extension on MS-DOS systems

	ofstream WRL(filename);
	//Set field widths
	WRL << setiosflags(ios::fixed) << setw(8) << setprecision(6);

	//determine the number of faces required (first face = 0)
	if(sphere_flg)
		end_face = face_quantity(classtype, polytype);
	else
		end_face = 0;

	edges_calc = bucky_edges;

	if(!show_status){
		cout << "Saving Data to File... ";
		status_count = 0;
	}
	//set up VRML file header
	WRL << "#VRML V2.0 utf8" << endl;
	WRL << "#WRL File Generated by WinDome 4.80 Beta 1" << endl;
	WRL << "Shape {" << endl;
	WRL << "    appearance Appearance {" << endl;
	WRL << "        material Material {" << endl;
	WRL << "            diffuseColor 0.0 0.0 1.0" << endl;
	WRL << "        }" << endl;
	WRL << "    }" << endl;
	WRL << "    geometry IndexedLineSet {" << endl;
	WRL << "        coord Coordinate {" << endl;
	WRL << "            point [" << endl;

	//output VRML data...start with vertexia points...
	for(j=0; j<=end_face; j++){
		if(polytype == 1)
			icosa_sphere(j);
		else if(polytype == 2)
			octa_sphere(j);
		else if(polytype == 3)
			tetra_sphere(j);

		WRL << "       #Face #" << (j+1) << '\n';
		for(i=1; i<=vertex_calc; i++){

			if(!show_status){
				status_count++;
				if(status_count > 3)
					status_count = 0;
			}

			//convert spherical to cartesian
			if(fmod((pnt_label[i].A + pnt_label[i].B), 3.0) != 0.0){
				dX = sphere_pnt[i].radius *
					  clean_float(cos(sphere_pnt[i].phi * DEG_TO_RAD) *
									  sin(sphere_pnt[i].theta * DEG_TO_RAD));
				dY = sphere_pnt[i].radius *
					  clean_float(sin(sphere_pnt[i].phi * DEG_TO_RAD) *
									  sin(sphere_pnt[i].theta * DEG_TO_RAD));
				dZ = sphere_pnt[i].radius *
					  clean_float(cos(sphere_pnt[i].theta * DEG_TO_RAD));
			 }
			 else{
				dX = 0.0;
				dY = 0.0;
				dZ = 0.0;
			 }
			 //Save data
			 WRL << dX << " " << dY << " " << dZ << "," << endl;
		}
	}
	WRL << "            ]" << '\n';
	WRL << "          }" << '\n';

	//Now define chords...
	WRL << "       coordIndex [" << endl;

	for(j=0; j<=end_face; j++){
		//output VRML line data...
		WRL << "       #Face #" << (j+1) << endl;
		for(i=1; i<=edges_calc; i++){
			if(!show_status){
				status_count++;
				if(status_count > 3)
					status_count = 0;
			}
			//Data saved is the point coordinate index for the given chord
			start_pnt = (edgepts[i].start + (vertex_calc * j)) - 1;
			end_pnt = (edgepts[i].end + (vertex_calc * j)) - 1;
		WRL << start_pnt << ", " << end_pnt << ", -1," << endl;
		}
	}
	WRL << "          ]" << endl;
	WRL << "      }" << endl;
	WRL << "}" << endl;
	WRL.close();
}
//End of WRLSAVE
