/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _OPENSSLXX_HH__
#define _OPENSSLXX_HH__

#include <openssl/pem.h>
#include <openssl/err.h>
#include <openssl/pkcs7.h>
#include <openssl/pkcs12.h>
#include <openssl/x509v3.h>

/**
 * @name FileFormat
 *
 * @doc Les diffrents formats reconnus
 * */
namespace Cryptonit {
  //typedef enum {
	/**
	 * Pour les std::listes de fichiers
	 * @see filestd::list
	 * */
	//auto_format,
	///Format PEM
//pem_format,
	///Format DER
//der_format,
//pkcs7_format,
	///Format PKCS#12
//pkcs12_format
//} FileFormat;

typedef enum {
  X509Valid,
  X509Signature,
  X509MissingCA,
  X509NotBefore,
  X509NotAfter,
  X509Revoked
} CertificateValidity;

/**
 * @name CipherName
 * @doc  Les diffrents algorithmes de chiffrement reconnus
 * */
typedef enum {
	///DES
	C_DES,
	///DES3
	C_DES3,
	///RC2 128 bits
	C_RC2_128,
	///RC2 64 bits
	C_RC2_64,
	///RC2 40 bits
	C_RC2_40,
	//AES 128 bits	
	C_AES_128,
	//AES 192 bits
	C_AES_192,
	//AES 256 bits
	C_AES_256
} CipherName;

/**
 * @name DigestName
 * @doc Les diffrents algorithmes de hashage reconnus
 * */
typedef enum {
	///MD2
	D_MD2,
	///MD5
	D_MD5,
	///SHA1
	D_SHA1
} DigestName;

/**
 * @name PKCS7ContentType
 *
 * @doc Les diffrents types de pkcs7.
 * @see pkcs7
 * */
typedef enum {
	///Ne contient rien
	PKCS7None            = 0,
	PKCS7Data            = NID_pkcs7_data,
	///Utilis pour la signature
	PKCS7Signed          = NID_pkcs7_signed,
	///Utilis pour le chiffrement
	PKCS7Encrypted       = NID_pkcs7_enveloped,
	///Utilis pour le chiffrement/signature
	PKCS7SignedEncrypted = NID_pkcs7_signedAndEnveloped,
} PKCS7ContentType;

}
#endif // __XSC_OPENSSLXX_HH__
