/*
 * basemenuitem.hh - Header which defines a basemenuitem.
 * Copyright (C) 2000 Frank Hale
 * frankhale@yahoo.com
 * http://sapphire.sourceforge.net/
 *
 * Updated: 1 Nov 2001
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _BASEMENUITEM_HH_
#define _BASEMENUITEM_HH_

#include "aewm.hh"
#include <string>

// Represents a menu item.
class BaseMenuItem 
{
public:	
	BaseMenuItem() {
		client		= NULL;
		icon		= None;
		name		= "";
		exec		= "";
		function	= 0;
		isSelected	= false;
		item_x		= 0;
		item_y		= 0;
		index		= 0;
		sub		= NULL; 
	}
	
	Client *client; 
	Window icon;   // this menu item may be pointing to an icon for use
		       // in an icon list or something.
	
	std::string name; // name showing on menu.
	std::string exec; // command to execute when clicked.
	
	int item_x;
	int item_y;

	int function;
	int index;

	bool isSelected;
	
	BaseMenu *sub; // submenu this item points to.
};

#endif
