/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
	
#include <metaquality.h>
 
#ifndef HAS_METALINE
#define HAS_METALINE
  
/*
*	MetaLine
* @short Class processing a line within a generic object.
*/
class MetaLine
{
  public:
		/**
		* Default constructor. Initializes a void object.
		*/
	  MetaLine() { name="", metaQuality=NULL; }
		/**
		* Constructor. Creates a line from the provided string.
		* @param line	the string to be processed
		*/
	  MetaLine(QString line);
		/**
		* Copy constructor.
		* @param ml	the source object.
		*/
	  MetaLine(MetaLine &ml);
	  ~MetaLine() { if (metaQuality) delete metaQuality; }
		/**
		* This method is provided for internal use.
		* @return the list of Qualities.
		*/
	  MetaQuality *getQuality();
		/**
		* This method is provided for internal use.
		* @return the line's name.
		*/
	  QString &getName();
		/**
		* This method is provided for internal use.
		* @return the line's content.
		*/
	  QString &getContent();
		/**
		* This method is provided for changing the line's name.
		* @param newName the line's new name.
		*/
		void setName(QString newName) { name=newName; }
		/**
		* This method is provided for changing the line's content.
		* @param newContent the line's new content.
		*/
		void setContent(QString newContent) { content=newContent; }
		/**
		* This method is provided for changing sequence "\\n" into "\n" and
		* vice-versa.
		* @param flag if TRUE changes "\\n" to "\n". If FALSE "\n" -> "\\n".
		*/
	  void replaceEnters(bool flag);
		/**
		* This method is provided for generating the line as a text (reverse).
		* @return the string containing the entire line description.
		*/
		QString recompose();
		
		/**
		* This method is provided for appending qualities to a line.
		* @param qualities the qualities to be added to the line.
		*/
		void addQualities(QString qualities);
		/**
		* This method is provided for replacing qualities in a line.
		* @param qualities the qualities to be added to the line.
		*/
		void replaceQualities(QString qualities);
		/**
		* This method is provided for erasing qualities off a line.
		* @param qualityName the qualities to be added to the line.
		* @param included the properties which are included for that quality.
		* @param excluded the excluded (not contained) properties.
		*/
		void eraseQuality(QString qualityName="", 
				QString included="", QString excluded="");
		/**
		* This method is provided for erasing all the qualities off a line.
		*/
		void deleteQualities();
		/**
		* This method is provided for checking if a line matches the
		* included/excluded requirements.
		* @param included the properties which are included for that quality.
		* @param excluded the excluded (not contained) properties.
		*/
		bool checkQualities(QString included, QString excluded);
		
  private:
    // private data
	  QString name;
	  MetaQuality *metaQuality;
	  QString content;
		QString text;
    // private methods
		/**
		* This method is used for parsing the input text and generating the 
		* MetaLine object.
		* @param line the input string containing a line.
		*/
	  void parse(QString line);
};

#endif








