/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
 
#ifndef HAS_TODOWIDGET
#define HAS_TODOWIDGET

#include <qfiledialog.h>
#include <qpixmap.h>
#include <warray.h>
#include <qlayout.h>
#include <qevent.h>
#include <qstring.h>
#include <qlist.h>
#include <qlabel.h>

class CheckBox : public QLabel
{
  Q_OBJECT
  public:
    CheckBox(QWidget *parent, const QPixmap &empty, const QPixmap &clicked, const QPixmap &full);
  signals:
    void toggled(bool);
  private:
    bool state, pressed;
    void mousePressEvent(QMouseEvent *e);
    void mouseReleaseEvent(QMouseEvent *e);
    QPixmap p1, p2, p3;
};

class ToDoWidget : public QWidget
{
  Q_OBJECT
  public:
    ToDoWidget(QWidget *parent, const char *name=0);
    ~ToDoWidget();
  private slots:
    void updateEntry();
    void discardChanges();
    void updateText(bool t);
  private:
    bool eventFilter(QObject *o, QEvent *e);
    void addEntry(QString t);  
      
    QLineEdit *title;
    WArray *body;
    QVBoxLayout *l;
    bool edit_mode;
    int current_entry;
    QList<CheckBox> checkList;
    QList<QLabel> textList;
};

#endif








