/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

/*

This file includes the definition of the so-called Tile Classes.
There are two kinds of objects defined here: TileWidget and SortingWidget.

A SortingWidget is a GUI object which contains and manages a collection of TileWidgets.
It can automatically arrange, sort, create, drag, copy, paste, display right-click menus etc. on its children.

They are pure classes, and they must be inherited to become useful.

*/

#ifndef __SortingWidget__
#define __SortingWidget__

#include <stdio.h>
#include <qwidget.h>
#include <qstring.h>
#include <qlist.h>
#include <qpopupmenu.h>
#include <qevent.h>
#include <qscrollview.h>
#include <datahandlerimpl.h>
#include <tilewidget.h>

class SortingWidget : public QScrollView, public DataHandlerImpl
{
  Q_OBJECT
  public:
    // Creates a SortingWidget object.
    SortingWidget(QWidget *parent=0, const char *name=0, WFlags f=0);

    // Destroys a SortingWidget object.
    ~SortingWidget();
		
		// reimplemented from DataHandler
		virtual void registerWidget(DataWidget *);
		virtual void unregisterWidget(DataWidget *);

    // Adds a TileWidget child. The child will be shown immediately in the correct position according to its size or sorting keys.
    // Queries the TileWidget for sorting information on the first insertion and builds the sortPopup.
    virtual void addChild(QWidget *child);

    // Removed a child from the SortingWidget without deleting it. The SortingWidget is updated if "update" is true.
    // Normally, the "update" parameter is used only when more than one children are removed at once, to avoid multiple updates.
    virtual void removeChild(QWidget *child);
		
		// Removes all child widgets
		virtual void clear();

    // Enables or disables the fixed height children property. If true, horizontal arranging chains are used, otherwise vertical.
    // This should be called only once, in the constructor.
    virtual void setChildFixedHeight(bool fixed_height=true);

    // Returns the fixedHeight property value.
    virtual bool childFixedHeight();

    // Enables or disabled the width resize feature of the SortingWidget. Should be called only once, in the constructor.
    virtual void enableWidthResize(bool wres=true);

    // Returns the width resize property value.
    virtual bool widthResizeEnabled();
		
		// returns true if it can draw the vertical lines
		bool canDrawLines();
		
		// set if it can display the vertical "columns separators"
		void setCanDrawLines(bool);

    // Sets the children width.
    virtual void setChildWidth(int width);

    // Sets the children height. Has no effect unless the children have fixed height, as declared by setChildrenFixedHeight().
    virtual void setChildHeight(int height);

    // Sets the children type (see mailer.h for a list of types).
    virtual void setChildType(int type);

    // Returns the children type.
    virtual int  getChildType();

    // Sets the children mimetype. The SortingWidget will accept only drops which can be converted to this mimetype.
    virtual void setChildMimeType(const char *m="application/octet-stream");

    // Returns the children mimetype.
    virtual const char *getChildMimeType();

    // Returns the child found at point viewport coordinated, or NULL if no child can be found there.
    virtual TileWidget* childAt( QPoint );

    // Returns the children dimensions. If the children don't have fixed height the "h" value should be ignored.
    virtual void getChildDimensions(int &w, int &h);

    // Returns the (x, y) coordinates of the n-th child, specified in "index".
    virtual void getIndexPosition(int index, int &x, int &y);

    // Sets the horizontal spacing.
    virtual void setXSpacing(int xsp);

    // Sets the vertical spacing.
    virtual void setYSpacing(int ysp);

    // Allows the SortingWidget to display the main popup when a child is right-clicked when childPopup doesn't exist.
    virtual void setAllwaysShowPopup(bool t=true);

    // Returns the allwaysPopup property.
    virtual bool allwaysShowPopup();

    // Enables multiple selection.
    virtual void setMultipleSelect(bool t=true);

    // Returns true if multiple selection is enabled.
    virtual bool multipleSelect();
		
    // Enables the sort popup, if the parameter is true.
    virtual void setShowSorting(bool t=true);

    // Returns true is the sort popup is enabled.
    virtual bool showSorting();

    // Makes the global popup.
    virtual void makeGlobalPopup();

    // Makes the child popup.
    virtual void makeChildPopup();

    // Shows the global popup.
    virtual void popupGlobal();

    // Shows the child popup (or the global, the child popup is null, the main popup exists and allwaysPopup is true).
    virtual void popupChild();

    // selection list
    QList<TileWidget> selected();
    			
    // children list
    QList<TileWidget> children();
    			
	public slots:
    // Sorts the children using the n-th key.
    virtual void sort(int number);

    virtual bool eventFilter(QObject *o, QEvent *e);
		
		virtual void triggerUpdate();
	public slots:
    void setStartView(const QString&);
    void setStartView(TileWidget *);
		
    // screen update
    virtual void screenUpdate();
  protected:
    // private data
    int childW, childH;
    int xSpacing, ySpacing;
    int currentKey;
    int childType;

    QPopupMenu *mainPopup, *sortPopup, *childPopup;
    void querySorting();
    QString childMimeType;
    bool fixedHeight, wResize, allwaysPopup, allowMultiple, enableDrags, showSort;
    bool canDoResizeHere;
    bool isDoResize;
    // internal event handlers
    virtual void resizeEvent(QResizeEvent *e); // handles resize events
    			
    // internal methods
    virtual int makePosChain(); // computes widget positions and move widget at this position, returning the new viewport width or height, according to the current sort chain

    void handleMouseDoubleClickEvent( TileWidget *, QMouseEvent *e );
    void handleMousePressEvent( TileWidget *, QMouseEvent *e );
    void handleMouseReleaseEvent( TileWidget *, QMouseEvent *e );
    void handleMouseMoveEvent( TileWidget *, QMouseEvent *e );

    void beginUnclippedPainter();
    void endUnclippedPainter();
    void endRectDraw();
    void startRectDraw();
    void continueRectDraw( int );
		void drawLines();
		void eraseLines();
		void blackLines();
		
    QPainter* unclippedPainter;
    int currentColumn;
    int currentColumnWidth;
		int oldColumnWidth;
		bool _canDrawLines;

	bool m_isDragging;
};

#endif
