/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * $Id: mainwindow.cpp,v 1.22 2001/07/09 18:00:58 eug Exp $
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

 // Eugen C. add the Aethera UIComponents support

#include <ktoolbar.h>
#include <ktoolbarradiogroup.h>
#include <ktoolbarbutton.h>
#include <kmainwindow.h>
#include <kmenubar.h>
#include <kapp.h>
#include <kaboutapplication.h>

#include <qfont.h>
#include <qcolor.h>
#include <qapplication.h>
#include <qmessagebox.h>
#include <qaccel.h>
#include <qvaluelist.h>
#include <qtooltip.h>
#include <qpopupmenu.h>
#include <qmenubar.h>

#include <elineedit.h>
#include <esplash.h>
#include <epopupbutton.h>
#include <ebutton.h>
#include <etoolbarbutton.h>
#include <toolbarseparator.h>
#include <pixmaps.h>
#include <contentswidget.h>
#include <mainwindow.h>
#include <composerwindow.h>
#include <menuid.h>
#include <clientrmi.h>
#include <newfolderdialog.h>
#include <clientvfs.h>
#include <foldertreeitem.h>
#include <sendreceivedialog.h>
#include <clientnotifier.h>
#include <ccenter.h>
#include <datahandlerimpl.h>
#include <cardtileview.h>
#include <groupview.h>
#include <noteview.h>
#include <cardview.h>
#include <bannergraphic.h>
#include <contentswidget.h>
#include <browsewidget.h>

// For UI component support
#include <pluginmanager.h>
#include <uiservice.h>
#include <uicomponent.h>
#include <jabberservice.h>
#include <korganizerservice.h>

extern KApplication *Kapp;
extern ContentsWidget *ContentsWid;
extern KConfig *GlobalConfig;
extern ESplash *s;

#include "../plugins/mailfilter/mailfilter_plugin.h"
extern MailFilter *mailFilter;

MainWindow *MainWindow::inst;

MainWindow *MainWindow::ref()
{
	return inst;
}

MainWindow::MainWindow():KDockMainWindow(0)
{
	inst=this;
	
	// Create ContentsWidget as main DockWidget
	KDockWidget *mainDock;
	mainDock = createDockWidget("Content", QPixmap());
	m_contentsWidget = new ContentsWidget(mainDock);
	mainDock->setWidget(m_contentsWidget);
	setView(mainDock);
	setMainDockWidget(mainDock);

	// Create Banner graphic
	KDockWidget *dockTop;
	dockTop = createDockWidget("Banner", QPixmap());
	m_bannerGraphic = new BannerGraphic(dockTop);
	dockTop->setWidget(m_bannerGraphic);
	dockTop->manualDock(mainDock, KDockWidget::DockTop, 0);

	// Create BrowseWidget, default to LHS of ContentsWidget
	KDockWidget* dockLeft;
	dockLeft = createDockWidget("Folders", QPixmap());
	m_browseWidget = new BrowseWidget(dockLeft);
	dockLeft->setWidget(m_browseWidget);
	dockLeft->manualDock(mainDock, KDockWidget::DockLeft, 20 );

	// Force DnD flag on toplevel window to be set. Although
	// the FolderTree in BrowseWidget calls this method on itself,
	// it does not propogate to the toplevel window because of
	// the KDockWidget implementation.
	setAcceptDrops(true);

	initComponents();
  initBrowseToolBar();
	s->setTicks(82,PROGRESS_TOOLBARS);
	s->setActive(PROGRESS_TOOLBARS, true);
	s->setActive(PROGRESS_WINDOWS, false);
	initMenu();
	s->tick("Building toolbars (1)...");			// toolbar
	initMailToolBar();
	s->tick("Building toolbars (2)...");			// toolbar
	initGroupsToolBar();
	s->tick("Building toolbars (3)...");			// toolbar
	initContactsToolBar();
	s->tick("Building toolbars (4)...");			// toolbar
	initNotesToolBar();
	s->tick("Building toolbars (5)...");			// toolbar
	initWelcomeToolBar();
	// XXX:DIMI
	s->tick("Building toolbars (6)...");			// toolbar
	if( componentsDict.find("jabber") )
	  initJabberToolBar();
	// / XXX:DIMI
	if( componentsDict.find("korganizer") )
	  initKOrganizerToolBar();
	
	statusBar()->setFixedHeight(18);
	s->tick("Finishing setup...");			// toolbar
	updateArrows();

	s->tick();			// toolbar
	QAccel *kaccel=new QAccel(this);
	s->tick();			// toolbar
	kaccel->connectItem(kaccel->insertItem(Key_F5), this,
			    SLOT(startButtonSendReceive()));
	
	s->tick();			// toolbar
	GlobalConfig->setGroup("Appearance");
	s->tick();			// toolbar
	setGeometry(GlobalConfig->readRectEntry("Geometry"));
		
	s->tick();			// toolbar
	setMode("welcome");
	s->tick();			// toolbar
	
	sendReceiveDialog=new SendReceiveDialog();

	connect(ClientNotifier::thisInstance(),
		SIGNAL(showProgress(const QString &)),
		sendReceiveDialog, SLOT(showProgress(const QString &)));

	setCaption("Aethera Beta 4");
		
	statusBar()->message("Ready");
};

MainWindow::~MainWindow()
{
  //remove all the UI components
  for(ComponentsMapIterator it=componentsMap.begin(); it!=componentsMap.end(); ++it)
    delete (*it);
  //clear the components lists
  componentsMap.clear();
  componentsDict.clear();
}

void MainWindow::initMenu()
{
	newPopup=new QPopupMenu(this);
	newPopup->insertItem("&Folder", this, SLOT(newFolder()), ALT+Key_F);
	newPopup->insertItem("&Message", this, SLOT(newMessage()), ALT+Key_M);
	newPopup->insertItem("&Contact", this, SLOT(newContact()), ALT+Key_C);
	newPopup->insertItem("&Group", this, SLOT(newGroup()), ALT+Key_G);
	newPopup->insertItem("&Note", this, SLOT(newNote()), ALT+Key_N);
	s->tick();			// toolbar (5x)
	
	filePopup=new QPopupMenu(this);
	s->tick();			// toolbar
	filePopup->insertItem("&New", newPopup);
	filePopup->insertItem("&Save as");
	filePopup->insertSeparator();
//	filePopup->insertItem("&Import");
//	filePopup->insertItem("&Export");
//	filePopup->insertItem("&Archive");
//	filePopup->insertSeparator();
//	filePopup->insertItem("Print setup");
//	filePopup->insertItem("&Print");
//	filePopup->insertSeparator();
//	filePopup->insertItem("&Work offline");
//	filePopup->insertSeparator();
	filePopup->insertItem("E&xit", this, SLOT(quitApp()));
	
	selectPopup=new QPopupMenu(this);
	s->tick();			// toolbar
	selectPopup->insertItem("Sender");
	selectPopup->insertItem("Subject");
	selectPopup->insertItem("Date");
	
	editPopup=new QPopupMenu(this);
	s->tick();			// toolbar
	editPopup->insertItem("&Undo", this, SLOT(undoAction()), 0, ID_UNDO);
	editPopup->insertItem("&Redo", this, SLOT(redoAction()), 0, ID_REDO);
	editPopup->insertSeparator();
	editPopup->insertItem("Cu&t", this, SLOT(cutSelection()), CTRL+Key_X, ID_CUT_OBJECT);
	editPopup->insertItem("&Copy", this, SLOT(copySelection()), CTRL+Key_C, ID_COPY_OBJECT);
	editPopup->insertItem("&Paste", this, SLOT(paste()), CTRL+Key_V, ID_PASTE_OBJECT);
	editPopup->insertItem("&Delete", this, SLOT(deleteSelection()), Key_Delete, ID_DELETE_OBJECT);
	editPopup->insertSeparator();
	editPopup->insertItem("Select &all", this, SLOT(selectAll()), CTRL+Key_A, ID_SELECT_ALL);
	editPopup->insertItem("Select by", selectPopup, ID_SELECT_BY);
	editPopup->insertSeparator();
	editPopup->insertItem("&Move to folder", this, SLOT(moveSelectionTo()), 0, ID_MOVETO_OBJECT);
	editPopup->insertItem("Copy to folder", this, SLOT(copySelectionTo()), 0, ID_COPYTO_OBJECT);
	editPopup->insertSeparator();
	editPopup->insertItem("Mark selected read", this, SLOT(markRead()), 0, ID_MARK_READ);
	editPopup->insertItem("Mark selected unread", this, SLOT(markUnread()), 0, ID_MARK_UNREAD);
	editPopup->insertItem("Mark all read", this, SLOT(markAllRead()), 0, ID_MARK_ALL_READ);
	editPopup->insertItem("Mark all unread", this, SLOT(markAllUnread()), 0, ID_MARK_ALL_READ);
	editPopup->insertSeparator();
	editPopup->insertItem("&Toggle flag", this, SLOT(toggleFlag()), 0, ID_TOGGLE_FLAG);
	editPopup->insertItem("Change color", this, SLOT(changeColor()), 0, ID_CHANGE_COLOR);
	editPopup->insertSeparator();
	editPopup->insertItem("Categories", this, SLOT(setCategory()), 0, ID_SET_CATEGORY);
	editPopup->insertSeparator();
	editPopup->insertItem("&Properties", this, SLOT(editProperties()), 0, ID_EDIT_PROPERTIES);
	
	viewPopup=new QPopupMenu(this);
	s->tick();			// toolbar
//	viewPopup->insertItem("T&hreaded view");
//	viewPopup->insertItem("&List view");
//	viewPopup->insertItem("&Tile view");
//	viewPopup->insertSeparator();
	viewPopup->insertItem("&Folder tree", this, SLOT(toggleFolderTree()), 0, ID_TOGGLE_FOLDER_TREE);
	viewPopup->insertItem("&Aethera bar", this, SLOT(toggleMagellanBar()), 0, ID_TOGGLE_MAGELLAN_BAR);
	viewPopup->insertItem("My &shortcuts", this, SLOT(toggleMyShortcuts()), 0, ID_TOGGLE_MY_SHORTCUTS);
	viewPopup->insertItem("&Collapsed view", this, SLOT(toggleCollapsedView()), 0, ID_TOGGLE_COLLAPSED_VIEW);
	
	sendReceivePopup=new QPopupMenu(this);
	connect(sendReceivePopup, SIGNAL(aboutToShow()), this, SLOT(genSendReceiveMenus()));
	connect(sendReceivePopup, SIGNAL(activated(int)), this, SLOT(startSendReceive(int)));
	s->tick();			// toolbar
	sendPopup=new QPopupMenu(this);
	connect(sendPopup, SIGNAL(aboutToShow()), this, SLOT(genSendReceiveMenus()));
	connect(sendPopup, SIGNAL(activated(int)), this, SLOT(startSend(int)));
	s->tick();			// toolbar
	receivePopup=new QPopupMenu(this);
	connect(receivePopup, SIGNAL(aboutToShow()), this, SLOT(genSendReceiveMenus()));
	connect(receivePopup, SIGNAL(activated(int)), this, SLOT(startReceive(int)));
	s->tick();			// toolbar
	
	quickFiltersPopup=new QPopupMenu(this);
	s->tick();			// toolbar
	quickFiltersPopup->insertItem("Junk mail from this sender");
	quickFiltersPopup->insertItem("Always move message to ...");
	quickFiltersPopup->insertItem("Always change color to ...");
	quickFiltersPopup->insertItem("Always mark as read");
	
	toolsPopup=new QPopupMenu(this);
	s->tick();			// toolbar
	toolsPopup->insertItem("Send/Receive", sendReceivePopup);
	toolsPopup->insertItem("&Send", sendPopup);
	toolsPopup->insertItem("&Receive", receivePopup);
	toolsPopup->insertSeparator();
//	toolsPopup->insertItem("&Find");
//	toolsPopup->insertSeparator();
	toolsPopup->insertItem("Fil&ters", this, SLOT(slotConfigureMailFilter()), 0, ID_MAIL_FILTER);
	toolsPopup->insertItem("&Quick filters", quickFiltersPopup);
//	toolsPopup->insertSeparator();
//	toolsPopup->insertItem("&Empty Deleted Mail");
//	toolsPopup->insertSeparator();
//	toolsPopup->insertItem("Si&gnatures");
//	toolsPopup->insertSeparator();
//	toolsPopup->insertItem("&My business card");
//	toolsPopup->insertSeparator();
//	toolsPopup->insertItem("&Vacation response");
	
	forwardPopup=new QPopupMenu(this);
	s->tick();			// toolbar
	forwardPopup->insertItem("&Quoted", this, SLOT(forwardQuoted()));
	forwardPopup->insertItem("&Inline", this, SLOT(forwardInline()));
	forwardPopup->insertItem("As &attachment", this, SLOT(forwardAsAttachment()));
			
	gotoPopup=new QPopupMenu(this);
	s->tick();			// toolbar
	gotoPopup->insertItem("next", this, SLOT(goNext()), 0, ID_NEXT); // dynamic
	gotoPopup->insertItem("prev", this, SLOT(goPrev()), 0, ID_PREV); // dynamic
//	gotoPopup->insertSeparator();
//	gotoPopup->insertItem("Next unread message");
//	gotoPopup->insertItem("Previous unread message");
//	gotoPopup->insertSeparator();
//	gotoPopup->insertItem("Next selected message");
//	gotoPopup->insertItem("Previous selected message");
//	gotoPopup->insertSeparator();
//	gotoPopup->insertItem("Next flagged message");
//	gotoPopup->insertItem("Previous flagged message");
//	gotoPopup->insertSeparator();
//	gotoPopup->insertItem("Next important message");
//	gotoPopup->insertItem("Previous important message");
	
	sortPopup=new QPopupMenu(this);
	sortPopup->insertItem("&Sender");
	sortPopup->insertItem("&Name");
	sortPopup->insertItem("Sub&ject");
	sortPopup->insertItem("&Date");
	sortPopup->insertItem("&Color");
	s->tick();			// toolbar
	
	actionsPopup=new QPopupMenu(this);
	s->tick();			// toolbar
	actionsPopup->insertItem("new", this, SLOT(newObject()), 0, ID_NEW_OBJECT); // dynamic
	actionsPopup->insertSeparator();
	actionsPopup->insertItem("&Open");
	actionsPopup->insertSeparator();
	actionsPopup->insertItem("&Reply", this, SLOT(reply()));
	actionsPopup->insertItem("Reply to &all", this, SLOT(replyAll()));
	actionsPopup->insertItem("&Forward", forwardPopup);
	actionsPopup->insertSeparator();
	actionsPopup->insertItem("Send &mail to ...");
	actionsPopup->insertSeparator();
	actionsPopup->insertItem("&Sort by", sortPopup);
	actionsPopup->insertSeparator();
	actionsPopup->insertItem("&Go to", gotoPopup);
	
	optionsPopup=new QPopupMenu(this);
	s->tick();			// toolbar
	optionsPopup->insertItem("&Configuration browser", this, SLOT(controlCenter()));
	optionsPopup->insertSeparator();

	QPopupMenu *opt_abook, *opt_mail, *opt_view, *opt_other;

	opt_abook = new QPopupMenu(this);
	opt_abook->insertItem(QString::fromLatin1("Contacts"));
	opt_abook->insertItem(QString::fromLatin1("Groups"));
	opt_abook->insertItem(QString::fromLatin1("Other"));

	opt_mail = new QPopupMenu(this);
	opt_mail->insertItem(QString::fromLatin1("Accounts"));
	opt_mail->insertItem(QString::fromLatin1("Send/Receive"));
	opt_mail->insertItem(QString::fromLatin1("Other"));

	opt_view = new QPopupMenu(this);
	opt_view->insertItem(QString::fromLatin1("Formatting"));
	opt_view->insertItem(QString::fromLatin1("View"));

	opt_other = new QPopupMenu(this);
	opt_other->insertItem(QString::fromLatin1("Other"));

	optionsPopup->insertItem(QString::fromLatin1("&Address book"), opt_abook);
	optionsPopup->insertItem(QString::fromLatin1("&Mail"), opt_mail);
	optionsPopup->insertItem(QString::fromLatin1("&View"), opt_view);
	optionsPopup->insertItem(QString::fromLatin1("&Other"), opt_other);

	
	helpPopup=new QPopupMenu(this);
	s->tick();			// toolbar
	helpPopup->insertItem("&Contents");
	helpPopup->insertItem("&Search");
	helpPopup->insertSeparator();
	helpPopup->insertItem("About &Aethera", this, SLOT(aboutMagellan()));
	
	menuBar()->insertItem("&File", filePopup);
	menuBar()->insertItem("&Edit", editPopup);
	menuBar()->insertItem("&View", viewPopup);
	menuBar()->insertItem("&Actions", actionsPopup);
	menuBar()->insertItem("&Tools", toolsPopup);
	menuBar()->insertItem("&Options", optionsPopup);
	menuBar()->insertSeparator();
	menuBar()->insertItem("&Help", helpPopup);
	s->tick();			// toolbar (8x)
}

bool MainWindow::insertComponent(UIComponent *component)
{
  componentsMap.insert(component->idNumber(), component);
  componentsDict.insert(component->idName(), component);

  return true;
}

void MainWindow::initComponents()
{
  unsigned uId=0;

	// Add all the UI components
	UIComponent *component;
	// Add Home
	component = new UIComponent(uId, "welcome", "/Magellan", "home", "welcome");
	insertComponent(component);
	uId++;
	// Add Contacts
	component = new UIComponent(uId, "contacts", "/Magellan/Contacts");
	insertComponent(component);
	uId++;
	// Add Mail
	component = new UIComponent(uId, "mail", "/Magellan/Mail");
	insertComponent(component);
	uId++;
	// Add Notes
	component = new UIComponent(uId, "notes", "/Magellan/Notes");
	insertComponent(component);
	uId++;
	// Add Groups
//	component = new UIComponent(uId, "groups", "/Magellan/Groups");
//	insertComponent(component);
//	uId++;
	// Add Plug Ins
	// Add the jabber plug in if it is available
	UIService *jabber = dynamic_cast<UIService*> ( PlugInManager::thisInstance()->serviceManager->registeredProvider(JABBERSERVICE_SERVICE) );
	if( jabber )
	{
  	component = new UIComponent(uId, "jabber", "/Magellan/Jabber", jabber->mainIcon().latin1(), "welcome");
  	insertComponent(component);
	  uId++;
	}
	// Add the KOrganizer plug in if it is available
	UIService *korganizer = dynamic_cast<UIService*> ( PlugInManager::thisInstance()->serviceManager->registeredProvider(KORGANIZERSERVICE_SERVICE) );
	if( korganizer )
	{
  	component = new UIComponent(uId, "korganizer", "/Magellan/KOrganizer", korganizer->mainIcon().latin1(), "welcome");
  	insertComponent(component);
	  uId++;
	}
}

void MainWindow::initBrowseToolBar()
{
	KToolBar *tb = toolBar("BrowseToolBar");
	KToolBarRadioGroup *rg = new KToolBarRadioGroup(tb);
	tb->setBarPos(KToolBar::Left);

  for(ComponentsMapIterator it=componentsMap.begin(); it!=componentsMap.end(); ++it)
  {
		tb->insertButton(it.data()->iconName + "_off.png", it.key());
		tb->setToggle(it.key());
		rg->addButton(it.key());

		KToolBarButton *b = tb->getButton(it.key());

		QIconSet is(BarIcon(it.data()->iconName));
		b->setOnIconSet(is);
		if(b->isOn()) {
			b->setPixmap(BarIcon(QString(it.data()->iconName) + "_on.png"));
		} else {
			b->setPixmap(BarIcon(QString(it.data()->iconName) + "_off.png"));
		}
	}

	connect(tb, SIGNAL(clicked(int)),
		this, SLOT(slotBrowseToolBarClicked(int)));

	connect(tb, SIGNAL(toggled(int)),
		this, SLOT(slotBrowseToolBarToggled(int)));

	// store for use in slotBrowseToolBarToggled
	m_browseToolBar = tb;

	// Activate 'home'
	tb->toggleButton(0);
}

void MainWindow::initGroupsToolBar()
{
	/*
	 *	Groups toolbar
	 */
	EPopupButton *new_group_popup=new EPopupButton(toolBar("groups"));
	s->tick();			// toolbar
	new_group_popup->button()->setNormalPixmap(BarIcon("new-group-normal"));
	new_group_popup->button()->setFocusPixmap(BarIcon("new-group-focus"));
	new_group_popup->button()->setClickedPixmap(BarIcon("new-group-focus"));
	new_group_popup->button()->setText(" New group ");
	connect(new_group_popup->button(), SIGNAL(clicked()), this, SLOT(newGroup()));

	toolSeparator(toolBar("groups"));
	
	EToolBarButton *cut_group=new EToolBarButton(BarIcon("cut"), toolBar("groups"));
	s->tick();			// toolbar
	EToolBarButton *copy_group=new EToolBarButton(BarIcon("copy"), toolBar("groups"));
	s->tick();			// toolbar
	EToolBarButton *paste_group=new EToolBarButton(BarIcon("paste"), toolBar("groups"));
	s->tick();			// toolbar
	EToolBarButton *delete_group=new EToolBarButton(BarIcon("delete"), toolBar("groups"));
	
	connect(cut_group, SIGNAL(clicked()), this, SLOT(cutSelection()));
	connect(copy_group, SIGNAL(clicked()), this, SLOT(copySelection()));
	connect(paste_group, SIGNAL(clicked()), this, SLOT(paste()));
	connect(delete_group, SIGNAL(clicked()), this, SLOT(deleteSelection()));
	s->tick();			// toolbar

	toolSeparator(toolBar("groups"));

	EToolBarButton *print_group;
	print_group=new EToolBarButton(BarIcon("print"), toolBar("groups"));
	s->tick();			// toolbar

	toolSeparator(toolBar("groups"));

	
	EToolBarButton *help_group=new EToolBarButton(toolBar("groups"));
	s->tick();			// toolbar
	help_group->setNormalPixmap(BarIcon("help-normal"));
	help_group->setFocusPixmap(BarIcon("help-focus"));
	help_group->setClickedPixmap(BarIcon("help-focus"));

	help_group->setFixedWidth(help_group->width());
}

void MainWindow::initMailToolBar()
{
	EToolBarButton *newmail_button = new EToolBarButton(BarIcon("mail-new"),
							    toolBar("mail"));
	connect(newmail_button, SIGNAL(clicked()), this, SLOT(newMessage()));

	QToolTip::add(newmail_button, "New mail message");

	toolSeparator(toolBar("mail"));
	
	EToolBarButton *cutmail_button=new EToolBarButton(BarIcon("cut"),
							  toolBar("mail"));
	s->tick();			// toolbar
	EToolBarButton *copymail_button=new EToolBarButton(BarIcon("copy"),
							   toolBar("mail"));
	s->tick();			// toolbar
	EToolBarButton *pastemail_button=new EToolBarButton(BarIcon("paste"),
							    toolBar("mail"));
	s->tick();			// toolbar
	EToolBarButton *deletemail_button=new EToolBarButton(BarIcon("delete"),
							     toolBar("mail"));
	connect(cutmail_button, SIGNAL(clicked()), this, SLOT(cutSelection()));
	connect(copymail_button, SIGNAL(clicked()), this, SLOT(copySelection()));
	connect(pastemail_button, SIGNAL(clicked()), this, SLOT(paste()));
	connect(deletemail_button, SIGNAL(clicked()),
		this, SLOT(deleteSelection()));
	s->tick();			// toolbar

	toolSeparator(toolBar("mail"));

	EToolBarButton *printmail_button;
	printmail_button=new EToolBarButton(BarIcon("print"), toolBar("mail"));
	s->tick();			// toolbar

	toolSeparator(toolBar("mail"));

	EToolBarButton *getmail_button=new EToolBarButton(toolBar("mail"), "getmail button");
	s->tick();			// toolbar
	getmail_button->setNormalPixmap(BarIcon("mail-send-receive"));
	getmail_button->setFocusPixmap(BarIcon("mail-send-receive"));
	getmail_button->setClickedPixmap(BarIcon("mail-send-receive"));
	connect(getmail_button, SIGNAL(clicked()), this, SLOT(startButtonSendReceive()));

	toolSeparator(toolBar("mail"));

	EToolBarButton *forward_button=new EToolBarButton(toolBar("mail"), "forward button");
	s->tick();			// toolbar
	forward_button->setNormalPixmap(BarIcon("mail-forward"));
	forward_button->setFocusPixmap(BarIcon("mail-forward"));
	forward_button->setClickedPixmap(BarIcon("mail-forward"));
	connect(forward_button, SIGNAL(clicked()), this, SLOT(forward()));

	EToolBarButton *reply_button=new EToolBarButton(toolBar("mail"), "reply button");
	s->tick();			// toolbar
	reply_button->setNormalPixmap(BarIcon("mail-reply"));
	reply_button->setFocusPixmap(BarIcon("mail-reply"));
	reply_button->setClickedPixmap(BarIcon("mail-reply"));
	connect(reply_button, SIGNAL(clicked()), this, SLOT(reply()));

	EToolBarButton *replyall_button=new EToolBarButton(toolBar("mail"), "replyall button");
	s->tick();			// toolbar
	replyall_button->setNormalPixmap(BarIcon("mail-reply-all"));
	replyall_button->setFocusPixmap(BarIcon("mail-reply-all"));
	replyall_button->setClickedPixmap(BarIcon("mail-reply-all"));
	connect(replyall_button, SIGNAL(clicked()), this, SLOT(replyAll()));
	
	toolSeparator(toolBar("mail"));

	arrowdown_button = new EToolBarButton(BarIcon("mail-next"), toolBar("mail"));
	connect(arrowdown_button, SIGNAL(clicked()), this, SLOT(goNext()));
	s->tick();			// toolbar

	arrowup_button = new EToolBarButton(BarIcon("mail-previous"), toolBar("mail"));
	connect(arrowup_button, SIGNAL(clicked()), this, SLOT(goPrev()));
	
	// set tooltips and arrow behavior
	updateArrows();

	arrowup_button->setFixedWidth(arrowup_button->width());
}

void MainWindow::initNotesToolBar()
{
	/*
	 *	Notes toolbar
	 */
	EToolBarButton *new_note = new EToolBarButton(BarIcon("note-new"),
						      toolBar("notes"));
	s->tick();			// toolbar
	connect(new_note, SIGNAL(clicked()), this, SLOT(newNote()));
	
	toolSeparator(toolBar("notes"));

	EToolBarButton *cut_note=new EToolBarButton(BarIcon("cut"), toolBar("notes"));
	EToolBarButton *copy_note=new EToolBarButton(BarIcon("copy"), toolBar("notes"));
	EToolBarButton *paste_note=new EToolBarButton(BarIcon("paste"), toolBar("notes"));
	EToolBarButton *delete_note=new EToolBarButton(BarIcon("delete"), toolBar("notes"));
	connect(cut_note, SIGNAL(clicked()), this, SLOT(cutSelection()));
	connect(copy_note, SIGNAL(clicked()), this, SLOT(copySelection()));
	connect(paste_note, SIGNAL(clicked()), this, SLOT(paste()));
	connect(delete_note, SIGNAL(clicked()), this, SLOT(deleteSelection()));
	s->tick();			// toolbar (4x)

	toolSeparator(toolBar("notes"));

	EToolBarButton *print_note;
	print_note=new EToolBarButton(BarIcon("print"), toolBar("notes"));
	s->tick();			// toolbar

	toolSeparator(toolBar("notes"));
	
	EToolBarButton *send_note=new EToolBarButton(BarIcon("note-send"), toolBar("notes"));
	s->tick();			// toolbar

	send_note->setFixedWidth(send_note->width());
}

void MainWindow::initContactsToolBar()
{
	/*
	 *	Contacts toolbar
	 */

	EToolBarButton *new_contact = new EToolBarButton(BarIcon("contact-new"), toolBar("contacts"));
	connect(new_contact, SIGNAL(clicked()), this, SLOT(newContact()));
/*
  EPopupButton *new_contact_popup=new EPopupButton(toolBar("contacts"));
	s->tick();			// toolbar
  new_contact_popup->button()->setNormalPixmap(BarIcon("contact-new"));
  new_contact_popup->button()->setFocusPixmap(BarIcon("contact-new"));
  new_contact_popup->button()->setClickedPixmap(BarIcon("contact-new"));
	connect(new_contact_popup->button(), SIGNAL(clicked()), this, SLOT(newContact()));
*/
	toolSeparator(toolBar("contacts"));

	EToolBarButton *cut_contact=new EToolBarButton(BarIcon("cut"), toolBar("contacts"));
	EToolBarButton *copy_contact=new EToolBarButton(BarIcon("copy"), toolBar("contacts"));
	EToolBarButton *paste_contact=new EToolBarButton(BarIcon("paste"), toolBar("contacts"));
	EToolBarButton *delete_contact=new EToolBarButton(BarIcon("delete"), toolBar("contacts"));
	connect(cut_contact, SIGNAL(clicked()), this, SLOT(cutSelection()));
	connect(copy_contact, SIGNAL(clicked()), this, SLOT(copySelection()));
	connect(paste_contact, SIGNAL(clicked()), this, SLOT(paste()));
	connect(delete_contact, SIGNAL(clicked()), this, SLOT(deleteSelection()));
	s->tick();			// toolbar (4x)

	toolSeparator(toolBar("contacts"));

	EToolBarButton *print_contact;
	print_contact=new EToolBarButton(BarIcon("print"), toolBar("contacts"));
	s->tick();			// toolbar

	toolSeparator(toolBar("contacts"));

	EToolBarButton *email_contact=new EToolBarButton(toolBar("contacts"));
	s->tick();			// toolbar
	email_contact->setNormalPixmap(BarIcon("mail-new"));
	email_contact->setFocusPixmap(BarIcon("mail-new"));
	email_contact->setClickedPixmap(BarIcon("mail-new"));

	email_contact->setFixedWidth(email_contact->width());
/*
  toolSeparator(toolBar("contacts"));
	
  EToolBarButton *help_contact=new EToolBarButton(toolBar("contacts"));
	s->tick();			// toolbar
  help_contact->setNormalPixmap(BarIcon("help-normal"));
  help_contact->setFocusPixmap(BarIcon("help-focus"));
  help_contact->setClickedPixmap(BarIcon("help-focus"));

  help_contact->setFixedWidth(help_contact->width());
*/
}

void MainWindow::initWelcomeToolBar()
{
	/*
	 *	Welcome toolbar
	 */

	EToolBarButton *new_mail = new EToolBarButton(BarIcon("mail-new"), toolBar("welcome"));
	connect(new_mail, SIGNAL(clicked()), this, SLOT(newMessage()));
/*
  EPopupButton *new_welcome_popup=new EPopupButton(toolBar("welcome"));
	s->tick();			// toolbar
  new_welcome_popup->button()->setNormalPixmap(BarIcon("mail-new"));
  new_welcome_popup->button()->setFocusPixmap(BarIcon("mail-new"));
  new_welcome_popup->button()->setClickedPixmap(BarIcon("mail-new"));
	new_welcome_popup->button()->setText(" New mail ");
	connect(new_welcome_popup->button(), SIGNAL(clicked()), this, SLOT(newMessage()));
*/
	toolSeparator(toolBar("welcome"));

	EToolBarButton *printmail_button=new EToolBarButton(BarIcon("print"), toolBar("welcome"));
	printmail_button->setFixedWidth(printmail_button->width());

/*
  toolSeparator(toolBar("welcome"));
	
  EToolBarButton *help_welcome=new EToolBarButton(toolBar("welcome"));
	s->tick();			// toolbar
  help_welcome->setNormalPixmap(BarIcon("help-normal"));
  help_welcome->setFocusPixmap(BarIcon("help-focus"));
  help_welcome->setClickedPixmap(BarIcon("help-focus"));

  help_welcome->setFixedWidth(help_welcome->width());
	
	toolBar("welcome")->setFixedHeight(toolBar("mail")->height());
*/
}

// XXX:DIMI
void MainWindow::initJabberToolBar()
{
	/*
	 *	Jabber toolbar
	 */

	toolSeparator(toolBar("welcome"));
}
// / XXX:DIMI

void MainWindow::initKOrganizerToolBar()
{
	toolSeparator(toolBar("welcome"));
}

void MainWindow::quitApp()
{
	//TODO: check if there are mounted remote folders
	// if so, unmount it
 	saveAppearance();
 	Kapp->quit();
}

void MainWindow::closeEvent(QCloseEvent *)
{
	quitApp();
}


void MainWindow::slotBrowseToolBarClicked(int id)
{
  ComponentsMapIterator it = componentsMap.find(id);
	if( it==componentsMap.end() )
		return;//Warn the user here
	else
		m_browseWidget->usePathAsRoot( it.data()->folderName );
}

void MainWindow::slotBrowseToolBarToggled(int id)
{
  ComponentsMapIterator it = componentsMap.find(id);
	if( it==componentsMap.end() )
		return;//Warn the user here
	else
	{
  	KToolBarButton *b = m_browseToolBar->getButton(id);

  	if (b->isOn())
  		b->setPixmap(BarIcon(it.data()->iconName + "_on.png"));
  	else
  		b->setPixmap(BarIcon(it.data()->iconName + "_off.png"));
	}
}

void MainWindow::saveAppearance()
{
	GlobalConfig->setGroup("Appearance");
	GlobalConfig->writeEntry("Geometry", geometry());
}

void MainWindow::showComponentToolBar(const QString &mode)
{
  for(ComponentsDictIterator it(componentsDict); it.current(); ++it)
    toolBar( it.current()->toolbarName )->hide();

  UIComponent *showComp = componentsDict.find(mode);
  if( showComp )
    toolBar( showComp->toolbarName )->show();
}

void MainWindow::setMode(const QString &mode)
{
	currentMode=mode;

	// update banner graphic to reflect current view type
	m_bannerGraphic->setMode(mode);
	
	if(mode=="mail" || mode=="genmail" || mode=="inbox" ||
	   mode=="outbox" || mode=="sent" || mode=="saved" ||
	   mode=="drafts" || mode=="deleted" || mode=="imap")
	{
	  //show the mail toolbar only
	  showComponentToolBar("mail");
		
		// set "new" option
		actionsPopup->changeItem(ID_NEW_OBJECT, "New message");
		
		// set "prev" and "next" options
		gotoPopup->changeItem(ID_NEXT, "Next message");
		gotoPopup->changeItem(ID_PREV, "Previous message");
		
		// enable "Select by" popup
		editPopup->setItemEnabled(ID_SELECT_BY, true);
	}
	else if(mode=="notes")
	{
	  //show the notes toolbar only
	  showComponentToolBar("notes");
		
		// set "new" option
		actionsPopup->changeItem(ID_NEW_OBJECT, "New note");
		
		// set "prev" and "next" options
		gotoPopup->changeItem(ID_NEXT, "Next note");
		gotoPopup->changeItem(ID_PREV, "Previous note");
		
		// disable "Select by" popup
		editPopup->setItemEnabled(ID_SELECT_BY, false);
	}
	else if(mode=="contacts")
	{
	  //show the contacts toolbar only
	  showComponentToolBar("contacts");
		
		// set "new" option
		actionsPopup->changeItem(ID_NEW_OBJECT, "New contact");
		
		// set "prev" and "next" options
		gotoPopup->changeItem(ID_NEXT, "Next contact");
		gotoPopup->changeItem(ID_PREV, "Previous contact");
		
		// disable "Select by" popup
		editPopup->setItemEnabled(ID_SELECT_BY, false);
	}
	else if(mode=="welcome")
	{
	  //show the welcome toolbar only
	  showComponentToolBar("welcome");
		
		// set "new" option
		actionsPopup->changeItem(ID_NEW_OBJECT, "New message");
		
		// disable "Select by" popup
		editPopup->setItemEnabled(ID_SELECT_BY, false);
	}
	else if(mode=="groups")
	{
	  //show the groups toolbar only
	  showComponentToolBar("groups");
		
		// set "new" option
		actionsPopup->changeItem(ID_NEW_OBJECT, "New group");
		
		// set "prev" and "next" options
		gotoPopup->changeItem(ID_NEXT, "Next group");
		gotoPopup->changeItem(ID_PREV, "Previous group");
		
		// disable "Select by" popup
		editPopup->setItemEnabled(ID_SELECT_BY, false);
	}
	else if(mode=="jabber")
	  //show the jabber toolbar only
	  showComponentToolBar("jabber");
	else if(mode=="korganizer")
	  showComponentToolBar("korganizer");
}

bool MainWindow::isOffline()
{
	return false;
}

void MainWindow::updateArrows()
{
  GlobalConfig->setGroup("Misc Mail");
  arrow_goto=GlobalConfig->readEntry("Goto");
  if(arrow_goto!="unread" && arrow_goto!="flagged" && arrow_goto!="first" && arrow_goto!="priority")
    arrow_goto="unread";
  QString utxt, dtxt;
  QToolTip::remove(arrowup_button);
  QToolTip::remove(arrowdown_button);
  if(arrow_goto=="unread")
  {
    dtxt="Next unread message";
    utxt="Previous unread message";
  }
  else
  if(arrow_goto=="flagged")
  {
    dtxt="Next flagged message";
    utxt="Previous flagged message";
  }
  else
  if(arrow_goto=="priority")
  {
    dtxt="Next high priority message";
    utxt="Previous high priority message";
  }
  else
  {
    dtxt="Next message";
    utxt="Previous message";
  }
	
  QToolTip::add(arrowup_button, utxt);
  QToolTip::add(arrowdown_button, dtxt);
}

void MainWindow::goNext()
{
  ContentsWidget::ref()->showNext(arrow_goto, true);
}

void MainWindow::goPrev()
{
  ContentsWidget::ref()->showNext(arrow_goto, false);
}

void MainWindow::controlCenter()
{
	ControlCenter *cc=new ControlCenter(this);
	cc->show();
}

void MainWindow::controlCenter_Accounts()
{
	ControlCenter *cc=new ControlCenter(this);
	cc->show();
}

void MainWindow::controlCenter_Notes()
{
	ControlCenter *cc=new ControlCenter(this);
	cc->show();
}

void MainWindow::aboutMagellan()
{
	KAboutData *kabd = new KAboutData("Aethera", "aethera", "0.9.3", "Unified Messaging and Groupware", KAboutData::License_GPL_V2, "(C) 2001 theKompany", NULL, "http://www.theKompany.com/", "@theKompany.com");
	
	kabd->addAuthor ("Eugen Constantinescu", "Programming", "eug@thekompany.com");
	kabd->addAuthor ("John L Grantham", "User Interface artwork design", "john@grantham.com");
	kabd->addCredit ("Based on the August 2000 version of Magellan");
	
	KAboutApplication *kab = new KAboutApplication(kabd);

	kab->exec();
}

void MainWindow::genSendReceiveMenus()
{
	sendReceivePopup->clear();
	sendPopup->clear();
	receivePopup->clear();
	
	accounts=ClientRMI::ref()->getAccountNames();

	bool hasActiveAccounts=false;
		
	for (unsigned int i = 0; i < accounts.count(); i++)
	{
		if (ClientRMI::ref()->isAccountActive(accounts[i]))
		{
			hasActiveAccounts=true;
			sendReceivePopup->insertItem(accounts[i], this, SLOT(startSendReceive(int)), 0, i+3);
			sendPopup->insertItem(accounts[i], this, SLOT(startSend(int)), 0, i+3);
			receivePopup->insertItem(accounts[i], this, SLOT(startReceive(int)), 0, i+3);
		}
	}
	
	if(hasActiveAccounts)
	{
		int allAccel=0, defAccel=0;
		
		GlobalConfig->setGroup("Accelerators");
		if(GlobalConfig->readEntry("F5")=="all")
			allAccel=Key_F5;
		else
			defAccel=Key_F5;
		
		sendReceivePopup->insertSeparator(0);
		sendPopup->insertSeparator(0);
		receivePopup->insertSeparator(0);
		
		sendReceivePopup->insertItem("All accounts", this, SLOT(startSendReceive(int)), allAccel, 0, 0);
		sendPopup->insertItem("All accounts", this, SLOT(startSend(int)), 0, 0, 0);
		receivePopup->insertItem("All accounts", this, SLOT(startReceive(int)), 0, 0, 0);
		
		sendReceivePopup->insertItem("Default account", this, SLOT(startSendReceive(int)), defAccel, 1, 0);
		sendPopup->insertItem("Default account", this, SLOT(startSend(int)), 0, 1, 0);
		receivePopup->insertItem("Default account", this, SLOT(startReceive(int)), 0, 1, 0);
	}
}

void MainWindow::startSendReceive(int id)
{
	sendReceiveDialog->start();
		
	if(!id)
	{
		for (unsigned int i = 0; i < accounts.count(); i++)
			if(ClientRMI::ref()->isAccountActive(accounts[i]))
				ClientRMI::ref()->startSendReceive(accounts[i]);
	}
	else if(id==1)
	{
		ClientRMI::ref()->startSendReceive(ClientRMI::ref()->getDefaultAccount());
	}
	else
	{
		ClientRMI::ref()->startSendReceive(accounts[id-3]);
	}
}

void MainWindow::startSend(int id)
{
	sendReceiveDialog->start();
		
	if (!id)
	{
		for (unsigned int i=0;i<accounts.count();i++)
			if(ClientRMI::ref()->isAccountActive(accounts[i]))
				ClientRMI::ref()->startSend(accounts[i]);
	}
	else if (id == 1)
	{
		ClientRMI::ref()->startSend(ClientRMI::ref()->getDefaultAccount());
	}
	else
	{
		ClientRMI::ref()->startSend(accounts[id-3]);
	}
}

void MainWindow::startReceive(int id)
{
	sendReceiveDialog->start();
		
	if (!id)
	{
		for (unsigned int i = 0; i < accounts.count(); i++)
			if(ClientRMI::ref()->isAccountActive(accounts[i]))
				ClientRMI::ref()->startReceive(accounts[i]);
	}
	else if(id==1)
	{
		ClientRMI::ref()->startReceive(ClientRMI::ref()->getDefaultAccount());
	}
	else
	{
		// debug
		printf("MainWindow: startReceive selected, account %s\n", (const char *)accounts[id-3]);
		
		ClientRMI::ref()->startReceive(accounts[id-3]);
	}
}

void MainWindow::startButtonSendReceive()
{
	GlobalConfig->setGroup("Accelerators");
	if(GlobalConfig->readEntry("F5")=="all")
		startSendReceive(0);
	else
		startSendReceive(1);
}

void MainWindow::newObject()
{
	if(currentMode=="mail")
		newMessage();
	else if(currentMode=="contacts")
		newContact();
	else if(currentMode=="groups")
		newGroup();
	else if(currentMode=="notes")
		newNote();
}

void MainWindow::newFolder()
{
	NewFolderDialog *d=new NewFolderDialog();
	int res=d->exec();
	
	if(res==QDialog::Accepted)
	{
		// create folder
		QString name=d->nameEdit->text();
		QString viewType,type;
		QString dialogType=d->typeCombo->text(d->typeCombo->currentItem());
		VFolder *parent=(d->getSelection()!=0)?((VFolder *)d->getSelection()->getVItem()):0;
		
		if(parent)
		{
		  // checking the types
		  bool bType=false;
		  QString parentType=parent->type();
		
  		if(dialogType=="Mail")
  		{
    		viewType="mail";
    		if( parentType=="genmail" || parentType=="mail" ||
    		   (parentType=="imap" && parent->viewType()=="genmail") )
    		{
    		  type=parentType;
    		  bType=true;
    		}
  		}
  		else if(dialogType=="Contacts")
  		{
    		viewType="contacts";
    		if( parentType==viewType )
    		{
    		  type=parentType;
    		  bType=true;
    		}
  		}
  		else if(dialogType=="Groups")
  		{
    		viewType="groups";
    		if( parentType==viewType )
    		{
    		  type=parentType;
    		  bType=true;
    		}
  		}
  		else if(dialogType=="Notes")
  		{
    		viewType="notes";
    		if( parentType==viewType )
    		{
    		  type=parentType;
    		  bType=true;
    		}
  		}
  		else if(dialogType=="Group mail")
  		{
    		viewType="genmail";
    		if( parentType=="genmail" || parentType=="mail" ||
    		   (parentType=="imap" && parent->viewType()=="genmail") )
    		{
    		  type=parentType;
    		  bType=true;
    		}
  		}
  		
  		if( bType )
  		{
  			if(VFolder *newFolder=ClientVFS::thisInstance()->createFolder(parent, name, type, viewType))
  			{
  				BrowseWidget::ref()->createFolderView(newFolder);
  				ContentsWidget::ref()->createFolderView(newFolder);
  			}
  			else
  			{
  			  if( type!="imap" )
    				// debug
    				printf("mainwindow: failed to create folder.\n");
  			}
  		}
  		else
  		{
  			QMessageBox::warning(this,"Create new folder",
  			        "Aethera can create folders with a type like the parent folder type.",
  			        "&Ok");
  		}
		}
		else
		{
			QMessageBox::warning(this,"Create new folder","Please select a parent folder from the folder tree"
				" before trying to create the folder","&Ok");
		}
	}
	
	delete d;
}

void MainWindow::createFolderView(VFolder* newFolder)
{
	if(newFolder)
	{
		BrowseWidget::ref()->createFolderView(newFolder);
		ContentsWidget::ref()->createFolderView(newFolder);
	}
}

void MainWindow::newMessage()
{
	ComposerWindow *cWin=new ComposerWindow();
	cWin->show();
}

void MainWindow::newContact()
{
	DataHandler *h=dynamic_cast<DataHandler *>(ContentsWidget::ref()->getCurrentView());
	if(h)
	{
		h->newObject();
	}
	else
	{
		VFolder *f=ClientVFS::thisInstance()->folderRef("/Magellan/Contacts");
		if(f)
		{
			DataHandler *sysh=dynamic_cast<CardView *>(f->getView());
			if(sysh) sysh->newObject();
			else printf("mainwindow: [newContact] cast rendered null\n");
		}
		else
		{
			printf("mainwindow: [newContact] could not get main contacts folder\n");
		}
	}
}

void MainWindow::newGroup()
{
	DataHandler *h=dynamic_cast<DataHandler *>(ContentsWidget::ref()->getCurrentView());
	if(h)
	{
		h->newObject();
	}
	else
	{
		VFolder *f=ClientVFS::thisInstance()->folderRef("/Magellan/Groups");
		if(f)
		{
			DataHandler *sysh=dynamic_cast<GroupView *>(f->getView());
			if(sysh) sysh->newObject();
		}
	}
}

void MainWindow::newNote()
{
	DataHandler *h=dynamic_cast<DataHandler *>(ContentsWidget::ref()->getCurrentView());
	if(h)
	{
		h->newObject();
	}
	else
	{
		VFolder *f=ClientVFS::thisInstance()->folderRef("/Magellan/Notes");
		if(f)
		{
			DataHandler *sysh=dynamic_cast<NoteView *>(f->getView());
			if(sysh) sysh->newObject();
		}
	}
}

void MainWindow::cutSelection()
{
	DataHandler *h=dynamic_cast<DataHandler *>(ContentsWidget::ref()->getCurrentView());
	if(h)
	{
		h->cutSelection();
	}
}

void MainWindow::paste()
{
	DataHandler *h=dynamic_cast<DataHandler *>(ContentsWidget::ref()->getCurrentView());
	if(h) h->paste();
}

void MainWindow::copySelection()
{
	DataHandler *h=dynamic_cast<DataHandler *>(ContentsWidget::ref()->getCurrentView());
	if(h) h->copySelection();
}

void MainWindow::deleteSelection()
{
	DataHandler *h=dynamic_cast<DataHandler *>(ContentsWidget::ref()->getCurrentView());
	if(h) h->deleteSelection();
}

void MainWindow::selectAll()
{
	DataHandler *h=dynamic_cast<DataHandler *>(ContentsWidget::ref()->getCurrentView());
	if(h) h->selectAll();
}

void MainWindow::moveSelectionTo()
{
	DataHandler *h=dynamic_cast<DataHandler *>(ContentsWidget::ref()->getCurrentView());
	if(h) h->moveSelectionTo();
	else printf("mainwindow: [moveSelectionTo] not a datahandler\n");
}

void MainWindow::copySelectionTo()
{
	DataHandler *h=dynamic_cast<DataHandler *>(ContentsWidget::ref()->getCurrentView());
	if(h) h->copySelectionTo();
	else printf("mainwindow: [copySelectionTo] not a datahandler\n");
}

void MainWindow::changeColor()
{
}

void MainWindow::setCategory()
{
}

void MainWindow::editProperties()
{
	DataHandlerImpl *h=dynamic_cast<DataHandlerImpl *>(ContentsWidget::ref()->getCurrentView());
	if(h) h->editProperties();
}

void MainWindow::reply()
{
	MailListView *view=dynamic_cast<MailListView *>(ContentsWidget::ref()->getCurrentView());
	if(view) view->reply();
}

void MainWindow::replyAll()
{
	MailListView *view=dynamic_cast<MailListView *>(ContentsWidget::ref()->getCurrentView());
	if(view) view->replyAll();
}

void MainWindow::forward()
{
	MailListView *view=dynamic_cast<MailListView *>(ContentsWidget::ref()->getCurrentView());
	if(view) view->forward();
}

void MainWindow::forwardInline()
{
	MailListView *view=dynamic_cast<MailListView *>(ContentsWidget::ref()->getCurrentView());
	if(view) view->forwardInline();
}

void MainWindow::forwardQuoted()
{
	MailListView *view=dynamic_cast<MailListView *>(ContentsWidget::ref()->getCurrentView());
	if(view) view->forwardQuoted();
}

void MainWindow::forwardAsAttachment()
{
	MailListView *view=dynamic_cast<MailListView *>(ContentsWidget::ref()->getCurrentView());
	if(view) view->forwardAsAttachment();
}

void MainWindow::markRead()
{
	MailListView *view=dynamic_cast<MailListView *>(ContentsWidget::ref()->getCurrentView());
	if(view) view->markRead();
}

void MainWindow::markUnread()
{
	MailListView *view=dynamic_cast<MailListView *>(ContentsWidget::ref()->getCurrentView());
	if(view) view->markUnread();
}

void MainWindow::markAllRead()
{
	MailListView *view=dynamic_cast<MailListView *>(ContentsWidget::ref()->getCurrentView());
	if(view) view->markAllRead();
}

void MainWindow::markAllUnread()
{
	MailListView *view=dynamic_cast<MailListView *>(ContentsWidget::ref()->getCurrentView());
	if(view) view->markAllUnread();
}

void MainWindow::toggleFlag()
{
	MailListView *view=dynamic_cast<MailListView *>(ContentsWidget::ref()->getCurrentView());
	if(view) view->toggleFlag();
}

void MainWindow::undoAction()
{
}

void MainWindow::redoAction()
{
}

void MainWindow::toggleFolderTree()
{
}

void MainWindow::toggleMagellanBar()
{
}

void MainWindow::toggleMyShortcuts()
{
}

void MainWindow::toggleCollapsedView()
{
}

ToolBarSeparator* MainWindow::toolSeparator(QWidget *parent, const char *name)
{
	return new ToolBarSeparator(parent, name);
}

void MainWindow::slotConfigureMailFilter()
{
	mailFilter->configure(0L,0L);
}















