/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <kapp.h>
#include <kconfig.h>
#include <kiconloader.h>

#include <groupobj.h>
#include <templateview.h>
#include <brokeriface.h>
#include <qmessagebox.h>
#include <grouptilewidget.h>
#include <pixtoolbox.h>
#include <groupdialog.h>
#include <stdio.h>
#include <videotoolbox.h>
#include <tilewidget.h>

extern KConfig *GlobalConfig;
extern PixmapToolBox ptb;

QDict<QWidget> GroupTileWidget::groupEditDialogs;

//#define DEBUG_GTW
#define IDSTRING "GroupTileWidget: "

GroupTileWidget::GroupTileWidget(GroupTileView *parent, GroupObject *item, 
		const char *name, const char */*fname*/):
		TileWidget(parent, name), TemplateView(item), TextFitter()
{
#ifdef DEBUG_GTW
	printf(IDSTRING"contructor: enter\n");
#endif
	_localParent=parent;
  
	resize(80,80);
	groupEditDialogs.setAutoDelete(false);
	setBackgroundColor(QColor("white"));

	item->setIconView(this);

	ntxt=new QLabel(this);
	ntxt->setBackgroundColor(QColor("white"));
	ntxt->setFont(QFont("helvetica", 10));
	ntxt->setAlignment(AlignCenter);

	npix=new QLabel(this);
	npix->setBackgroundColor(QColor("white"));

	npix->move(27, 9);
	npix->resize(36,36);
	npix->setAlignment(AlignVCenter | AlignHCenter);

	ntxt->setAlignment(AlignTop|AlignHCenter);
	ntxt->setFont(QFont("helvetica", 10));
	ntxt->move(5, 50);
	ntxt->setFixedSize(80, 15);

	update();

	installEventFilter(parent);
	npix->installEventFilter(parent);
	ntxt->installEventFilter(parent);

#ifdef DEBUG_GTW
	printf(IDSTRING"Text [%s]\n",(const char *)ntxt->text());
	printf(IDSTRING" width:%d height:%d\n",width(), height());
#endif
	npix->show();
	ntxt->show();
	
	// debug
#ifdef DEBUG_GTW
	printf(IDSTRING"constructor: exit\n");
#endif
}

GroupTileWidget::~GroupTileWidget()
{
}

QString GroupTileWidget::key(int number)
{
	QString s;
	if (number==0)
		s = static_cast<GroupObject *>(getVItem())->groupName();
	if (number==1)
		s = static_cast<GroupObject *>(getVItem())->classes()[0];
	return s;
}

int GroupTileWidget::keyCount()
{
	return 2;
}

QString GroupTileWidget::keyName(int number)
{
	QString s;
	if(number==0)
		s="Name";
	if(number==1)
		s="Class";
	return s;
}

void GroupTileWidget::setTitle(const char *t)
{
	QString txt = QString::fromLatin1(t);
	if (txt.isEmpty())
		txt=QString::fromLatin1("Undefined");
	QFont f=font();
	f.setBold(true);
	ntxt->setText(fitText(txt, 80, f));
}

void GroupTileWidget::setIcon(const QString &c)
{
	GlobalConfig->setGroup("Group Icons");
	if(c.isEmpty())
	{
		npix->setPixmap(QPixmap(GlobalConfig->readEntry("Default pixmap")));
	}
	else
	{
		KIconLoader kil;
		npix->setPixmap(ptb.compoundPixmap(kil.loadIcon(c, 0), BarIcon("MASK-group")));
	}
		
}

void GroupTileWidget::deleteData()
{
	GroupObject *item=static_cast<GroupObject *>(getVItem());

	if(BrokerInterface::thisInstance()->remove(item->path()))
	{
		// remove this widget from the view list, so that it doesn't get deleted twice
		item->setIconView(0);
		// delete the associated object - this will automatically delete all the other views
		delete item;
	}
	else
	{
		QMessageBox::information(0, "Delete failed",
			QString("Could not delete object.\nReason: ")+BrokerInterface::thisInstance()->lastError(), 1);
	}
}

void GroupTileWidget::setState(ViewState state)
{
	DataWidget::setState(state);
 	
 	if(state==Selected)
		ntxt->setFont(QFont("helvetica", 10, QFont::Bold));
	else
		ntxt->setFont(QFont("helvetica", 10, QFont::Normal));

	ntxt->repaint();
}

void GroupTileWidget::open()
{
	GroupDialog *gd=static_cast<GroupDialog *>(dialogGroupQuery(group()->path()));
	if (gd)
		gd->raise();
	else
	{
		gd=new GroupDialog();
		QString str;
		gd->setCaption(str);
		gd->setObject((GroupObject *)getVItem());
		addGroupDialog(((GroupObject *)getVItem())->path(), gd);
		connect(gd, SIGNAL(dialogClosed(QString)), this, SLOT(removeDialog(QString)));
		gd->show();
	}
}

void GroupTileWidget::update()
{
	setIcon(group()->icon());
	setTitle(((GroupObject *)getVItem())->groupName());
	((SortingWidget *)localParent())->screenUpdate();
}

GroupObject *GroupTileWidget::group()
{
	return ((GroupObject *)getVItem());
}


QWidget *GroupTileWidget::dialogGroupQuery(QString path)
{
#ifdef DEBUG_GTW
	printf(IDSTRING"Querying: %s %p\n", (const char *)path, groupEditDialogs[path]);
#endif
	return groupEditDialogs[path];
}

void GroupTileWidget::addGroupDialog(QString path, QWidget *widget)
{
#ifdef DEBUG_GTW
	printf(IDSTRING"Adding: %s\n", (const char *)path);
#endif
	if(!groupEditDialogs[path])
		groupEditDialogs.insert(path, widget);
}

void GroupTileWidget::removeGroupDialog(QString path)
{
#ifdef DEBUG_GTW
	printf(IDSTRING"Removing: %s\n", (const char *)path);
#endif
	groupEditDialogs.remove(path);
}

void GroupTileWidget::removeDialog(QString path)
{
	removeGroupDialog(path);
}

QWidget* GroupTileWidget::localParent()
{
  return _localParent;
}
