/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * $Id: grouptileview.cpp,v 1.3 2001/07/09 18:00:58 eug Exp $
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <kiconloader.h>
#include <qmessagebox.h>

#include <grouptileview.h>
#include <pixmaps.h>
#include <templateview.h>
#include <vfolder.h>
#include <brokeriface.h>
#include <clientvfs.h>
#include <groupobj.h>
#include <grouptilewidget.h>
#include <groupdialog.h>
#include <datahandlerimpl.h>

#define IDSTRING "GroupTileView: "

#define DEBUG_GTV

GroupTileView::GroupTileView(VFolder *folder, QWidget *parent, const char *name):SortingWidget(parent, name), TemplateView(folder)
{
	// set parameters
	setChildWidth(80);
	setChildHeight(80);
	setChildFixedHeight(true);
	
	// make the popups
  makeGlobalPopup();
  makeChildPopup();
	
	// scan for groups
	QList<VObject> groupList=folder->objectList();
	GroupObject *go;
	GroupTileWidget *gtw;
	for(unsigned int i=0; i < groupList.count(); i++)
	{
	  if( folder->isSimpleObject(groupList.at(i)->name()) )
	  {
#ifdef DEBUG_GTV
  		printf("GroupTileView (%s): adding child %s\n",
  			(const char *)folder->path(),
  			(const char *)groupList.at(i)->name());
#endif
  		go=(GroupObject *)(groupList.at(i));
  		gtw=new GroupTileWidget(this, go);
  		//go->setView(gtw);
  		addChild(gtw);
	  }
	}
	
	screenUpdate();
}

void GroupTileView::makeGlobalPopup()
{
  mainPopup=new QPopupMenu();

  mainPopup->insertItem(QIconSet(BarIcon("contacts-group-small")),
		"New Group", this, SLOT(slotNewObject()));
  mainPopup->insertSeparator();
  mainPopup->insertItem(QIconSet(QPixmap(paste_xpm)), "Paste", this, SLOT(slotPaste()));
}

void GroupTileView::makeChildPopup()
{
  childPopup=new QPopupMenu();

  childPopup->insertItem("Open", this, SLOT(openSelection()));
  childPopup->insertItem(QIconSet(BarIcon("contacts-group-small")), "New group", this, SLOT(slotNewObject()));
  childPopup->insertSeparator();
  childPopup->insertItem(QIconSet(QPixmap(cut_xpm)), "Cut", this,
      SLOT(slotCutSelection()));
  childPopup->insertItem(QIconSet(QPixmap(copy_xpm)), "Copy", this,
      SLOT(slotCopySelection()));
  childPopup->insertItem(QIconSet(QPixmap(paste_xpm)), "Paste", this,
      SLOT(slotPaste()));
  childPopup->insertSeparator();
  childPopup->insertItem(QIconSet(QPixmap(delete_xpm)), "Delete", this,
      SLOT(slotDeleteSelection()));
  childPopup->insertItem("Select all", this, SLOT(slotSelectAll()));
  childPopup->insertSeparator();
  childPopup->insertItem(QIconSet(QPixmap(send_xpm)), "Send mail to...");
}

void GroupTileView::newObject()
{
	// try to create a new object
	QString id=BrokerInterface::thisInstance()->createObject(getVItem()->path());
	GroupObject *item=(GroupObject *)ClientVFS::thisInstance()->_fact_ref(getVItem()->path()+"/"+id, "groups");
	
	// check for failures
	if(!item)
	{
		QMessageBox::information(0, "Creation failed",
			QString("Could not create a new object in this folder.\nReason: ")+BrokerInterface::thisInstance()->lastError(), 1);
	}
	else
	{
		// save the new object, as it might have some default data
		GroupDialog *gd=new GroupDialog(true, 0);
		QString str = QString::fromLatin1("Group: %1");
		str = str.arg((item->groupName() == QString::null) ?
			QString::fromLatin1("Undefined") :
			item->groupName());
		gd->setCaption(str);
		gd->setObject(item);
		GroupTileWidget::addGroupDialog(item->path(), gd);
		GroupTileWidget::addGroupDialog(item->path(), gd);
		connect(gd, SIGNAL(dialogClosed(QString)), this, SLOT(removeDialog(QString)));
		gd->show();
	}
}

void GroupTileView::openSelection()
{
	QList<DataWidget> sList=getSelection();
	GroupTileWidget *w;
	
	for(unsigned int i=0;i<sList.count();i++)
	{
		w=(GroupTileWidget *)sList.at(i);
		printf("GroupTileWidget: Item: %s\n", w->group()->path().latin1());
		GroupDialog *gd=static_cast<GroupDialog *>(w->dialogGroupQuery(w->group()->path().latin1()));
		if (gd)
			gd->raise();
		else
		{
			gd=new GroupDialog(false, 0);
			QString str = QString::fromLatin1("Group: %s");
			str = str.arg( (w->group()->groupName()==QString::null) ?
				QString::fromLatin1("Undefined"):
				w->group()->groupName());
			gd->setCaption(str);
			GroupTileWidget::addGroupDialog(w->group()->path(), gd);
			gd->setObject(w->group());
			connect(gd, SIGNAL(dialogClosed(QString)), this, SLOT(removeDialog(QString)));
			gd->show();
		}
	}
}
void GroupTileView::removeDialog(QString str)
{
	GroupTileWidget::removeGroupDialog(str);
}

void GroupTileView::slotOpenSelection()
{
	openSelection();
}

void GroupTileView::slotNewObject()
{
	newObject();
}

void GroupTileView::slotDeleteSelection()
{
	deleteSelection();
}

void GroupTileView::slotCopySelection()
{
	copySelection();
}

void GroupTileView::slotCutSelection()
{
	cutSelection();
}

void GroupTileView::slotPaste()
{
	paste();
}

void GroupTileView::slotSelectAll()
{
}

