/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>

#include <kstddirs.h>

#include <vfolder.h>
#include <vfolderattribute.h>
#include <clientvfs.h>
#include <containerwidget.h>

ContainerWidget::ContainerWidget(VFolder *f, QWidget *parent=0, const char *name=0) :
	KHTMLPart(parent, name), TemplateView(f)
{
	setFolder(f);
}
void ContainerWidget::buildWidget()
{
#if 0
	autoloadImages(true);
	QString buffer;
	QString path = locate("appdata","container.html");
	QFile fp(path);
	int pos;
  if(!fp.open(IO_ReadOnly))
	{
/*
		begin(QString("file:/") + path);
  	write("<html><body bgcolor=\"white\">"
						"<table border=0 width=\"100%\" height=\"100%\"><tr>"
						"<td valign=\"middle\" align=\"center\"><font face=\"arial, helvetica\" size=\"+2\">"
						"Could not open template file."
						"</font></td></tr></table></body></html>");
  	end();
*/
		return;
	}
	
	QTextStream txt(&fp);
  while(!txt.atEnd())
    buffer+=txt.readLine()+"\n";
  fp.close();
	// replacing the name
	QString temp="<!-- Name -->";
	pos=buffer.find(temp);
	if(pos>=0)
	{
		buffer.replace(pos, temp.length(), folder()->name());
	}
	temp="<!-- Body -->";
	pos=buffer.find(temp);
	if(pos>=0)
	{
		QString tbuf;
		buildTable(folder()->path(),tbuf,maxDepth(folder()->path())+3, 3);
		tbuf.prepend("<br><br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<table border=0>").append("</table>");
		buffer.replace(pos, temp.length(), tbuf);
	}
	
	begin(QString("file:/") + path);
  write((const char *)buffer);
  end();
#endif
}

void ContainerWidget::buildTable(QString path, QString &buffer, int mDepth, int fDepth)
{
	VFolder *vfolder=ClientVFS::thisInstance()->folderRef(path);
#ifdef DEBUG_CW
	printf("Building table for <%s>\n", (const char *)vfolder->name());
#endif
	// build the column and then go to the children...
	QString tmp;
	QString columnColor;
	QString column="<tr>\n";
	for(int i=0;i<fDepth;i++)
		column+="\t<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>\n";
		
	tmp.sprintf("\"%d\"",mDepth-fDepth+1);
	column+="\t<td ";

	columnColor="<span class=\"";
	
	// paint the root differently
	if(fDepth==3)
		columnColor+="firstFolder\">";
	else
		columnColor+="secondFolder\">";
	
	VFolderAttribute *attr;
	if(vfolder->viewType()!="genmail")
	{
		attr=(VFolderAttribute *)ClientVFS::thisInstance()->_fact_ref(vfolder->path()+"/default.fattr",
			"vfolderattribute");
		// do different if there are new messages
		if(attr && attr->recent)
			columnColor+=QString("<a href=\"") + vfolder->path() + "\">";
	}
	columnColor+=vfolder->name();
	if(vfolder->viewType()!="genmail")
	{
		// then the folder has "new messages"
		if(attr && attr->recent)
		{
			QString temp;
			columnColor+=QString("</a>&nbsp;&nbsp;&nbsp;<font color=\"black\">(<font color=\"red\">")+QString::number(attr->recent)+"</font>)</font>";
		}
	}
	columnColor+="</span>";
	
	if(mDepth-fDepth+1>1)
		column += QString("colspan=")+ tmp + ">";
	else
		column += QString(">");
	column += columnColor +"</td>\n";
	column+="</tr>\n";
	
	buffer+=column;
	
	QStringList folders=ClientVFS::thisInstance()->folderList(path);
  for(int i=0;i<folders.count();i++)
  {
    buildTable(folders[i], buffer, mDepth, fDepth+1);
  }
}

int ContainerWidget::maxDepth(QString path, int depth=0)
{
	int d=0;
  QStringList folders=ClientVFS::thisInstance()->folderList(path);
  if(folders.count()==0)
		return depth;
	int d1;
  for(int i=0;i<folders.count();i++)
  {
    d1=maxDepth(folders[i], depth+1);
		d=(d<d1)?d1:d;
  }
	return d;
}
int ContainerWidget::newMessages(QString path)
{
	VFolder *vfolder=ClientVFS::thisInstance()->folderRef(path);
	VFolderAttribute *attr=
		(VFolderAttribute *)ClientVFS::thisInstance()->_fact_ref(vfolder->path()+"/default.fattr",
		"vfolderattribute");
  QStringList folders=ClientVFS::thisInstance()->folderList(path);
  if(folders.count()==0)
		return attr->recent;
	int d=0;
  for(int i=0;i<folders.count();i++)
  {
    d+=newMessages(folders[i]);
  }
	return d;
}




void ContainerWidget::setFolder(VFolder *f)
{
	_folder=f;
}
VFolder *ContainerWidget::folder()
{
	return _folder;
}


