/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * $Id: composereditor.cpp,v 1.2 2001/05/18 04:05:10 alex Exp $
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <kconfig.h>
#include <qsplitter.h>
#include <qmultilineedit.h>
#include <qfont.h>
#include <composereditor.h>

extern KConfig *GlobalConfig;

ComposerEditor::ComposerEditor(QWidget *parent, const char *name)
:QSplitter(QSplitter::Vertical, parent, name)
{
	editBox=new QMultiLineEdit(this);
	signatureViewer=new SignatureViewer(this);
	
	GlobalConfig->setGroup("Composer");
	if(GlobalConfig->hasKey("Font"))
		editBox->setFont(GlobalConfig->readFontEntry("Font"));
	else
		editBox->setFont(QFont("courier", 12));
	
	editBox->setWordWrap(QMultiLineEdit::WidgetWidth);
	
	editBox->show();
	signatureViewer->hide();
}

ComposerEditor::~ComposerEditor()
{
	delete signatureViewer;
	delete editBox;
}

void ComposerEditor::setText(const QString &txt)
{
	editBox->setText(txt);
}

QString ComposerEditor::text()
{
	return userText()+signatureText();
}

QString ComposerEditor::userText()
{
	return editBox->text();
}

QString ComposerEditor::signatureText()
{
	return QString::null;
}

void ComposerEditor::transferSignature()
{
}
