/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef HAS_CARDLISTVIEW
#define HAS_CARDLISTVIEW

#include <templateview.h>
#include <vfolder.h>
#include <qlistview.h>
#include <qstringlist.h>
#include <qvaluelist.h>
#include <qlist.h>
#include <datahandlerimpl.h>

/******************* Proportions for the table *****************/

#define NAME_SIZE								20
#define HOME_ADDRESS_SIZE				60
#define PHONE_SIZE							20
#define WORK_ADDRESS_SIZE				60
#define EMAIL_SIZE							20
#define URL_SIZE								40
#define TITLE_SIZE							10
#define ROLE_SIZE								10
#define ORG_SIZE								15
#define CLASS_SIZE							10
#define FN_SIZE									40

class CardView;
class CardListViewItem;

class CardListView : public QListView, public TemplateView, public DataHandlerImpl
{
	Q_OBJECT
	
	 public:
    CardListView(VFolder *parent, CardView *parent, const char *name=0);
    ~CardListView();
    void refreshSum(QStringList &);
    void update();
		
		void newObject();
		void openSelection();
	public slots:
		// slots for the menus
		void slotNewObject();
		void slotOpenSelection();
	protected:
		void viewportResizeEvent(QResizeEvent *re);
	private slots:
		void itemRightClicked(QListViewItem *item, const QPoint &p, int column);
		void itemDoubleClicked(QListViewItem *item);
	private:
		CardListViewItem *childAt(int x, int y);
		int getSize(QString field);
		static QStringList columnTitles;
		static QValueList<int> columnSizes;
		QList <CardListViewItem> items;
		int sum;
		static QPopupMenu *genericMenu, *itemMenu;
		QPoint mousePoint;
		CardListViewItem *currentItem;
};

#endif
