/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <pixlibrary.h>

#include <qintdict.h>
#include <qpixmap.h>
#include <kiconloader.h>

#define IDSTRING "PixLibrary: "

PixLibrary *PixLibrary::pixLibInstance=0;

PixLibrary::PixLibrary()
{
	buffer.setAutoDelete(true);
	load();
}
QPixmap &PixLibrary::pixmap(int identifier)
{
	return *(buffer[identifier]);
}


PixLibrary *PixLibrary::thisInstance()
{
	if(!pixLibInstance)
		pixLibInstance = new PixLibrary();
	return pixLibInstance;
}

void PixLibrary::load()
{
	// the normals
	buffer.insert(PixLibrary::SaveIcon,				new QPixmap(BarIcon("save")));
	buffer.insert(PixLibrary::NewIcon,				new QPixmap(BarIcon("new")));
	buffer.insert(PixLibrary::PrintIcon,			new QPixmap(BarIcon("print")));
	buffer.insert(PixLibrary::GroupIcon,			new QPixmap(BarIcon("contacts-group-small")));
	buffer.insert(PixLibrary::SendMailIcon,		new QPixmap(BarIcon("send")));
	buffer.insert(PixLibrary::BlankIcon,			new QPixmap(BarIcon("empty")));
	buffer.insert(PixLibrary::OkIcon,					new QPixmap(BarIcon("ok")));
	buffer.insert(PixLibrary::CancelIcon,			new QPixmap(BarIcon("cancel")));
	
	// the arrows & help
	buffer.insert(PixLibrary::ArrowUpFocusIcon,		new QPixmap(BarIcon("arrow-up-focus")));
	buffer.insert(PixLibrary::ArrowUpNormalIcon,	new QPixmap(BarIcon("arrow-up-normal")));
	buffer.insert(PixLibrary::ArrowDownFocusIcon,	new QPixmap(BarIcon("arrow-down-focus")));
	buffer.insert(PixLibrary::ArrowDownNormalIcon,new QPixmap(BarIcon("arrow-down-normal")));
	buffer.insert(PixLibrary::HelpFocusIcon,			new QPixmap(BarIcon("help-focus")));
	buffer.insert(PixLibrary::HelpNormalIcon,			new QPixmap(BarIcon("help-normal")));
	
	// the mail tree
	buffer.insert(PixLibrary::TreeContactsIcon, 				new QPixmap(BarIcon("")));
	buffer.insert(PixLibrary::TreeDeletedMessagesIcon, 	new QPixmap(BarIcon("DeletedMessages")));
	buffer.insert(PixLibrary::TreeDocumentsIcon, 				new QPixmap(BarIcon("Documents")));
	buffer.insert(PixLibrary::TreeDraftsIcon, 					new QPixmap(BarIcon("Drafts")));
	buffer.insert(PixLibrary::TreeGroupsIcon, 					new QPixmap(BarIcon("Groups")));
	buffer.insert(PixLibrary::TreeInboxIcon, 						new QPixmap(BarIcon("Inbox")));
	buffer.insert(PixLibrary::TreeJournalIcon, 					new QPixmap(BarIcon("Journal")));
	buffer.insert(PixLibrary::TreeMagellanIcon, 				new QPixmap(BarIcon("Magellan")));
	buffer.insert(PixLibrary::TreeMailContainerIcon, 		new QPixmap(BarIcon("MailContainer")));
	buffer.insert(PixLibrary::TreeMailFolderIcon, 			new QPixmap(BarIcon("MailFolder")));
	buffer.insert(PixLibrary::TreeNotesIcon, 						new QPixmap(BarIcon("Notes")));
	buffer.insert(PixLibrary::TreeOutboxIcon, 					new QPixmap(BarIcon("Outbox")));
	buffer.insert(PixLibrary::TreePersonalIcon, 				new QPixmap(BarIcon("Personal")));
	buffer.insert(PixLibrary::TreeProjectsIcon, 				new QPixmap(BarIcon("Projects")));
	buffer.insert(PixLibrary::TreeSavedMessagesIcon, 		new QPixmap(BarIcon("SavedMessages")));
	buffer.insert(PixLibrary::TreeSchedulerIcon, 				new QPixmap(BarIcon("Scheduler")));
	buffer.insert(PixLibrary::TreeScriptIcon, 					new QPixmap(BarIcon("Script")));
	buffer.insert(PixLibrary::TreeSentMailIcon, 				new QPixmap(BarIcon("SentMail")));
	buffer.insert(PixLibrary::TreeTasksIcon, 						new QPixmap(BarIcon("Tasks")));
	buffer.insert(PixLibrary::TreeTemplatesIcon, 				new QPixmap(BarIcon("Templates")));
	buffer.insert(PixLibrary::TreeTrashIcon, 						new QPixmap(BarIcon("Trash")));
	buffer.insert(PixLibrary::TreeWebIcon, 							new QPixmap(BarIcon("Web")));
	
	// the MailListView
	buffer.insert(PixLibrary::MailAttachmentIcon 			,new QPixmap(BarIcon("attachment")));
	buffer.insert(PixLibrary::MailHigherIcon 					,new QPixmap(BarIcon("higher")));
	buffer.insert(PixLibrary::MailHighestIcon 				,new QPixmap(BarIcon("highest")));
	buffer.insert(PixLibrary::MailLowerIcon 					,new QPixmap(BarIcon("lower")));
	buffer.insert(PixLibrary::MailLowestIcon 					,new QPixmap(BarIcon("lowest")));
	buffer.insert(PixLibrary::MailNewForwardReplyIcon ,new QPixmap(BarIcon("new-forward-reply")));
	buffer.insert(PixLibrary::MailNewForwardIcon 			,new QPixmap(BarIcon("new-forward")));
	buffer.insert(PixLibrary::MailNewNormalIcon 			,new QPixmap(BarIcon("new-normal")));
	buffer.insert(PixLibrary::MailNewReplyIcon 				,new QPixmap(BarIcon("new-reply")));
	buffer.insert(PixLibrary::MailNormalIcon 					,new QPixmap(BarIcon("normal")));
	buffer.insert(PixLibrary::MailOldForwardReplyIcon ,new QPixmap(BarIcon("old-forward-reply")));
	buffer.insert(PixLibrary::MailOldForwardIcon 			,new QPixmap(BarIcon("old-forward")));
	buffer.insert(PixLibrary::MailOldNormalIcon 			,new QPixmap(BarIcon("old-normal")));
	buffer.insert(PixLibrary::MailOldReplyIcon 				,new QPixmap(BarIcon("old-reply")));
	
	// the Control Center
	buffer.insert(PixLibrary::CCenterABActiveIcon					,new QPixmap(BarIcon("ab-focus")));
	buffer.insert(PixLibrary::CCenterABNormalIcon					,new QPixmap(BarIcon("ab-normal")));
	buffer.insert(PixLibrary::CCenterMailActiveIcon				,new QPixmap(BarIcon("mail-focus")));
	buffer.insert(PixLibrary::CCenterMailNormalIcon				,new QPixmap(BarIcon("mail-normal")));
	buffer.insert(PixLibrary::CCenterViewActiveIcon				,new QPixmap(BarIcon("view-focus")));
	buffer.insert(PixLibrary::CCenterViewNormalIcon				,new QPixmap(BarIcon("view-normal")));
	buffer.insert(PixLibrary::CCenterOtherActiveIcon			,new QPixmap(BarIcon("others-focus")));
	buffer.insert(PixLibrary::CCenterOtherNormalIcon			,new QPixmap(BarIcon("others-normal")));
	// the buttons
	buffer.insert(PixLibrary::CCenterAccountsNormalIcon		,new QPixmap(BarIcon("accounts-disabled")));
	buffer.insert(PixLibrary::CCenterAccountsActiveIcon		,new QPixmap(BarIcon("accounts-focus")));
	buffer.insert(PixLibrary::CCenterComposerNormalIcon		,new QPixmap(BarIcon("composer-disabled")));
	buffer.insert(PixLibrary::CCenterComposerActiveIcon		,new QPixmap(BarIcon("composer-focus")));
	buffer.insert(PixLibrary::CCenterContactsNormalIcon		,new QPixmap(BarIcon("contacts-disabled")));
	buffer.insert(PixLibrary::CCenterContactsActiveIcon		,new QPixmap(BarIcon("contacts-focus")));
	buffer.insert(PixLibrary::CCenterFormatOptNormalIcon	,new QPixmap(BarIcon("format-opts-disabled")));
	buffer.insert(PixLibrary::CCenterFormatOptActiveIcon	,new QPixmap(BarIcon("format-opts-focus")));
	buffer.insert(PixLibrary::CCenterGroupsNormalIcon			,new QPixmap(BarIcon("groups-disabled")));
	buffer.insert(PixLibrary::CCenterGroupsActiveIcon			,new QPixmap(BarIcon("groups-focus")));
	buffer.insert(PixLibrary::CCenterMailOptNormalIcon		,new QPixmap(BarIcon("mail-opts-disabled")));
	buffer.insert(PixLibrary::CCenterMailOptActiveIcon		,new QPixmap(BarIcon("mail-opts-focus")));
	buffer.insert(PixLibrary::CCenterNotesNormalIcon			,new QPixmap(BarIcon("notes-disabled")));
	buffer.insert(PixLibrary::CCenterNotesActiveIcon			,new QPixmap(BarIcon("notes-focus")));
	buffer.insert(PixLibrary::CCenterOtherOptNormalIcon		,new QPixmap(BarIcon("other-disabled")));
	buffer.insert(PixLibrary::CCenterOtherOptActiveIcon		,new QPixmap(BarIcon("other-focus")));
	buffer.insert(PixLibrary::CCenterSROptNormalIcon			,new QPixmap(BarIcon("sr-disabled")));
	buffer.insert(PixLibrary::CCenterSROptActiveIcon			,new QPixmap(BarIcon("sr-focus")));
	buffer.insert(PixLibrary::CCenterViewOptNormalIcon		,new QPixmap(BarIcon("view-opts-disabled")));
	buffer.insert(PixLibrary::CCenterViewOptActiveIcon		,new QPixmap(BarIcon("view-opts-focus")));

	// the aethera icon...
	buffer.insert(PixLibrary::MagellanIcon, new QPixmap(BarIcon("aethera")));
}
