/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
 
#include <qmessagebox.h>
#include <existsframe.h>
#include <videotoolbox.h>
#include <definedmessages.h>

extern VideoToolBox vtb;

ExistsFrame::ExistsFrame(QWidget *parent, QString name,
	int x, int y, int dx, int dy, int idx) :
	QFrame(parent, name)
{
	index=idx;
	setGeometry(x, y, dx, dy);
	setFrameStyle(0);
	// Creating the continue-cancel buttons
	// The buttons are going to be in the bottom right
	int x,y;
	x=dx-280, y=dy-vtb.fontHeight();
	backButton=vtb.setUpQPushButton(this,"Back",
		80, vtb.fontHeight(), &x, &y);
	x=dx-180, y=dy-vtb.fontHeight();
	continueButton=vtb.setUpQPushButton(this,"Next",
		80, vtb.fontHeight(), &x, &y);
	continueButton->setDefault(true);
	x=dx-80, y=dy-vtb.fontHeight();
	finishButton=vtb.setUpQPushButton(this,"Cancel",
		80, vtb.fontHeight(), &x, &y);
	// create the text
	int DX=5, DY=5;
	vtb.setUpFonts(QFont("helvetica",12,QFont::Normal));
	text=vtb.setUpLabelSize(this,"The directory you selected already exists. "
		"Do you want to import the old files?", width(),&DX, &DY);
	DY=(dy-vtb.fontHeight()*3-DY)/2 +DY - vtb.fontHeight()/2;
	DX=5;
//	DY+=vtb.fontHeight()+vtb.offsetY();
	radioGroup=new QButtonGroup(this);
	radioGroup->setGeometry(DX,DY,dx,vtb.fontHeight()*3);
	radioGroup->setExclusive(true);
	radioGroup->setFrameStyle(0);
	int dummyDX=DX, dummyDY=DY+vtb.fontHeight()*3;
	warning=vtb.setUpLabelSize(this,"<b>WARNING:</b> "
		"If you choose to start a new configuration, all the files in the specified directories"
		" will be deleted.", width(),&dummyDX, &dummyDY);
	warning->setAlignment(QLabel::WordBreak);
	warning->setFixedHeight(warning->height()*2);
	DY=0;
	DX=(radioGroup->width()-vtb.charSize()*30)/2;
	yesButton=vtb.setUpQRadioButton(radioGroup,
		"Yes, &keep the files.",&DX, &DY);
	yesButton->setChecked(true);
	DX=(radioGroup->width()-vtb.charSize()*30)/2;
	DY+=vtb.fontHeight()+vtb.offsetY();
	noButton=vtb.setUpQRadioButton(radioGroup,
		"No, &start with a new configuration.",&DX, &DY);
	radioGroup->insert(yesButton,1);
	radioGroup->insert(noButton,2);
	connect(radioGroup, SIGNAL(clicked(int)), this, SLOT(radioClicked(int)));
	connect(backButton, SIGNAL(clicked()), this, SLOT(backClicked()));
	connect(continueButton, SIGNAL(clicked()), this, SLOT(continueClicked()));
	connect(finishButton, SIGNAL(clicked()), this, SLOT(finishClicked()));
}
void ExistsFrame::continueClicked()
{
	QStringList rez;
	rez.append("[Directory Exists]");
	if(yesButton->isChecked())
		rez.append("Keep=Yes");
	if(noButton->isChecked())
		rez.append("Keep=No");
	
	emit result(1, index, rez);
	close();
}

void ExistsFrame::finishClicked()
{
	emit result(0, index, QStringList(""));
	close();
}

void ExistsFrame::backClicked()
{
	emit result(BackMessage, index, QStringList(""));
	close();
}

void ExistsFrame::radioClicked(int id)
{
	switch(id)
	{
		case 1: // keep
			break;
		case 2: // don't keep
			/*
			 QMessageBox::warning(this,"Directory", "All the files in the specified"
				" directories will be deleted.","&Ok");
			*/
			break;
	}
}
