/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <congratsframe.h>
#include <videotoolbox.h>
#include <definedmessages.h>

extern VideoToolBox vtb;
extern bool setupDone;

CongratsFrame::CongratsFrame(QWidget *parent, QString name,
	int x, int y, int dx, int dy, int idx) :
	QFrame(parent, name)
{
	index=idx;
	setGeometry(x, y, dx, dy);
	setFrameStyle(0);
	// Creating the continue-cancel buttons
	// The buttons are going to be in the bottom right
	int h,w;
	w=dx-180;
	h=dy-vtb.fontHeight();
	int x,y;
	x=dx-80, y=dy-vtb.fontHeight();
	continueButton=vtb.setUpQPushButton(this,"&Close",
		80, vtb.fontHeight(), &x, &y);
	// create the frame!
	int DX=0, DY=0;
	welcomeView= vtb.setUpTextView(this, QFrame::Panel | QFrame::Plain,
		QColor(200,200,200),
		"<font color=#000000>&nbsp;&nbsp;&nbsp;&nbsp;Congratulations, you have "
		"succesfully created your <font color=#101080>Aethera</font> profile."
		"<br><br>&nbsp;&nbsp;&nbsp;&nbsp;You can run this wizard at any later "
		"date by passing the command line \"-setup\" option to <font "
		"color=#101080>Aethera</font>."
		"<br><br>&nbsp;&nbsp;&nbsp;&nbsp;All the settings you have given, and "
		"many others can be reviewed in <font color=#101080>Aethera</font>'s "
		"Configuration Center</font>.",
		dx,dy-vtb.fontHeight()-vtb.offsetY(),DX,DY);
	welcomeView->setHScrollBarMode(QScrollView::AlwaysOff);
	connect(continueButton, SIGNAL(clicked()), this, SLOT(finishClicked()));
}

void CongratsFrame::finishClicked()
{
	setupDone=true;
	printf("Congrats frame: done\n");
}
