/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <qstring.h>
#include <qstringlist.h>
#include <qdatastream.h>
#include <messagedescriptor.h>
#include <messageclass.h>

MessageDescriptor::MessageDescriptor():requestReceipt(0),red(0),green(0),blue(0),flag(0),persistence(0),_coreLoad(false)
{
}

void MessageDescriptor::setCoreLoad(bool coreLoad)
{
	_coreLoad=coreLoad;
}

void MessageDescriptor::load(MessageClass &message)
{
	from=(const char *)(QCString)message.From;
	to=(const char *)(QCString)message.To;
	cc=(const char *)(QCString)message.Cc;
	bcc=(const char *)(QCString)message.Bcc;
	replyTo=(const char *)(QCString)message.Reply_To;
	
	subject=(const char *)message.Subject;
	messageID=(const char *)message.Message_ID;
	organization=(const char *)message.Organization;
	status=(const char *)message.Status;
	priority=(const char *)message.Priority;
	
	inReplyTo=(const char *)message.In_Reply_To;
	references.clear();
	for(QStrListIterator it(message.References); it.current(); ++it)
	  references.append( it.current() );
	
	contentType=(const char *)message.Content_Type;
	contentEncoding=(const char *)message.Content_Transfer_Encoding;
	
	sentDate=(const char *)(QCString)message.Date;
	route.clear();
	for(QStrListIterator it(message.Received); it.current(); ++it)
	  route.append( it.current() );
	
	attachments=false;
	size=0;
	for(QListIterator<MimePart> it(message.partList); it.current(); ++it)
	{
		if( it.current()->type=="attachment")
		  attachments=true;
		size+=it.current()->length;
	}
	
}

QDataStream& operator>>(QDataStream &stream, MessageDescriptor &descriptor)
{
	// read core data
	stream>>descriptor.from;
	stream>>descriptor.to;
	stream>>descriptor.subject;
	stream>>descriptor.status;
	stream>>descriptor.priority;
	stream>>descriptor.contentType;
	stream>>descriptor.sentDate;
	stream>>descriptor.receivedDate;
	stream>>descriptor.scheduling;
	stream>>descriptor.flags;
	stream>>descriptor.red>>descriptor.green>>descriptor.blue;
	stream>>descriptor.flag;
	stream>>descriptor.inReplyTo;
	stream>>descriptor.references;
	stream>>descriptor.indexID;
	stream>>descriptor.parentIndexID;
	stream>>descriptor.relatedIndexIDList;
	
	// other data
	if(!descriptor._coreLoad)
	{
		stream>>descriptor.replyTo;
		stream>>descriptor.cc;
		stream>>descriptor.bcc;
		stream>>descriptor.messageID;
		stream>>descriptor.organization;
		stream>>descriptor.uid;
		stream>>descriptor.extendedStatus;
		stream>>descriptor.contentEncoding;
		stream>>descriptor.account;
		stream>>descriptor.route;
		stream>>descriptor.requestReceipt;
		stream>>descriptor.archive;
		stream>>descriptor.category;
		stream>>descriptor.persistence;
		stream>>descriptor.extraData;
	}
	
	stream>>descriptor.attachments;
	stream>>descriptor.size;
	
	return stream;
}

QDataStream& operator<<(QDataStream &stream, MessageDescriptor &descriptor)
{
	// write core data
	stream<<descriptor.from;
	stream<<descriptor.to;
	stream<<descriptor.subject;
	stream<<descriptor.status;
	stream<<descriptor.priority;
	stream<<descriptor.contentType;
	stream<<descriptor.sentDate;
	stream<<descriptor.receivedDate;
	stream<<descriptor.scheduling;
	stream<<descriptor.flags;
	stream<<descriptor.red<<descriptor.green<<descriptor.blue;
	stream<<descriptor.flag;
	stream<<descriptor.inReplyTo;
	stream<<descriptor.references;
	stream<<descriptor.indexID;
	stream<<descriptor.parentIndexID;
	stream<<descriptor.relatedIndexIDList;
	
	// other data
	if(!descriptor._coreLoad)
	{
  	stream<<descriptor.replyTo;
  	stream<<descriptor.cc;
  	stream<<descriptor.bcc;
  	stream<<descriptor.messageID;
  	stream<<descriptor.organization;
  	stream<<descriptor.uid;
  	stream<<descriptor.extendedStatus;
  	stream<<descriptor.contentEncoding;
  	stream<<descriptor.account;
  	stream<<descriptor.route;
  	stream<<descriptor.requestReceipt;
  	stream<<descriptor.archive;
  	stream<<descriptor.category;
  	stream<<descriptor.persistence;
  	stream<<descriptor.extraData;
 }
	
	stream<<descriptor.attachments;
	stream<<descriptor.size;
	
	return stream;
}


