/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <datacollection.h>
#include <transactionserver.h>
#include <stdio.h>
#include <assert.h>

//#define DEBUG_DATACOLLECTION

DataCollection::DataCollection(QString prefix)
{
	if(!prefix)
    idPrefix="OBJ";
  else
    idPrefix=prefix;
  objectList.setAutoDelete(false);
	lastIDNum=0;
}

DataCollection::~DataCollection()
{
}

QStringList DataCollection::getEntryList()
{
#ifdef DEBUG_DATACOLLECTION
	printf(">>>>> DataCollection: getEntryList...\n");
#endif
  QStringList t;
  for(int i=0;i<objectList.count();i++)
    t.append(objectList.at(i)->id);
#ifdef DEBUG_DATACOLLECTION
	printf(">>>>> DataCollection: getEntryList %d\n",t.count());
#endif
  return t;
}

QString DataCollection::addEntry()
{
#ifdef DEBUG_DATACOLLECTION
	printf("DataCollection: Adding a new entry...(void)\n");
#endif
  ObjectReference *t=new ObjectReference;
  t->id=nextID();
	t->isNewObject=true;
	if(type==FolderStorage)
		t->filename=t->id;
	t->collection=this;
  t->dirty=false;
  objectList.append(t);
  return t->id;
}

QString DataCollection::addEntry(ObjectReference *obj)
{
#ifdef DEBUG_DATACOLLECTION
	printf("DataCollection: Adding a new entry...(ObjectReference)\n");
#endif
	obj->collection=this;
	obj->dirty=false;
	objectList.append(obj);
	return obj->id;
}

ObjectReference *DataCollection::ref(QString id)
{
  for(int i=0;i<objectList.count();i++)
    if(objectList.at(i)->id==id)
		{
#ifdef DEBUG_DATACOLLECTION
			printf("DataCollection: referring %s\n",(const char *)id);
#endif
      return objectList.at(i);
		}
	return 0;
}

QString DataCollection::nextID()
{
  QString t;
  QDict<ObjectReference> objects=getEntryDict();
  bool bCheck=false;
  unsigned long nextId;

  // check if there are free ids
  for(nextId=1; nextId<=lastIDNum+1; nextId++)
  {
    t.sprintf("%s%09ld", (const char *)idPrefix, nextId);
    // check the dict if there is the "next" entry
    if( !objects[t] )
    {
      bCheck=true;
      break;
    }
  }

  // that's a bug
  assert(bCheck);

  // there wasn't any free id, so just increase the ids number
  if( nextId==lastIDNum+1 )
    lastIDNum++;
  return t;
}

QString DataCollection::lastID()
{
  QString t;
  t.sprintf("%s%09ld", (const char *)idPrefix, lastIDNum);
  return t;
}

bool DataCollection::isValidID(QString id)
{
	if(id.left(idPrefix.length())!=idPrefix)
		return false;
	for(int i=idPrefix.length();i<id.length();i++)
		if(!id[i].isNumber())
			return false;
	
	return true;
}

QDict<ObjectReference> DataCollection::getEntryDict()
{
  QDict<ObjectReference> t;
  for(int i=0;i<objectList.count();i++)
    t.insert(objectList.at(i)->id, objectList.at(i));

  return t;
}

