/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef __IOSyncHandler__
#define __IOSyncHandler__

#include <string>
#include <imap4handler.h>
#include <qstringlist.h>

class IndexClass;
class IncomingMessage;

class IOSyncHandler
{
	public:
		static IOSyncHandler *ref();
		
		/** Dispatch the message to the local inbox folder.*/
		void dispatchToInbox(const IncomingMessage &);
		/** Dispatch the message to the remote mailbox folder.*/
		void dispatchMessage(const IMAP_MESSAGE &, bool);
		/** Update the IMAP messages.*/
		void updateMessage(const IMAP_MESSAGE &);
		/**
		  * It creates the messages from the list and delete the messages from trash.
		  * It is a very useful and important method for the mail folders.
		  */
		void pop3Sync();
		/**
		  * It creates the messages from the list and delete the messages from trash.
		  * It is a very useful and important method for the mail folders.
		  */
		void imap4Sync();
		void unlinkOutgoing(IndexClass *);
		void updateOutgoing(IndexClass *, string);
		/** Create a new folder.*/
		void createFolder(string &parent, string &folderPath, string& type, string &viewType);
		/** Deletee a folder.*/
		void deleteFolder(string &parent, string &folderPath, string& type, string &serverPath);
	private:
		static IOSyncHandler *thisInstance;
		QStringList foldersToSync;
};

#endif






