/***************************************************************************
        stlutil.h  -  STL tools like split and toUpper/toLower
                             -------------------
    begin                : Thu Jul  5 17:35:17 EEST 2001
    copyright            : (C) 2001 by Eugen C.
    email                : eug@thekompany.com
 ***************************************************************************/

#ifndef __STLUtil__
#define __STLUtil__

#include <vector>
#include <list>
#include <string>

typedef vector<int> IntVect;
typedef IntVect::iterator IntVectIt;
typedef vector<unsigned long> ULongVect;
typedef ULongVect::iterator ULongVectIt;
typedef vector<string> StringVect;
typedef StringVect::iterator StringVectIt;

typedef list<int> IntList;
typedef IntList::iterator IntListIt;
typedef list<unsigned long> ULongList;
typedef ULongList::iterator ULongListIt;
typedef list<string> StringList;
typedef StringList::iterator StringListIt;

class STLUtil
{
	public:
	  enum SPLIT_TYPES {DEFAULT_SPLIT=0, WHITE_SPACES};
	
	  /** Split the string with a char delimiter.*/
		virtual vector<string> split(char, const string&);
	  /** Split the input string with a string delimiter.*/
		virtual vector<string> split(const char*, const string&);
	  /** Split the input string with some special delimiters.*/
		virtual vector<string> split(const int, const string&);
		
    /**
      * Skip the spaces from line begining with uPos.
      */
    virtual unsigned skipSpaces(string& line, unsigned uPos=0) const;

    /**
      * Parse the first word from the line begining with uPos.
      * For IMAP the word delimiter is the space char.
      */
    virtual unsigned parseNextWord(string &strWord, string &line, unsigned uPos=0);

    /** To Upper.*/
    virtual void toUpper(string &strWord);
    /** To Lower.*/
    virtual void toLower(string &strWord);
};

#endif

