/***************************************************************************
        stlutil.cpp  -  STL tools like split and toUpper/toLower
                             -------------------
    begin                : Thu Jul  5 17:35:17 EEST 2001
    copyright            : (C) 2001 by Eugen C.
    email                : eug@thekompany.com
 ***************************************************************************/

#include <stlutil.h>
#include <string.h>
#include <ctype.h>

vector<string> STLUtil::split(char sep, const string &str)
{
  vector<string> chunks;

	unsigned begin=0, end;
	while((end=str.find(sep, begin))!=str.npos)
	{
		chunks.insert(chunks.end(), str.substr(begin, end-begin));
		begin=end+1;
	}
	
	if(begin<str.size()) chunks.insert(chunks.end(), str.substr(begin));
	
  return chunks;
}

vector<string> STLUtil::split(const char* sep, const string &str)
{
  vector<string> chunks;
	unsigned begin=0, end, length=strlen(sep);
	
	while((end=str.find(sep, begin))!=str.npos)
	{
		chunks.insert(chunks.end(), str.substr(begin, end-begin));
		begin=end+length;
	}
	
	if(begin<str.size()) chunks.insert(chunks.end(), str.substr(begin));
	
  return chunks;
}

vector<string> STLUtil::split(const int iSep, const string &line)
{
  vector<string> chunks;
  string chunk;
  unsigned uError=line.size();
	unsigned uBegin=uError, i;

  switch( iSep )
  {
    case STLUtil::WHITE_SPACES :
      for(i=0; i<uError; i++)
      {
        if( line.data()[i]!=' ' && line.data()[i]!='\t' && uBegin==uError )
          uBegin=i;
        else if( (line.data()[i]==' ' || line.data()[i]=='\t') && uBegin!=uError )
        {
          // the word was found
          chunks.insert(chunks.end(), line.substr(uBegin, i-uBegin));
          uBegin=uError;
        }
      }
      break;
  }

  return chunks;
}

unsigned STLUtil::skipSpaces(string &line, unsigned uPos) const
{
  unsigned i;

  for(i=uPos; i<line.size(); i++)
    if( line.data()[i]!=' ' && line.data()[i]!='\t' )
      break;

  if( i!=uPos )
    line.erase(uPos, i-uPos);
  return i-uPos;
}

unsigned STLUtil::parseNextWord(string &strWord, string &line, unsigned uPos)
{
  unsigned i;

  skipSpaces(line, uPos);
  for(i=uPos; i<line.size(); i++)
    if( line.data()[i]==' ' || line.data()[i]=='\t' )
      break;

  if( i!=uPos )
    strWord=line.substr(uPos, i-uPos);
  else
    strWord="";
  return i;
}

void STLUtil::toUpper(string &strWord)
{
  string output;

  for(unsigned i=0; i<strWord.size(); ++i)
    output.append(1, (char)toupper(strWord.data()[i]) );

  strWord=output;
}

void STLUtil::toLower(string &strWord)
{
  string output;

  for(unsigned i=0; i<strWord.size(); ++i)
    output.append(1, (char)tolower(strWord.data()[i]) );

  strWord=output;
}




