/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <mimepart.h>
#include <qdatastream.h>

MimePart::MimePart()
{
	// set some defaults
	mimetype="text/plain";
	encoding="8bit";
	type="attachment";	
	offset=-1;
	length=0;
	name="";
	cid="";
	charset="us-ascii";
	embeddedPath="";
}

MimePart::MimePart(QCString &p)
{
  // printf("Adding part: %s\n", (const char *)p);
  
  QTextStream txt(p, IO_ReadOnly);
  char c;
  txt>>c;
  switch(c)
  {
    case 'T':
      // text part
      txt>>mimetype>>encoding>>offset>>length>>ws;
      charset=txt.readLine();
      type="text";
      break;
    case 'R':
      // related part
      txt>>mimetype>>cid>>encoding>>offset>>length;
      name=txt.readLine();
      type="related";
      break;
    case 'A':
      // attachment part
      txt>>mimetype>>encoding>>offset>>length>>name;
      type="attachment";
      break;
    case 'D':
      // digest part
      txt>>offset>>length;
      type="digest";
      break;
    default:
      type="unknown";
  }
}

QDataStream& operator<<(QDataStream &s, MimePart &p)
{
	if(p.type=="text")
	{
		s<<p.type<<p.mimetype<<p.encoding<<p.offset<<p.length<<p.charset;
	}
	else if(p.type=="related")
	{
		s<<p.type<<p.mimetype<<p.cid<<p.encoding<<p.offset<<p.length<<p.name<<p.embeddedPath;
	}
	else if(p.type=="attachment")
	{
		s<<p.type<<p.mimetype<<p.encoding<<p.offset<<p.length<<p.name<<p.embeddedPath;
	}
	else if(p.type=="digest")
	{
		s<<p.type<<p.offset<<p.length<<p.embeddedPath;
	}
  
  return s;
}

QDataStream& operator>>(QDataStream &s, MimePart &p)
{
	s>>p.type;

	if(p.type=="text")  
		s>>p.mimetype>>p.encoding>>p.offset>>p.length>>p.charset;
	else if(p.type=="related")
		s>>p.mimetype>>p.cid>>p.encoding>>p.offset>>p.length>>p.name>>p.embeddedPath;
	else if(p.type=="attachment")
		s>>p.mimetype>>p.encoding>>p.offset>>p.length>>p.name>>p.embeddedPath;
	else if(p.type=="digest")
		s>>p.offset>>p.length>>p.embeddedPath;
	
  return s;
}
