/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <qframe.h>
#include <qpixmap.h>
#include <qfont.h>
#include <qpainter.h>
#include <qstring.h>
#include <qevent.h>
#include <qcolor.h>
#include <qwidget.h>

#ifndef HAS_KFBUTTON
#define HAS_KFBUTTON

/**
 *
 *		This class was modified by Laur IVAN on Feb 10, 2000 to add support
 *	for persistent clicks when in ECollection.
 *		Added:
 *			- int index  in all constructors with the default value -1, so from
 *				this pov the constructors are compatible with the last version
 *			- buttonIndex variable insite the EButton class
 *			- serialPressed signal to be emitted when part of a ECollection
 *			- setIndex method for setting up the index (reccomended usage only
 *				within the ECollection class)
 *			- getIndex method for geting the index (reccomended usage only
 *				within the ECollection class)
 *			- getPixmap(PixmapType) retuns a button's pixmap for the specified
 *				type (Normal -> pix_normal and so on)
 *
 */

class EButton : public QFrame
{
	Q_OBJECT
	public:
		enum PixmapTypes {Normal=0, Focus=1, Clicked=2, Disabled=3};
		EButton(QWidget *parent=0, const char *name=0, int index=-1);
		EButton(const QPixmap &npix, QWidget *parent=0, 
				const char *name=0, int index=-1);
		EButton(const QString &text, QWidget *parent=0,
				const char *name=0, int index=-1);
		~EButton();
		void setNormalPixmap(const QPixmap &pix);
		void setFocusPixmap(const QPixmap &pix);
		void setClickedPixmap(const QPixmap &pix);
		void setDisabledPixmap(const QPixmap &pix);
		void setTextFont(const QFont &f);
		void setTextColor(const QColor &c);
		void setNormalFrameStyle(int s);
		void setFocusFrameStyle(int s);
		void setClickedFrameStyle(int s);
    void setNormalFrameWidth(int w);
    void setFocusFrameWidth(int w);
    void setClickedFrameWidth(int w);
    void setNormalBgColor(const QColor &c);
    void setFocusBgColor(const QColor &c);
    void setClickedBgColor(const QColor &c);
    void setNormalFrameColor(const QColor &c);
		void setText(const QString &text);
		void setSpacing(int sp);
		void setContentMargin(int cm);
		bool isDisabled();
		void setToolBarStyle(int=0);
    void setCollectionStyle();
    void setArrowStyle();
    void showFocused();
    void showNormal();
    void setFocusBuddy(EButton *b);
		void setIndex(int index=-1);
		int getIndex();
		QPixmap getPixmap(PixmapTypes pt);
	
	public slots:
		void setDisabled(bool d);
	
	signals:
		void pressed();
		void released();
		void clicked();
		void indexClicked(int index);
	
	protected:
		void enterEvent(QEvent *e);
		void leaveEvent(QEvent *e);
		void mousePressEvent(QMouseEvent *e);
		void mouseReleaseEvent(QMouseEvent *e);
		void drawContents(QPainter *p);
	
	private:
		void set_defs();
		void set_dims();
		
		QPixmap normal_pix, focus_pix, clicked_pix, disabled_pix;
		QString label;
		int nstyle, fstyle, cstyle, spacing;
		int buttonIndex;
		QColor tcolor, ncolor, fcolor, ccolor;
		QFont tfont;
		bool is_pressed;
		bool mouse_on;
		bool disabled;
		bool hasText, hasPixmap;
		bool fixedHeight;
		bool useDefaultStyle;
		int cmargin, nwidth, fwidth, cwidth;
    EButton *buddy;
};

#endif
