/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qcombobox.h>

#include <otherwidgetbase.h>
#include <otherwidget.h>
#include <cardclasses.h>
#include <miscfunctions.h>

OtherWidget::OtherWidget(CardOtherElements *elements, QWidget *parent=0, const char *name=0) : OtherWidgetBase(parent, name)
{
	setItems(elements);
}

CardOtherElements *OtherWidget::items()
{
	return _items;
}

void OtherWidget::setItems(CardOtherElements *_it)
{
	_items=_it;
	if(!_items)
	{
		birthdayEdit->setText("");
		categoriesEdit->setText("");
		notesEdit->setText("");
		return;
	}
	birthdayEdit->setText(items()->bday());
	categoriesEdit->setText(items()->categories());
	notesEdit->setText(items()->notes());
	updateComboBox(securityBox, items()->security());
}

void OtherWidget::bdayChanged(const QString &str)
{
	printf("bday\n");
	items()->setBday(str);
	emit(changedSignal());
}

void OtherWidget::categoriesChanged(const QString &str)
{
	items()->setCategories(str);
	emit(changedSignal());
}

void OtherWidget::editCategories()
{
}

void OtherWidget::notesChanged()
{
	items()->setNotes(notesEdit->text());
	emit(changedSignal());
}

void OtherWidget::securityChanged(const QString &str)
{
	items()->setSecurity(str);
	emit(changedSignal());
}

