/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <vreference.h>
#include <templateview.h>
#include <qstring.h>
#include <stdio.h>

VReference::VReference()
{
	mainView=0;
	mainIconView=0;
	autoDelViews=true;
	autoDelIconViews=true;
	views.setAutoDelete(false);
	iconViews.setAutoDelete(false);
}

VReference::~VReference()
{
	if(mainView && autoDelViews)
		delete mainView;
	if(mainIconView && autoDelIconViews)
		delete mainIconView;
	
	views.setAutoDelete(autoDelViews);
	views.clear();
	iconViews.setAutoDelete(autoDelIconViews);
	iconViews.clear();
}

void VReference::autoDeleteViews(bool mode)
{
	autoDelViews=mode;
}

void VReference::autoDeleteIconViews(bool mode)
{
	autoDelIconViews=mode;
}

TemplateView *VReference::getView()
{
	return mainView;
}

void VReference::setView(TemplateView *view)
{
	mainView=view;
	if(views.containsRef(view)) views.removeRef(view);
}

TemplateView *VReference::getIconView()
{
	return mainIconView;
}

void VReference::setIconView(TemplateView *entry)
{
	mainIconView=entry;
	if(iconViews.containsRef(entry)) iconViews.removeRef(entry);
}

QList<TemplateView> VReference::altViews()
{
	return views;
}

bool VReference::addView(TemplateView *view)
{
	if(views.containsRef(view)) return false;
	views.append(view);
	if(mainView==view) mainView=0;
	return true;
}

bool VReference::removeView(TemplateView *view)
{
	return views.removeRef(view);
}

QList<TemplateView> VReference::altIconViews()
{
	return iconViews;
}

bool VReference::addIconView(TemplateView *entry)
{
	if(iconViews.containsRef(entry)) return false;
	iconViews.append(entry);
	if(mainIconView==entry) mainIconView=0;
	return true;
}

bool VReference::removeIconView(TemplateView *entry)
{
	return iconViews.removeRef(entry);
}

QList<void> VReference::altReferences()
{
	return references;
}

bool VReference::addReference(void *ref)
{
	if(references.containsRef(ref)) return false;
	references.append(ref);
	return true;
}

bool VReference::removeReference(void *ref)
{
	return references.removeRef(ref);
}

void VReference::updateViews(TemplateView *initiator)
{
	// debug
	// printf("vreference (%s): updating views...\n", (const char *)path());
	// printf("mainview: %p, initiator %p\n", mainView, initiator);
	if(mainView && mainView!=initiator)
	{
		// debug
		// printf("vreference: updating main view...\n");
		
		mainView->update();
	}
	if(mainIconView && mainIconView!=initiator)
	{
		// debug
		// printf("vreference: updating main icon view...\n");
	
		mainIconView->update();
	}
	
	TemplateView *v;
	for(int i=0;i<views.count();i++)
	{
		// debug
		// printf("vreference: updating alt view... (%p)\n", views.at(i));
		
		v=views.at(i);
		if(v!=initiator)
			v->update();
	}
	for(int i=0;i<iconViews.count();i++)
	{
		// debug
		// printf("vreference: updating alt icon view...\n");
		
		v=iconViews.at(i);
		if(v!=initiator)
			v->update();
	}
}




