/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qslider.h>

#include <editaccountdialogbase.h>
#include <editaccountdialog.h>


// make it modal
EditAccountDialog::EditAccountDialog(AccountsConfig::Account *a, QWidget *parent, const char *name=0) :
	EditAccountDialogBase(a->type, parent, name, true)
{
	tmp=*a;
	element=a;
	load();
}

void EditAccountDialog::load()
{
	QString t;
	// first frame
	passCheck->setChecked(element->rememberPasswd);
	passEdit->setEnabled(element->enabled);
	accountEdit->setText(element->accountName);
	userEdit->setText(element->name);
	loginEdit->setText(element->user);
	serverEdit->setText(element->Server);
	passEdit->setText(element->passwd);
	portEdit->setText(t.sprintf("%d",element->port));
	// second frame
	smtpServerEdit->setText(element->SMTPServer);
	fromEdit->setText(element->from);
	replyToEdit->setText(element->replyTo);
	smtpPortEdit->setText(t.sprintf("%d",element->SMTPport));
	// third frame
	syncCheck->setChecked(element->sync);
	sortCheck->setChecked(element->sort);
	maxEdit->setText(t.sprintf("%d",element->maxSize));
	if(element->maxSize==0)
	{
		maxActionGroup->setEnabled(false);
	}
	else
	{
		maxActionGroup->setEnabled(true);
	}
	if(element->maxAction=="ignore")
		maxActionGroup->setButton(0);
	else if(element->maxAction=="remove")
		maxActionGroup->setButton(1);
	else
		maxActionGroup->setButton(2);
	if(element->speed=="Very slow")
		speedSlider->setValue(2);
	else if(element->speed=="Slow")
		speedSlider->setValue(1);
	else
		speedSlider->setValue(0);
}


void EditAccountDialog::cancelClicked()
{
	element->SMTPServer=QString::null;
	close();
}

void EditAccountDialog::fromChanged(const QString &str)
{
	tmp.from=str;
}

void EditAccountDialog::maxEditChanged(const QString &str)
{
	maxActionGroup->setEnabled(str.length() && str.toInt());
	tmp.maxSize=str.toInt();
}

void EditAccountDialog::maxGroupChanged(int val)
{
	switch(val)
	{
		case 0:
			tmp.maxAction="Ignore";
			break;
		case 1:
			tmp.maxAction="Remove";
			break;
		case 2:
			tmp.maxAction="Ask";
			break;
	}
}

void EditAccountDialog::nameChanged(const QString &str)
{
	tmp.accountName=str;
}

void EditAccountDialog::passClicked()
{
	passEdit->setEnabled(passCheck->isChecked());
	if(passCheck->isChecked())
		tmp.passwd=passEdit->text();
	else
		tmp.passwd="";
}

void EditAccountDialog::okClicked()
{
	*element=tmp;
	close();
}

void EditAccountDialog::passChanged(const QString &str)
{
	tmp.passwd=str;
}

void EditAccountDialog::portChanged(const QString &str)
{
	tmp.port=str.toInt();
	okButton->setEnabled(tmp.port);
}

void EditAccountDialog::serverChanged(const QString &str)
{
	tmp.Server=str;
	okButton->setEnabled(str.length());
}

void EditAccountDialog::replyToChanged(const QString &str)
{
	tmp.replyTo=str;
}

void EditAccountDialog::smtpPortChanged(const QString &str)
{
	tmp.SMTPport=str.toInt();
	okButton->setEnabled(tmp.SMTPport);
}

void EditAccountDialog::smtpServerChanged(const QString &str)
{
	tmp.SMTPServer=str;
	okButton->setEnabled(str.length());
}

void EditAccountDialog::speedChanged(int val)
{
	switch(val)
	{
		case 0:
			tmp.speed="Normal";
			break;
		case 1:
			tmp.speed="Slow";
			break;
		case 2:
			tmp.speed="Very slow";
			break;
	}
}

void EditAccountDialog::loginChanged(const QString &str)
{
	okButton->setEnabled(str.length());
	tmp.user=str;
}

void EditAccountDialog::userChanged(const QString &str)
{
	tmp.name=str;
}

void EditAccountDialog::syncClicked()
{
	tmp.sync=syncCheck->isChecked();
}

void EditAccountDialog::sortClicked()
{
	tmp.sort=sortCheck->isChecked();
}



