/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __Has_CCenter__
#define __Has_CCenter__

#include <ccenterbase.h>
#include <qvaluelist.h>

class ECollection;
class NotesConfig;

class ControlCenter : public ControlCenterBase
{
	Q_OBJECT
	public:
		enum { 	ContactsConfigID=0,
						GroupsConfigID=1,
						AddressBookConfigID=2,
						AccountsConfigID=3,
						SendReceiveConfigID=4,
						ComposerConfigID=5,
						FormatOptionsConfigID=6,
						MailOptionsConfigID=7,
						NotesConfigID=9
		};
		
		ControlCenter(QWidget *parent=0, const char *name=0);
		void initTab();
		void initStack();
	public slots:
    virtual void applyClicked();
    virtual void cancelClicked();
    virtual void eTabActivated(int);
    virtual void eTabSelected(int, int);
    virtual void okClicked();
		void statusChanged();
		void statusCleared();
	
	protected slots:
		void accountsFrameRaise();
		void composerFrameRaise();
		void contactsFrameRaise();
		void formatOptFrameRaise();
		void groupsFrameRaise();
		void mailOptFrameRaise();
		void notesFrameRaise();
		void otherOptFrameRaise();
		void srOptFrameRaise();
	
	
	signals:
		void doSync(bool); // emit when it needs do do a sync.
		
	private:
		void raise(int);
		ECollection *notesCollection;
		ECollection *mailCollection;
		ECollection *contactsCollection;
		ECollection *groupsCollection;
		
		NotesConfig *notesConfig;
		QValueList<bool> changed;
};
#endif
