/*
 * Package org.openjump.core.ui.style.style.classification for OpenJUMP
 *
 * Copyright (C) 2004
 * Olivier Bedel, ingnieur informaticien laboratoire Reso UMR ESO 6590, Bassin versant du Jaudy-Guindy-Bizien.
 * Cline Foureau, stagiaire MIAGE, laboratoire Reso UMR ESO 6590.
 * Erwan Bocher, doctorant en gographie, laboratoire Reso UMR ESO 6590, Bassin versant du Jaudy-Guindy-Bizien
 *
 * Date de cration : 5 oct. 2004
 *
 * Dvelopp dans le cadre du Projet APARAD 
 *  (Laboratoire Reso UMR ESO 6590 CNRS / Bassin Versant du Jaudy-Guindy-Bizien)
 *    Responsable : Erwan BOCHER
 *    Dveloppeurs : Cline FOUREAU, Olivier BEDEL
 *
 * olivier.bedel@uhb.fr ou olivier.bedel@yahoo.fr
 * erwan.bocher@uhb.fr ou erwan.bocher@free.fr
 * celine.foureau@uhb.fr ou celine.foureau@wanadoo.fr
 * 
 * Ce package hrite de la licence GPL de JUMP. Il est rgi par la licence CeCILL soumise au droit franais et
 * respectant les principes de diffusion des logiciels libres. (http://www.cecill.info)
 * 
 */

package org.openjump.core.ui.style.classification;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author FOUREAU_C
 */

public class ComputeRange {
	private List classes = new ArrayList();

	public ComputeRange(List donnees, int nbClasses) {
		calculerRange(donnees, nbClasses);
	}

	private void calculerRange(List donnees, int nbClasses) {
		classes.clear();
		Interval classe = null;
		int i = 0;

		Collections.sort(donnees);

		Number min = (Number) donnees.get(0);
		Number max = (Number) donnees.get(donnees.size() - 1);

		double etalement = reduireNbDecimales(((max.doubleValue() - min.doubleValue()) / nbClasses));

		if (min instanceof Integer && max instanceof Integer) {
			max = new Integer(new Long(Math.round(etalement)).intValue());
			while (i < nbClasses) {
				classe = new Interval(min, true, max, true);
				classes.add(classe);
				min = new Integer(max.intValue() + 1);
				max =
					new Integer(
						new Double(max.intValue() + etalement).intValue());
				i++;
			}
		} else if (min instanceof Double && max instanceof Double) {
			max = new Double(etalement);
			while (i < nbClasses) {
				classe = new Interval(min, true, max, true);
				classes.add(classe);
				min = new Double(reduireNbDecimales(max.doubleValue()) + 0.01);
				max = new Double(reduireNbDecimales(max.doubleValue()) + etalement);
				i++;
			}
		}
		((Interval)classes.get(classes.size()-1)).setMax((Number) donnees.get(donnees.size() - 1));
	}
	
	public double reduireNbDecimales(double d){
		DecimalFormat df = new DecimalFormat("#");
		df.setMaximumFractionDigits(2);
		df.setDecimalSeparatorAlwaysShown(false);
		String res = df.format(d);
		res = res.replaceAll(",",".");
		return Double.valueOf(res).doubleValue();
	}

	public List getClasses() {
		return classes;
	}
}
