/*
 *	Associate a callsign with a uid.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/ax25.h>
#include "config.h" 
#include <pwd.h>


void main(int argc, char *argv[])
{
	struct sockaddr_ax25 sax25;
	struct passwd *pw;
	int s=socket(AF_AX25, SOCK_DGRAM,0);
	if(!s)
	{
		perror("ax.25");
		exit(1);
	}
	
	if(argc!=3)
	{
		fprintf(stderr,"%s [callsign] [username]\n", argv[0]);
		fprintf(stderr,"%s [callsign] delete\n", argv[0]);
		fprintf(stderr,"%s policy <default|deny>\n", argv[0]);
		exit(1);
	}
	
	if(strcmp(argv[1],"policy")==0)
	{
		if(strcmp(argv[2], "default")==0)
		{
			int opt=AX25_NOUID_DEFAULT;
			if(ioctl(s, SIOCAX25NOUID, &opt)==-1)
			{
				perror("set policy");
				exit(1);
			}
			exit(0);
		}
		if(strcmp(argv[2],"deny")==0)
		{
			int opt=AX25_NOUID_BLOCK;
			if(ioctl(s, SIOCAX25NOUID, &opt)==-1)
			{
				perror("set policy");
				exit(1);
			}
			exit(0);
		}
		fprintf(stderr,"%s: 'default' or 'block' required.\n",argv[0]);
		exit(1);
	}
	
	
	
	if(convert_call_entry(argv[1],(char *)&sax25.sax25_call)==-1)
		exit(1);

	if(strcmp(argv[2],"delete")==0)
	{
		if(ioctl(s, SIOCAX25DELUID, &sax25)==-1)
		{
			perror("del uid");
			exit(1);
		}
		exit(0);
	}
	pw=getpwnam(argv[2]);
	if(!pw)
	{
		fprintf(stderr,"%s: unknown username.\n", argv[0]);
		exit(1);
	}
	sax25.sax25_uid=pw->pw_uid;
		
	if(ioctl(s, SIOCAX25ADDUID, &sax25)==-1)
	{
		perror("add uid");
		exit(1);
	}
}
