#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/sockios.h>
#include <linux/if.h>
#include <linux/if_arp.h>
#include <linux/ax25.h>
#include <netinet/in.h>
#include <netdb.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "config.h"

void main(int argc, char *argv[])
{
	struct arpreq arq;
	struct sockaddr_in *i;
	int sock;
	struct full_sockaddr_ax25 sax;
	struct hostent *he;
	int err;
	
	if(argc!=3)
	{
		fprintf(stderr,"%s ip_address callsign.\n",argv[0]);
		exit(1);
	}

	he=gethostbyname(argv[1]);
	if(he==NULL)
	{
		fprintf(stderr,"%s: unknown host %s.\n",argv[0], argv[1]);
		exit(1);
	}
	
	err=convert_call(argv[2],&sax);
	if(err==-1)
		exit(1);
		
	if(err!=sizeof(struct sockaddr_ax25))
	{	
		fprintf(stderr,"%s: you may not add digipeated paths.\n",argv[0]);
		exit(1);
	}
	
	sock=socket(AF_INET,SOCK_DGRAM,0);
	if(sock==-1)
	{
		perror("sock");
		exit(1);
	}
	
	arq.arp_flags=ATF_PERM;
	
	i=(struct sockaddr_in *)&arq.arp_pa;
	i->sin_family=AF_INET;
	i->sin_addr.s_addr=*(long *)(he->h_addr);
	
	arq.arp_ha.sa_family=ARPHRD_AX25;
	memcpy(arq.arp_ha.sa_data,&sax.fsa_ax25.sax25_call,7);
	
	if(ioctl(sock,SIOCSARP,&arq)==-1)
		perror("ioctl");
	close(sock);
}

