#!/usr/bin/perl
##
## Copyright (c) 1999 Internet Images Srl
##                    Massimiliano Masserelli
##
## $Id: php_xgettext.pl,v 1.1 1999/11/02 11:11:16 negro Exp $
##

@script_ext = (".php3", ".inc", ".ihtml");
@lf_id = ("\\\$lang->f\\(", "\\\$lang->p\\(", "_\\(", "_P\\(");

$target_catalog = shift || die("Specificare il nome del catalogo principale.");
$target_dir = shift || ".";

require "find.pl";
use GDBM_File;

tie(%MSGID, 'GDBM_File', 'msgid_tmp', 1, 0);
while (($key,$val) = each %MSGID) {
  delete($MSGID{$key});
}
&find($target_dir);
open(CATALOG, ">$target_catalog") || die("cannot write to $target_catalog");
for $msgid  (sort { fpcomp($MSGID{$a}, $MSGID{$b}); } keys %MSGID) {
  $filepos = $MSGID{$msgid};
  print CATALOG "\n";
  $fs = "";
  for $fp (split(" ", $filepos)) {
    if ((length($fs) + length($fp) + 1) > 70) {
      print CATALOG "#:$fs\n";
      $fs = " $fp";
    } else {
      $fs .= " " . $fp;
    }
  }
  if (length($fs) > 0) {
    print CATALOG "#:$fs\n";
  }
  if ($msgid =~ /\n/s) {
    print CATALOG "msgid \"\"\n";
    print CATALOG '"' . join("\\n\"\n\"", split("\n", $msgid)) . '"' . "\n";
  } else {
    print CATALOG "msgid \"$msgid\"\n";
  }
  print CATALOG "msgstr \"\"\n";
}
close(CATALOG);
untie(%MSGID);
unlink('msgid_tmp');

exit;

sub wanted {
  if ((($dev,$ino,$mode,$nlink,$uid,$gid) = lstat($_)) &&
    -f _ &&
    /^.*\.php3$/
      ||
    /^.*\.inc$/
      ||
    /^.*\.ihtml$/) {
    &parselang($_);
  }
}

sub parselang {
  $filename = shift;
  $ln = 0;
  open(INFILE, $filename) || die("cannot open $filename");
  my($parsing) = 0;
  while (<INFILE>) {
    $ln++;
    $search = join("|", @lf_id);
    if ($parsing == 1) {
      if (/^(.+?[^\\])"/) {
        $msgid .= $1;
        $MSGID{$msgid} .= "$filename:$ln ";
        $parsing = 0;
      } else {
        $msgid .= $_;
        $parsing = 1;
      }
    } elsif (/$search/) {
      HORRIBLE: $candidate = $';
      next if ($candidate =~ /^[^)"]*\)/);
      if ($candidate =~ /"(.+?[^\\])"/) {
        $msgid = $1;
        $MSGID{$msgid} .= "$filename:$ln ";
        $parsing = 0;
	$candidate = $';
	if ($candidate =~ /$search/) { goto HORRIBLE; }
      } elsif ($candidate =~ /"(.*)$/) {
        $msgid = $1 . "\n";
        $parsing = 1;
      } else {
        print $filename . ":" . $ln . "\n";
        die("parsing error in $_");
      }
    }
  }
  close(INFILE);
}

sub fpcomp($$) {
  my($a) = shift;
  my($b) = shift;
  my($fia, $rest) = split(" ", $a);
  my($fib, $rest) = split(" ", $b);
  my($fna, $fpa) = split(":", $fia);
  my($fnb, $fpb) = split(":", $fib);

  if (($rv = ($fna cmp $fnb)) == 0) {
    $rv = $fpa <=> $fpb;
  }

  return $rv;
}
